/*
 * Decompiled with CFR 0.152.
 */
package nakadi;

import java.io.Closeable;
import java.io.IOException;
import nakadi.NakadiClient;
import nakadi.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResponseSupport {
    private static final Logger logger = LoggerFactory.getLogger((String)NakadiClient.class.getSimpleName());

    ResponseSupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void closeQuietly(Response res) {
        String tName = Thread.currentThread().getName();
        boolean closed = false;
        try {
            logger.debug("op=connection_close msg=close_ask thread={} res_hash={} res={}", new Object[]{tName, res.hashCode(), res});
            res.responseBody().close();
            return;
        }
        catch (Exception e) {
            block11: {
                try {
                    logger.error("op=connection_close msg=err_close thread={} class={} err={} res_hash={} res={}", new Object[]{tName, e.getClass().getName(), e.getMessage(), res.hashCode(), res});
                    if (closed) break block11;
                }
                catch (Throwable throwable) {
                    if (!closed) {
                        try {
                            res.responseBody().close();
                            closed = true;
                        }
                        catch (IOException e2) {
                            logger.error("op=connection_close msg=err_close_reattempt thread={}  class={} err={} res_hash={} res={}", new Object[]{tName, e2.getClass().getName(), e2.getMessage(), res.hashCode(), res});
                        }
                    }
                    if (closed) throw throwable;
                    logger.warn(String.format("op=connection_close msg=error_close_fail thread=%s %s %s", tName, res.hashCode(), res));
                    throw throwable;
                }
                try {
                    res.responseBody().close();
                    return;
                }
                catch (IOException e3) {
                    logger.error("op=connection_close msg=err_close_reattempt thread={}  class={} err={} res_hash={} res={}", new Object[]{tName, e3.getClass().getName(), e3.getMessage(), res.hashCode(), res});
                }
            }
            if (closed) return;
            logger.warn(String.format("op=connection_close msg=error_close_fail thread=%s %s %s", tName, res.hashCode(), res));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void closeQuietly(Closeable closeable, int attempts) {
        int attempt;
        String tName = Thread.currentThread().getName();
        boolean closed = false;
        try {
            logger.trace("response_close_ask thread={}", (Object)tName);
            closeable.close();
            logger.trace("response_close_ok thread={}", (Object)tName);
            closed = true;
            attempt = 0;
        }
        catch (Exception e) {
            int attempt2;
            try {
                logger.error("response_close_error problem closing on {} {}", (Object)e.getClass().getName(), (Object)e.getMessage());
                attempt2 = 0;
            }
            catch (Throwable throwable) {
                int attempt3 = 0;
                while (!closed && attempt3++ < attempts) {
                    try {
                        closeable.close();
                        closed = true;
                    }
                    catch (Exception e1) {
                        logger.error("response_close_error retrying close attempts {}/{} on {}", new Object[]{attempt3, attempts, e1.getMessage()});
                    }
                }
                if (!closed) {
                    logger.error("response_close_error could not close http response attempts {}/{}", (Object)attempt3, (Object)attempts);
                }
                throw throwable;
            }
            while (!closed && attempt2++ < attempts) {
                try {
                    closeable.close();
                    closed = true;
                }
                catch (Exception e1) {
                    logger.error("response_close_error retrying close attempts {}/{} on {}", new Object[]{attempt2, attempts, e1.getMessage()});
                }
            }
            if (!closed) {
                logger.error("response_close_error could not close http response attempts {}/{}", (Object)attempt2, (Object)attempts);
            }
        }
        while (!closed && attempt++ < attempts) {
            try {
                closeable.close();
                closed = true;
            }
            catch (Exception e1) {
                logger.error("response_close_error retrying close attempts {}/{} on {}", new Object[]{attempt, attempts, e1.getMessage()});
            }
        }
        if (!closed) {
            logger.error("response_close_error could not close http response attempts {}/{}", (Object)attempt, (Object)attempts);
        }
    }
}

