/*
 * Decompiled with CFR 0.152.
 */
package nakadi;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import nakadi.NakadiException;
import nakadi.TokenProvider;

class ResourceOptions {
    private final Map<String, Object> headers = new HashMap<String, Object>();
    private TokenProvider provider;

    ResourceOptions() {
    }

    public ResourceOptions tokenProvider(TokenProvider provider) {
        NakadiException.throwNonNull(provider, "Please provide a TokenProvider");
        this.provider = provider;
        return this;
    }

    public ResourceOptions header(String name, Object value) {
        NakadiException.throwNonNull(name, "Please provide a header name");
        NakadiException.throwNonNull(value, "Please provide a header value");
        this.headers.put(name, value);
        return this;
    }

    public ResourceOptions headers(Map<String, Object> headers) {
        NakadiException.throwNonNull(headers, "Please provide some headers");
        this.headers.putAll(headers);
        return this;
    }

    @Deprecated
    public ResourceOptions scope(String scope) {
        return this;
    }

    public ResourceOptions flowId(String flowId) {
        NakadiException.throwNonNull(flowId, "Please provide a flow ID");
        return this.header("X-Flow-Id", flowId);
    }

    public Map<String, Object> headers() {
        return this.headers;
    }

    public Optional<String> supplyToken() {
        return this.provider.authHeaderValue(null);
    }

    @Deprecated
    public String scope() {
        return null;
    }
}

