/*
 * Decompiled with CFR 0.152.
 */
package nakadi;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import nakadi.NakadiClient;
import nakadi.NakadiException;
import nakadi.Problem;
import nakadi.ResourceCollectionEmpty;
import nakadi.ResourceCollectionIterable;
import nakadi.ResourceLink;

public abstract class ResourceCollection<T> {
    private static final String REL_NEXT = "next";
    private final List<T> items;
    private final List<ResourceLink> links;
    protected final NakadiClient client;
    protected boolean hasNextLink;
    private volatile ResourceCollectionEmpty<T> empty;

    public ResourceCollection(List<T> items, List<ResourceLink> links, NakadiClient client) {
        this.items = items;
        this.links = links;
        this.client = client;
        this.hasNextLink = this.determineHasNextLink(this.links);
    }

    public abstract ResourceCollection<T> fetchPage(String var1);

    public ResourceCollection<T> emptyPage() {
        if (this.empty == null) {
            this.empty = new ResourceCollectionEmpty();
        }
        return this.empty;
    }

    public ResourceCollection<T> nextPage() {
        Optional<URI> link;
        if (this.hasNextLink() && (link = this.findLink(REL_NEXT)).isPresent()) {
            String url = this.resolveNextPageLink(link);
            ResourceCollection<T> collection = this.fetchPage(url);
            NakadiException.throwNonNull(collection, String.format("Concrete collection %s must provide a non-null page", this.getClass()));
            this.hasNextLink = collection.hasNextLink();
            return collection;
        }
        ResourceCollection<T> empty = this.emptyPage();
        NakadiException.throwNonNull(empty, String.format("Concrete collection %s must provide a non-null empty page", this.getClass()));
        return empty;
    }

    private String resolveNextPageLink(Optional<URI> link) {
        String url;
        URI uri = link.get();
        String host = uri.getHost();
        if (host == null) {
            URI pageUri;
            URI baseURI = this.client.baseURI();
            try {
                pageUri = new URI(baseURI.getScheme(), baseURI.getUserInfo(), baseURI.getHost(), baseURI.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException e) {
                throw new NakadiException(Problem.localProblem("pagination_err", e.getMessage()), (Throwable)e);
            }
            url = pageUri.toASCIIString();
        } else {
            url = uri.toASCIIString();
        }
        return url;
    }

    public List<T> items() {
        return this.items;
    }

    public List<ResourceLink> links() {
        return this.links;
    }

    public boolean hasNextLink() {
        return this.hasNextLink;
    }

    public Optional<URI> findLink(String rel) {
        NakadiException.throwNonNull(rel, "Please provide a rel value");
        URI uri = null;
        for (ResourceLink link : this.links) {
            if (!rel.equals(link.rel())) continue;
            uri = link.href();
            break;
        }
        return Optional.ofNullable(uri);
    }

    public Iterable<T> iterable() {
        return new ResourceCollectionIterable(this);
    }

    boolean determineHasNextLink(List<ResourceLink> links) {
        boolean next = false;
        for (ResourceLink link : links) {
            if (!REL_NEXT.equals(link.rel())) continue;
            next = true;
            break;
        }
        return next;
    }

    public int hashCode() {
        return Objects.hash(this.items, this.links, this.hasNextLink, this.empty);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourceCollection)) {
            return false;
        }
        ResourceCollection that = (ResourceCollection)o;
        return this.hasNextLink == that.hasNextLink && Objects.equals(this.items, that.items) && Objects.equals(this.links, that.links) && Objects.equals(this.empty, that.empty);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{items=" + this.items + ", links=" + this.links + ", hasNextLink=" + this.hasNextLink + ", empty=" + this.empty + '}';
    }
}

