/*
 * Decompiled with CFR 0.152.
 */
package nakadi;

import java.util.concurrent.TimeUnit;
import nakadi.NakadiClient;
import nakadi.RetryPolicy;
import nakadi.shadow.io.reactivex.Observable;
import nakadi.shadow.io.reactivex.ObservableTransformer;
import nakadi.shadow.io.reactivex.Scheduler;
import nakadi.shadow.io.reactivex.functions.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RequestRetry {
    private static final Logger logger = LoggerFactory.getLogger((String)NakadiClient.class.getSimpleName());

    RequestRetry() {
    }

    <T> ObservableTransformer<T, T> retryWhenWithBackoffObserver(RetryPolicy backoff, Scheduler scheduler, Function<Throwable, Boolean> isRetryable) {
        return o -> {
            logger.info("request_retry loading with, backoff={}", (Object)backoff);
            return o.observeOn(scheduler).retryWhen(observable -> observable.zipWith(Observable.range(1, backoff.maxAttempts()), (throwable, integer) -> new Narp((Integer)integer, (Throwable)throwable)).flatMap(narp -> {
                Throwable throwable = narp.throwable;
                if (!((Boolean)isRetryable.apply(throwable)).booleanValue()) {
                    logger.warn(String.format("request_retry: not retryable, propagating error %s, %s", throwable.getClass().getSimpleName(), throwable.getMessage()));
                    return Observable.error(throwable);
                }
                if (backoff.isFinished()) {
                    logger.warn(String.format("request_retry: cycle failed after %d attempts, propagating error %s, %s", narp.attempt, throwable.getClass().getSimpleName(), throwable.getMessage()));
                    return Observable.error(throwable);
                }
                long delay = backoff.nextBackoffMillis();
                if (delay == -1L) {
                    logger.warn(String.format("request_retry: cycle failed after %d attempts, propagating error %s, %s", narp.attempt, throwable.getClass().getSimpleName(), throwable.getMessage()));
                    return Observable.error(throwable);
                }
                logger.info(String.format("request_retry: will sleep for a bit, sleep=%s attempt=%d/%d error=%s", delay, narp.attempt, backoff.maxAttempts(), throwable.getMessage()));
                return Observable.timer(delay, TimeUnit.MILLISECONDS, scheduler);
            }));
        };
    }

    private static class Narp {
        Integer attempt;
        Throwable throwable;

        Narp(Integer attempt, Throwable throwable) {
            this.attempt = attempt;
            this.throwable = throwable;
        }
    }
}

