/*
 * Decompiled with CFR 0.152.
 */
package nakadi;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import nakadi.EnrichmentStrategyCollection;
import nakadi.NakadiClient;
import nakadi.ResourceLink;
import nakadi.ResourceOptions;
import nakadi.ResourceSupport;
import nakadi.Response;
import nakadi.RetryPolicy;
import nakadi.UriBuilder;
import nakadi.ValidationStrategyCollection;
import nakadi.shadow.com.google.gson.reflect.TypeToken;

public class RegistryResource {
    private static final String PATH = "registry";
    private static final String PATH_VALIDATION_STRATEGIES = "validation-strategies";
    private static final String PATH_ENRICHMENT_STRATEGIES = "enrichment-strategies";
    private static final String APPLICATION_JSON = "application/json";
    private static final Type TYPE = new TypeToken<List<String>>(){}.getType();
    private final NakadiClient client;
    private volatile RetryPolicy retryPolicy;

    public RegistryResource(NakadiClient client) {
        this.client = client;
    }

    public RegistryResource retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public ValidationStrategyCollection listValidationStrategies() {
        return this.loadValidationPage(this.collection(PATH, PATH_VALIDATION_STRATEGIES).buildString());
    }

    public EnrichmentStrategyCollection listEnrichmentStrategies() {
        return this.loadEnrichmentPage(this.collection(PATH, PATH_ENRICHMENT_STRATEGIES).buildString());
    }

    ValidationStrategyCollection loadValidationPage(String url) {
        return new ValidationStrategyCollection(this.loadCollection(url), new ArrayList<ResourceLink>(), this, this.client);
    }

    EnrichmentStrategyCollection loadEnrichmentPage(String url) {
        return new EnrichmentStrategyCollection(this.loadCollection(url), new ArrayList<ResourceLink>(), this, this.client);
    }

    private List<String> loadCollection(String url) {
        ResourceOptions options = ResourceSupport.options(APPLICATION_JSON).tokenProvider(this.client.resourceTokenProvider());
        Response response = this.client.resourceProvider().newResource().retryPolicy(this.retryPolicy).requestThrowing("GET", url, options);
        return (List)this.client.jsonSupport().fromJson(response.responseBody().asString(), TYPE);
    }

    private UriBuilder collection(String basePath, String path) {
        return UriBuilder.builder(this.client.baseURI()).path(basePath).path(path);
    }
}

