/*
 * Decompiled with CFR 0.152.
 */
package nakadi;

import java.util.Optional;
import nakadi.AuthorizationException;
import nakadi.ClientException;
import nakadi.ConflictException;
import nakadi.HttpException;
import nakadi.InvalidException;
import nakadi.JsonSupport;
import nakadi.MetricCollector;
import nakadi.NotFoundException;
import nakadi.PreconditionFailedException;
import nakadi.Problem;
import nakadi.RateLimitException;
import nakadi.Response;
import nakadi.ServerException;

class ProblemSupport {
    ProblemSupport() {
    }

    static Problem toProblem(Response response, JsonSupport jsonSupport) {
        String raw = response.responseBody().asString();
        Problem problem = jsonSupport.fromJson(raw, Problem.class);
        if (problem == null) {
            problem = Problem.noProblemo("no problem sent back from server", "", response.statusCode());
        }
        if (problem.status() == 0 && (response.statusCode() == 400 || response.statusCode() == 401) && raw.contains("\"error_description\"")) {
            problem = Problem.authProblem("token_assumed_unauthorized", "Inferred from invalid response there was an auth issue, see https://github.com/zalando/nakadi/issues/645 raw_response=" + raw);
        }
        problem = Optional.ofNullable(problem).orElse(Problem.noProblemo("no problem sent back from server", "", response.statusCode()));
        return problem;
    }

    static <T> T throwProblem(int code, Problem problem, MetricCollector metricCollector) {
        if (code == 401) {
            metricCollector.mark(MetricCollector.Meter.http401);
            throw new AuthorizationException(problem);
        }
        if (code == 403) {
            metricCollector.mark(MetricCollector.Meter.http403);
            throw new AuthorizationException(problem);
        }
        if (code == 404 || code == 410) {
            metricCollector.mark(MetricCollector.Meter.http404);
            throw new NotFoundException(problem);
        }
        if (code == 409) {
            metricCollector.mark(MetricCollector.Meter.http409);
            throw new ConflictException(problem);
        }
        if (code == 412) {
            metricCollector.mark(MetricCollector.Meter.http412);
            throw new PreconditionFailedException(problem);
        }
        if (code == 422) {
            metricCollector.mark(MetricCollector.Meter.http422);
            throw new InvalidException(problem);
        }
        if (code == 429) {
            metricCollector.mark(MetricCollector.Meter.http429);
            throw new RateLimitException(problem);
        }
        if (code == 400) {
            metricCollector.mark(MetricCollector.Meter.http400);
            throw new ClientException(problem);
        }
        if (code >= 400 && code < 500) {
            metricCollector.mark(MetricCollector.Meter.http4xx);
            throw new ClientException(problem);
        }
        if (code == 500) {
            metricCollector.mark(MetricCollector.Meter.http500);
            throw new ServerException(problem);
        }
        if (code == 503) {
            metricCollector.mark(MetricCollector.Meter.http503);
            throw new ServerException(problem);
        }
        if (code > 500 && code < 600) {
            metricCollector.mark(MetricCollector.Meter.http5xx);
            throw new ServerException(problem);
        }
        metricCollector.mark(MetricCollector.Meter.httpUnknown);
        throw new HttpException(problem);
    }
}

