/*
 * Decompiled with CFR 0.152.
 */
package nakadi;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class Problem {
    static final URI T1000_TYPE = URI.create("about:t1000");
    private static final URI DEFAULT_TYPE = URI.create("about:blank");
    private static final URI LOCAL_TYPE = URI.create("about:local");
    private static final URI AUTH_TYPE = URI.create("about:auth");
    private static final URI CONTRACT_TYPE = URI.create("about:contract");
    private static final URI CONTRACT_RETRYABLE_TYPE = URI.create("about:contract_retryable");
    private static final URI OBSERVER_TYPE = URI.create("about:observer");
    private static final URI NETWORK_TYPE = URI.create("about:wire");
    private static final Map SENTINEL_MAP = new HashMap();
    private URI type = DEFAULT_TYPE;
    private String title;
    private int status;
    private String detail;
    private URI instance;
    private Map data;
    private volatile transient String message;

    public static Problem localProblem(String title, String detail) {
        return new Problem().title(title).detail(detail).data(SENTINEL_MAP).status(400).type(LOCAL_TYPE);
    }

    public static Problem authProblem(String title, String detail) {
        return new Problem().title(title).detail(detail).data(SENTINEL_MAP).status(401).type(AUTH_TYPE);
    }

    public static Problem noProblemo(String title, String detail, int code) {
        return new Problem().title(title).detail(detail).data(SENTINEL_MAP).status(code).type(T1000_TYPE);
    }

    public static Problem networkProblem(String title, String detail) {
        return new Problem().title(title).detail(detail).data(SENTINEL_MAP).status(400).type(NETWORK_TYPE);
    }

    public static Problem contractProblem(String title, String detail) {
        return new Problem().title(title).detail(detail).data(SENTINEL_MAP).status(500).type(CONTRACT_TYPE);
    }

    public static Problem contractRetryableProblem(String title, String detail) {
        return new Problem().title(title).detail(detail).data(SENTINEL_MAP).status(500).type(CONTRACT_RETRYABLE_TYPE);
    }

    public static Problem observerProblem(String title, String detail) {
        return new Problem().title(title).detail(detail).data(SENTINEL_MAP).status(400).type(OBSERVER_TYPE);
    }

    public String toMessage() {
        if (this.message != null) {
            return this.message;
        }
        this.message = this.title() + "; " + this.detail().orElse("") + " (" + this.status() + ")";
        return this.message;
    }

    public URI type() {
        return this.type;
    }

    public Problem type(URI type) {
        this.type = type;
        return this;
    }

    public String title() {
        return this.title;
    }

    public Problem title(String title) {
        this.title = title;
        return this;
    }

    public int status() {
        return this.status;
    }

    public Problem status(int status) {
        this.status = status;
        return this;
    }

    public Optional<String> detail() {
        return Optional.ofNullable(this.detail);
    }

    public Problem detail(String detail) {
        this.detail = detail;
        return this;
    }

    public Optional<URI> instance() {
        return Optional.ofNullable(this.instance);
    }

    public Problem instance(URI instance) {
        this.instance = instance;
        return this;
    }

    public Map data() {
        return this.data;
    }

    public Problem data(Map data) {
        this.data = data;
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.title, this.status, this.detail, this.instance, this.data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Problem problem = (Problem)o;
        return this.status == problem.status && Objects.equals(this.type, problem.type) && Objects.equals(this.title, problem.title) && Objects.equals(this.detail, problem.detail) && Objects.equals(this.instance, problem.instance) && Objects.equals(this.data, problem.data);
    }

    public String toString() {
        return "Problem{type=" + this.type + ", title='" + this.title + '\'' + ", status=" + this.status + ", detail='" + this.detail + '\'' + ", instance=" + this.instance + ", data=" + this.data + '}';
    }
}

