/*
 * Decompiled with CFR 0.152.
 */
package nakadi;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import nakadi.ClientException;
import nakadi.ContractRetryableException;
import nakadi.NakadiClient;
import nakadi.Problem;
import nakadi.ResponseBody;
import nakadi.ResponseSupport;
import nakadi.shadow.okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OkHttpResponseBody
implements ResponseBody {
    private static final Logger logger = LoggerFactory.getLogger((String)NakadiClient.class.getSimpleName());
    private static final int CLOSE_ATTEMPTS = 3;
    private final Response okResponse;

    OkHttpResponseBody(Response okResponse) {
        this.okResponse = okResponse;
    }

    @Override
    public String asString() throws ClientException {
        try {
            return this.okResponse.body().string();
        }
        catch (IOException e) {
            throw new ContractRetryableException(Problem.contractRetryableProblem("missing_response_body", e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public Reader asReader() {
        return this.okResponse.body().charStream();
    }

    @Override
    public InputStream asInputStream() {
        return this.okResponse.body().byteStream();
    }

    @Override
    public String mediaTypeString() {
        return this.okResponse.body().contentType().toString();
    }

    @Override
    public long contentLength() {
        return this.okResponse.body().contentLength();
    }

    @Override
    public void close() throws IOException {
        ResponseSupport.closeQuietly(this.okResponse, 3);
    }
}

