/*
 * Decompiled with CFR 0.152.
 */
package nakadi;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import nakadi.NakadiClient;
import nakadi.OkHttpResponseBody;
import nakadi.ResponseBody;
import nakadi.shadow.okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OkHttpResponse
implements nakadi.Response {
    private static final Logger logger = LoggerFactory.getLogger((String)NakadiClient.class.getSimpleName());
    private final Response okResponse;

    public OkHttpResponse(Response okResponse) {
        this.okResponse = okResponse;
    }

    @Override
    public int statusCode() {
        return this.okResponse.code();
    }

    @Override
    public String reason() {
        return this.okResponse.message();
    }

    @Override
    public Map<String, List<String>> headers() {
        return this.okResponse.headers().toMultimap();
    }

    @Override
    public ResponseBody responseBody() {
        return new OkHttpResponseBody(this.okResponse);
    }

    @Override
    public void close() {
        try {
            this.responseBody().close();
        }
        catch (RuntimeException rethrow) {
            throw rethrow;
        }
        catch (Exception suppressed) {
            logger.warn("exception closing http response {}", (Object)suppressed.getMessage());
        }
    }

    public int hashCode() {
        return Objects.hash(this.okResponse);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OkHttpResponse that = (OkHttpResponse)o;
        return Objects.equals(this.okResponse, that.okResponse);
    }

    public String toString() {
        return "HttpResponse{response=" + this.okResponse + '}';
    }
}

