/*
 * Decompiled with CFR 0.152.
 */
package nakadi;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import nakadi.ContentSupplier;
import nakadi.ContractRetryableException;
import nakadi.ExceptionSupport;
import nakadi.HttpException;
import nakadi.JsonSupport;
import nakadi.MetricCollector;
import nakadi.NakadiClient;
import nakadi.NakadiException;
import nakadi.OkHttpResponse;
import nakadi.Problem;
import nakadi.ProblemSupport;
import nakadi.RequestRetry;
import nakadi.Resource;
import nakadi.ResourceOptions;
import nakadi.Response;
import nakadi.ResponseSupport;
import nakadi.RetryPolicy;
import nakadi.RetryableException;
import nakadi.VisibleForTesting;
import nakadi.shadow.io.reactivex.Observable;
import nakadi.shadow.io.reactivex.ObservableTransformer;
import nakadi.shadow.io.reactivex.schedulers.Schedulers;
import nakadi.shadow.okhttp3.MediaType;
import nakadi.shadow.okhttp3.OkHttpClient;
import nakadi.shadow.okhttp3.Request;
import nakadi.shadow.okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OkHttpResource
implements Resource {
    private static final Logger logger = LoggerFactory.getLogger((String)NakadiClient.class.getSimpleName());
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String APPLICATION_JSON_CHARSET_UTF8 = "application/json; charset=utf8";
    private final OkHttpClient okHttpClient;
    private final JsonSupport jsonSupport;
    private final MetricCollector metricCollector;
    private long connectTimeout = 0L;
    private long readTimeout = 0L;
    private long writeTimeout = 0L;
    private volatile boolean hasPerRequestConnectTimeout;
    private volatile boolean hasPerRequestReadTimeout;
    private volatile boolean hasPerRequestWriteTimeout;
    private volatile RetryPolicy retryPolicy;
    private volatile Response response;

    OkHttpResource(OkHttpClient okHttpClient, JsonSupport jsonSupport, MetricCollector collector) {
        NakadiException.throwNonNull(okHttpClient, "Please provide a client");
        NakadiException.throwNonNull(jsonSupport, "Please provide JSON support");
        NakadiException.throwNonNull(collector, "Please provide a metric collector");
        this.okHttpClient = okHttpClient;
        this.jsonSupport = jsonSupport;
        this.metricCollector = collector;
    }

    @Override
    public OkHttpResource connectTimeout(long timeout, TimeUnit unit) {
        NakadiException.throwNonNull(unit, "Please provide a time unit");
        this.connectTimeout = unit.toMillis(timeout);
        this.hasPerRequestConnectTimeout = true;
        return this;
    }

    @Override
    public OkHttpResource readTimeout(long timeout, TimeUnit unit) {
        NakadiException.throwNonNull(unit, "Please provide a time unit");
        this.readTimeout = unit.toMillis(timeout);
        this.hasPerRequestReadTimeout = true;
        return this;
    }

    @Override
    public Resource writeTimeout(long timeout, TimeUnit unit) {
        NakadiException.throwNonNull(unit, "Please provide a time unit");
        this.writeTimeout = unit.toMillis(timeout);
        this.hasPerRequestWriteTimeout = true;
        return this;
    }

    @Override
    public OkHttpResource retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    @Override
    public Response request(String method, String url, ResourceOptions options) throws NakadiException {
        if (this.retryPolicy != null) {
            if (this.retryPolicy.isFinished()) {
                logger.warn("no_retry_cowardly refusing to apply finished retry policy {}", (Object)this.retryPolicy);
                this.metricCollector.mark(MetricCollector.Meter.retrySkipFinished);
            } else {
                Response first = null;
                try {
                    Observable<Response> observable = Observable.defer(() -> Observable.just(this.requestThrowingInner(method, url, options, null)));
                    first = observable.compose(this.buildRetry(this.retryPolicy)).blockingFirst();
                    this.releaseResponseQuietly();
                    return first;
                }
                catch (HttpException e) {
                    if (first != null) {
                        ResponseSupport.closeQuietly(first);
                    }
                    logger.error("retryable_request_failed, {}", (Object)e.getMessage(), (Object)e);
                    return this.response;
                }
            }
        }
        return (Response)Observable.defer(() -> Observable.just(this.requestInner(method, url, options, null))).blockingFirst();
    }

    @Override
    public Response requestThrowing(String method, String url, ResourceOptions options) throws NakadiException {
        return this.maybeComposeRetryPolicy(Observable.defer(() -> Observable.just(this.requestThrowingInner(method, url, options)))).blockingFirst();
    }

    @Override
    public Response requestThrowing(String method, String url, ResourceOptions options, ContentSupplier body) throws NakadiException {
        return this.maybeComposeRetryPolicy(Observable.defer(() -> Observable.just(this.requestThrowingInner(method, url, options, body)))).blockingFirst();
    }

    @Override
    public Response postEventsThrowing(String url, ResourceOptions options, ContentSupplier body) throws NakadiException {
        return this.maybeComposeRetryPolicy(Observable.defer(() -> Observable.just(this.throwPostEventsIfError(this.requestInner("POST", url, options, body))))).blockingFirst();
    }

    @Override
    public <Res> Res requestThrowing(String method, String url, ResourceOptions options, Class<Res> res) throws NakadiException {
        Response response = this.maybeComposeRetryPolicy(Observable.defer(() -> Observable.just(this.requestThrowingInner(method, url, options)))).blockingFirst();
        return this.marshalResponse(response, res);
    }

    @Override
    public <Res> Res requestThrowing(String method, String url, ResourceOptions options, ContentSupplier body, Class<Res> res) throws NakadiException {
        Response response = this.maybeComposeRetryPolicy(Observable.defer(() -> Observable.just(this.requestThrowingInner(method, url, options, body)))).blockingFirst();
        return this.marshalResponse(response, res);
    }

    private void releaseResponseQuietly() {
        if (this.response != null) {
            try {
                ResponseSupport.closeQuietly(this.response, 1);
            }
            finally {
                this.response = null;
            }
        }
    }

    private <Req> Response requestThrowingInner(String method, String url, ResourceOptions options, ContentSupplier body) {
        return this.throwIfError(this.requestInner(method, url, options, body));
    }

    private <Req> Response requestInner(String method, String url, ResourceOptions options, ContentSupplier body) {
        return this.okHttpRequest(this.prepareBuilder(method, url, options, body));
    }

    private Response requestThrowingInner(String method, String url, ResourceOptions options) {
        return this.requestThrowingInner(method, url, options, null);
    }

    private Observable<Response> maybeComposeRetryPolicy(Observable<Response> observable) {
        if (this.retryPolicy != null) {
            if (this.retryPolicy.isFinished()) {
                logger.warn("no_retry_cowardly refusing to compose with finished retry policy {}", (Object)this.retryPolicy);
                this.metricCollector.mark(MetricCollector.Meter.retrySkipFinished);
            } else {
                return observable.compose(this.buildRetry(this.retryPolicy));
            }
        }
        return observable;
    }

    private Request.Builder prepareBuilder(String method, String url, ResourceOptions options, ContentSupplier body) {
        Request.Builder builder;
        if (body != null) {
            RequestBody requestBody = RequestBody.create(MediaType.parse(APPLICATION_JSON_CHARSET_UTF8), body.content());
            builder = new Request.Builder().url(url).method(method, requestBody);
        } else {
            builder = this.applyMethodForNoBody(method, url, new Request.Builder().url(url));
        }
        options.headers().entrySet().stream().filter(this::filterAcceptEncodingGzip).forEach(e -> builder.addHeader((String)e.getKey(), e.getValue().toString()));
        this.applyAuthHeaderIfPresent(options, builder);
        return builder;
    }

    private boolean filterAcceptEncodingGzip(Map.Entry<String, Object> e) {
        return !"Accept-Encoding".equalsIgnoreCase(e.getKey()) || !"gzip".equalsIgnoreCase(e.getValue().toString());
    }

    @VisibleForTesting
    Response okHttpRequest(Request.Builder builder) {
        try {
            return new OkHttpResponse(this.okHttpCall(builder));
        }
        catch (IOException e) {
            throw new RetryableException(Problem.networkProblem(e.getMessage(), ""), (Throwable)e);
        }
    }

    private nakadi.shadow.okhttp3.Response okHttpCall(Request.Builder builder) throws IOException {
        if (this.hasPerRequestReadTimeout || this.hasPerRequestConnectTimeout || this.hasPerRequestWriteTimeout) {
            OkHttpClient.Builder clientBuilder = this.okHttpClient.newBuilder();
            if (this.hasPerRequestReadTimeout) {
                clientBuilder.readTimeout(this.readTimeout, TimeUnit.MILLISECONDS);
            }
            if (this.hasPerRequestConnectTimeout) {
                clientBuilder.connectTimeout(this.connectTimeout, TimeUnit.MILLISECONDS);
            }
            if (this.hasPerRequestConnectTimeout) {
                clientBuilder.writeTimeout(this.writeTimeout, TimeUnit.MILLISECONDS);
            }
            return clientBuilder.build().newCall(builder.build()).execute();
        }
        return this.okHttpClient.newCall(builder.build()).execute();
    }

    private void applyAuthHeaderIfPresent(ResourceOptions options, Request.Builder builder) {
        options.supplyToken().ifPresent(t -> builder.header(HEADER_AUTHORIZATION, (String)t));
    }

    private ObservableTransformer<Response, Response> buildRetry(RetryPolicy backoff) {
        return new RequestRetry().retryWhenWithBackoffObserver(backoff, Schedulers.computation(), ExceptionSupport::isApiRequestRetryable);
    }

    private Request.Builder applyMethodForNoBody(String method, String url, Request.Builder builder) {
        if ("DELETE".equals(method)) {
            return builder.delete();
        }
        if ("GET".equals(method)) {
            return builder.get();
        }
        if ("HEAD".equals(method)) {
            return builder.head();
        }
        logger.warn("unexpected_method_request_with_no_body method={} url={}", (Object)method, (Object)url);
        return builder.method(method, RequestBody.create(MediaType.parse("text/plain"), ""));
    }

    private <Res> Res marshalResponse(Response response, Class<Res> res) {
        if (res != null && res.isAssignableFrom(Response.class)) {
            return (Res)response;
        }
        return this.jsonSupport.fromJson(response.responseBody().asString(), res);
    }

    private Response throwIfError(Response response) {
        int code = response.statusCode();
        if (code >= 200 && code < 300) {
            return response;
        }
        this.response = response;
        return (Response)this.handleError(response);
    }

    private Response throwPostEventsIfError(Response response) {
        int code = response.statusCode();
        if (code == 207 || code == 422) {
            return response;
        }
        return this.throwIfError(response);
    }

    private <T> T handleError(Response response) throws ContractRetryableException {
        Problem problem = ProblemSupport.toProblem(response, this.jsonSupport);
        return this.throwProblem(problem.status(), problem);
    }

    private <T> T throwProblem(int code, Problem problem) {
        return ProblemSupport.throwProblem(code, problem, this.metricCollector);
    }
}

