/*
 * Decompiled with CFR 0.152.
 */
package nakadi;

import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalQuery;
import nakadi.NakadiClient;
import nakadi.shadow.com.google.gson.JsonDeserializationContext;
import nakadi.shadow.com.google.gson.JsonDeserializer;
import nakadi.shadow.com.google.gson.JsonElement;
import nakadi.shadow.com.google.gson.JsonParseException;
import nakadi.shadow.com.google.gson.JsonPrimitive;
import nakadi.shadow.com.google.gson.JsonSerializationContext;
import nakadi.shadow.com.google.gson.JsonSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OffsetDateTimeSerdes
implements JsonDeserializer<OffsetDateTime>,
JsonSerializer<OffsetDateTime> {
    private static final Logger logger = LoggerFactory.getLogger((String)NakadiClient.class.getSimpleName());
    private static final DateTimeFormatter ISO = DateTimeFormatter.ISO_OFFSET_DATE_TIME;

    OffsetDateTimeSerdes() {
    }

    @Override
    public JsonElement serialize(OffsetDateTime src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(this.fromOffsetDateTime(src));
    }

    @Override
    public OffsetDateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String raw = json.getAsString();
        return this.toOffsetDateTime(raw);
    }

    String fromOffsetDateTime(OffsetDateTime src) {
        return ISO.format(src);
    }

    OffsetDateTime toOffsetDateTime(String raw) {
        return this.toDateObject(raw, OffsetDateTime::from);
    }

    private <T> T toDateObject(String raw, TemporalQuery<T> from) {
        return ISO.parse((CharSequence)raw, from);
    }
}

