/*
 * Decompiled with CFR 0.152.
 */
package nakadi;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import nakadi.CompressionSupport;
import nakadi.CompressionSupportGzip;
import nakadi.EmptyTokenProvider;
import nakadi.GsonSupport;
import nakadi.HttpLoggingInterceptor;
import nakadi.JsonSupport;
import nakadi.MetricCollector;
import nakadi.MetricCollectorDevnull;
import nakadi.MetricCollectorSafely;
import nakadi.NakadiException;
import nakadi.OkHttpResourceProvider;
import nakadi.Problem;
import nakadi.ResourceProvider;
import nakadi.Resources;
import nakadi.SecuritySupport;
import nakadi.TokenProvider;
import nakadi.shadow.okhttp3.OkHttpClient;
import nakadi.shadow.okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NakadiClient {
    private static final Logger logger = LoggerFactory.getLogger((String)NakadiClient.class.getSimpleName());
    private static final String VERSION = "0.17.0";
    static final String USER_AGENT = "nakadi-java/0.17.0";
    private final URI baseURI;
    private final JsonSupport jsonSupport;
    private final ResourceProvider resourceProvider;
    private final TokenProvider tokenProvider;
    private final MetricCollector metricCollector;
    private final Resources resources;
    private final String certificatePath;
    private final boolean enablePublishingCompression;
    private final CompressionSupport compressionSupport;

    private NakadiClient(Builder builder) {
        NakadiException.throwNonNull(builder.baseURI, "Please provide a base URI.");
        this.baseURI = builder.baseURI;
        this.jsonSupport = builder.jsonSupport;
        this.resourceProvider = builder.resourceProvider;
        this.tokenProvider = builder.tokenProvider;
        this.metricCollector = builder.metricCollector;
        this.resources = new Resources(this);
        this.certificatePath = builder.certificatePath;
        this.enablePublishingCompression = builder.enablePublishingCompression;
        this.compressionSupport = builder.compressionSupport;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public URI baseURI() {
        return this.baseURI;
    }

    public ResourceProvider resourceProvider() {
        return this.resourceProvider;
    }

    public TokenProvider resourceTokenProvider() {
        return this.tokenProvider;
    }

    public JsonSupport jsonSupport() {
        return this.jsonSupport;
    }

    public CompressionSupport compressionSupport() {
        return this.compressionSupport;
    }

    public MetricCollector metricCollector() {
        return this.metricCollector;
    }

    public String certificatePath() {
        return this.certificatePath;
    }

    boolean enablePublishingCompression() {
        return this.enablePublishingCompression;
    }

    public Resources resources() {
        return this.resources;
    }

    public static class Builder {
        private URI baseURI;
        private JsonSupport jsonSupport;
        private ResourceProvider resourceProvider;
        private TokenProvider tokenProvider;
        private MetricCollector metricCollector;
        private long connectTimeout = 20000L;
        private long readTimeout = 20000L;
        private long writeTimeout = 10000L;
        private boolean enableHttpLogging;
        private boolean enablePublishingCompression;
        private CompressionSupport compressionSupport;
        private String certificatePath;

        Builder() {
        }

        public NakadiClient build() {
            NakadiException.throwNonNull(this.baseURI, "Please provide a base URI");
            if (this.jsonSupport == null) {
                this.jsonSupport = new GsonSupport();
            }
            if (this.compressionSupport == null) {
                this.compressionSupport = new CompressionSupportGzip();
            }
            logger.info("Loaded compression support {}", (Object)this.compressionSupport.getClass().getName());
            if (this.tokenProvider == null) {
                this.tokenProvider = new EmptyTokenProvider();
            }
            logger.info("Loaded resource token provider {}", (Object)this.tokenProvider.getClass().getName());
            if (this.metricCollector == null) {
                this.metricCollector = new MetricCollectorDevnull();
            }
            logger.info("Loaded metric collector {}", (Object)this.metricCollector.getClass().getName());
            this.metricCollector = new MetricCollectorSafely(this.metricCollector);
            if (this.resourceProvider == null) {
                this.resourceProvider = this.buildResourceProvider();
            }
            return new NakadiClient(this);
        }

        private ResourceProvider buildResourceProvider() {
            OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(this.connectTimeout, TimeUnit.MILLISECONDS).readTimeout(this.readTimeout, TimeUnit.MILLISECONDS).writeTimeout(this.writeTimeout, TimeUnit.MILLISECONDS);
            if (this.certificatePath != null) {
                new SecuritySupport(this.certificatePath).applySslSocketFactory(builder);
            }
            if (this.enableHttpLogging) {
                builder = builder.addNetworkInterceptor(new HttpLoggingInterceptor(new HttpLoggingInterceptor.Logger(){
                    final Logger httpLogger = LoggerFactory.getLogger((String)"NakadiClientHttpLog");

                    @Override
                    public void log(String message) {
                        this.httpLogger.info(message);
                    }
                }).setLevel(HttpLoggingInterceptor.Level.BODY));
                logger.info("Enabled http tracing");
            }
            return new OkHttpResourceProvider(builder.build(), this.jsonSupport, this.metricCollector);
        }

        public Builder enableHttpLogging() {
            this.enableHttpLogging = true;
            return this;
        }

        public Builder enablePublishingCompression() {
            this.enablePublishingCompression = true;
            return this;
        }

        public Builder connectTimeout(long timeout, TimeUnit unit) {
            this.connectTimeout = unit.toMillis(timeout);
            return this;
        }

        public Builder readTimeout(long timeout, TimeUnit unit) {
            this.readTimeout = unit.toMillis(timeout);
            return this;
        }

        public Builder writeTimeout(long timeout, TimeUnit unit) {
            this.writeTimeout = unit.toMillis(timeout);
            return this;
        }

        public Builder tokenProvider(TokenProvider tokenProvider) {
            this.tokenProvider = tokenProvider;
            return this;
        }

        public Builder metricCollector(MetricCollector metricCollector) {
            this.metricCollector = metricCollector;
            return this;
        }

        public Builder baseURI(URI baseURI) {
            this.baseURI = baseURI;
            return this;
        }

        public Builder baseURI(String baseURI) {
            try {
                this.baseURI(new URI(baseURI));
                return this;
            }
            catch (URISyntaxException e) {
                throw new NakadiException(Problem.localProblem(String.format("Bad base URI [%s]", baseURI), e.getMessage()), (Throwable)e);
            }
        }

        public Builder certificatePath(String path) {
            this.certificatePath = path;
            return this;
        }

        public Builder jsonSupport(JsonSupport jsonSupport) {
            this.jsonSupport = jsonSupport;
            return this;
        }
    }
}

