/*
 * Decompiled with CFR 0.152.
 */
package nakadi;

import java.lang.reflect.Type;
import java.util.Map;
import nakadi.AuthorizationException;
import nakadi.ClientException;
import nakadi.InvalidException;
import nakadi.Metrics;
import nakadi.NakadiClient;
import nakadi.NakadiException;
import nakadi.RateLimitException;
import nakadi.ResourceOptions;
import nakadi.ResourceSupport;
import nakadi.Response;
import nakadi.RetryPolicy;
import nakadi.ServerException;
import nakadi.UriBuilder;
import nakadi.shadow.com.google.gson.reflect.TypeToken;

public class MetricsResource {
    public static final String PATH = "metrics";
    private static final String APPLICATION_JSON = "application/json";
    private static final Type TYPE = new TypeToken<Map<String, Object>>(){}.getType();
    private final NakadiClient client;
    private volatile RetryPolicy retryPolicy;

    public MetricsResource(NakadiClient client) {
        this.client = client;
    }

    public MetricsResource retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public Metrics get() throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException, NakadiException {
        String url = UriBuilder.builder(this.client.baseURI()).path(PATH).buildString();
        Response response = this.client.resourceProvider().newResource().retryPolicy(this.retryPolicy).requestThrowing("GET", url, this.prepareOptions());
        Map items = (Map)this.client.jsonSupport().fromJson(response.responseBody().asString(), TYPE);
        return new Metrics().items(items);
    }

    private ResourceOptions prepareOptions() {
        return ResourceSupport.options(APPLICATION_JSON).tokenProvider(this.client.resourceTokenProvider());
    }
}

