/*
 * Decompiled with CFR 0.152.
 */
package nakadi;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import nakadi.NakadiClient;
import nakadi.StreamBatch;
import nakadi.StreamBatchRecord;
import nakadi.StreamCursorContext;
import nakadi.StreamObserverBackPressure;
import nakadi.StreamOffsetObserver;
import nakadi.UndefinedEventMapped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingUndefinedEventObserver
extends StreamObserverBackPressure<UndefinedEventMapped<Map<String, Object>>> {
    private static final Logger logger = LoggerFactory.getLogger((String)NakadiClient.class.getSimpleName());

    @Override
    public void onStart() {
        logger.info("LoggingUndefinedEventObserver.onStart");
    }

    @Override
    public void onStop() {
        logger.info("LoggingUndefinedEventObserver.onStop");
    }

    @Override
    public void onCompleted() {
        logger.info(String.format("LoggingUndefinedEventObserver.onCompleted %s", Thread.currentThread().getName()));
    }

    @Override
    public void onError(Throwable e) {
        logger.info(String.format("LoggingUndefinedEventObserver.onError %s %s", e.getMessage(), Thread.currentThread().getName()));
        if (e instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void onNext(StreamBatchRecord<UndefinedEventMapped<Map<String, Object>>> record) {
        StreamOffsetObserver offsetObserver = record.streamOffsetObserver();
        StreamBatch<UndefinedEventMapped<Map<String, Object>>> batch = record.streamBatch();
        StreamCursorContext cursor = record.streamCursorContext();
        logger.info(String.format("LoggingUndefinedEventObserver: partition: %s ------------- %s", cursor.cursor().partition(), Thread.currentThread().getName()));
        if (batch.isEmpty()) {
            logger.info(String.format("LoggingUndefinedEventObserver: partition: %s empty batch", cursor.cursor().partition()));
        } else {
            List<UndefinedEventMapped<Map<String, Object>>> events = batch.events();
            for (UndefinedEventMapped<Map<String, Object>> event : events) {
                logger.info(String.format("LoggingUndefinedEventObserver: EVENT: %s ", event));
            }
        }
        offsetObserver.onNext(record.streamCursorContext());
    }

    @Override
    public Optional<Long> requestBackPressure() {
        return Optional.empty();
    }

    @Override
    public Optional<Integer> requestBuffer() {
        return Optional.empty();
    }
}

