/*
 * Decompiled with CFR 0.152.
 */
package nakadi;

import java.util.List;
import java.util.Map;
import nakadi.BusinessEventMapped;
import nakadi.StreamBatch;
import nakadi.StreamBatchRecord;
import nakadi.StreamCursorContext;
import nakadi.StreamObserverBackPressure;
import nakadi.StreamOffsetObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingBusinessEventObserver
extends StreamObserverBackPressure<BusinessEventMapped<Map<String, Object>>> {
    private static final Logger logger = LoggerFactory.getLogger(LoggingBusinessEventObserver.class);

    @Override
    public void onStart() {
        logger.info("onStart");
    }

    @Override
    public void onStop() {
        logger.info("onStop");
    }

    @Override
    public void onCompleted() {
        logger.info("onCompleted {}", (Object)Thread.currentThread().getName());
    }

    @Override
    public void onError(Throwable e) {
        logger.info("onError {} {}", (Object)e.getMessage(), (Object)Thread.currentThread().getName());
        if (e instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void onNext(StreamBatchRecord<BusinessEventMapped<Map<String, Object>>> record) {
        StreamOffsetObserver offsetObserver = record.streamOffsetObserver();
        StreamBatch<BusinessEventMapped<Map<String, Object>>> batch = record.streamBatch();
        StreamCursorContext cursor = record.streamCursorContext();
        logger.info("partition: {} ------------- {}", (Object)cursor.cursor().partition(), (Object)Thread.currentThread().getName());
        if (batch.isEmpty()) {
            logger.info("partition: %s empty batch", (Object)cursor.cursor().partition());
        } else {
            List<BusinessEventMapped<Map<String, Object>>> events = batch.events();
            for (BusinessEventMapped<Map<String, Object>> event : events) {
                int hashCode = event.hashCode();
                logger.info("{} event ------------- ", (Object)hashCode);
                logger.info("{} metadata: {} ", (Object)hashCode, (Object)event.metadata());
                logger.info("{} data: {} ", (Object)hashCode, event.data());
            }
        }
        offsetObserver.onNext(record.streamCursorContext());
    }
}

