/*
 * Decompiled with CFR 0.152.
 */
package nakadi;

import nakadi.AuthorizationException;
import nakadi.ClientException;
import nakadi.InvalidException;
import nakadi.NakadiClient;
import nakadi.NakadiException;
import nakadi.RateLimitException;
import nakadi.Resource;
import nakadi.ResourceSupport;
import nakadi.Response;
import nakadi.RetryPolicy;
import nakadi.ServerException;
import nakadi.UriBuilder;

public class HealthCheckResource {
    private final NakadiClient client;
    private volatile RetryPolicy retryPolicy;

    public HealthCheckResource(NakadiClient client) {
        this.client = client;
    }

    public HealthCheckResource retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public Response healthcheck() throws NakadiException {
        Resource resource = this.client.resourceProvider().newResource();
        return resource.retryPolicy(this.retryPolicy).request("GET", UriBuilder.builder(this.client.baseURI()).path("health").buildString(), ResourceSupport.options("*/*").tokenProvider(this.client.resourceTokenProvider()));
    }

    public Response healthcheckThrowing() throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException, NakadiException {
        Resource resource = this.client.resourceProvider().newResource();
        return resource.retryPolicy(this.retryPolicy).requestThrowing("GET", UriBuilder.builder(this.client.baseURI()).path("health").buildString(), ResourceSupport.options("*/*").tokenProvider(this.client.resourceTokenProvider()), Response.class);
    }
}

