/*
 * Decompiled with CFR 0.152.
 */
package nakadi;

import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import nakadi.BusinessEventMapped;
import nakadi.Event;
import nakadi.EventMetadata;
import nakadi.EventRecord;
import nakadi.EventStreamBatch;
import nakadi.JsonSupport;
import nakadi.OffsetDateTimeSerdes;
import nakadi.UndefinedEventMapped;
import nakadi.VisibleForTesting;
import nakadi.shadow.com.google.common.base.Charsets;
import nakadi.shadow.com.google.gson.FieldNamingPolicy;
import nakadi.shadow.com.google.gson.Gson;
import nakadi.shadow.com.google.gson.GsonBuilder;
import nakadi.shadow.com.google.gson.JsonElement;
import nakadi.shadow.com.google.gson.JsonObject;
import nakadi.shadow.com.google.gson.reflect.TypeToken;

class GsonSupport
implements JsonSupport {
    private static final Type EVENT_STREAM_BATCH_FIRSTPASS_TYPE = new TypeToken<EventStreamBatch<JsonObject>>(){}.getType();
    private static final String METADATA_FIELD = "metadata";
    private static final Type OFFSET_DATE_TIME_TYPE = new TypeToken<OffsetDateTime>(){}.getType();
    private final Gson gson = GsonSupport.gson();
    private final Gson gsonCompressed = GsonSupport.gsonCompressed();

    static <T> boolean isAssignableFrom(Type type, Class<? super T> c) {
        TypeToken<?> typeToken = TypeToken.get(type);
        Class<?> rawType = typeToken.getRawType();
        return c.isAssignableFrom(rawType);
    }

    public static Gson gsonCompressed() {
        return GsonCompressedHolder.INSTANCE;
    }

    public static Gson gson() {
        return GsonHolder.INSTANCE;
    }

    @Override
    public String toJsonCompressed(Object o) {
        return this.gsonCompressed.toJson(o);
    }

    @Override
    public String toJson(Object o) {
        return this.gson.toJson(o);
    }

    @Override
    public byte[] toJsonBytes(Object o) {
        return this.toJson(o).getBytes(Charsets.UTF_8);
    }

    @Override
    public byte[] toJsonBytesCompressed(Object o) {
        return this.toJsonCompressed(o).getBytes(Charsets.UTF_8);
    }

    @Override
    public <T> T fromJson(String raw, Class<T> c) {
        if (String.class.isAssignableFrom(c)) {
            return (T)raw;
        }
        return this.gson.fromJson(raw, c);
    }

    @Override
    public <T> T fromJson(String raw, Type tType) {
        if (tType.getTypeName().equals("java.lang.String")) {
            return (T)raw;
        }
        return this.gson.fromJson(raw, tType);
    }

    public <T> T fromJson(JsonObject jsonObject, Type tType) {
        if (tType.getTypeName().equals("java.lang.String")) {
            return (T)jsonObject.toString();
        }
        return this.gson.fromJson((JsonElement)jsonObject, tType);
    }

    @Override
    public <T> T fromJson(Reader r, Class<T> c) {
        return this.gson.fromJson(r, c);
    }

    @Override
    public <T> T fromJson(Reader r, Type tType) {
        return this.gson.fromJson(r, tType);
    }

    @Override
    public <T> Object transformEventRecord(EventRecord<T> eventRecord) {
        if (eventRecord.event().getClass().isAssignableFrom(BusinessEventMapped.class)) {
            BusinessEventMapped businessEvent = (BusinessEventMapped)eventRecord.event();
            Gson gson = GsonSupport.gson();
            JsonObject jsonObject = new JsonObject();
            jsonObject.add(METADATA_FIELD, gson.toJsonTree(businessEvent.metadata()));
            JsonElement jsonElement = gson.toJsonTree(businessEvent.data());
            for (Map.Entry<String, JsonElement> entry : jsonElement.getAsJsonObject().entrySet()) {
                jsonObject.add(entry.getKey(), entry.getValue());
            }
            return jsonObject;
        }
        if (eventRecord.event().getClass().isAssignableFrom(UndefinedEventMapped.class)) {
            UndefinedEventMapped mapped = (UndefinedEventMapped)eventRecord.event();
            return mapped.data();
        }
        return eventRecord.event();
    }

    private <T> UndefinedEventMapped<T> marshalUndefinedEventMapped(JsonObject jo, Type type) {
        return this.marshalUndefinedEventMapped(type, (Type t) -> this.fromJson(jo, (Type)t));
    }

    private <T> UndefinedEventMapped<T> marshalUndefinedEventMapped(String raw, Type type) {
        return this.marshalUndefinedEventMapped(type, (Type t) -> this.fromJson(raw, (Type)t));
    }

    private <T> UndefinedEventMapped<T> marshalUndefinedEventMapped(Type type, Function<Type, T> function) {
        if (!GsonSupport.isAssignableFrom(type, UndefinedEventMapped.class)) {
            throw new IllegalArgumentException("Supplied type must be assignable from UndefinedEventMapped " + type.getTypeName());
        }
        return this.toUndefinedEventMapped(type, function);
    }

    private <T> UndefinedEventMapped<T> toUndefinedEventMapped(Type type, Function<Type, T> function) {
        if (type instanceof ParameterizedType) {
            ParameterizedType genericType = (ParameterizedType)type;
            Type[] actualTypeArguments = genericType.getActualTypeArguments();
            Type serdeType = actualTypeArguments[0];
            T data = function.apply(serdeType);
            return new UndefinedEventMapped<T>(data);
        }
        throw new IllegalArgumentException("Supplied type must be a parameterized UndefinedEventMapped" + type.getTypeName());
    }

    @VisibleForTesting
    <T> BusinessEventMapped<T> marshalBusinessEventMapped(String raw, Type type) {
        if (!GsonSupport.isAssignableFrom(type, BusinessEventMapped.class)) {
            throw new IllegalArgumentException("Supplied type must be assignable BusinessEventMapped " + type.getTypeName());
        }
        return this.marshalBusinessEventMapped(this.fromJson(raw, JsonObject.class), type);
    }

    private <T> BusinessEventMapped<T> marshalBusinessEventMapped(JsonObject jo, Type type) {
        EventMetadata metadata = this.gson.fromJson(jo.remove(METADATA_FIELD), EventMetadata.class);
        Function<Type, Object> function = serdeType -> this.fromJson(jo, (Type)serdeType);
        if (type instanceof ParameterizedType) {
            ParameterizedType genericType = (ParameterizedType)type;
            Type[] actualTypeArguments = genericType.getActualTypeArguments();
            Type serdeType2 = actualTypeArguments[0];
            Object data = function.apply(serdeType2);
            return new BusinessEventMapped<Object>(data, metadata);
        }
        throw new IllegalArgumentException("Supplied type must be a parameterized BusinessEventMapped" + type.getTypeName());
    }

    private <T> T marshalJsonObjectToEvent(JsonObject json, Type type) {
        Event<T> t = GsonSupport.isAssignableFrom(type, UndefinedEventMapped.class) ? this.marshalUndefinedEventMapped(json, type) : (GsonSupport.isAssignableFrom(type, BusinessEventMapped.class) ? this.marshalBusinessEventMapped(json, type) : this.fromJson(json, type));
        return (T)t;
    }

    @Override
    public <T> EventStreamBatch<T> marshalEventStreamBatch(String raw, Type type) {
        EventStreamBatch<JsonObject> esb = this.marshalBatch(raw, EVENT_STREAM_BATCH_FIRSTPASS_TYPE);
        List<T> ts = this.marshallEvents(type, esb.events());
        esb.events().clear();
        return new EventStreamBatch<T>(esb.cursor(), esb.info(), ts);
    }

    private EventStreamBatch<JsonObject> marshalBatch(String line, Type type) {
        return (EventStreamBatch)this.fromJson(line, type);
    }

    private <T> List<T> marshallEvents(Type type, List<JsonObject> events) {
        return events.stream().map(e -> this.marshalJsonObjectToEvent((JsonObject)e, type)).collect(Collectors.toList());
    }

    static /* synthetic */ Type access$200() {
        return OFFSET_DATE_TIME_TYPE;
    }

    private static class GsonHolder {
        private static final Gson INSTANCE = new GsonBuilder().setPrettyPrinting().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(GsonSupport.access$200(), new OffsetDateTimeSerdes()).setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").create();

        private GsonHolder() {
        }
    }

    private static class GsonCompressedHolder {
        private static final Gson INSTANCE = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(GsonSupport.access$200(), new OffsetDateTimeSerdes()).setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").create();

        private GsonCompressedHolder() {
        }
    }
}

