/*
 * Decompiled with CFR 0.152.
 */
package nakadi;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import nakadi.NakadiException;
import nakadi.RetryPolicy;

public class ExponentialRetry
implements RetryPolicy {
    public static final int MAX_INTERVAL_MIN_AS_MILLIS = 20;
    public static final int INITIAL_INTERVAL_MIN_AS_MILLIS = 10;
    public static final float PERCENT_OF_MAX_INTERVAL_AS_JITTER = 10.0f;
    static final int DEFAULT_INITIAL_INTERVAL_MILLIS = 1000;
    static final int DEFAULT_MAX_INTERVAL_MILLIS = 32000;
    static final int DEFAULT_MAX_ATTEMPTS = Integer.MAX_VALUE;
    static final long DEFAULT_MAX_TIME = Long.MAX_VALUE;
    private final long initialInterval;
    private final long maxInterval;
    int maxAttempts;
    long workingAttempts = 1L;
    long maxTime;
    long workingTime = 0L;
    TimeUnit unit;
    private long workingInterval;
    private volatile long startTime = 0L;
    private float percentOfMaxIntervalForJitter;

    ExponentialRetry(Builder builder) {
        this.initialInterval = Math.min(builder.maxInterval, builder.initialInterval);
        this.maxInterval = builder.maxInterval;
        this.workingInterval = this.initialInterval;
        this.maxAttempts = builder.maxAttempts;
        this.unit = builder.unit;
        this.maxTime = builder.maxTime;
        this.percentOfMaxIntervalForJitter = builder.percentOfMaxIntervalForJitter;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public long initialInterval() {
        return this.initialInterval;
    }

    public long maxIntervalMillis() {
        return this.maxInterval;
    }

    @Override
    public boolean isFinished() {
        return this.workingAttempts >= (long)this.maxAttempts || this.workingTime >= this.maxTime;
    }

    @Override
    public long nextBackoffMillis() {
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        } else {
            this.workingTime += System.currentTimeMillis() - this.startTime;
        }
        if (this.isFinished()) {
            return -1L;
        }
        this.workingInterval = this.unit.toMillis(this.workingInterval) * (this.workingAttempts * this.workingAttempts);
        ++this.workingAttempts;
        if (this.workingInterval <= 0L) {
            this.workingInterval = this.unit.toMillis(this.maxInterval);
        }
        if (this.initialInterval != this.workingInterval) {
            this.workingInterval = Math.min(this.maxInterval, ThreadLocalRandom.current().nextLong(this.initialInterval, this.workingInterval));
            if (this.workingInterval == this.maxInterval) {
                long percentMax = (long)((float)this.maxInterval * (this.percentOfMaxIntervalForJitter / 100.0f));
                this.workingInterval = ThreadLocalRandom.current().nextLong(this.maxInterval - percentMax, this.maxInterval);
            }
        }
        return this.workingInterval;
    }

    @Override
    public int maxAttempts() {
        return this.maxAttempts;
    }

    @Override
    public long workingAttempts() {
        return this.workingAttempts;
    }

    public String toString() {
        return "ExponentialRetry{workingInterval=" + this.workingInterval + ", initialInterval=" + this.initialInterval + ", maxInterval=" + this.maxInterval + ", maxAttempts=" + this.maxAttempts + ", workingAttempts=" + this.workingAttempts + ", unit=" + (Object)((Object)this.unit) + '}';
    }

    public static class Builder {
        private final TimeUnit unit = TimeUnit.MILLISECONDS;
        public float percentOfMaxIntervalForJitter = 10.0f;
        private long initialInterval = 1000L;
        private long maxInterval = 32000L;
        private int maxAttempts = Integer.MAX_VALUE;
        private long maxTime = Long.MAX_VALUE;

        private Builder() {
        }

        public Builder initialInterval(long initialInterval, TimeUnit unit) {
            NakadiException.throwNonNull(unit, "Please provide a TimeUnit");
            this.initialInterval = unit.toMillis(initialInterval);
            if (this.initialInterval < 10L) {
                NakadiException.throwNonNull(null, "Please provide an initial value of at least 10 millis");
            }
            return this;
        }

        public Builder maxInterval(long maxInterval, TimeUnit unit) {
            NakadiException.throwNonNull(unit, "Please provide a TimeUnit");
            this.maxInterval = unit.toMillis(maxInterval);
            if (this.maxInterval < 20L) {
                NakadiException.throwNonNull(null, "Please provide a max interval value of at least 20 millis");
            }
            return this;
        }

        public Builder maxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public Builder maxTime(long maxTime, TimeUnit unit) {
            NakadiException.throwNonNull(unit, "Please provide a TimeUnit");
            this.maxTime = unit.toMillis(maxTime);
            return this;
        }

        public Builder percentOfMaxIntervalForJitter(int percentOfMaxIntervalForJitter) {
            this.percentOfMaxIntervalForJitter = (float)percentOfMaxIntervalForJitter + 0.0f;
            return this;
        }

        public ExponentialRetry build() {
            return new ExponentialRetry(this);
        }
    }
}

