/*
 * Decompiled with CFR 0.152.
 */
package nakadi;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import nakadi.NakadiClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorServiceSupport {
    private static final Logger logger = LoggerFactory.getLogger((String)NakadiClient.class.getSimpleName());

    public static void shutdown(ExecutorService executorService) {
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(8L, TimeUnit.SECONDS)) {
                executorService.shutdownNow();
                if (!executorService.awaitTermination(16L, TimeUnit.SECONDS)) {
                    logger.info(String.format("executor service did not shutdown cleanly %s", executorService.toString()));
                }
            }
        }
        catch (InterruptedException e) {
            executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

