/*
 * Decompiled with CFR 0.152.
 */
package nakadi;

import java.io.InterruptedIOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import nakadi.AuthorizationException;
import nakadi.ClientException;
import nakadi.ConflictException;
import nakadi.InvalidException;
import nakadi.NakadiClient;
import nakadi.NakadiException;
import nakadi.NonRetryableNakadiException;
import nakadi.NotFoundException;
import nakadi.PreconditionFailedException;
import nakadi.RateLimitException;
import nakadi.ServerException;
import nakadi.VisibleForTesting;
import nakadi.shadow.io.reactivex.exceptions.UndeliverableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExceptionSupport {
    private static final Map<Integer, Class> CODES_TO_EXCEPTIONS = new HashMap<Integer, Class>();
    private static final Logger logger = LoggerFactory.getLogger((String)NakadiClient.class.getSimpleName());

    ExceptionSupport() {
    }

    static boolean isInterruptedIOException(Throwable e) {
        return e instanceof UndeliverableException && e.getCause() != null && e.getCause() instanceof UncheckedIOException && e.getCause().getCause() != null && e.getCause().getCause() instanceof InterruptedIOException;
    }

    static Map<Integer, Class> responseCodesToExceptionsMap() {
        return CODES_TO_EXCEPTIONS;
    }

    static boolean isConsumerStreamRetryable(Throwable e) {
        if (e instanceof Error) {
            logger.error(String.format("non_retryable_error_class_consumer %s %s", e.getClass(), e.getMessage()), e);
            return false;
        }
        if (ExceptionSupport.nonRetryableException(e)) {
            logger.error(String.format("non_retryable_exception %s %s", e.getClass(), e.getMessage()), e);
            return false;
        }
        if (e instanceof NonRetryableNakadiException) {
            logger.error(String.format("non_retryable_nakadi_exception_consumer %s %s", e.getClass(), e.getMessage()), e);
            return false;
        }
        if (e instanceof NotFoundException) {
            logger.error(String.format("non_retryable_not_found_exception_consumer %s %s", e.getClass(), e.getMessage()), e);
            return false;
        }
        logger.info(String.format("retryable_exception_consumer %s %s", e.getClass(), e.getMessage()));
        return true;
    }

    private static boolean nonRetryableException(Throwable e) {
        return e instanceof IllegalStateException;
    }

    @VisibleForTesting
    static boolean isApiRequestRetryable(Throwable e) {
        if (e instanceof Error) {
            logger.error(String.format("non_retryable_error_class_api %s %s", e.getClass(), e.getMessage()), e);
            return false;
        }
        if (e instanceof NonRetryableNakadiException) {
            logger.error(String.format("non_retryable_nakadi_exception_api %s %s", e.getClass(), e.getMessage()), e);
            return false;
        }
        if (e instanceof NotFoundException) {
            logger.error(String.format("non_retryable_not_found_exception_api %s %s", e.getClass(), e.getMessage()), e);
            return false;
        }
        if (e instanceof NakadiException) {
            logger.info(String.format("retryable_nakadi_exception %s %s", e.getClass(), e.getMessage()), e);
            return true;
        }
        logger.info(String.format("retryable_exception %s %s", e.getClass(), e.getMessage()), e);
        return true;
    }

    static {
        CODES_TO_EXCEPTIONS.put(400, ClientException.class);
        CODES_TO_EXCEPTIONS.put(401, AuthorizationException.class);
        CODES_TO_EXCEPTIONS.put(403, AuthorizationException.class);
        CODES_TO_EXCEPTIONS.put(404, NotFoundException.class);
        CODES_TO_EXCEPTIONS.put(409, ConflictException.class);
        CODES_TO_EXCEPTIONS.put(412, PreconditionFailedException.class);
        CODES_TO_EXCEPTIONS.put(422, InvalidException.class);
        CODES_TO_EXCEPTIONS.put(429, RateLimitException.class);
        CODES_TO_EXCEPTIONS.put(500, ServerException.class);
        CODES_TO_EXCEPTIONS.put(503, ServerException.class);
    }
}

