/*
 * Decompiled with CFR 0.152.
 */
package nakadi;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import nakadi.AuthorizationException;
import nakadi.ClientException;
import nakadi.Cursor;
import nakadi.CursorCollection;
import nakadi.CursorDistance;
import nakadi.CursorDistanceCollection;
import nakadi.EventType;
import nakadi.EventTypeCollection;
import nakadi.EventTypeResource;
import nakadi.EventTypeSchema;
import nakadi.EventTypeSchemaCollection;
import nakadi.InvalidException;
import nakadi.LinkSupport;
import nakadi.NakadiClient;
import nakadi.NakadiException;
import nakadi.NotFoundException;
import nakadi.PaginationLinks;
import nakadi.Partition;
import nakadi.PartitionCollection;
import nakadi.QueryParams;
import nakadi.RateLimitException;
import nakadi.ResourceLink;
import nakadi.ResourceOptions;
import nakadi.ResourceSupport;
import nakadi.Response;
import nakadi.RetryPolicy;
import nakadi.ServerException;
import nakadi.UriBuilder;
import nakadi.shadow.com.google.gson.reflect.TypeToken;

class EventTypeResourceReal
implements EventTypeResource {
    private static final String PATH_EVENT_TYPES = "event-types";
    private static final String PATH_PARTITIONS = "partitions";
    private static final String PATH_SCHEMAS = "schemas";
    private static final String PATH_CURSOR_SHIFTS = "shifted-cursors";
    private static final String PATH_CURSOR_DISTANCE = "cursor-distances";
    private static final String APPLICATION_JSON = "application/json";
    private static final Type TYPE = new TypeToken<List<EventType>>(){}.getType();
    private static final Type TYPE_P = new TypeToken<List<Partition>>(){}.getType();
    private static final Type TYPE_ETS = new TypeToken<List<EventTypeSchema>>(){}.getType();
    private static final Type TYPE_C = new TypeToken<List<Cursor>>(){}.getType();
    private static final Type TYPE_CD = new TypeToken<List<CursorDistance>>(){}.getType();
    private static final List<ResourceLink> SENTINEL_LINKS = Collections.emptyList();
    private final NakadiClient client;
    private volatile RetryPolicy retryPolicy;

    EventTypeResourceReal(NakadiClient client) {
        this.client = client;
    }

    @Override
    @Deprecated
    public EventTypeResource scope(String scope) {
        return this;
    }

    @Override
    public EventTypeResource retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    @Override
    public Response create(EventType eventType) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException, NakadiException {
        ResourceOptions options = this.prepareOptions();
        return this.client.resourceProvider().newResource().retryPolicy(this.retryPolicy).requestThrowing("POST", this.collectionUri().buildString(), options, () -> this.client.jsonSupport().toJsonBytes(eventType));
    }

    @Override
    public Response update(EventType eventType) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException, NakadiException {
        String url = this.collectionUri().path(eventType.name()).buildString();
        ResourceOptions options = this.prepareOptions();
        return this.client.resourceProvider().newResource().retryPolicy(this.retryPolicy).requestThrowing("PUT", url, options, () -> this.client.jsonSupport().toJsonBytes(eventType));
    }

    @Override
    public EventType findByName(String eventTypeName) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException, NakadiException {
        String url = this.collectionUri().path(eventTypeName).buildString();
        ResourceOptions options = this.prepareOptions();
        return this.client.resourceProvider().newResource().retryPolicy(this.retryPolicy).requestThrowing("GET", url, options, EventType.class);
    }

    @Override
    public Optional<EventType> tryFindByName(String eventTypeName) throws AuthorizationException, ClientException, ServerException, RateLimitException, NakadiException {
        try {
            return Optional.of(this.findByName(eventTypeName));
        }
        catch (NotFoundException e) {
            return Optional.empty();
        }
    }

    @Override
    public Response delete(String eventTypeName) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException, NakadiException {
        String url = this.collectionUri().path(eventTypeName).buildString();
        ResourceOptions options = this.prepareOptions();
        return this.client.resourceProvider().newResource().retryPolicy(this.retryPolicy).requestThrowing("DELETE", url, options);
    }

    @Override
    public EventTypeCollection list() throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException, NakadiException {
        return this.loadPage(this.collectionUri().buildString());
    }

    @Override
    public PartitionCollection partitions(String eventTypeName) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException, NakadiException {
        return this.loadPartitionPage(this.collectionUri().path(eventTypeName).path(PATH_PARTITIONS).buildString());
    }

    @Override
    public Partition partition(String eventTypeName, String partitionId) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException, NakadiException {
        String url = this.collectionUri().path(eventTypeName).path(PATH_PARTITIONS).path(partitionId).buildString();
        ResourceOptions options = this.prepareOptions();
        return this.client.resourceProvider().newResource().retryPolicy(this.retryPolicy).requestThrowing("GET", url, options, Partition.class);
    }

    @Override
    public Partition partition(String eventTypeName, String partitionId, QueryParams params) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException, NakadiException {
        String url = this.collectionUri().path(eventTypeName).path(PATH_PARTITIONS).path(partitionId).query(params).buildString();
        ResourceOptions options = this.prepareOptions();
        return this.client.resourceProvider().newResource().retryPolicy(this.retryPolicy).requestThrowing("GET", url, options, Partition.class);
    }

    @Override
    public EventTypeSchemaCollection schemas(String eventTypeName) throws AuthorizationException, ClientException, ServerException, RateLimitException, NakadiException {
        return this.loadSchemaPage(this.collectionUri().path(eventTypeName).path(PATH_SCHEMAS).buildString());
    }

    @Override
    public CursorCollection shift(String eventTypeName, List<Cursor> cursorList) {
        NakadiException.throwNotNullOrEmpty(cursorList, "Please provide at least one cursor");
        String url = this.collectionUri().path(eventTypeName).path(PATH_CURSOR_SHIFTS).buildString();
        ResourceOptions options = this.prepareOptions();
        Response response = this.client.resourceProvider().newResource().retryPolicy(this.retryPolicy).requestThrowing("POST", url, options, () -> this.client.jsonSupport().toJsonBytes(cursorList));
        List collection = (List)this.client.jsonSupport().fromJson(response.responseBody().asString(), TYPE_C);
        return new CursorCollection(collection, SENTINEL_LINKS, this.client);
    }

    @Override
    public CursorDistanceCollection distance(String eventTypeName, List<CursorDistance> cursorDistanceList) {
        String url = this.collectionUri().path(eventTypeName).path(PATH_CURSOR_DISTANCE).buildString();
        ResourceOptions options = this.prepareOptions();
        Response response = this.client.resourceProvider().newResource().retryPolicy(this.retryPolicy).requestThrowing("POST", url, options, () -> this.client.jsonSupport().toJsonBytes(cursorDistanceList));
        List collection = (List)this.client.jsonSupport().fromJson(response.responseBody().asString(), TYPE_CD);
        return new CursorDistanceCollection(collection, SENTINEL_LINKS, this.client);
    }

    @Override
    public PartitionCollection lag(String eventTypeName, List<Cursor> cursors) {
        String url = this.collectionUri().path(eventTypeName).path("cursors-lag").buildString();
        ResourceOptions options = this.prepareOptions();
        Response response = this.client.resourceProvider().newResource().retryPolicy(this.retryPolicy).requestThrowing("POST", url, options, () -> this.client.jsonSupport().toJsonBytes(cursors));
        List collection = (List)this.client.jsonSupport().fromJson(response.responseBody().asString(), TYPE_P);
        return new PartitionCollection(collection, SENTINEL_LINKS, this, this.client);
    }

    EventTypeCollection loadPage(String url) {
        ResourceOptions options = this.prepareOptions();
        Response response = this.client.resourceProvider().newResource().retryPolicy(this.retryPolicy).requestThrowing("GET", url, options);
        List collection = (List)this.client.jsonSupport().fromJson(response.responseBody().asString(), TYPE);
        return new EventTypeCollection(collection, new ArrayList<ResourceLink>(), this, this.client);
    }

    PartitionCollection loadPartitionPage(String url) {
        ResourceOptions options = this.prepareOptions();
        Response response = this.client.resourceProvider().newResource().retryPolicy(this.retryPolicy).requestThrowing("GET", url, options);
        List collection = (List)this.client.jsonSupport().fromJson(response.responseBody().asString(), TYPE_P);
        return new PartitionCollection(collection, new ArrayList<ResourceLink>(), this, this.client);
    }

    EventTypeSchemaCollection loadSchemaPage(String url) {
        ResourceOptions options = this.prepareOptions();
        Response response = this.client.resourceProvider().newResource().retryPolicy(this.retryPolicy).requestThrowing("GET", url, options);
        EventTypeSchemaList list = this.client.jsonSupport().fromJson(response.responseBody().asString(), EventTypeSchemaList.class);
        return new EventTypeSchemaCollection(this.toEventTypeSchema(list.items()), this.toLinks(list._links()), this, this.client);
    }

    private ResourceOptions prepareOptions() {
        return ResourceSupport.options(APPLICATION_JSON).tokenProvider(this.client.resourceTokenProvider());
    }

    private UriBuilder collectionUri() {
        return UriBuilder.builder(this.client.baseURI()).path(PATH_EVENT_TYPES);
    }

    private List<ResourceLink> toLinks(PaginationLinks _links) {
        return new LinkSupport().toLinks(_links);
    }

    private List<EventTypeSchema> toEventTypeSchema(List<EventTypeSchema> items) {
        ArrayList<EventTypeSchema> subscriptions = new ArrayList<EventTypeSchema>();
        if (items != null) {
            subscriptions.addAll(items);
        }
        return subscriptions;
    }

    private static class EventTypeSchemaList {
        private final PaginationLinks _links = null;
        private final List<EventTypeSchema> items = new ArrayList<EventTypeSchema>();

        private EventTypeSchemaList() {
        }

        PaginationLinks _links() {
            return this._links;
        }

        List<EventTypeSchema> items() {
            return this.items;
        }
    }
}

