/*
 * Decompiled with CFR 0.152.
 */
package nakadi;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nakadi.AuthorizationAttribute;
import nakadi.NakadiException;
import nakadi.shadow.com.google.common.collect.ImmutableList;

public class EventTypeAuthorization {
    private List<AuthorizationAttribute> admins;
    private List<AuthorizationAttribute> readers;
    private List<AuthorizationAttribute> writers;

    public List<AuthorizationAttribute> admins() {
        return ImmutableList.copyOf(this.admins);
    }

    public EventTypeAuthorization admins(List<AuthorizationAttribute> admins) {
        NakadiException.throwNonNull(admins, "Please provide a non-null admin authorization list");
        this.guardAdmins();
        this.admins.addAll(admins);
        return this;
    }

    public List<AuthorizationAttribute> readers() {
        return ImmutableList.copyOf(this.readers);
    }

    public EventTypeAuthorization readers(List<AuthorizationAttribute> readers) {
        NakadiException.throwNonNull(readers, "Please provide a non-null readers authorization list");
        this.guardReaders();
        this.readers.addAll(readers);
        return this;
    }

    public List<AuthorizationAttribute> writers() {
        return ImmutableList.copyOf(this.writers);
    }

    public EventTypeAuthorization writers(List<AuthorizationAttribute> writers) {
        NakadiException.throwNonNull(writers, "Please provide a non-null writers authorization list");
        this.guardWriters();
        this.writers.addAll(writers);
        return this;
    }

    public EventTypeAuthorization admin(AuthorizationAttribute admin) {
        NakadiException.throwNonNull(admin, "Please provide a non-null admin authorization");
        this.guardAdmins();
        this.admins.add(admin);
        return this;
    }

    public EventTypeAuthorization reader(AuthorizationAttribute reader) {
        NakadiException.throwNonNull(reader, "Please provide a non-null reader authorization");
        this.guardReaders();
        this.readers.add(reader);
        return this;
    }

    public EventTypeAuthorization writer(AuthorizationAttribute writer) {
        NakadiException.throwNonNull(writer, "Please provide a non-null writer authorization");
        this.guardWriters();
        this.writers.add(writer);
        return this;
    }

    private void guardAdmins() {
        if (this.admins == null) {
            this.admins = new ArrayList<AuthorizationAttribute>();
        }
    }

    private void guardReaders() {
        if (this.readers == null) {
            this.readers = new ArrayList<AuthorizationAttribute>();
        }
    }

    private void guardWriters() {
        if (this.writers == null) {
            this.writers = new ArrayList<AuthorizationAttribute>();
        }
    }

    public String toString() {
        return "EventTypeAuthorization{admins=" + this.admins + ", readers=" + this.readers + ", writers=" + this.writers + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventTypeAuthorization that = (EventTypeAuthorization)o;
        return Objects.equals(this.admins, that.admins) && Objects.equals(this.readers, that.readers) && Objects.equals(this.writers, that.writers);
    }

    public int hashCode() {
        return Objects.hash(this.admins, this.readers, this.writers);
    }
}

