/*
 * Decompiled with CFR 0.152.
 */
package nakadi;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import nakadi.EventTypeAuthorization;
import nakadi.EventTypeOptions;
import nakadi.EventTypeSchema;
import nakadi.EventTypeStatistics;
import nakadi.Experimental;
import nakadi.NakadiException;
import nakadi.shadow.com.google.common.collect.Lists;

public class EventType {
    public static final String ENRICHMENT_METADATA = "metadata_enrichment";
    public static final String PARTITION_RANDOM = "random";
    public static final String PARTITION_HASH = "hash";
    public static final String DELETE = "delete";
    public static final String COMPACT = "compact";
    private static final List<String> SENTINEL_EMPTY_SCOPES = Collections.unmodifiableList(Lists.newArrayList());
    private final List<String> enrichmentStrategies = new ArrayList<String>();
    private String name;
    private String owningApplication;
    private Category category;
    private String partitionStrategy = "random";
    private EventTypeSchema schema;
    private List<String> partitionKeyFields = new ArrayList<String>();
    private EventTypeStatistics defaultStatistic;
    private EventTypeOptions options;
    private String compatibilityMode;
    private EventTypeAuthorization authorization;
    private String cleanupPolicy;
    private String audience;
    private OffsetDateTime createdAt;
    private OffsetDateTime updatedAt;

    public String name() {
        return this.name;
    }

    public EventType name(String name) {
        NakadiException.throwNonNull(name, "Please provide a non-null name");
        this.name = name;
        return this;
    }

    public String owningApplication() {
        return this.owningApplication;
    }

    public EventType owningApplication(String owningApplication) {
        NakadiException.throwNonNull(owningApplication, "Please provide a non-null owning application");
        this.owningApplication = owningApplication;
        return this;
    }

    public Category category() {
        return this.category;
    }

    public EventType category(Category category) {
        NakadiException.throwNonNull(category, "Please provide a non-null category");
        this.category = category;
        return this;
    }

    public List<String> enrichmentStrategies() {
        return this.enrichmentStrategies;
    }

    public String partitionStrategy() {
        return this.partitionStrategy;
    }

    public EventType partitionStrategy(String partitionStrategy) {
        NakadiException.throwNonNull(partitionStrategy, "Please provide a non-null partition strategy");
        this.partitionStrategy = partitionStrategy;
        return this;
    }

    public EventTypeSchema schema() {
        return this.schema;
    }

    public EventType schema(EventTypeSchema schema) {
        NakadiException.throwNonNull(schema, "Please provide non-null schema");
        this.schema = schema;
        return this;
    }

    public List<String> partitionKeyFields() {
        return this.partitionKeyFields;
    }

    public EventType partitionKeyFields(String ... partitionKeyFields) {
        NakadiException.throwNonNull(partitionKeyFields, "Please provide non-null partition key fields");
        this.partitionKeyFields = Arrays.asList(partitionKeyFields);
        return this;
    }

    public EventTypeStatistics eventTypeStatistics() {
        return this.defaultStatistic;
    }

    public EventType eventTypeStatistics(EventTypeStatistics eventTypeStatistic) {
        this.defaultStatistic = eventTypeStatistic;
        return this;
    }

    public EventType options(EventTypeOptions options) {
        NakadiException.throwNonNull(options, "Please provide non-null event type options");
        this.options = options;
        return this;
    }

    public EventTypeOptions options() {
        return this.options;
    }

    public EventType enrichmentStrategies(String ... enrichmentStrategies) {
        NakadiException.throwNonNull(enrichmentStrategies, "Please provide non-null enrichment strategies");
        this.enrichmentStrategies.addAll(Arrays.asList(enrichmentStrategies));
        return this;
    }

    public EventType enrichmentStrategy(String enrichmentStrategy) {
        NakadiException.throwNonNull(enrichmentStrategy, "Please provide a non-null enrichment strategy");
        this.enrichmentStrategies.add(enrichmentStrategy);
        return this;
    }

    @Deprecated
    public List<String> readScopes() {
        return SENTINEL_EMPTY_SCOPES;
    }

    @Deprecated
    public EventType readScopes(String ... readScopes) {
        return this;
    }

    @Deprecated
    public List<String> writeScopes() {
        return SENTINEL_EMPTY_SCOPES;
    }

    @Deprecated
    public EventType writeScopes(String ... writeScopes) {
        return this;
    }

    @Experimental
    public String compatibilityMode() {
        return this.compatibilityMode;
    }

    @Experimental
    public EventType compatibilityMode(String compatibilityMode) {
        this.compatibilityMode = compatibilityMode;
        return this;
    }

    @Experimental
    public OffsetDateTime createdAt() {
        return this.createdAt;
    }

    @Experimental
    public OffsetDateTime updatedAt() {
        return this.updatedAt;
    }

    public EventTypeAuthorization authorization() {
        return this.authorization;
    }

    public EventType authorization(EventTypeAuthorization authorization) {
        this.authorization = authorization;
        return this;
    }

    public String cleanupPolicy() {
        return this.cleanupPolicy;
    }

    public EventType cleanupPolicy(String cleanupPolicy) {
        this.cleanupPolicy = cleanupPolicy;
        return this;
    }

    public String audience() {
        return this.audience;
    }

    public EventType audience(String audience) {
        this.audience = audience;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventType eventType = (EventType)o;
        return Objects.equals(this.enrichmentStrategies, eventType.enrichmentStrategies) && Objects.equals(this.name, eventType.name) && Objects.equals(this.owningApplication, eventType.owningApplication) && this.category == eventType.category && Objects.equals(this.partitionStrategy, eventType.partitionStrategy) && Objects.equals(this.schema, eventType.schema) && Objects.equals(this.partitionKeyFields, eventType.partitionKeyFields) && Objects.equals(this.defaultStatistic, eventType.defaultStatistic) && Objects.equals(this.options, eventType.options) && Objects.equals(this.compatibilityMode, eventType.compatibilityMode) && Objects.equals(this.authorization, eventType.authorization) && Objects.equals(this.audience, eventType.audience) && Objects.equals(this.createdAt, eventType.createdAt) && Objects.equals(this.updatedAt, eventType.updatedAt);
    }

    public String toString() {
        return "EventType{enrichmentStrategies=" + this.enrichmentStrategies + ", name='" + this.name + '\'' + ", owningApplication='" + this.owningApplication + '\'' + ", category=" + (Object)((Object)this.category) + ", partitionStrategy='" + this.partitionStrategy + '\'' + ", schema=" + this.schema + ", partitionKeyFields=" + this.partitionKeyFields + ", defaultStatistic=" + this.defaultStatistic + ", options=" + this.options + ", compatibilityMode='" + this.compatibilityMode + '\'' + ", authorization=" + this.authorization + ", audience=" + this.audience + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + '}';
    }

    public static enum Category {
        undefined,
        business,
        data;

    }
}

