/*
 * Decompiled with CFR 0.152.
 */
package nakadi;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nakadi.Cursor;
import nakadi.StreamInfo;

public class EventStreamBatch<T> {
    private static final StreamInfo SENTINEL_STREAM_INFO = new StreamInfo();
    private final Cursor cursor;
    private volatile StreamInfo info;
    private volatile List<T> events;

    public EventStreamBatch(Cursor cursor, StreamInfo info, List<T> events) {
        Objects.requireNonNull(cursor);
        this.cursor = cursor;
        this.info = info;
        this.events = events;
    }

    public Cursor cursor() {
        return this.cursor;
    }

    public StreamInfo info() {
        if (this.info == null) {
            this.info = SENTINEL_STREAM_INFO;
        }
        return this.info;
    }

    public boolean isEmpty() {
        return this.events().isEmpty();
    }

    public List<T> events() {
        if (this.events == null) {
            this.events = new ArrayList<T>();
        }
        return this.events;
    }

    public int hashCode() {
        return Objects.hash(this.cursor, this.info(), this.events());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventStreamBatch that = (EventStreamBatch)o;
        return Objects.equals(this.cursor, that.cursor) && Objects.equals(this.info(), that.info()) && Objects.equals(this.events(), that.events());
    }

    public String toString() {
        return "EventStreamBatch{cursor=" + this.cursor + ", info=" + this.info() + ", events=" + this.events() + '}';
    }
}

