/*
 * Decompiled with CFR 0.152.
 */
package nakadi;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import nakadi.Experimental;
import nakadi.ResourceSupport;

public class EventMetadata {
    private String eid;
    private String eventType;
    private OffsetDateTime occurredAt;
    private OffsetDateTime receivedAt;
    private List<String> parentEids;
    private String flowId;
    private String partition;
    private String version;
    private String partitionCompactionKey;
    private Map<String, String> spanCtx;

    public static EventMetadata newPreparedEventMetadata() {
        return new EventMetadata().withEid().withFlowId().withOccurredAt();
    }

    public EventMetadata withEid() {
        return this.newEid();
    }

    public EventMetadata withOccurredAt() {
        return this.newOccurredAt();
    }

    public EventMetadata withFlowId() {
        return this.newFlowId();
    }

    public String eid() {
        return this.eid;
    }

    public EventMetadata eid(String eid) {
        this.eid = eid;
        return this;
    }

    EventMetadata newEid() {
        this.eid = ResourceSupport.nextEid();
        return this;
    }

    public String partitionCompactionKey() {
        return this.partitionCompactionKey;
    }

    public EventMetadata partitionCompactionKey(String partitionCompactionKey) {
        this.partitionCompactionKey = partitionCompactionKey;
        return this;
    }

    public String eventType() {
        return this.eventType;
    }

    public EventMetadata eventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    public OffsetDateTime occurredAt() {
        return this.occurredAt;
    }

    public EventMetadata occurredAt(OffsetDateTime occurredAt) {
        this.occurredAt = occurredAt;
        return this;
    }

    EventMetadata newOccurredAt() {
        this.occurredAt = OffsetDateTime.now();
        return this;
    }

    public OffsetDateTime receivedAt() {
        return this.receivedAt;
    }

    public List<String> parentEids() {
        return this.parentEids;
    }

    public EventMetadata parentEids(String ... parentEids) {
        this.parentEids = Arrays.asList(parentEids);
        return this;
    }

    public String flowId() {
        return this.flowId;
    }

    public EventMetadata flowId(String flowId) {
        this.flowId = flowId;
        return this;
    }

    EventMetadata newFlowId() {
        this.flowId = ResourceSupport.nextFlowId();
        return this;
    }

    public String partition() {
        return this.partition;
    }

    public EventMetadata partition(String partition) {
        this.partition = partition;
        return this;
    }

    public Map<String, String> spanCtx() {
        return this.spanCtx;
    }

    public EventMetadata spanCtx(Map<String, String> spanCtx) {
        this.spanCtx = spanCtx;
        return this;
    }

    @Experimental
    public String version() {
        return this.version;
    }

    public int hashCode() {
        return Objects.hash(this.eid, this.eventType, this.occurredAt, this.receivedAt, this.parentEids, this.flowId, this.partition, this.version, this.spanCtx);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventMetadata that = (EventMetadata)o;
        return Objects.equals(this.eid, that.eid) && Objects.equals(this.eventType, that.eventType) && Objects.equals(this.occurredAt, that.occurredAt) && Objects.equals(this.receivedAt, that.receivedAt) && Objects.equals(this.parentEids, that.parentEids) && Objects.equals(this.flowId, that.flowId) && Objects.equals(this.partition, that.partition) && Objects.equals(this.spanCtx, that.spanCtx) && Objects.equals(this.version, that.version);
    }

    public String toString() {
        return "EventMetadata{eid='" + this.eid + '\'' + ", eventType='" + this.eventType + '\'' + ", occurredAt=" + this.occurredAt + ", receivedAt=" + this.receivedAt + ", parentEids=" + this.parentEids + ", flowId='" + this.flowId + '\'' + ", partition='" + this.partition + '\'' + ", version='" + this.version + '\'' + ", spanCtx='" + this.spanCtx + '\'' + '}';
    }
}

