/*
 * Decompiled with CFR 0.152.
 */
package nakadi;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class Cursor {
    private String partition;
    private String offset;
    private String eventType;
    private String cursorToken;
    private Long shift;

    static Cursor prepareRequiringEventType(Cursor cursor) {
        return new Cursor(cursor.partition(), cursor.offset(), cursor.eventType().orElseThrow(() -> new IllegalArgumentException("Please supply a cursor with an event type")));
    }

    static List<Cursor> prepareRequiringEventType(List<Cursor> cursors) {
        return cursors.stream().map(Cursor::prepareRequiringEventType).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public Cursor() {
    }

    public Cursor(String partition, String offset) {
        this.partition = partition;
        this.offset = offset;
    }

    public Cursor(String partition, String offset, String eventType, String cursorToken) {
        this(partition, offset);
        this.eventType = eventType;
        this.cursorToken = cursorToken;
    }

    public Cursor(String partition, String offset, String eventType) {
        this(partition, offset, eventType, null);
    }

    public Optional<String> eventType() {
        return Optional.ofNullable(this.eventType);
    }

    public Cursor eventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    public Optional<String> cursorToken() {
        return Optional.ofNullable(this.cursorToken);
    }

    public Cursor cursorToken(String cursorToken) {
        this.cursorToken = cursorToken;
        return this;
    }

    public String partition() {
        return this.partition;
    }

    public String offset() {
        return this.offset;
    }

    public Cursor partition(String partition) {
        this.partition = partition;
        return this;
    }

    public Cursor offset(String offset) {
        this.offset = offset;
        return this;
    }

    public Long shift() {
        return this.shift;
    }

    public Cursor shift(Long shift) {
        this.shift = shift;
        return this;
    }

    boolean isSubscriptionCursor() {
        return this.eventType().isPresent() && this.cursorToken().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.partition, this.offset, this.eventType, this.cursorToken, this.shift);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cursor cursor = (Cursor)o;
        return Objects.equals(this.partition, cursor.partition) && Objects.equals(this.offset, cursor.offset) && Objects.equals(this.eventType, cursor.eventType) && Objects.equals(this.cursorToken, cursor.cursorToken) && Objects.equals(this.shift, cursor.shift);
    }

    public String toString() {
        String sb = "Cursor{partition='" + this.partition + '\'' + ", offset='" + this.offset + '\'' + ", eventType='" + this.eventType + '\'' + ", cursorToken='" + this.cursorToken + '\'';
        if (this.shift != null) {
            sb = sb + ", shift='" + this.shift + '\'';
        }
        return sb + '}';
    }
}

