/*
 * Decompiled with CFR 0.152.
 */
package nakadi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import nakadi.CompressionSupport;
import nakadi.EncodingException;
import nakadi.Problem;
import nakadi.shadow.com.google.common.base.Charsets;
import nakadi.shadow.okio.BufferedSink;
import nakadi.shadow.okio.BufferedSource;
import nakadi.shadow.okio.GzipSink;
import nakadi.shadow.okio.GzipSource;
import nakadi.shadow.okio.Okio;

class CompressionSupportGzip
implements CompressionSupport {
    CompressionSupportGzip() {
    }

    @Override
    public byte[] compress(byte[] bytes) {
        try {
            return this.toGzip(bytes);
        }
        catch (IOException e) {
            throw new EncodingException(Problem.localProblem("could not gzip request entity", ""), (Throwable)e);
        }
    }

    @Override
    public byte[] compress(String json) {
        try {
            return this.toGzip(json);
        }
        catch (IOException e) {
            throw new EncodingException(Problem.localProblem("could not gzip request entity", ""), (Throwable)e);
        }
    }

    @Override
    public String decompress(byte[] compressed) {
        try {
            return this.fromGzip(compressed);
        }
        catch (IOException e) {
            throw new EncodingException(Problem.localProblem("could not gzip request entity", ""), (Throwable)e);
        }
    }

    @Override
    public String name() {
        return "gzip";
    }

    byte[] toGzip(byte[] json) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (BufferedSink sink = Okio.buffer(new GzipSink(Okio.sink(baos)));){
            sink.write(json);
        }
        return baos.toByteArray();
    }

    byte[] toGzip(String json) throws IOException {
        return this.toGzip(json.getBytes(Charsets.UTF_8));
    }

    String fromGzip(byte[] gzipped) throws IOException {
        try (BufferedSource source = Okio.buffer(new GzipSource(Okio.source(new ByteArrayInputStream(gzipped))));){
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(source.readByteArray());
            String string = baos.toString(Charsets.UTF_8.name());
            return string;
        }
    }
}

