package nakadi;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface EventResource {

  /**
   * Deprecated since 0.9.7 and will be removed in 0.10.0. Scopes set here are ignored.
   *
   * @param scope the OAuth scope to be used for the request
   * @return this
   */
  @Deprecated
  EventResource scope(String scope);

  /**
   * Set the retry policy to be used for the request. This can be reset between requests. Setting
   * it to null (the default) disables retries.
   * <p>
   * <b>Warning: </b> the ordering and general delivery behaviour for event delivery is
   * undefined under retries. That is, a delivery retry may result in out or order events being
   * sent to the server.
   * </p>
   *
   * @param retryPolicy the retry policy
   * @return this
   */
  EventResource retryPolicy(RetryPolicy retryPolicy);

  /**
   * Set the flow ID that should be included in the header of all future requests.
   * <p>
   * The default value is null. If the current value is null, a flow ID will be generated by
   * the client.
   * </p>
   *
   * @param flowId the flow ID.
   * @return this
   */
  EventResource flowId(String flowId);

  /**
   * Send a batch of events to the server.
   *
   * <p>
   * If the first item in events is detected to be a String, the list will be treated as raw
   * JSON items. Otherwise the event is serialised to JSON. This behaviour is fragile and
   * might be changed prior to 1.0.0, most likely by introducing a new signature for raw
   * JSON events.
   * </p>
   * <p>
   * The response may be a 207 indicating some or none of the events succeeded. See the Nakadi
   * API definition for details.
   * </p>
   * <p>
   * <b>Warning: </b> the ordering and general delivery behaviour for event delivery is
   * undefined under retries. That is, a delivery retry may result in out or order batches being
   * sent to the server. Also retrying a partially delivered (207) batch may result in one
   * or more events being delivered multiple times.
   * </p>
   *
   * @param eventTypeName the event type name
   * @param events the events
   * @param <T> the type of the events
   * @return the response
   */
  <T> Response send(String eventTypeName, Collection<T> events);
  <T> Response send(String eventTypeName, Collection<T> events, Map<String, Object> headers);

  /**
   * Send an event to the server.
   * <p>
   * If the event is detected to be a String, it will be treated as raw JSON. Otherwise the
   * event is serialised to JSON.
   * </p>
   * <p>
   * <b>Warning: </b> the ordering and general delivery behaviour for event delivery is
   * undefined under retries. That is, a delivery retry may result in out or order events being
   * sent to the server.
   * </p>
   *
   * @param eventTypeName the event type name
   * @param event the event
   * @param <T> the type of the event
   * @return the response
   */
  <T> Response send(String eventTypeName, T event);
  <T> Response send(String eventTypeName, T event, Map<String, Object> headers);

  /**
   * Send a batch of events to the server.
   *
   * <p>
   * If the response is 422 or 207 the BatchItemResponseCollection will contain items.
   * </p>
   * <p>
   * <b>Warning: </b> the ordering and general delivery behaviour for event delivery is
   * undefined under retries. That is, a delivery retry may result in out or order batches being
   * sent to the server. Also retrying a partially delivered (207) batch may result in one
   * or more events being delivered multiple times.
   * </p>
   *
   * @param eventTypeName the event type name
   * @param events the events
   * @return a BatchItemResponseCollection which will be empty if successful or have items if the
   * post was partially successful (via a 422 or 207 response)
   */
  <T> BatchItemResponseCollection sendBatch(String eventTypeName, List<T> events);
  <T> BatchItemResponseCollection sendBatch(String eventTypeName, List<T> events, Map<String, Object> headers);
}
