/*
 * Decompiled with CFR 0.152.
 */
package net.darkmist.alib.escape;

import java.io.IOException;
import net.darkmist.alib.escape.BackSlashUHexMaker;
import net.darkmist.alib.escape.BackSlashXHexMaker;
import net.darkmist.alib.escape.StrMaker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JSEscapeMaker
extends StrMaker.PreCachedSingletonAbstract {
    private static final Class<JSEscapeMaker> CLASS = JSEscapeMaker.class;
    private static final Logger logger = LoggerFactory.getLogger(CLASS);
    private static final JSEscapeMaker SINGLETON = new JSEscapeMaker();
    private final StrMaker BACKSLASH_X_HEX = BackSlashXHexMaker.instance();
    private final StrMaker BACKSLASH_U_HEX = BackSlashUHexMaker.instance();

    private JSEscapeMaker() {
        this.makeCache();
    }

    static JSEscapeMaker instance() {
        return SINGLETON;
    }

    @Override
    protected Appendable appendStrNoCache(Appendable appendable, int ch) throws IOException {
        if (ch < 0) {
            throw new IllegalArgumentException("Negative code point");
        }
        if (ch < 256) {
            return this.BACKSLASH_X_HEX.appendStr(appendable, ch);
        }
        if (ch < 65536) {
            return this.BACKSLASH_U_HEX.appendStr(appendable, ch);
        }
        throw new IllegalArgumentException("JavaScript/ECMAScript does not define how code points greater than 0xFFFF are handled.");
    }
}

