/*
 * Decompiled with CFR 0.152.
 */
package net.darkmist.alib.escape;

import java.io.IOException;
import net.darkmist.alib.escape.Charsets;
import net.darkmist.alib.escape.StrMaker;
import net.darkmist.alib.escape.TwoCharHexMaker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class URLEscapeMaker
extends StrMaker.PreCachedSingletonAbstract {
    private static final Class<URLEscapeMaker> CLASS = URLEscapeMaker.class;
    private static final Logger logger = LoggerFactory.getLogger(CLASS);
    private static final URLEscapeMaker SINGLETON = new URLEscapeMaker();
    private final StrMaker HEXER = TwoCharHexMaker.instance();

    private URLEscapeMaker() {
        this.makeCache();
    }

    static URLEscapeMaker instance() {
        return SINGLETON;
    }

    private Appendable appendSingleByteEscape(Appendable appendable, int ch) throws IOException {
        return this.HEXER.appendStr(appendable.append('%'), ch);
    }

    private Appendable appendMultiByteEscape(Appendable appendable, int ch) throws IOException {
        int[] codePointStr = new int[]{ch};
        String str = new String(codePointStr, 0, 1);
        for (byte b : str.getBytes(Charsets.UTF8)) {
            this.appendSingleByteEscape(appendable, b & 0xFF);
        }
        return appendable;
    }

    @Override
    protected Appendable appendStrNoCache(Appendable appendable, int ch) throws IOException {
        if (ch < 0) {
            throw new IllegalArgumentException("Negative valued character is invalid.");
        }
        if (ch < 256) {
            return this.appendSingleByteEscape(appendable, ch);
        }
        return this.appendMultiByteEscape(appendable, ch);
    }
}

