/*
 * Decompiled with CFR 0.152.
 */
package net.darkmist.alib.escape;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.darkmist.alib.escape.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

interface StrMaker {
    public String makeStr(int var1);

    public Appendable appendStr(Appendable var1, int var2) throws IOException;

    public StringBuilder appendStr(StringBuilder var1, int var2);

    public StringBuffer appendStr(StringBuffer var1, int var2);

    public static abstract class PreCachedSingletonAbstract
    extends Abstract {
        private static final Class<PreCachedSingletonAbstract> CLASS = PreCachedSingletonAbstract.class;
        private static final Logger logger = LoggerFactory.getLogger(CLASS);
        private List<String> cache;

        protected PreCachedSingletonAbstract() {
        }

        protected final void makeCache() {
            int size = Util.getPositiveIntProp(this.getClass(), Util.getCacheSizePropName(), Util.getCacheSizeDefault());
            if (size == 0) {
                this.cache = Collections.emptyList();
                return;
            }
            String[] cacheArray = new String[size];
            for (int i = 0; i < size; ++i) {
                cacheArray[i] = this.makeStrNoCache(i).intern();
            }
            this.cache = Collections.unmodifiableList(Arrays.asList(cacheArray));
        }

        protected abstract Appendable appendStrNoCache(Appendable var1, int var2) throws IOException;

        protected String makeStrNoCache(int ch) {
            try {
                return this.appendStrNoCache(new StringBuilder(), ch).toString();
            }
            catch (IOException e) {
                throw new IllegalStateException("IOException appending to StringBuilder cast to Appendable?", e);
            }
        }

        @Override
        public String makeStr(int ch) {
            if (ch < 0) {
                throw new IllegalArgumentException("Character code was less than zero");
            }
            if (this.cache == null) {
                logger.warn("Cache was never initialized for {}", (Object)this);
            } else if (ch < this.cache.size()) {
                return this.cache.get(ch);
            }
            return this.makeStrNoCache(ch);
        }

        @Override
        public Appendable appendStr(Appendable appendable, int ch) throws IOException {
            if (ch < 0) {
                throw new IllegalArgumentException("Character code was less than zero");
            }
            if (this.cache == null) {
                logger.warn("Cache was never initialized for {}", (Object)this);
            } else if (ch < this.cache.size()) {
                return appendable.append(this.cache.get(ch));
            }
            return this.appendStrNoCache(appendable, ch);
        }
    }

    public static abstract class Abstract
    implements StrMaker {
        private static final Class<Abstract> CLASS = Abstract.class;
        private static final Logger logger = LoggerFactory.getLogger(CLASS);

        protected Abstract() {
        }

        @Override
        public String makeStr(int code) {
            return this.appendStr(new StringBuilder(), code).toString();
        }

        @Override
        public StringBuilder appendStr(StringBuilder sb, int code) {
            try {
                this.appendStr((Appendable)sb, code);
                return sb;
            }
            catch (IOException e) {
                throw new IllegalStateException("IOException appending to StringBuilder cast to Appendable?", e);
            }
        }

        @Override
        public StringBuffer appendStr(StringBuffer sb, int code) {
            try {
                this.appendStr((Appendable)sb, code);
                return sb;
            }
            catch (IOException e) {
                throw new IllegalStateException("IOException appending to StringBuffer cast to Appendable?", e);
            }
        }
    }
}

