/*
 * Decompiled with CFR 0.152.
 */
package net.darkmist.alib.escape;

import java.io.IOException;
import net.darkmist.alib.escape.StrMaker;

class FourCharHexMaker
extends StrMaker.PreCachedSingletonAbstract {
    private static final Class<FourCharHexMaker> CLASS = FourCharHexMaker.class;
    private static final FourCharHexMaker SINGLETON = new FourCharHexMaker();

    private FourCharHexMaker() {
        this.makeCache();
    }

    static FourCharHexMaker instance() {
        return SINGLETON;
    }

    @Override
    protected Appendable appendStrNoCache(Appendable appendable, int ch) throws IOException {
        if (ch < 0) {
            throw new IllegalArgumentException("Negative code point.");
        }
        if (ch > 65535) {
            throw new IllegalArgumentException("Char code is too large for four hex digits.");
        }
        if (ch < 16) {
            appendable.append("000");
        } else if (ch < 256) {
            appendable.append("00");
        } else if (ch < 4096) {
            appendable.append('0');
        }
        return appendable.append(Integer.toHexString(ch));
    }
}

