/*
 * Decompiled with CFR 0.152.
 */
package net.darkmist.alib.escape;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import net.darkmist.alib.escape.Escaper;

class EscapingWriter
extends FilterWriter {
    private final Escaper escaper;

    EscapingWriter(Writer out, Escaper esc) {
        super(out);
        this.escaper = esc;
    }

    @Override
    public void write(int ch) throws IOException {
        this.escaper.escape((Appendable)this.out, ch);
    }

    @Override
    public void write(char[] chars) throws IOException {
        this.escaper.escape((Appendable)this.out, chars);
    }

    @Override
    public void write(char[] chars, int off, int len) throws IOException {
        this.escaper.escape((Appendable)this.out, chars, off, len);
    }

    @Override
    public void write(String str) throws IOException {
        this.escaper.escape((Appendable)this.out, str);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.escaper.escape((Appendable)this.out, str, off, len);
    }

    @Override
    public Writer append(char ch) throws IOException {
        this.escaper.escape((Appendable)this.out, (int)ch);
        return this;
    }

    @Override
    public Writer append(CharSequence str) throws IOException {
        this.escaper.escape((Appendable)this.out, str);
        return this;
    }

    @Override
    public Writer append(CharSequence str, int off, int len) throws IOException {
        this.escaper.escape((Appendable)this.out, str, off, len);
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

