/*
 * Decompiled with CFR 0.152.
 */
package net.darkmist.alib.escape;

import java.io.IOException;
import java.io.Writer;
import net.darkmist.alib.escape.EscapingWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Escaper {
    public String escape(int var1);

    public String escape(String var1);

    public StringBuilder escape(StringBuilder var1, int var2);

    public StringBuilder escape(StringBuilder var1, String var2);

    public StringBuilder escape(StringBuilder var1, String var2, int var3, int var4);

    public StringBuilder escape(StringBuilder var1, CharSequence var2);

    public StringBuilder escape(StringBuilder var1, CharSequence var2, int var3, int var4);

    public StringBuilder escape(StringBuilder var1, char[] var2);

    public StringBuilder escape(StringBuilder var1, char[] var2, int var3, int var4);

    public StringBuffer escape(StringBuffer var1, int var2);

    public StringBuffer escape(StringBuffer var1, String var2);

    public StringBuffer escape(StringBuffer var1, String var2, int var3, int var4);

    public StringBuffer escape(StringBuffer var1, CharSequence var2);

    public StringBuffer escape(StringBuffer var1, CharSequence var2, int var3, int var4);

    public StringBuffer escape(StringBuffer var1, char[] var2);

    public StringBuffer escape(StringBuffer var1, char[] var2, int var3, int var4);

    public Appendable escape(Appendable var1, int var2) throws IOException;

    public Appendable escape(Appendable var1, String var2) throws IOException;

    public Appendable escape(Appendable var1, String var2, int var3, int var4) throws IOException;

    public Appendable escape(Appendable var1, CharSequence var2) throws IOException;

    public Appendable escape(Appendable var1, CharSequence var2, int var3, int var4) throws IOException;

    public Appendable escape(Appendable var1, char[] var2) throws IOException;

    public Appendable escape(Appendable var1, char[] var2, int var3, int var4) throws IOException;

    public Writer escape(Writer var1);

    public static abstract class Abstract
    implements Escaper {
        private static final Class<Abstract> CLASS = Abstract.class;
        private static final Logger logger = LoggerFactory.getLogger(CLASS);

        @Override
        public String escape(int ch) {
            return this.escape(new StringBuilder(ch).toString());
        }

        @Override
        public String escape(String str) {
            return this.escape(new StringBuilder(), str).toString();
        }

        @Override
        public StringBuilder escape(StringBuilder sb, int ch) {
            try {
                this.escape((Appendable)sb, ch);
                return sb;
            }
            catch (IOException e) {
                throw new IllegalStateException("IOException appending to StringBuilder cast to Appendable?", e);
            }
        }

        @Override
        public StringBuilder escape(StringBuilder sb, String str) {
            try {
                this.escape((Appendable)sb, str);
                return sb;
            }
            catch (IOException e) {
                throw new IllegalStateException("IOException appending to StringBuilder cast to Appendable?", e);
            }
        }

        @Override
        public StringBuilder escape(StringBuilder sb, String str, int off, int len) {
            try {
                this.escape((Appendable)sb, str, off, len);
                return sb;
            }
            catch (IOException e) {
                throw new IllegalStateException("IOException appending to StringBuilder cast to Appendable?", e);
            }
        }

        @Override
        public StringBuilder escape(StringBuilder sb, CharSequence str) {
            try {
                this.escape((Appendable)sb, str);
                return sb;
            }
            catch (IOException e) {
                throw new IllegalStateException("IOException appending to StringBuilder cast to Appendable?", e);
            }
        }

        @Override
        public StringBuilder escape(StringBuilder sb, CharSequence str, int off, int len) {
            try {
                this.escape((Appendable)sb, str, off, len);
                return sb;
            }
            catch (IOException e) {
                throw new IllegalStateException("IOException appending to StringBuilder cast to Appendable?", e);
            }
        }

        @Override
        public StringBuilder escape(StringBuilder sb, char[] chars) {
            try {
                this.escape((Appendable)sb, chars);
                return sb;
            }
            catch (IOException e) {
                throw new IllegalStateException("IOException appending to StringBuilder cast to Appendable?", e);
            }
        }

        @Override
        public StringBuilder escape(StringBuilder sb, char[] chars, int off, int len) {
            try {
                this.escape((Appendable)sb, chars, off, len);
                return sb;
            }
            catch (IOException e) {
                throw new IllegalStateException("IOException appending to StringBuilder cast to Appendable?", e);
            }
        }

        @Override
        public StringBuffer escape(StringBuffer sb, int ch) {
            try {
                this.escape((Appendable)sb, ch);
                return sb;
            }
            catch (IOException e) {
                throw new IllegalStateException("IOException appending to StringBuffer cast to Appendable?", e);
            }
        }

        @Override
        public StringBuffer escape(StringBuffer sb, String str) {
            try {
                this.escape((Appendable)sb, str);
                return sb;
            }
            catch (IOException e) {
                throw new IllegalStateException("IOException appending to StringBuffer cast to Appendable?", e);
            }
        }

        @Override
        public StringBuffer escape(StringBuffer sb, String str, int off, int len) {
            try {
                this.escape((Appendable)sb, str, off, len);
                return sb;
            }
            catch (IOException e) {
                throw new IllegalStateException("IOException appending to StringBuffer cast to Appendable?", e);
            }
        }

        @Override
        public StringBuffer escape(StringBuffer sb, CharSequence str) {
            try {
                this.escape((Appendable)sb, str);
                return sb;
            }
            catch (IOException e) {
                throw new IllegalStateException("IOException appending to StringBuffer cast to Appendable?", e);
            }
        }

        @Override
        public StringBuffer escape(StringBuffer sb, CharSequence str, int off, int len) {
            try {
                this.escape((Appendable)sb, str, off, len);
                return sb;
            }
            catch (IOException e) {
                throw new IllegalStateException("IOException appending to StringBuffer cast to Appendable?", e);
            }
        }

        @Override
        public StringBuffer escape(StringBuffer sb, char[] chars) {
            try {
                this.escape((Appendable)sb, chars);
                return sb;
            }
            catch (IOException e) {
                throw new IllegalStateException("IOException appending to StringBuffer cast to Appendable?", e);
            }
        }

        @Override
        public StringBuffer escape(StringBuffer sb, char[] chars, int off, int len) {
            try {
                this.escape((Appendable)sb, chars, off, len);
                return sb;
            }
            catch (IOException e) {
                throw new IllegalStateException("IOException appending to StringBuffer cast to Appendable?", e);
            }
        }

        @Override
        public Appendable escape(Appendable appendable, int ch) throws IOException {
            return appendable.append(this.escape(ch));
        }

        @Override
        public Appendable escape(Appendable appendable, String str) throws IOException {
            return this.escape(appendable, str, 0, str.length());
        }

        @Override
        public Appendable escape(Appendable appendable, String str, int off, int len) throws IOException {
            int end = off + len;
            int codePoints = str.codePointCount(off, end);
            int codePointsBegin = str.codePointCount(0, off);
            int codePointsEnd = codePointsBegin + codePoints;
            for (int i = codePointsBegin; i < codePointsEnd; ++i) {
                this.escape(appendable, str.codePointAt(i));
            }
            return appendable;
        }

        @Override
        public Appendable escape(Appendable appendable, CharSequence str) throws IOException {
            return this.escape(appendable, ((Object)str).toString());
        }

        @Override
        public Appendable escape(Appendable appendable, CharSequence str, int start, int end) throws IOException {
            return this.escape(appendable, ((Object)str).toString(), start, end);
        }

        @Override
        public Appendable escape(Appendable appendable, char[] chars) throws IOException {
            return this.escape(appendable, String.valueOf(chars));
        }

        @Override
        public Appendable escape(Appendable appendable, char[] chars, int off, int len) throws IOException {
            return this.escape(appendable, String.valueOf(chars, off, len));
        }

        @Override
        public Writer escape(Writer out) {
            return new EscapingWriter(out, this);
        }
    }
}

