/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.mime.service.creator;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.dankito.mime.service.FileDownloader;
import net.dankito.mime.service.creator.MimeTypeFileParserBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u001c\u0010\u000b\u001a\u0016\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u000e\u0018\u00010\fH\u0016J\"\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u000e0\f2\u0006\u0010\u000f\u001a\u00020\rH\u0014J@\u0010\u0010\u001a\u00020\u00112.\u0010\u0012\u001a*\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u000e0\u0013j\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u000e`\u00142\u0006\u0010\t\u001a\u00020\nH\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lnet/dankito/mime/service/creator/JavaMimeUtilsParser;", "Lnet/dankito/mime/service/creator/MimeTypeFileParserBase;", "downloader", "Lnet/dankito/mime/service/FileDownloader;", "(Lnet/dankito/mime/service/FileDownloader;)V", "getDownloader", "()Lnet/dankito/mime/service/FileDownloader;", "isMimeTypeToFileExtensionMappingLine", "", "sourceCodeLine", "Lorg/jsoup/nodes/Element;", "parseJavaMimeUtilsSource", "", "", "", "html", "parseMimeTypeMappingLine", "", "mimeTypesToExtensionsMap", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "Companion", "mime-utils"})
public class JavaMimeUtilsParser
extends MimeTypeFileParserBase {
    @NotNull
    private final FileDownloader downloader;
    @NotNull
    public static final String SourceFileUrl = "https://android.googlesource.com/platform/libcore/+/master/luni/src/main/java/libcore/net/MimeUtils.java";
    public static final Companion Companion = new Companion(null);

    @Nullable
    public Map<String, Set<String>> parseJavaMimeUtilsSource() {
        String string = this.downloader.get(SourceFileUrl).getDownloadedContent();
        if (string != null) {
            String string2;
            String html = string2 = string;
            return this.parseJavaMimeUtilsSource(html);
        }
        return null;
    }

    @NotNull
    protected Map<String, Set<String>> parseJavaMimeUtilsSource(@NotNull String html) {
        Intrinsics.checkParameterIsNotNull((Object)html, (String)"html");
        HashMap<String, Set<String>> mimeTypesToExtensionsMap = new HashMap<String, Set<String>>();
        Document document = Jsoup.parse((String)html);
        Elements elements = document.body().select("table.FileContents tbody td.FileContents-lineContents");
        Intrinsics.checkExpressionValueIsNotNull((Object)elements, (String)"document.body().select(\"\u2026leContents-lineContents\")");
        Iterable $receiver$iv = (Iterable)elements;
        for (Object element$iv : $receiver$iv) {
            Element sourceCodeLine;
            Element element = sourceCodeLine = (Element)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"sourceCodeLine");
            if (!this.isMimeTypeToFileExtensionMappingLine(element)) continue;
            this.parseMimeTypeMappingLine(mimeTypesToExtensionsMap, sourceCodeLine);
        }
        return mimeTypesToExtensionsMap;
    }

    protected boolean isMimeTypeToFileExtensionMappingLine(@NotNull Element sourceCodeLine) {
        Intrinsics.checkParameterIsNotNull((Object)sourceCodeLine, (String)"sourceCodeLine");
        String string = sourceCodeLine.text();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sourceCodeLine.text()");
        return StringsKt.startsWith$default((String)string, (String)"add(", (boolean)false, (int)2, null);
    }

    protected void parseMimeTypeMappingLine(@NotNull HashMap<String, Set<String>> mimeTypesToExtensionsMap, @NotNull Element sourceCodeLine) {
        Intrinsics.checkParameterIsNotNull(mimeTypesToExtensionsMap, (String)"mimeTypesToExtensionsMap");
        Intrinsics.checkParameterIsNotNull((Object)sourceCodeLine, (String)"sourceCodeLine");
        Elements stringSpans = sourceCodeLine.select("span.str");
        if (stringSpans.size() == 2) {
            String string;
            String string2;
            String string3 = ((Element)stringSpans.get(0)).text();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"stringSpans[0].text()");
            String string4 = string2 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String mimeType = StringsKt.replace$default((String)((Object)StringsKt.trim((CharSequence)string4)).toString(), (String)"\"", (String)"", (boolean)false, (int)4, null);
            String string5 = ((Element)stringSpans.get(1)).text();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"stringSpans[1].text()");
            String string6 = string = string5;
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String fileExtension = StringsKt.replace$default((String)((Object)StringsKt.trim((CharSequence)string6)).toString(), (String)"\"", (String)"", (boolean)false, (int)4, null);
            this.addFileExtensionForMimeType(mimeTypesToExtensionsMap, mimeType, fileExtension);
        }
    }

    @NotNull
    protected final FileDownloader getDownloader() {
        return this.downloader;
    }

    public JavaMimeUtilsParser(@NotNull FileDownloader downloader) {
        Intrinsics.checkParameterIsNotNull((Object)downloader, (String)"downloader");
        this.downloader = downloader;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/dankito/mime/service/creator/JavaMimeUtilsParser$Companion;", "", "()V", "SourceFileUrl", "", "mime-utils"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

