/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.mime.service.creator;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.dankito.mime.model.DownloadResult;
import net.dankito.mime.service.FileDownloader;
import net.dankito.mime.service.creator.IanaMimeTypeFileParser;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006JR\u0010\u000b\u001a\u00020\f2.\u0010\r\u001a*\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00100\u000ej\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u0010`\u00112\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00100\u0013H\u0014J\u0016\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u0013H\u0016J\u001a\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00160\u0013H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lnet/dankito/mime/service/creator/IanaMimeTypeRetriever;", "", "parser", "Lnet/dankito/mime/service/creator/IanaMimeTypeFileParser;", "downloader", "Lnet/dankito/mime/service/FileDownloader;", "(Lnet/dankito/mime/service/creator/IanaMimeTypeFileParser;Lnet/dankito/mime/service/FileDownloader;)V", "getDownloader", "()Lnet/dankito/mime/service/FileDownloader;", "getParser", "()Lnet/dankito/mime/service/creator/IanaMimeTypeFileParser;", "mergeMimeTypes", "", "mimeTypesToExtensionsMap", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "mimeTypesToExtensionsMapForFile", "", "retrieveAllFiles", "retrieveAndParseAllFiles", "", "Companion", "mime-utils"})
public class IanaMimeTypeRetriever {
    @NotNull
    private final IanaMimeTypeFileParser parser;
    @NotNull
    private final FileDownloader downloader;
    @NotNull
    public static final String ApplicationCsvUrl = "http://www.iana.org/assignments/media-types/application.csv";
    @NotNull
    public static final String AudioCsvUrl = "http://www.iana.org/assignments/media-types/audio.csv";
    @NotNull
    public static final String FontCsvUrl = "http://www.iana.org/assignments/media-types/font.csv";
    @NotNull
    public static final String ImageCsvUrl = "http://www.iana.org/assignments/media-types/image.csv";
    @NotNull
    public static final String MessageCsvUrl = "http://www.iana.org/assignments/media-types/message.csv";
    @NotNull
    public static final String ModelCsvUrl = "http://www.iana.org/assignments/media-types/model.csv";
    @NotNull
    public static final String MultipartCsvUrl = "http://www.iana.org/assignments/media-types/multipart.csv";
    @NotNull
    public static final String TextCsvUrl = "http://www.iana.org/assignments/media-types/text.csv";
    @NotNull
    public static final String VideoCsvUrl = "http://www.iana.org/assignments/media-types/video.csv";
    @NotNull
    private static final List<String> CsvFilesUrls;
    public static final Companion Companion;

    @NotNull
    public Map<String, String> retrieveAllFiles() {
        HashMap<String, String> fileDownloadResults = new HashMap<String, String>();
        Iterable $receiver$iv = Companion.getCsvFilesUrls();
        for (Object element$iv : $receiver$iv) {
            String csvFileUrl = (String)element$iv;
            DownloadResult result = this.downloader.get(csvFileUrl);
            fileDownloadResults.put(new File(csvFileUrl).getName(), result.getDownloadedContent());
        }
        return fileDownloadResults;
    }

    @NotNull
    public Map<String, Set<String>> retrieveAndParseAllFiles() {
        HashMap<String, Set<String>> mimeTypesToExtensionsMap = new HashMap<String, Set<String>>();
        Iterable $receiver$iv = CollectionsKt.filterNotNull((Iterable)this.retrieveAllFiles().values());
        for (Object element$iv : $receiver$iv) {
            String csvFileContent = (String)element$iv;
            Map<String, Set<String>> mimeTypesToExtensionsMapForFile = this.parser.parseIanaCsvFile(csvFileContent);
            this.mergeMimeTypes(mimeTypesToExtensionsMap, mimeTypesToExtensionsMapForFile);
        }
        return mimeTypesToExtensionsMap;
    }

    protected void mergeMimeTypes(@NotNull HashMap<String, Set<String>> mimeTypesToExtensionsMap, @NotNull Map<String, ? extends Set<String>> mimeTypesToExtensionsMapForFile) {
        Intrinsics.checkParameterIsNotNull(mimeTypesToExtensionsMap, (String)"mimeTypesToExtensionsMap");
        Intrinsics.checkParameterIsNotNull(mimeTypesToExtensionsMapForFile, (String)"mimeTypesToExtensionsMapForFile");
        mimeTypesToExtensionsMapForFile.forEach((BiConsumer<String, ? extends Set<String>>)new BiConsumer<String, Set<String>>(mimeTypesToExtensionsMap){
            final /* synthetic */ HashMap $mimeTypesToExtensionsMap;

            public final void accept(@NotNull String mimeType, @NotNull Set<String> fileExtensions) {
                Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
                Intrinsics.checkParameterIsNotNull(fileExtensions, (String)"fileExtensions");
                if (this.$mimeTypesToExtensionsMap.containsKey(mimeType)) {
                    Set set = (Set)this.$mimeTypesToExtensionsMap.get(mimeType);
                    if (set != null) {
                        set.addAll((Collection)fileExtensions);
                    }
                } else {
                    this.$mimeTypesToExtensionsMap.put(mimeType, fileExtensions);
                }
            }
            {
                this.$mimeTypesToExtensionsMap = hashMap;
            }
        });
    }

    @NotNull
    protected final IanaMimeTypeFileParser getParser() {
        return this.parser;
    }

    @NotNull
    protected final FileDownloader getDownloader() {
        return this.downloader;
    }

    public IanaMimeTypeRetriever(@NotNull IanaMimeTypeFileParser parser, @NotNull FileDownloader downloader) {
        Intrinsics.checkParameterIsNotNull((Object)parser, (String)"parser");
        Intrinsics.checkParameterIsNotNull((Object)downloader, (String)"downloader");
        this.parser = parser;
        this.downloader = downloader;
    }

    static {
        Companion = new Companion(null);
        CsvFilesUrls = CollectionsKt.listOf((Object[])new String[]{ApplicationCsvUrl, AudioCsvUrl, FontCsvUrl, ImageCsvUrl, MessageCsvUrl, ModelCsvUrl, MultipartCsvUrl, TextCsvUrl, VideoCsvUrl});
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lnet/dankito/mime/service/creator/IanaMimeTypeRetriever$Companion;", "", "()V", "ApplicationCsvUrl", "", "AudioCsvUrl", "CsvFilesUrls", "", "getCsvFilesUrls", "()Ljava/util/List;", "FontCsvUrl", "ImageCsvUrl", "MessageCsvUrl", "ModelCsvUrl", "MultipartCsvUrl", "TextCsvUrl", "VideoCsvUrl", "mime-utils"})
    public static final class Companion {
        @NotNull
        public final List<String> getCsvFilesUrls() {
            return CsvFilesUrls;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

