/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.mime.service.creator;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.dankito.mime.service.creator.MimeTypeFileParserBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0016\u0010\u0007\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u0014J@\u0010\n\u001a\u00020\u000b2.\u0010\f\u001a*\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000e0\rj\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000e`\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\"\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000e0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\"\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000e0\u00112\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J(\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000e0\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u0016J$\u0010\u0016\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000e\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0018"}, d2={"Lnet/dankito/mime/service/creator/IanaMimeTypeFileParser;", "Lnet/dankito/mime/service/creator/MimeTypeFileParserBase;", "()V", "isHeaderLine", "", "line", "", "isValidLine", "columns", "", "parseCsvLine", "", "mimeTypesToExtensionsMap", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "parseIanaCsvFile", "", "csvFile", "Ljava/io/File;", "csvFileContent", "csvFileLines", "parseIanaCsvFileNotThrowingExceptions", "Companion", "mime-utils"})
public class IanaMimeTypeFileParser
extends MimeTypeFileParserBase {
    private static final Logger log;
    public static final Companion Companion;

    @Nullable
    public Map<String, Set<String>> parseIanaCsvFileNotThrowingExceptions(@NotNull File csvFile) {
        Intrinsics.checkParameterIsNotNull((Object)csvFile, (String)"csvFile");
        try {
            return this.parseIanaCsvFile(csvFile);
        }
        catch (Exception e) {
            IanaMimeTypeFileParser.Companion.getLog().error("Could not parse .csv file " + csvFile, (Throwable)e);
            return null;
        }
    }

    @NotNull
    public Map<String, Set<String>> parseIanaCsvFile(@NotNull File csvFile) {
        Intrinsics.checkParameterIsNotNull((Object)csvFile, (String)"csvFile");
        FileReader reader = new FileReader(csvFile);
        List fileContent = TextStreamsKt.readLines((Reader)reader);
        reader.close();
        return this.parseIanaCsvFile(fileContent);
    }

    @NotNull
    public Map<String, Set<String>> parseIanaCsvFile(@NotNull String csvFileContent) {
        Intrinsics.checkParameterIsNotNull((Object)csvFileContent, (String)"csvFileContent");
        return this.parseIanaCsvFile(StringsKt.lines((CharSequence)csvFileContent));
    }

    @NotNull
    public Map<String, Set<String>> parseIanaCsvFile(@NotNull List<String> csvFileLines) {
        Intrinsics.checkParameterIsNotNull(csvFileLines, (String)"csvFileLines");
        HashMap<String, Set<String>> mimeTypesToExtensionsMap = new HashMap<String, Set<String>>();
        Iterable $receiver$iv = csvFileLines;
        for (Object element$iv : $receiver$iv) {
            String line = (String)element$iv;
            CharSequence charSequence = line;
            if (!(!StringsKt.isBlank((CharSequence)charSequence)) || this.isHeaderLine(line)) continue;
            this.parseCsvLine(mimeTypesToExtensionsMap, line);
        }
        return mimeTypesToExtensionsMap;
    }

    protected void parseCsvLine(@NotNull HashMap<String, Set<String>> mimeTypesToExtensionsMap, @NotNull String line) {
        Intrinsics.checkParameterIsNotNull(mimeTypesToExtensionsMap, (String)"mimeTypesToExtensionsMap");
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        List columns = StringsKt.split$default((CharSequence)line, (char[])new char[]{','}, (boolean)false, (int)0, (int)6, null);
        if (this.isValidLine(columns)) {
            String fileExtension = (String)columns.get(0);
            String mimeType = (String)columns.get(1);
            this.addFileExtensionForMimeType(mimeTypesToExtensionsMap, mimeType, fileExtension);
        } else {
            IanaMimeTypeFileParser.Companion.getLog().warn("Csv line has " + columns.size() + " but should have 3 or for image.csv 4 columns: " + line);
        }
    }

    protected boolean isHeaderLine(@NotNull String line) {
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        String string = line;
        String string2 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        return StringsKt.startsWith$default((String)string2, (String)"name,", (boolean)false, (int)2, null);
    }

    protected boolean isValidLine(@NotNull List<String> columns) {
        Intrinsics.checkParameterIsNotNull(columns, (String)"columns");
        if (columns.size() == 3 || columns.size() == 4) {
            CharSequence charSequence = columns.get(0);
            return !StringsKt.isBlank((CharSequence)charSequence);
        }
        return false;
    }

    static {
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(IanaMimeTypeFileParser.class);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lnet/dankito/mime/service/creator/IanaMimeTypeFileParser$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "mime-utils"})
    public static final class Companion {
        private final Logger getLog() {
            return log;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

