/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.mime.service;

import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.dankito.mime.model.DownloadResult;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0015J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J$\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00120\u0014H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lnet/dankito/mime/service/FileDownloader;", "", "()V", "client", "Lokhttp3/OkHttpClient;", "getClient", "()Lokhttp3/OkHttpClient;", "executeRequest", "Lokhttp3/Response;", "request", "Lokhttp3/Request;", "countRetries", "", "get", "Lnet/dankito/mime/model/DownloadResult;", "url", "", "getAsync", "", "callback", "Lkotlin/Function1;", "Companion", "mime-utils"})
public class FileDownloader {
    @NotNull
    private final OkHttpClient client;
    public static final int DefaultConnectionTimeoutMillis = 2000;
    public static final int DefaultCountConnectionRetries = 2;
    private static final Logger log;
    public static final Companion Companion;

    @NotNull
    protected final OkHttpClient getClient() {
        return this.client;
    }

    public void getAsync(@NotNull String url, @NotNull Function1<? super DownloadResult, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        callback.invoke((Object)this.get(url));
    }

    @NotNull
    public DownloadResult get(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        try {
            Request request;
            FileDownloader.Companion.getLog().info("Starting to download from url " + url);
            Request request2 = request = new Request.Builder().url(url).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)request2, (String)"request");
            Response response = FileDownloader.executeRequest$default(this, request2, 0, 2, null);
            FileDownloader.Companion.getLog().info("Was downloading " + url + " successful? " + response.isSuccessful());
            ResponseBody responseBody = response.body();
            return new DownloadResult(true, null, responseBody != null ? responseBody.string() : null, 2, null);
        }
        catch (Exception e) {
            FileDownloader.Companion.getLog().error("Could not download url " + url, (Throwable)e);
            return new DownloadResult(false, e, null, 4, null);
        }
    }

    @NotNull
    protected Response executeRequest(@NotNull Request request, int countRetries) throws Exception {
        Response response;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Response response2 = response = this.client.newCall(request).execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
        if (!response2.isSuccessful() && countRetries > 0) {
            return this.executeRequest(request, countRetries - 1);
        }
        return response;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Response executeRequest$default(FileDownloader fileDownloader, Request request, int n, int n2, Object object) throws Exception {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: executeRequest");
        }
        if ((n2 & 2) != 0) {
            n = 2;
        }
        return fileDownloader.executeRequest(request, n);
    }

    public FileDownloader() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.followRedirects(true);
        builder.retryOnConnectionFailure(true);
        builder.connectTimeout((long)2000, TimeUnit.MILLISECONDS);
        builder.readTimeout((long)2000, TimeUnit.MILLISECONDS);
        builder.writeTimeout((long)2000, TimeUnit.MILLISECONDS);
        OkHttpClient okHttpClient = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)okHttpClient, (String)"builder.build()");
        this.client = okHttpClient;
    }

    static {
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(FileDownloader.class);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lnet/dankito/mime/service/FileDownloader$Companion;", "", "()V", "DefaultConnectionTimeoutMillis", "", "DefaultCountConnectionRetries", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "mime-utils"})
    public static final class Companion {
        private final Logger getLog() {
            return log;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

