/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.mime;

import java.io.File;
import java.net.URI;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.dankito.mime.MimeTypePicker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0014J\b\u0010\u0014\u001a\u00020\u0011H\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001a\u001a\u00020\u0007H\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u001f2\u0006\u0010\u0012\u001a\u00020\u0007H\u0016J\u0018\u0010 \u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u001f2\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\u0018\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u001f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u001f2\u0006\u0010\u001a\u001a\u00020\u0007H\u0016J\u0018\u0010#\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0014\u0010$\u001a\u0004\u0018\u00010\u00072\b\u0010%\u001a\u0004\u0018\u00010\u0007H\u0014R<\u0010\u0005\u001a*\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u0006j\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b`\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR<\u0010\f\u001a*\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u0006j\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b`\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006&"}, d2={"Lnet/dankito/mime/MimeTypeDetector;", "", "picker", "Lnet/dankito/mime/MimeTypePicker;", "(Lnet/dankito/mime/MimeTypePicker;)V", "fileExtensionsToMimeTypeMap", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "getFileExtensionsToMimeTypeMap", "()Ljava/util/HashMap;", "mimeTypesMap", "getMimeTypesMap", "getPicker", "()Lnet/dankito/mime/MimeTypePicker;", "addMapping", "", "mimeType", "fileExtension", "generateMimeTypeToFileExtensionMapping", "getBestPickForExtension", "getBestPickForFile", "file", "Ljava/io/File;", "getBestPickForFilename", "filename", "getBestPickForUri", "uri", "Ljava/net/URI;", "getExtensionsForMimeType", "", "getMimeTypesForExtension", "getMimeTypesForFile", "getMimeTypesForFilename", "getMimeTypesForUri", "normalizeFileExtension", "extension", "mime-utils"})
public class MimeTypeDetector {
    @NotNull
    private final HashMap<String, Set<String>> mimeTypesMap;
    @NotNull
    private final HashMap<String, Set<String>> fileExtensionsToMimeTypeMap;
    @NotNull
    private final MimeTypePicker picker;

    @NotNull
    protected final HashMap<String, Set<String>> getMimeTypesMap() {
        return this.mimeTypesMap;
    }

    @NotNull
    protected final HashMap<String, Set<String>> getFileExtensionsToMimeTypeMap() {
        return this.fileExtensionsToMimeTypeMap;
    }

    @Nullable
    public List<String> getMimeTypesForUri(@NotNull URI uri) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        String string = uri.toASCIIString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"uri.toASCIIString()");
        return this.getMimeTypesForFilename(string);
    }

    @Nullable
    public List<String> getMimeTypesForFile(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (file.isDirectory()) {
            return null;
        }
        return this.getMimeTypesForExtension(FilesKt.getExtension((File)file));
    }

    @Nullable
    public List<String> getMimeTypesForFilename(@NotNull String filename) {
        Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
        return this.getMimeTypesForExtension(StringsKt.substringAfterLast((String)filename, (char)'.', (String)""));
    }

    @Nullable
    public List<String> getMimeTypesForExtension(@NotNull String fileExtension) {
        Intrinsics.checkParameterIsNotNull((Object)fileExtension, (String)"fileExtension");
        try {
            List result;
            Object object = this.fileExtensionsToMimeTypeMap;
            String string = this.normalizeFileExtension(fileExtension);
            Object v = object.get(string);
            Set set = (Set)v;
            List list = result = set != null ? CollectionsKt.toList((Iterable)set) : null;
            if (result == null) {
                String string2 = URLConnection.guessContentTypeFromName(fileExtension);
                if (string2 != null) {
                    Object mimeType = object = string2;
                    result = CollectionsKt.listOf((Object)mimeType);
                }
            }
            return result;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    protected String normalizeFileExtension(@Nullable String extension) {
        int n;
        String string;
        if (extension == null) {
            return extension;
        }
        String normalizedExtension = extension;
        if (StringsKt.startsWith$default((CharSequence)normalizedExtension, (char)'*', (boolean)false, (int)2, null)) {
            string = normalizedExtension;
            n = 1;
            String string2 = string.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
            normalizedExtension = string2;
        }
        if (StringsKt.startsWith$default((CharSequence)normalizedExtension, (char)'.', (boolean)false, (int)2, null)) {
            string = normalizedExtension;
            n = 1;
            String string3 = string;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            normalizedExtension = string4;
        }
        String string5 = string = normalizedExtension;
        if (string5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).toLowerCase()");
        return string6;
    }

    @Nullable
    public String getBestPickForUri(@NotNull URI uri) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        return this.picker.getBestPick(this.getMimeTypesForUri(uri));
    }

    @Nullable
    public String getBestPickForFile(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return this.picker.getBestPick(this.getMimeTypesForFile(file));
    }

    @Nullable
    public String getBestPickForFilename(@NotNull String filename) {
        Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
        return this.picker.getBestPick(this.getMimeTypesForFilename(filename));
    }

    @Nullable
    public String getBestPickForExtension(@NotNull String fileExtension) {
        Intrinsics.checkParameterIsNotNull((Object)fileExtension, (String)"fileExtension");
        return this.picker.getBestPick(this.getMimeTypesForExtension(fileExtension));
    }

    @Nullable
    public List<String> getExtensionsForMimeType(@NotNull String mimeType) {
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        String string = mimeType;
        HashMap<String, Set<String>> hashMap = this.mimeTypesMap;
        String string2 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        String string3 = string2;
        Set<String> set = hashMap.get(string3);
        return set != null ? CollectionsKt.toList((Iterable)set) : null;
    }

    /*
     * Opcode count of 15510 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    protected void generateMimeTypeToFileExtensionMapping() {
        this.addMapping("application/vnd.ms-htmlhelp", "chm");
        this.addMapping("application/atom+xml", "atom");
        this.addMapping("application/vnd.3gpp.pic-bw-var", "pvb");
        this.addMapping("application/clue_info+xml", "clue");
        this.addMapping("application/vnd.kidspiration", "kia");
        this.addMapping("application/vnd.ufdl", "ufdl");
        this.addMapping("application/vnd.ufdl", "ufd");
        this.addMapping("application/vnd.ufdl", "frm");
        this.addMapping("video/vnd.dece.mp4", "uvu");
        this.addMapping("video/vnd.dece.mp4", "uvvu");
        this.addMapping("audio/dls", "dls");
        this.addMapping("audio/x-flac", "flac");
        this.addMapping("application/font-tdpfr", "pfr");
        this.addMapping("application/vnd.crick.clicker.wordbank", "clkw");
        this.addMapping("application/tamp-apex-update", "tau");
        this.addMapping("application/vnd.geocube+xml", "g3");
        this.addMapping("application/vnd.geocube+xml", "g\u00b3");
        this.addMapping("application/vnd.kenameaapp", "htke");
        this.addMapping("text/xml", "xml");
        this.addMapping("text/xml", "xsd");
        this.addMapping("text/xml", "rng");
        this.addMapping("application/rss+xml", "rss");
        this.addMapping("application/x-tcl", "tcl");
        this.addMapping("application/vnd.fujitsu.oasys", "oas");
        this.addMapping("audio/EVRCB", "evb");
        this.addMapping("application/vnd.visionary", "vis");
        this.addMapping("multipart/vnd.bint.med-plus", "bmed");
        this.addMapping("application/prs.rdf-xml-crypt", "rdf-crypt");
        this.addMapping("application/xcap-diff+xml", "xdf");
        this.addMapping("text/html", "html");
        this.addMapping("text/html", "htm");
        this.addMapping("application/vnd.lotus-freelance", "prz");
        this.addMapping("application/vnd.lotus-freelance", "pre");
        this.addMapping("application/vnd.ms-artgalry", "cil");
        this.addMapping("application/vnd.geometry-explorer", "gex");
        this.addMapping("application/vnd.geometry-explorer", "gre");
        this.addMapping("application/vnd.genomatix.tuxedo", "txd");
        this.addMapping("audio/x-ms-wma", "wma");
        this.addMapping("application/vnd.commonspace", "csp");
        this.addMapping("application/vnd.commonspace", "cst");
        this.addMapping("application/vnd.fujixerox.docuworks.binder", "xbd");
        this.addMapping("application/vnd.amazon.mobi8-ebook", "azw3");
        this.addMapping("application/scvp-cv-request", "scq");
        this.addMapping("application/x-wais-source", "src");
        this.addMapping("application/vnd.accpac.simply.imp", "imp");
        this.addMapping("application/vnd.lotus-wordpro", "lwp");
        this.addMapping("application/vnd.lotus-wordpro", "sam");
        this.addMapping("application/vnd.mophun.application", "mpn");
        this.addMapping("application/vnd.osgi.dp", "dp");
        this.addMapping("text/html-sandboxed", "sandboxed");
        this.addMapping("application/provenance+xml", "provx");
        this.addMapping("application/vnd.citationstyles.style+xml", "csl");
        this.addMapping("application/vnd.neurolanguage.nlu", "nlu");
        this.addMapping("application/vnd.wap.mms-message", "mms");
        this.addMapping("application/mac-compactpro", "cpt");
        this.addMapping("application/urc-uisocketdesc+xml", "uis");
        this.addMapping("application/vnd.hbci", "hbci");
        this.addMapping("application/vnd.hbci", "hbc");
        this.addMapping("application/vnd.hbci", "kom");
        this.addMapping("application/vnd.hbci", "upa");
        this.addMapping("application/vnd.hbci", "pkd");
        this.addMapping("application/vnd.hbci", "bpd");
        this.addMapping("application/vnd.openxmlformats-officedocument.spreadsheetml.template", "xltx");
        this.addMapping("application/vnd.tcpdump.pcap", "pcap");
        this.addMapping("application/vnd.tcpdump.pcap", "cap");
        this.addMapping("application/vnd.tcpdump.pcap", "dmp");
        this.addMapping("application/x-tex", "tex");
        this.addMapping("application/vnd.multiad.creator.cif", "cif");
        this.addMapping("application/vnd.picsel", "efif");
        this.addMapping("application/tamp-sequence-adjust-confirm", "sac");
        this.addMapping("application/vnd.ms-cab-compressed", "cab");
        this.addMapping("application/tamp-update-confirm", "tuc");
        this.addMapping("audio/vnd.sealedmedia.softseal.mpeg", "smp3");
        this.addMapping("audio/vnd.sealedmedia.softseal.mpeg", "smp");
        this.addMapping("audio/vnd.sealedmedia.softseal.mpeg", "s1m");
        this.addMapping("application/n-quads", "nq");
        this.addMapping("application/vnd.software602.filler.form+xml", "fo");
        this.addMapping("application/vnd.anki", "apkg");
        this.addMapping("application/vnd.rainstor.data", "tree");
        this.addMapping("x-conference/x-cooltalk", "ice");
        this.addMapping("application/vnd.Mobius.DAF", "daf");
        this.addMapping("application/A2L", "a2l");
        this.addMapping("image/vnd.sealed.png", "spng");
        this.addMapping("image/vnd.sealed.png", "spn");
        this.addMapping("image/vnd.sealed.png", "s1n");
        this.addMapping("application/vnd.coreos.ignition+json", "ign");
        this.addMapping("application/vnd.coreos.ignition+json", "ignition");
        this.addMapping("image/webp", "webp");
        this.addMapping("audio/x-realaudio", "ra");
        this.addMapping("application/vnd.fdf", "fdf");
        this.addMapping("application/vnd.apple.mpegurl", "m3u8");
        this.addMapping("application/vnd.rig.cryptonote", "cryptonote");
        this.addMapping("application/x-killustrator", "kil");
        this.addMapping("application/vnd.nokia.radio-preset", "rpst");
        this.addMapping("application/vnd.syncml+xml", "xsm");
        this.addMapping("audio/x-aiff", "aif");
        this.addMapping("audio/x-aiff", "aiff");
        this.addMapping("audio/x-aiff", "aifc");
        this.addMapping("image/vnd.fpx", "fpx");
        this.addMapping("application/pkix-cert", "cer");
        this.addMapping("application/vnd.framemaker", "fm");
        this.addMapping("image/vnd.dece.graphic", "uvi");
        this.addMapping("image/vnd.dece.graphic", "uvvi");
        this.addMapping("image/vnd.dece.graphic", "uvg");
        this.addMapping("image/vnd.dece.graphic", "uvvg");
        this.addMapping("application/vnd.oasis.opendocument.image-template", "oti");
        this.addMapping("application/rtf", "rtf");
        this.addMapping("application/vnd.aristanetworks.swi", "swi");
        this.addMapping("image/t38", "t38");
        this.addMapping("application/vnd.imagemeter.folder+zip", "imf");
        this.addMapping("image/x-portable-pixmap", "ppm");
        this.addMapping("application/vnd.groove-help", "ghf");
        this.addMapping("application/vnd.vidsoft.vidconference", "vsc");
        this.addMapping("application/vnd.syncml.dm+wbxml", "bdm");
        this.addMapping("application/vnd.pg.osasli", "ei6");
        this.addMapping("application/vnd.ahead.space", "ahead");
        this.addMapping("application/vnd.unity", "unityweb");
        this.addMapping("application/vnd.panoply", "plp");
        this.addMapping("audio/AMR", "amr");
        this.addMapping("text/uri-list", "uris");
        this.addMapping("text/uri-list", "uri");
        this.addMapping("application/vnd.evolv.ecig.settings", "ecig");
        this.addMapping("application/vnd.adobe.formscentral.fcdt", "fcdt");
        this.addMapping("text/vnd.abc", "abc");
        this.addMapping("application/ccxml+xml", "ccxml");
        this.addMapping("application/cpl+xml", "cpl");
        this.addMapping("application/vnd.wolfram.mathematica.package", "m");
        this.addMapping("application/vnd.eszigno3+xml", "es3");
        this.addMapping("application/vnd.eszigno3+xml", "et3");
        this.addMapping("image/png", "png");
        this.addMapping("application/cccex", "c3ex");
        this.addMapping("application/vnd.onepagertamx", "tamx");
        this.addMapping("application/ATFX", "atfx");
        this.addMapping("application/vnd.musician", "mus");
        this.addMapping("application/lgr+xml", "lgr");
        this.addMapping("application/vnd.yamaha.smaf-audio", "saf");
        this.addMapping("application/vnd.ms-xpsdocument", "xps");
        this.addMapping("application/vnd.anser-web-certificate-issue-initiation", "cii");
        this.addMapping("application/vnd.onepagertamp", "tamp");
        this.addMapping("application/vnd.sealed.3df", "s3df");
        this.addMapping("audio/ogg", "oga");
        this.addMapping("audio/ogg", "ogg");
        this.addMapping("audio/ogg", "opus");
        this.addMapping("audio/ogg", "spx");
        this.addMapping("audio/32kadpcm", "726");
        this.addMapping("application/x-tar", "tar");
        this.addMapping("application/vnd.smart.notebook", "notebook");
        this.addMapping("application/vnd.ms-asf", "asf");
        this.addMapping("application/vnd.stepmania.package", "smzip");
        this.addMapping("application/vnd.medcalcdata", "mc1");
        this.addMapping("application/xcap-el+xml", "xel");
        this.addMapping("text/vnd.wap.sl", "sl");
        this.addMapping("application/vnd.hdt", "hdt");
        this.addMapping("text/x-pod", "pod");
        this.addMapping("text/vnd.wap.si", "si");
        this.addMapping("application/vnd.pg.format", "str");
        this.addMapping("application/vnd.openxmlformats-officedocument.wordprocessingml.template", "dotx");
        this.addMapping("application/vnd.piaccess.application-license", "pil");
        this.addMapping("text/sgml", "sgml");
        this.addMapping("text/sgml", "sgm");
        this.addMapping("application/vnd.adobe.flash.movie", "swf");
        this.addMapping("application/vnd.noblenet-sealer", "nns");
        this.addMapping("application/vnd.shana.informed.formdata", "ifm");
        this.addMapping("application/vnd.trid.tpt", "tpt");
        this.addMapping("application/vnd.blueice.multipass", "mpm");
        this.addMapping("application/vnd.contact.cmsg", "cdbcmsg");
        this.addMapping("application/vnd.epson.quickanime", "qam");
        this.addMapping("application/vnd.ms-excel.sheet.binary.macroEnabled.12", "xlsb");
        this.addMapping("application/ocsp-request", "orq");
        this.addMapping("application/vnd.hp-hps", "hps");
        this.addMapping("audio/vnd.rip", "rip");
        this.addMapping("application/vnd.dreamfactory", "dfac");
        this.addMapping("application/vnd.ieee.1905", "1905.1");
        this.addMapping("application/epub+zip", "epub");
        this.addMapping("text/vnd.a", "a");
        this.addMapping("text/vnd.si.uricatalogue", "uric");
        this.addMapping("application/reginfo+xml", "rif");
        this.addMapping("application/vnd.crick.clicker", "clkx");
        this.addMapping("application/vnd.symbian.install", "sis");
        this.addMapping("application/exi", "exi");
        this.addMapping("application/marc", "mrc");
        this.addMapping("application/vnd.mediastation.cdkey", "cdkey");
        this.addMapping("application/vnd.oma.dd+xml", "dd");
        this.addMapping("application/vnd.3gpp2.tcap", "tcap");
        this.addMapping("image/vnd.sealedmedia.softseal.jpg", "sjpg");
        this.addMapping("image/vnd.sealedmedia.softseal.jpg", "sjp");
        this.addMapping("image/vnd.sealedmedia.softseal.jpg", "s1j");
        this.addMapping("model/vnd.parasolid.transmit.text", "x_t");
        this.addMapping("model/vnd.parasolid.transmit.text", "xmt_txt");
        this.addMapping("application/vnd.sun.xml.math", "sxm");
        this.addMapping("application/vnd.cluetrust.cartomobile-config", "c11amc");
        this.addMapping("application/vnd.spotfire.dxp", "dxp");
        this.addMapping("application/vnd.smaf", "mmf");
        this.addMapping("application/vnd.joost.joda-archive", "joda");
        this.addMapping("audio/x-annodex", "axa");
        this.addMapping("application/vnd.sun.xml.writer", "sxw");
        this.addMapping("application/vnd.3gpp2.sms", "sms");
        this.addMapping("image/vnd.fujixerox.edmics-mmr", "mmr");
        this.addMapping("application/vnd.theqvd", "qvd");
        this.addMapping("application/vnd.data-vision.rdz", "rdz");
        this.addMapping("application/vnd.pvi.ptid1", "ptid");
        this.addMapping("application/vnd.sus-calendar", "sus");
        this.addMapping("application/vnd.sus-calendar", "susp");
        this.addMapping("application/timestamped-data", "tsd");
        this.addMapping("application/vnd.acucobol", "acu");
        this.addMapping("application/vnd.olpc-sugar", "xo");
        this.addMapping("application/vnd.sealed.ppt", "sppt");
        this.addMapping("application/vnd.sealed.ppt", "s1p");
        this.addMapping("application/vnd.Mobius.MBK", "mbk");
        this.addMapping("application/vnd.Mobius.DIS", "dis");
        this.addMapping("application/vnd.lotus-1-2-3", "123");
        this.addMapping("application/vnd.lotus-1-2-3", "wk4");
        this.addMapping("application/vnd.lotus-1-2-3", "wk3");
        this.addMapping("application/vnd.lotus-1-2-3", "wk1");
        this.addMapping("application/vnd.novadigm.EXT", "ext");
        this.addMapping("application/vnd.clonk.c4group", "c4g");
        this.addMapping("application/vnd.clonk.c4group", "c4d");
        this.addMapping("application/vnd.clonk.c4group", "c4f");
        this.addMapping("application/vnd.clonk.c4group", "c4p");
        this.addMapping("application/vnd.clonk.c4group", "c4u");
        this.addMapping("application/vnd.geonext", "gxt");
        this.addMapping("application/srgs", "gram");
        this.addMapping("image/x-xbitmap", "xbm");
        this.addMapping("application/vnd.oasis.opendocument.graphics-template", "otg");
        this.addMapping("application/vnd.onepagertatx", "tatx");
        this.addMapping("model/vnd.parasolid.transmit.binary", "x_b");
        this.addMapping("model/vnd.parasolid.transmit.binary", "xmt_bin");
        this.addMapping("application/vnd.noblenet-directory", "nnd");
        this.addMapping("application/vnd.onepagertatp", "tatp");
        this.addMapping("audio/x-wav", "wav");
        this.addMapping("application/vnd.kahootz", "ktz");
        this.addMapping("application/vnd.kahootz", "ktr");
        this.addMapping("application/ccmp+xml", "ccmp");
        this.addMapping("font/ttf", "ttf");
        this.addMapping("application/cms", "cmsc");
        this.addMapping("image/emf", "emf");
        this.addMapping("audio/vnd.audikoz", "koz");
        this.addMapping("application/octet-stream", "bin");
        this.addMapping("application/octet-stream", "lha");
        this.addMapping("application/octet-stream", "lzh");
        this.addMapping("application/octet-stream", "exe");
        this.addMapping("application/octet-stream", "class");
        this.addMapping("application/octet-stream", "so");
        this.addMapping("application/octet-stream", "dll");
        this.addMapping("application/octet-stream", "img");
        this.addMapping("application/octet-stream", "iso");
        this.addMapping("video/x-ms-asf", "asx");
        this.addMapping("application/rdf+xml", "rdf");
        this.addMapping("application/x-sv4crc", "sv4crc");
        this.addMapping("application/vnd.google-earth.kml+xml", "kml");
        this.addMapping("video/3gpp2", "3g2");
        this.addMapping("video/3gpp2", "3gpp2");
        this.addMapping("application/vnd.dvb.ait", "ait");
        this.addMapping("audio/mpeg", "mp3");
        this.addMapping("audio/mpeg", "mpga");
        this.addMapping("audio/mpeg", "mp1");
        this.addMapping("audio/mpeg", "mp2");
        this.addMapping("application/davmount+xml", "davmount");
        this.addMapping("application/vnd.geoplan", "g2w");
        this.addMapping("application/vnd.palm", "prc");
        this.addMapping("application/vnd.palm", "pdb");
        this.addMapping("application/vnd.palm", "pqa");
        this.addMapping("application/vnd.palm", "oprc");
        this.addMapping("audio/x-mpegurl", "m3u");
        this.addMapping("application/tamp-community-update", "tcu");
        this.addMapping("application/xcap-caps+xml", "xca");
        this.addMapping("image/svg+xml", "svg");
        this.addMapping("image/svg+xml", "svgz");
        this.addMapping("model/vnd.dwf", "dwf");
        this.addMapping("application/vnd.hp-jlyt", "jlt");
        this.addMapping("application/vnd.llamagraphics.life-balance.exchange+xml", "lbe");
        this.addMapping("application/vnd.apple.installer+xml", "dist");
        this.addMapping("application/vnd.apple.installer+xml", "distz");
        this.addMapping("application/vnd.apple.installer+xml", "pkg");
        this.addMapping("application/vnd.apple.installer+xml", "mpkg");
        this.addMapping("application/vnd.osa.netdeploy", "ndc");
        this.addMapping("message/global-delivery-status", "u8dsn");
        this.addMapping("video/vnd.vivo", "viv");
        this.addMapping("application/vnd.jam", "jam");
        this.addMapping("image/fits", "fits");
        this.addMapping("image/fits", "fit");
        this.addMapping("image/fits", "fts");
        this.addMapping("application/mathematica", "nb");
        this.addMapping("application/mathematica", "ma");
        this.addMapping("application/mathematica", "mb");
        this.addMapping("audio/ATRAC3", "at3");
        this.addMapping("audio/ATRAC3", "aa3");
        this.addMapping("audio/ATRAC3", "omg");
        this.addMapping("application/mp21", "m21");
        this.addMapping("application/mp21", "mp21");
        this.addMapping("image/vnd.airzip.accelerator.azv", "azv");
        this.addMapping("application/MF4", "mf4");
        this.addMapping("model/x3d-vrml", "x3dv");
        this.addMapping("model/x3d-vrml", "x3dvz");
        this.addMapping("application/vnd.software602.filler.form-xml-zip", "zfo");
        this.addMapping("image/x-portable-anymap", "pnm");
        this.addMapping("application/yin+xml", "yin");
        this.addMapping("application/vnd.balsamiq.bmml+xml", "bmml");
        this.addMapping("application/cellml+xml", "cellml");
        this.addMapping("application/cellml+xml", "cml");
        this.addMapping("video/x-msvideo", "avi");
        this.addMapping("application/ecmascript", "es");
        this.addMapping("application/vnd.kde.kpresenter", "kpr");
        this.addMapping("application/vnd.kde.kpresenter", "kpt");
        this.addMapping("application/vnd.osgi.subsystem", "esa");
        this.addMapping("application/vnd.1000minds.decision-model+xml", "1km");
        this.addMapping("application/vnd.kde.kontour", "kon");
        this.addMapping("application/vnd.geospace", "g3w");
        this.addMapping("image/vnd.xiff", "xif");
        this.addMapping("application/vnd.uiq.theme", "utz");
        this.addMapping("video/x-annodex", "axv");
        this.addMapping("audio/prs.sid", "sid");
        this.addMapping("audio/prs.sid", "psid");
        this.addMapping("application/oebps-package+xml", "opf");
        this.addMapping("application/vnd.oxli.countgraph", "oxlicg");
        this.addMapping("application/vnd.syncml.dmddf+xml", "ddf");
        this.addMapping("application/PDX", "pdx");
        this.addMapping("application/vnd.comicbook+zip", "cbz");
        this.addMapping("application/dssc+der", "dssc");
        this.addMapping("text/csv", "csv");
        this.addMapping("application/pkcs10", "p10");
        this.addMapping("application/pkcs12", "p12");
        this.addMapping("application/pkcs12", "pfx");
        this.addMapping("application/vnd.lotus-notes", "nsf");
        this.addMapping("application/vnd.lotus-notes", "ntf");
        this.addMapping("application/vnd.lotus-notes", "ndl");
        this.addMapping("application/vnd.lotus-notes", "ns4");
        this.addMapping("application/vnd.lotus-notes", "ns3");
        this.addMapping("application/vnd.lotus-notes", "ns2");
        this.addMapping("application/vnd.lotus-notes", "nsh");
        this.addMapping("application/vnd.lotus-notes", "nsg");
        this.addMapping("application/vnd.is-xpr", "xpr");
        this.addMapping("text/css", "css");
        this.addMapping("text/troff", "t");
        this.addMapping("text/troff", "tr");
        this.addMapping("text/troff", "roff");
        this.addMapping("image/cgm", "cgm");
        this.addMapping("model/vnd.mts", "mts");
        this.addMapping("application/x-troff-ms", "ms");
        this.addMapping("application/sru+xml", "sru");
        this.addMapping("application/vnd.kde.kivio", "flw");
        this.addMapping("application/vnd.scribus", "scd");
        this.addMapping("application/vnd.scribus", "sla");
        this.addMapping("application/vnd.scribus", "slaz");
        this.addMapping("application/vnd.las.las+json", "lasjson");
        this.addMapping("application/sparql-query", "rq");
        this.addMapping("application/vnd.sun.xml.calc.template", "stc");
        this.addMapping("audio/EVRCWB", "evw");
        this.addMapping("application/x-troff-me", "me");
        this.addMapping("application/resource-lists+xml", "rl");
        this.addMapping("application/vnd.tmobile-livetv", "tmo");
        this.addMapping("application/x-dvi", "dvi");
        this.addMapping("application/x-latex", "latex");
        this.addMapping("application/vnd.oma.drm.message", "dm");
        this.addMapping("application/watcherinfo+xml", "wif");
        this.addMapping("application/vnd.frogans.ltf", "ltf");
        this.addMapping("model/x3d+xml", "x3db");
        this.addMapping("application/ttml+xml", "ttml");
        this.addMapping("video/mpeg", "mpeg");
        this.addMapping("video/mpeg", "mpg");
        this.addMapping("video/mpeg", "mpe");
        this.addMapping("video/mpeg", "m1v");
        this.addMapping("video/mpeg", "m2v");
        this.addMapping("application/vnd.mcd", "mcd");
        this.addMapping("audio/vnd.everad.plj", "plj");
        this.addMapping("application/oda", "oda");
        this.addMapping("application/vnd.oasis.opendocument.text-master", "odm");
        this.addMapping("application/vnd.bluetooth.ep.oob", "ep");
        this.addMapping("text/tab-separated-values", "tsv");
        this.addMapping("audio/vnd.ms-playready.media.pya", "pya");
        this.addMapping("application/vnd.xmpie.dpkg", "dpkg");
        this.addMapping("image/gif", "gif");
        this.addMapping("application/vnd.bmi", "bmi");
        this.addMapping("application/vnd.dtg.local.flash", "fla");
        this.addMapping("text/vnd.esmertec.theme-descriptor", "jtd");
        this.addMapping("application/vnd.oma.drm.dcf", "o4a");
        this.addMapping("application/vnd.oma.drm.dcf", "o4v");
        this.addMapping("audio/ATRAC-X", "atx");
        this.addMapping("image/vnd.fastbidsheet", "fbs");
        this.addMapping("application/vnd.epson.salt", "slt");
        this.addMapping("application/sdp", "sdp");
        this.addMapping("application/srgs+xml", "grxml");
        this.addMapping("application/vnd.pmi.widget", "wg");
        this.addMapping("application/vnd.triscape.mxs", "mxs");
        this.addMapping("audio/L16", "l16");
        this.addMapping("message/global", "u8msg");
        this.addMapping("application/vnd.sun.wadl+xml", "wadl");
        this.addMapping("application/link-format", "wlnk");
        this.addMapping("application/vnd.kde.kformula", "kfo");
        this.addMapping("application/vnd.quobject-quoxdocument", "quox");
        this.addMapping("application/vnd.quobject-quoxdocument", "quiz");
        this.addMapping("text/cache-manifest", "appcache");
        this.addMapping("text/cache-manifest", "manifest");
        this.addMapping("application/vnd.multiad.creator", "crtr");
        this.addMapping("audio/iLBC", "lbc");
        this.addMapping("application/vnd.oasis.opendocument.text", "odt");
        this.addMapping("application/x-bcpio", "bcpio");
        this.addMapping("application/atomdeleted+xml", "atomdeleted");
        this.addMapping("application/ocsp-response", "ors");
        this.addMapping("application/vnd.adobe.fxp", "fxp");
        this.addMapping("application/vnd.adobe.fxp", "fxpl");
        this.addMapping("model/vnd.gdl", "gdl");
        this.addMapping("model/vnd.gdl", "gsm");
        this.addMapping("model/vnd.gdl", "win");
        this.addMapping("model/vnd.gdl", "dor");
        this.addMapping("model/vnd.gdl", "lmp");
        this.addMapping("model/vnd.gdl", "rsm");
        this.addMapping("model/vnd.gdl", "msm");
        this.addMapping("model/vnd.gdl", "ism");
        this.addMapping("application/scvp-cv-response", "scs");
        this.addMapping("font/woff", "woff");
        this.addMapping("model/vnd.collada+xml", "dae");
        this.addMapping("model/vnd.valve.source.compiled-map", "bsp");
        this.addMapping("application/lostsync+xml", "lostsyncxml");
        this.addMapping("audio/vnd.dts", "dts");
        this.addMapping("image/vnd.tencent.tap", "tap");
        this.addMapping("application/vnd.businessobjects", "rep");
        this.addMapping("application/vnd.sigrok.session", "sr");
        this.addMapping("application/vnd.ms-works", "wcm");
        this.addMapping("application/vnd.ms-works", "wdb");
        this.addMapping("application/vnd.ms-works", "wks");
        this.addMapping("application/vnd.ms-works", "wps");
        this.addMapping("image/vnd.fujixerox.edmics-rlc", "rlc");
        this.addMapping("audio/x-stm", "stm");
        this.addMapping("application/vnd.dna", "dna");
        this.addMapping("application/vnd.lotus-screencam", "scm");
        this.addMapping("application/vnd.fsc.weblaunch", "fsc");
        this.addMapping("application/vnd.dynageo", "geo");
        this.addMapping("application/vnd.fluxtime.clip", "ftc");
        this.addMapping("image/ktx", "ktx");
        this.addMapping("application/vnd.sealed.csf", "scsf");
        this.addMapping("audio/x-s3m", "s3m");
        this.addMapping("application/mbox", "mbox");
        this.addMapping("application/prs.xsf+xml", "xsf");
        this.addMapping("application/vnd.accpac.simply.aso", "aso");
        this.addMapping("image/vnd.radiance", "hdr");
        this.addMapping("image/vnd.radiance", "rgbe");
        this.addMapping("image/vnd.radiance", "xyze");
        this.addMapping("application/vnd.xmpie.xlim", "xlim");
        this.addMapping("application/urc-grpsheet+xml", "gsheet");
        this.addMapping("application/vnd.fastcopy-disk-image", "dim");
        this.addMapping("application/vnd.ms-word.template.macroEnabled.12", "dotm");
        this.addMapping("application/vnd.seemail", "see");
        this.addMapping("application/scvp-vp-response", "spp");
        this.addMapping("application/vnd.nokia.n-gage.ac+xml", "ac");
        this.addMapping("application/vnd.novadigm.EDM", "edm");
        this.addMapping("application/vnd.ms-excel", "xls");
        this.addMapping("application/vnd.ms-excel", "xlm");
        this.addMapping("application/vnd.ms-excel", "xla");
        this.addMapping("application/vnd.ms-excel", "xlc");
        this.addMapping("application/vnd.ms-excel", "xlt");
        this.addMapping("application/vnd.ms-excel", "xlw");
        this.addMapping("application/vnd.noblenet-web", "nnw");
        this.addMapping("application/tamp-error", "ter");
        this.addMapping("application/pkcs8", "p8");
        this.addMapping("application/vnd.novadigm.EDX", "edx");
        this.addMapping("application/x-sv4cpio", "sv4cpio");
        this.addMapping("application/vnd.muvee.style", "msty");
        this.addMapping("application/xml-dtd", "dtd");
        this.addMapping("model/vnd.opengex", "ogex");
        this.addMapping("application/vnd.sealed.eml", "seml");
        this.addMapping("application/vnd.sealed.eml", "sem");
        this.addMapping("application/vnd.document+json", "docjson");
        this.addMapping("application/route-apd+xml", "rapd");
        this.addMapping("application/vnd.ims.imsccv1p1", "imscc");
        this.addMapping("application/metalink+xml", "metalink");
        this.addMapping("application/vnd.oasis.opendocument.database", "odb");
        this.addMapping("application/vnd.wqd", "wqd");
        this.addMapping("model/gltf+json", "gltf");
        this.addMapping("application/vnd.mapbox-vector-tile", "mvt");
        this.addMapping("application/scim+json", "scim");
        this.addMapping("application/vnd.Mobius.MQY", "mqy");
        this.addMapping("application/vnd.cinderella", "cdy");
        this.addMapping("application/postscript", "ps");
        this.addMapping("application/postscript", "eps");
        this.addMapping("application/postscript", "ai");
        this.addMapping("text/prs.fallenstein.rst", "rst");
        this.addMapping("application/vnd.kde.karbon", "karbon");
        this.addMapping("application/vnd.ms-ims", "ims");
        this.addMapping("application/timestamp-reply", "tsr");
        this.addMapping("application/vnd.ipunplugged.rcprofile", "rcprofile");
        this.addMapping("application/jrd+json", "jrd");
        this.addMapping("audio/EVRCNW", "enw");
        this.addMapping("application/vnd.yamaha.openscoreformat", "osf");
        this.addMapping("application/shf+xml", "shf");
        this.addMapping("application/vnd.smart.teacher", "teacher");
        this.addMapping("application/vnd.fujitsu.oasysprs", "bh2");
        this.addMapping("application/vnd.spotfire.sfs", "sfs");
        this.addMapping("audio/AMR-WB", "awb");
        this.addMapping("video/vnd.dvb.file", "dvb");
        this.addMapping("application/vnd.nintendo.snes.rom", "sfc");
        this.addMapping("application/vnd.nintendo.snes.rom", "smc");
        this.addMapping("application/vnd.openxmlformats-officedocument.presentationml.template", "potx");
        this.addMapping("video/vnd.sealed.mpeg4", "s14");
        this.addMapping("application/CEA", "cea");
        this.addMapping("application/tei+xml", "tei");
        this.addMapping("application/tei+xml", "teiCorpus");
        this.addMapping("application/tei+xml", "odd");
        this.addMapping("video/vnd.sealed.mpeg1", "smpg");
        this.addMapping("video/vnd.sealed.mpeg1", "s11");
        this.addMapping("video/vnd.sealedmedia.softseal.mov", "smov");
        this.addMapping("video/vnd.sealedmedia.softseal.mov", "smo");
        this.addMapping("video/vnd.sealedmedia.softseal.mov", "s1q");
        this.addMapping("application/x-gtar", "gtar");
        this.addMapping("video/vnd.dece.sd", "uvs");
        this.addMapping("video/vnd.dece.sd", "uvvs");
        this.addMapping("application/prs.hpub+zip", "hpub");
        this.addMapping("application/vnd.nokia.n-gage.data", "ngdat");
        this.addMapping("image/ief", "ief");
        this.addMapping("application/ld+json", "jsonld");
        this.addMapping("application/relax-ng-compact-syntax", "rnc");
        this.addMapping("application/vnd.ibm.modcap", "list3820");
        this.addMapping("application/vnd.ibm.modcap", "listafp");
        this.addMapping("application/vnd.ibm.modcap", "afp");
        this.addMapping("application/vnd.ibm.modcap", "pseg3820");
        this.addMapping("application/vnd.kde.kchart", "chrt");
        this.addMapping("application/vnd.yellowriver-custom-menu", "cmp");
        this.addMapping("application/vnd.openxmlformats-officedocument.wordprocessingml.document", "docx");
        this.addMapping("video/vnd.dece.pd", "uvp");
        this.addMapping("video/vnd.dece.pd", "uvvp");
        this.addMapping("application/x-cdlink", "vcd");
        this.addMapping("application/csrattrs", "csrattrs");
        this.addMapping("application/vnd.crick.clicker.keyboard", "clkk");
        this.addMapping("text/vnd.fmi.flexstor", "flx");
        this.addMapping("application/n-triples", "nt");
        this.addMapping("audio/asc", "acn");
        this.addMapping("application/smil+xml", "smil");
        this.addMapping("application/smil+xml", "smi");
        this.addMapping("application/smil+xml", "sml");
        this.addMapping("application/vnd.epson.ssf", "ssf");
        this.addMapping("text/vnd.in3d.3dml", "3dml");
        this.addMapping("text/vnd.in3d.3dml", "3dm");
        this.addMapping("application/x-annodex", "anx");
        this.addMapping("application/vnd.cosmocaller", "cmc");
        this.addMapping("application/vnd.pocketlearn", "plf");
        this.addMapping("text/markdown", "markdown");
        this.addMapping("text/markdown", "md");
        this.addMapping("application/vnd.dvb.service", "svc");
        this.addMapping("application/dash+xml", "mpd");
        this.addMapping("application/calendar+xml", "xcs");
        this.addMapping("application/vnd.frogans.fnc", "fnc");
        this.addMapping("model/vnd.moml+xml", "moml");
        this.addMapping("application/vnd.wap.wmlscriptc", "wmlsc");
        this.addMapping("application/vnd.wmc", "wmc");
        this.addMapping("application/vnd.recordare.musicxml", "mxl");
        this.addMapping("model/iges", "igs");
        this.addMapping("model/iges", "iges");
        this.addMapping("text/richtext", "rtx");
        this.addMapping("image/x-targa", "tga");
        this.addMapping("application/xcap-att+xml", "xav");
        this.addMapping("application/vnd.igloader", "igl");
        this.addMapping("application/vnd.cups-ppd", "ppd");
        this.addMapping("application/x-shar", "shar");
        this.addMapping("application/tamp-update", "tur");
        this.addMapping("application/vnd.publishare-delta-tree", "qps");
        this.addMapping("application/vnd.qualcomm.brew-app-res", "bar");
        this.addMapping("application/vnd.crick.clicker.palette", "clkp");
        this.addMapping("application/gzip", "gz");
        this.addMapping("application/gzip", "tgz");
        this.addMapping("application/vnd.sun.xml.impress", "sxi");
        this.addMapping("application/vnd.yamaha.hv-voice", "hvp");
        this.addMapping("application/vnd.sealedmedia.softseal.pdf", "spdf");
        this.addMapping("application/vnd.sealedmedia.softseal.pdf", "spd");
        this.addMapping("application/vnd.sealedmedia.softseal.pdf", "s1a");
        this.addMapping("application/vnd.groove-tool-template", "tpl");
        this.addMapping("text/vnd.net2phone.commcenter.command", "ccc");
        this.addMapping("chemical/x-xyz", "xyz");
        this.addMapping("application/vnd.uri-map", "urim");
        this.addMapping("application/vnd.uri-map", "urimap");
        this.addMapping("application/vnd.Quark.QuarkXPress", "qxd");
        this.addMapping("application/vnd.Quark.QuarkXPress", "qxt");
        this.addMapping("application/vnd.Quark.QuarkXPress", "qwd");
        this.addMapping("application/vnd.Quark.QuarkXPress", "qwt");
        this.addMapping("application/vnd.Quark.QuarkXPress", "qxl");
        this.addMapping("application/vnd.Quark.QuarkXPress", "qxb");
        this.addMapping("application/vnd.imagemeter.image+zip", "imi");
        this.addMapping("application/vnd.ms-excel.template.macroEnabled.12", "xltm");
        this.addMapping("text/provenance-notation", "provn");
        this.addMapping("application/sgml-open-catalog", "soc");
        this.addMapping("application/vnd.onepager", "tam");
        this.addMapping("application/vnd.openxmlformats-officedocument.presentationml.slideshow", "ppsx");
        this.addMapping("application/vnd.geogebra.file", "ggb");
        this.addMapping("application/voicexml+xml", "vxml");
        this.addMapping("video/x-javafx", "fxm");
        this.addMapping("application/vnd.xara", "xar");
        this.addMapping("audio/midi", "mid");
        this.addMapping("audio/midi", "midi");
        this.addMapping("audio/midi", "kar");
        this.addMapping("application/vnd.hal+xml", "hal");
        this.addMapping("application/vnd.wfa.p2p", "p2p");
        this.addMapping("application/x-perl", "pl");
        this.addMapping("application/vnd.ibm.electronic-media", "emm");
        this.addMapping("application/vnd.tao.intent-module-archive", "tao");
        this.addMapping("application/vnd.pawaafile", "paw");
        this.addMapping("application/wsdl+xml", "wsdl");
        this.addMapping("image/x-rgb", "rgb");
        this.addMapping("application/vnd.epson.msf", "msf");
        this.addMapping("application/vnd.oasis.opendocument.spreadsheet-template", "ots");
        this.addMapping("application/trig", "trig");
        this.addMapping("application/vnd.3lightssoftware.imagescal", "imgcal");
        this.addMapping("application/x-futuresplash", "spl");
        this.addMapping("text/jcr-cnd", "cnd");
        this.addMapping("application/mets+xml", "mets");
        this.addMapping("video/vnd.mpegurl", "mxu");
        this.addMapping("video/vnd.mpegurl", "m4u");
        this.addMapping("application/vnd.FloGraphIt", "gph");
        this.addMapping("application/x-netcdf", "nc");
        this.addMapping("application/x-netcdf", "cdf");
        this.addMapping("text/vcard", "vcf");
        this.addMapping("text/vcard", "vcard");
        this.addMapping("application/vnd.HandHeld-Entertainment+xml", "zmm");
        this.addMapping("application/vnd.intercon.formnet", "xpw");
        this.addMapping("application/vnd.intercon.formnet", "xpx");
        this.addMapping("video/x-matroska-3d", "mk3d");
        this.addMapping("application/vnd.kde.kspread", "ksp");
        this.addMapping("application/prs.cww", "cw");
        this.addMapping("application/prs.cww", "cww");
        this.addMapping("application/vnd.balsamiq.bmpr", "bmpr");
        this.addMapping("application/xop+xml", "xop");
        this.addMapping("image/x-xpixmap", "xpm");
        this.addMapping("application/geo+json", "geojson");
        this.addMapping("application/vnd.lotus-approach", "apr");
        this.addMapping("application/vnd.lotus-approach", "vew");
        this.addMapping("video/quicktime", "mov");
        this.addMapping("video/quicktime", "qt");
        this.addMapping("video/mp4", "mp4");
        this.addMapping("video/mp4", "mpg4");
        this.addMapping("video/mp4", "m4v");
        this.addMapping("application/x-sh", "sh");
        this.addMapping("video/webm", "webm");
        this.addMapping("image/vnd.djvu", "djvu");
        this.addMapping("image/vnd.djvu", "djv");
        this.addMapping("application/vnd.nokia.radio-presets", "rpss");
        this.addMapping("video/x-ms-wm", "wm");
        this.addMapping("audio/vnd.nortel.vbk", "vbk");
        this.addMapping("application/mads+xml", "mads");
        this.addMapping("image/vnd.valve.source.texture", "vtf");
        this.addMapping("application/vnd.font-fontforge-sfd", "sfd");
        this.addMapping("application/vnd.etsi.asic-s+zip", "asics");
        this.addMapping("application/p2p-overlay+xml", "relo");
        this.addMapping("application/vnd.fujixerox.docuworks", "xdw");
        this.addMapping("application/vnd.mophun.certificate", "mpc");
        this.addMapping("application/vnd.yamaha.hv-script", "hvs");
        this.addMapping("application/vnd.hhe.lesson-player", "les");
        this.addMapping("video/3gpp", "3gp");
        this.addMapping("video/3gpp", "3gpp");
        this.addMapping("x-epoc/x-sisx-app", "sisx");
        this.addMapping("application/vnd.claymore", "cla");
        this.addMapping("application/vnd.acucorp", "atc");
        this.addMapping("application/vnd.acucorp", "acutc");
        this.addMapping("application/vnd.denovo.fcselayout-link", "fe_launch");
        this.addMapping("application/vnd.chess-pgn", "pgn");
        this.addMapping("application/vnd.nervana", "entity");
        this.addMapping("application/vnd.nervana", "request");
        this.addMapping("application/vnd.nervana", "bkm");
        this.addMapping("application/vnd.nervana", "kcm");
        this.addMapping("application/zip", "zip");
        this.addMapping("application/rpki-roa", "roa");
        this.addMapping("application/xslt+xml", "xsl");
        this.addMapping("application/xslt+xml", "xslt");
        this.addMapping("application/vnd.groove-vcard", "vcg");
        this.addMapping("application/dvcs", "dvc");
        this.addMapping("image/vnd.adobe.photoshop", "psd");
        this.addMapping("application/vnd.audiograph", "aep");
        this.addMapping("application/vnd.Mobius.MSL", "msl");
        this.addMapping("video/vnd.dece.hd", "uvh");
        this.addMapping("video/vnd.dece.hd", "uvvh");
        this.addMapping("model/vnd.vtu", "vtu");
        this.addMapping("image/vnd.zbrush.pcx", "pcx");
        this.addMapping("application/vnd.oma.drm.rights+xml", "dr");
        this.addMapping("application/vnd.hydrostatix.sof-data", "sfd-hdstx");
        this.addMapping("application/vnd.ms-officetheme", "thmx");
        this.addMapping("application/vnd.google-earth.kmz", "kmz");
        this.addMapping("application/vnd.ericsson.quickcall", "qcall");
        this.addMapping("application/vnd.ericsson.quickcall", "qca");
        this.addMapping("application/vnd.marlin.drm.mdcf", "mdc");
        this.addMapping("application/tamp-apex-update-confirm", "auc");
        this.addMapping("application/vnd.syncml.dm+xml", "xdm");
        this.addMapping("application/vnd.vcx", "vcx");
        this.addMapping("application/gml+xml", "gml");
        this.addMapping("application/ATF", "atf");
        this.addMapping("text/vnd.fly", "fly");
        this.addMapping("application/vnd.curl", "curl");
        this.addMapping("audio/EVRC", "evc");
        this.addMapping("audio/SMV", "smv");
        this.addMapping("application/owl+xml", "owx");
        this.addMapping("application/vnd.ibm.MiniPay", "mpy");
        this.addMapping("application/x-java-pack200", "pack");
        this.addMapping("video/x-ms-wvx", "wvx");
        this.addMapping("application/vnd.proteus.magazine", "mgz");
        this.addMapping("application/inkml+xml", "ink");
        this.addMapping("application/inkml+xml", "inkml");
        this.addMapping("application/x-xz", "xz");
        this.addMapping("model/vnd.gtw", "gtw");
        this.addMapping("application/vnd.ms-powerpoint.slide.macroEnabled.12", "sldm");
        this.addMapping("application/vnd.cluetrust.cartomobile-config-pkg", "c11amz");
        this.addMapping("video/vnd.radgamettools.bink", "bik");
        this.addMapping("video/vnd.radgamettools.bink", "bk2");
        this.addMapping("application/vnd.3gpp.pic-bw-large", "plb");
        this.addMapping("application/x-director", "dcr");
        this.addMapping("application/x-director", "dir");
        this.addMapping("application/x-director", "dxr");
        this.addMapping("application/vnd.groove-injector", "grv");
        this.addMapping("application/vnd.ms-excel.addin.macroEnabled.12", "xlam");
        this.addMapping("font/otf", "otf");
        this.addMapping("text/vnd.trolltech.linguist", "ts");
        this.addMapping("video/vnd.radgamettools.smacker", "smk");
        this.addMapping("application/dashdelta", "mpdd");
        this.addMapping("audio/vnd.dolby.mlp", "mlp");
        this.addMapping("application/vnd.nintendo.nitro.rom", "nds");
        this.addMapping("application/vnd.maxmind.maxmind-db", "mmdb");
        this.addMapping("application/pkix-crl", "crl");
        this.addMapping("image/x-xwindowdump", "xwd");
        this.addMapping("image/vnd.ms-modi", "mdi");
        this.addMapping("application/x-cpio", "cpio");
        this.addMapping("application/vnd.espass-espass+zip", "espass");
        this.addMapping("video/x-sgi-movie", "movie");
        this.addMapping("image/prs.pti", "pti");
        this.addMapping("video/vnd.sealed.swf", "sswf");
        this.addMapping("video/vnd.sealed.swf", "ssw");
        this.addMapping("application/vnd.sailingtracker.track", "st");
        this.addMapping("application/vnd.criticaltools.wbs+xml", "wbs");
        this.addMapping("application/vnd.evolv.ecig.theme", "ecigtheme");
        this.addMapping("application/vnd.oasis.opendocument.presentation-template", "otp");
        this.addMapping("application/thraud+xml", "tfi");
        this.addMapping("application/vnd.sealed.xls", "sxls");
        this.addMapping("application/vnd.sealed.xls", "sxl");
        this.addMapping("application/vnd.sealed.xls", "s1e");
        this.addMapping("application/pkixcmp", "pki");
        this.addMapping("image/x-portable-graymap", "pgm");
        this.addMapping("application/vnd.ibm.secure-container", "sc");
        this.addMapping("application/vnd.ms-excel.sheet.macroEnabled.12", "xlsm");
        this.addMapping("text/vnd.debian.copyright", "copyright");
        this.addMapping("application/vnd.wap.sic", "sic");
        this.addMapping("application/vnd.jisp", "jisp");
        this.addMapping("application/xv+xml", "mxml");
        this.addMapping("application/xv+xml", "xhvml");
        this.addMapping("application/xv+xml", "xvml");
        this.addMapping("application/xv+xml", "xvm");
        this.addMapping("application/vnd.previewsystems.box", "box");
        this.addMapping("application/vnd.previewsystems.box", "vbox");
        this.addMapping("application/x-ustar", "ustar");
        this.addMapping("application/sql", "sql");
        this.addMapping("application/vnd.intergeo", "i2g");
        this.addMapping("application/wspolicy+xml", "wspolicy");
        this.addMapping("application/vnd.msa-disk-image", "msa");
        this.addMapping("application/vnd.realvnc.bed", "bed");
        this.addMapping("application/vnd.ms-project", "mpp");
        this.addMapping("application/vnd.ms-project", "mpt");
        this.addMapping("application/prs.nprend", "rnd");
        this.addMapping("application/prs.nprend", "rct");
        this.addMapping("application/vnd.adobe.xfdf", "xfdf");
        this.addMapping("application/CDFX+XML", "cdfx");
        this.addMapping("application/vnd.fujitsu.oasys2", "oa2");
        this.addMapping("application/vnd.oasis.opendocument.text-template", "ott");
        this.addMapping("audio/x-matroska", "mka");
        this.addMapping("application/vnd.fujitsu.oasys3", "oa3");
        this.addMapping("text/vnd.ms-mediapackage", "mpf");
        this.addMapping("application/x-hdf", "hdf");
        this.addMapping("application/x-texinfo", "texinfo");
        this.addMapping("application/x-texinfo", "texi");
        this.addMapping("application/pls+xml", "pls");
        this.addMapping("application/route-usd+xml", "rusd");
        this.addMapping("application/json-patch+json", "json-patch");
        this.addMapping("image/bmp", "bmp");
        this.addMapping("image/bmp", "dib");
        this.addMapping("application/sieve", "siv");
        this.addMapping("application/sieve", "sieve");
        this.addMapping("application/yang", "yang");
        this.addMapping("application/mods+xml", "mods");
        this.addMapping("audio/mobile-xmf", "mxmf");
        this.addMapping("application/scvp-vp-request", "spq");
        this.addMapping("application/vnd.3M.Post-it-Notes", "pwn");
        this.addMapping("application/timestamp-query", "tsq");
        this.addMapping("image/x-cmu-raster", "ras");
        this.addMapping("text/dns", "soa");
        this.addMapping("text/dns", "zone");
        this.addMapping("application/vnd.ms-word.document.macroEnabled.12", "docm");
        this.addMapping("application/vnd.ms-powerpoint.slideshow.macroEnabled.12", "ppsm");
        this.addMapping("application/cdmi-queue", "cdmiq");
        this.addMapping("audio/qcelp", "qcp");
        this.addMapping("video/iso.segment", "m4s");
        this.addMapping("application/vnd.xfdl", "xfdl");
        this.addMapping("application/vnd.xfdl", "xfd");
        this.addMapping("application/vnd.yaoweme", "yme");
        this.addMapping("application/vnd.nokia.n-gage.symbian.install", "n-gage");
        this.addMapping("application/vnd.groove-account", "gac");
        this.addMapping("application/vnd.ms-powerpoint", "ppt");
        this.addMapping("application/vnd.ms-powerpoint", "pps");
        this.addMapping("application/vnd.ms-powerpoint", "pot");
        this.addMapping("image/vnd.sealedmedia.softseal.gif", "sgif");
        this.addMapping("image/vnd.sealedmedia.softseal.gif", "sgi");
        this.addMapping("image/vnd.sealedmedia.softseal.gif", "s1g");
        this.addMapping("application/vnd.dzr", "dzr");
        this.addMapping("image/vnd.globalgraphics.pgb", "pgb");
        this.addMapping("image/tiff", "tiff");
        this.addMapping("image/tiff", "tif");
        this.addMapping("application/x-stuffit", "sit");
        this.addMapping("application/vnd.MFER", "mwf");
        this.addMapping("application/vnd.wap.wbxml", "wbxml");
        this.addMapping("application/vnd.dece.unspecified", "uvx");
        this.addMapping("application/vnd.dece.unspecified", "uvvx");
        this.addMapping("application/vnd.vectorworks", "vwx");
        this.addMapping("audio/vnd.dts.hd", "dtshd");
        this.addMapping("application/vnd.wt.stf", "stf");
        this.addMapping("application/vnd.etsi.asic-e+zip", "asice");
        this.addMapping("application/vnd.etsi.asic-e+zip", "sce");
        this.addMapping("application/vnd.SimTech-MindMapper", "twd");
        this.addMapping("application/vnd.SimTech-MindMapper", "twds");
        this.addMapping("application/widget", "wgt");
        this.addMapping("video/x-matroska", "mkv");
        this.addMapping("application/vnd.ezpix-album", "ez2");
        this.addMapping("application/vnd.sun.xml.calc", "sxc");
        this.addMapping("application/vnd.oma.dd2+xml", "dd2");
        this.addMapping("application/vnd.ms-tnef", "tnef");
        this.addMapping("application/vnd.ms-tnef", "tnf");
        this.addMapping("application/vnd.astraea-software.iota", "iota");
        this.addMapping("application/vnd.oasis.opendocument.text-web", "oth");
        this.addMapping("application/vnd.hp-hpid", "hpi");
        this.addMapping("application/vnd.hp-hpid", "hpid");
        this.addMapping("text/x-setext", "etx");
        this.addMapping("application/fdt+xml", "fdt");
        this.addMapping("application/vnd.airzip.filesecure.azs", "azs");
        this.addMapping("application/metalink4+xml", "meta4");
        this.addMapping("application/x-java-jnlp-file", "jnlp");
        this.addMapping("application/vnd.las.las+xml", "lasxml");
        this.addMapping("audio/vnd.dece.audio", "uva");
        this.addMapping("audio/vnd.dece.audio", "uvva");
        this.addMapping("text/vnd.dvb.subtitle", "sub");
        this.addMapping("application/vnd.isac.fcs", "fcs");
        this.addMapping("audio/x-mod", "mod");
        this.addMapping("audio/x-mod", "ult");
        this.addMapping("audio/x-mod", "uni");
        this.addMapping("audio/x-mod", "m15");
        this.addMapping("audio/x-mod", "mtm");
        this.addMapping("audio/x-mod", "669");
        this.addMapping("audio/x-mod", "med");
        this.addMapping("text/vnd.sun.j2me.app-descriptor", "jad");
        this.addMapping("application/vnd.stepmania.stepchart", "sm");
        this.addMapping("application/vnd.uoml+xml", "uoml");
        this.addMapping("application/vnd.uoml+xml", "uo");
        this.addMapping("application/vnd.airzip.filesecure.azf", "azf");
        this.addMapping("application/vnd.oasis.opendocument.presentation", "odp");
        this.addMapping("application/vnd.irepository.package+xml", "irp");
        this.addMapping("application/vnd.mif", "mif");
        this.addMapping("application/vnd.sealedmedia.softseal.html", "stml");
        this.addMapping("application/vnd.sealedmedia.softseal.html", "s1h");
        this.addMapping("audio/ac3", "ac3");
        this.addMapping("application/vnd.debian.binary-package", "deb");
        this.addMapping("application/vnd.debian.binary-package", "udeb");
        this.addMapping("application/vnd.doremir.scorecloud-binary-document", "scld");
        this.addMapping("video/mj2", "mj2");
        this.addMapping("video/mj2", "mjp2");
        this.addMapping("application/ogg", "ogx");
        this.addMapping("application/vnd.dart", "dart");
        this.addMapping("application/vnd.amiga.ami", "ami");
        this.addMapping("text/turtle", "ttl");
        this.addMapping("application/ATXML", "atxml");
        this.addMapping("text/vnd.ascii-art", "ascii");
        this.addMapping("video/vnd.fvt", "fvt");
        this.addMapping("application/vnd.hp-HPGL", "hpgl");
        this.addMapping("application/vnd.ibm.rights-management", "irm");
        this.addMapping("audio/vnd.digital-winds", "eol");
        this.addMapping("application/vnd.hzn-3d-crossword", "x3d");
        this.addMapping("video/vnd.dece.video", "uvv");
        this.addMapping("video/vnd.dece.video", "uvvv");
        this.addMapping("application/vnd.oma.drm.rights+wbxml", "drc");
        this.addMapping("application/vnd.fujitsu.oasysgp", "fg5");
        this.addMapping("application/vnd.anser-web-funds-transfer-initiation", "fti");
        this.addMapping("application/vnd.solent.sdkm+xml", "sdkm");
        this.addMapping("application/vnd.solent.sdkm+xml", "sdkd");
        this.addMapping("image/prs.btif", "btif");
        this.addMapping("image/prs.btif", "btf");
        this.addMapping("application/vnd.oasis.opendocument.image", "odi");
        this.addMapping("application/x-bzip2", "bz2");
        this.addMapping("application/atomcat+xml", "atomcat");
        this.addMapping("application/vnd.micrografx.flo", "flo");
        this.addMapping("application/vnd.wap.slc", "slc");
        this.addMapping("application/vnd.android.package-archive", "apk");
        this.addMapping("application/AML", "aml");
        this.addMapping("application/vnd.sema", "sema");
        this.addMapping("application/vnd.grafeq", "gqf");
        this.addMapping("application/vnd.grafeq", "gqs");
        this.addMapping("application/x-xpinstall", "xpi");
        this.addMapping("application/vnd.semd", "semd");
        this.addMapping("application/vnd.semf", "semf");
        this.addMapping("application/vnd.shana.informed.interchange", "iif");
        this.addMapping("audio/vnd.nuera.ecelp4800", "ecelp4800");
        this.addMapping("application/vnd.Kinar", "kne");
        this.addMapping("application/vnd.Kinar", "knp");
        this.addMapping("application/vnd.Kinar", "sdf");
        this.addMapping("application/vnd.openblox.game-binary", "obg");
        this.addMapping("image/vnd.dxf", "dxf");
        this.addMapping("message/rfc822", "eml");
        this.addMapping("message/rfc822", "mail");
        this.addMapping("message/rfc822", "art");
        this.addMapping("application/vnd.visio", "vsd");
        this.addMapping("application/vnd.visio", "vst");
        this.addMapping("application/vnd.visio", "vsw");
        this.addMapping("application/vnd.visio", "vss");
        this.addMapping("application/x-csh", "csh");
        this.addMapping("application/x-chrome-extension", "crx");
        this.addMapping("image/wmf", "wmf");
        this.addMapping("application/vnd.insors.igm", "igm");
        this.addMapping("application/vnd.jcp.javame.midlet-rms", "rms");
        this.addMapping("application/cdmi-capability", "cdmia");
        this.addMapping("application/vnd.epson.esf", "esf");
        this.addMapping("application/vnd.fuzzysheet", "fzs");
        this.addMapping("application/hyperstudio", "stk");
        this.addMapping("application/vnd.americandynamics.acc", "acc");
        this.addMapping("application/vnd.openxmlformats-officedocument.presentationml.slide", "sldx");
        this.addMapping("application/vnd.etsi.timestamp-token", "tst");
        this.addMapping("application/vnd.dece.zip", "uvz");
        this.addMapping("application/vnd.dece.zip", "uvvz");
        this.addMapping("application/vnd.mseq", "mseq");
        this.addMapping("audio/mp4", "m4a");
        this.addMapping("application/pdf", "pdf");
        this.addMapping("application/pgp-encrypted", "pgp");
        this.addMapping("application/vnd.wap.wmlc", "wmlc");
        this.addMapping("application/x-bittorrent", "torrent");
        this.addMapping("application/sparql-results+xml", "srx");
        this.addMapping("multipart/voice-message", "vpm");
        this.addMapping("application/vnd.commerce-battelle", "ica");
        this.addMapping("application/vnd.commerce-battelle", "icf");
        this.addMapping("application/vnd.commerce-battelle", "icd");
        this.addMapping("application/vnd.commerce-battelle", "ic0");
        this.addMapping("application/vnd.commerce-battelle", "ic1");
        this.addMapping("application/vnd.commerce-battelle", "ic2");
        this.addMapping("application/vnd.commerce-battelle", "ic3");
        this.addMapping("application/vnd.commerce-battelle", "ic4");
        this.addMapping("application/vnd.commerce-battelle", "ic5");
        this.addMapping("application/vnd.commerce-battelle", "ic6");
        this.addMapping("application/vnd.commerce-battelle", "ic7");
        this.addMapping("application/vnd.commerce-battelle", "ic8");
        this.addMapping("application/mathml+xml", "mml");
        this.addMapping("application/vnd.kde.kword", "kwd");
        this.addMapping("application/vnd.kde.kword", "kwt");
        this.addMapping("application/vnd.ms-wpl", "wpl");
        this.addMapping("application/dssc+xml", "xdssc");
        this.addMapping("application/vnd.openstreetmap.data+xml", "osm");
        this.addMapping("application/vnd.xmpie.ppkg", "ppkg");
        this.addMapping("application/x-rpm", "rpm");
        this.addMapping("application/vnd.dece.data", "uvf");
        this.addMapping("application/vnd.dece.data", "uvvf");
        this.addMapping("application/vnd.dece.data", "uvd");
        this.addMapping("application/vnd.dece.data", "uvvd");
        this.addMapping("image/vnd.microsoft.icon", "ico");
        this.addMapping("application/vnd.sun.xml.writer.template", "stw");
        this.addMapping("application/vnd.wordperfect", "wpd");
        this.addMapping("application/vnd.umajin", "umj");
        this.addMapping("application/vnd.oma.drm.content", "dcf");
        this.addMapping("application/vnd.ms-powerpoint.presentation.macroEnabled.12", "pptm");
        this.addMapping("application/vnd.fujixerox.docuworks.container", "xct");
        this.addMapping("model/vrml", "wrl");
        this.addMapping("model/vrml", "vrml");
        this.addMapping("application/vnd.Mobius.TXF", "txf");
        this.addMapping("application/vnd.yamaha.smaf-phrase", "spf");
        this.addMapping("application/javascript", "js");
        this.addMapping("application/dskpp+xml", "xmls");
        this.addMapping("application/vnd.intu.qbo", "qbo");
        this.addMapping("application/ssml+xml", "ssml");
        this.addMapping("application/urc-ressheet+xml", "rsheet");
        this.addMapping("application/resource-lists-diff+xml", "rld");
        this.addMapping("application/vnd.ms-powerpoint.addin.macroEnabled.12", "ppam");
        this.addMapping("application/vnd.groove-tool-message", "gtm");
        this.addMapping("image/vnd.dwg", "dwg");
        this.addMapping("application/vnd.sun.xml.writer.global", "sxg");
        this.addMapping("application/vnd.iccprofile", "icc");
        this.addMapping("application/vnd.iccprofile", "icm");
        this.addMapping("application/oxps", "oxps");
        this.addMapping("application/vnd.mfmp", "mfm");
        this.addMapping("application/ODX", "odx");
        this.addMapping("application/vnd.oasis.opendocument.chart-template", "otc");
        this.addMapping("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "xlsx");
        this.addMapping("text/csv-schema", "csvs");
        this.addMapping("application/vnd.shana.informed.package", "ipk");
        this.addMapping("application/cdmi-object", "cdmio");
        this.addMapping("application/vnd.valve.source.material", "vmt");
        this.addMapping("application/vnd.cloanto.rp9", "rp9");
        this.addMapping("application/vnd.osgeo.mapguide.package", "mgp");
        this.addMapping("application/route-s-tsid+xml", "sls");
        this.addMapping("application/andrew-inset", "ez");
        this.addMapping("application/vnd.autopackage", "package");
        this.addMapping("video/ogg", "ogv");
        this.addMapping("application/atomsvc+xml", "atomsvc");
        this.addMapping("application/msword", "doc");
        this.addMapping("image/jpm", "jpm");
        this.addMapping("image/jpm", "jpgm");
        this.addMapping("application/vnd.ms-3mfdocument", "3mf");
        this.addMapping("application/DIT", "dit");
        this.addMapping("application/emotionml+xml", "emotionml");
        this.addMapping("image/jpx", "jpx");
        this.addMapping("image/jpx", "jpf");
        this.addMapping("text/vnd.graphviz", "gv");
        this.addMapping("text/vnd.graphviz", "dot");
        this.addMapping("application/vnd.dece.ttml+xml", "uvt");
        this.addMapping("application/vnd.dece.ttml+xml", "uvvt");
        this.addMapping("text/vnd.in3d.spot", "spot");
        this.addMapping("text/vnd.in3d.spot", "spo");
        this.addMapping("application/vnd.ezpix-package", "ez3");
        this.addMapping("application/DII", "dii");
        this.addMapping("application/vnd.route66.link66+xml", "link66");
        this.addMapping("application/vnd.sealed.mht", "smht");
        this.addMapping("application/vnd.sealed.mht", "smh");
        this.addMapping("application/vnd.vsf", "vsf");
        this.addMapping("application/cbor", "cbor");
        this.addMapping("application/vnd.openblox.game+xml", "obgx");
        this.addMapping("image/vnd.wap.wbmp", "wbmp");
        this.addMapping("application/vnd.ctc-posml", "pml");
        this.addMapping("application/pkcs7-mime", "p7m");
        this.addMapping("application/pkcs7-mime", "p7c");
        this.addMapping("application/cdmi-container", "cdmic");
        this.addMapping("application/vnd.powerbuilder6", "pbd");
        this.addMapping("application/vnd.intu.qfx", "qfx");
        this.addMapping("message/global-disposition-notification", "u8mdn");
        this.addMapping("application/rpki-manifest", "mft");
        this.addMapping("application/fastinfoset", "finf");
        this.addMapping("text/n3", "n3");
        this.addMapping("audio/x-pn-realaudio", "ram");
        this.addMapping("audio/x-pn-realaudio", "rm");
        this.addMapping("application/vnd.koan", "skp");
        this.addMapping("application/vnd.koan", "skd");
        this.addMapping("application/vnd.koan", "skm");
        this.addMapping("application/vnd.koan", "skt");
        this.addMapping("text/plain", "txt");
        this.addMapping("text/plain", "asc");
        this.addMapping("text/plain", "text");
        this.addMapping("text/plain", "pm");
        this.addMapping("text/plain", "el");
        this.addMapping("text/plain", "c");
        this.addMapping("text/plain", "h");
        this.addMapping("text/plain", "cc");
        this.addMapping("text/plain", "hh");
        this.addMapping("text/plain", "cxx");
        this.addMapping("text/plain", "hxx");
        this.addMapping("text/plain", "f90");
        this.addMapping("text/plain", "conf");
        this.addMapping("text/plain", "log");
        this.addMapping("application/ipfix", "ipfix");
        this.addMapping("application/vnd.ecowin.chart", "mag");
        this.addMapping("application/vnd.groove-identity-message", "gim");
        this.addMapping("application/vnd.tml", "vfr");
        this.addMapping("application/vnd.tml", "viaframe");
        this.addMapping("application/vnd.Mobius.PLC", "plc");
        this.addMapping("application/vnd.yamaha.hv-dic", "hvd");
        this.addMapping("application/vnd.hp-PCL", "pcl");
        this.addMapping("text/vnd.wap.wmlscript", "wmls");
        this.addMapping("application/vnd.sun.xml.impress.template", "sti");
        this.addMapping("application/vnd.oasis.opendocument.formula", "odf");
        this.addMapping("video/vnd.ms-playready.media.pyv", "pyv");
        this.addMapping("application/pgp-signature", "sig");
        this.addMapping("application/vnd.mozilla.xul+xml", "xul");
        this.addMapping("application/vnd.onepagertat", "tat");
        this.addMapping("application/vnd.webturbo", "wtb");
        this.addMapping("image/vnd.fst", "fst");
        this.addMapping("application/vnd.sun.xml.draw.template", "std");
        this.addMapping("application/vnd.filmit.zfc", "zfc");
        this.addMapping("application/vnd.vd-study", "mxi");
        this.addMapping("application/vnd.vd-study", "study-inter");
        this.addMapping("application/vnd.vd-study", "model-inter");
        this.addMapping("application/lost+xml", "lostxml");
        this.addMapping("application/vnd.shana.informed.formtemplate", "itp");
        this.addMapping("application/xcap-ns+xml", "xns");
        this.addMapping("image/x-portable-bitmap", "pbm");
        this.addMapping("application/vnd.lotus-organizer", "or3");
        this.addMapping("application/vnd.lotus-organizer", "or2");
        this.addMapping("application/vnd.lotus-organizer", "org");
        this.addMapping("audio/vnd.nuera.ecelp7470", "ecelp7470");
        this.addMapping("application/urc-targetdesc+xml", "td");
        this.addMapping("application/vnd.geogebra.tool", "ggt");
        this.addMapping("image/vnd.mozilla.apng", "apng");
        this.addMapping("text/prs.lines.tag", "tag");
        this.addMapping("text/prs.lines.tag", "dsc");
        this.addMapping("text/mizar", "miz");
        this.addMapping("font/woff2", "woff2");
        this.addMapping("application/json", "json");
        this.addMapping("audio/vnd.lucent.voice", "lvp");
        this.addMapping("application/x-troff-man", "man");
        this.addMapping("application/x-troff-man", "1");
        this.addMapping("application/x-troff-man", "2");
        this.addMapping("application/x-troff-man", "3");
        this.addMapping("application/x-troff-man", "4");
        this.addMapping("application/x-troff-man", "5");
        this.addMapping("application/x-troff-man", "6");
        this.addMapping("application/x-troff-man", "7");
        this.addMapping("application/x-troff-man", "8");
        this.addMapping("image/jls", "jls");
        this.addMapping("application/vnd.fdsn.mseed", "msd");
        this.addMapping("application/vnd.fdsn.mseed", "mseed");
        this.addMapping("application/vnd.fdsn.seed", "seed");
        this.addMapping("application/vnd.fdsn.seed", "dataless");
        this.addMapping("application/vnd.ms-lrm", "lrm");
        this.addMapping("application/auth-policy+xml", "apxml");
        this.addMapping("audio/vnd.presonus.multitrack", "multitrack");
        this.addMapping("application/efi", "efi");
        this.addMapping("application/vnd.kodak-descriptor", "sse");
        this.addMapping("audio/ATRAC-ADVANCED-LOSSLESS", "aal");
        this.addMapping("text/calendar", "ics");
        this.addMapping("text/calendar", "ifb");
        this.addMapping("application/vnd.macports.portpkg", "portpkg");
        this.addMapping("application/x-xspf+xml", "xspf");
        this.addMapping("application/tamp-sequence-adjust", "tsa");
        this.addMapping("video/vnd.dece.mobile", "uvm");
        this.addMapping("video/vnd.dece.mobile", "uvvm");
        this.addMapping("application/mxf", "mxf");
        this.addMapping("application/vnd.evolv.ecig.profile", "ecigprofile");
        this.addMapping("application/xhtml+xml", "xhtml");
        this.addMapping("application/xhtml+xml", "xhtm");
        this.addMapping("application/xhtml+xml", "xht");
        this.addMapping("application/pkcs7-signature", "p7s");
        this.addMapping("application/vnd.enliven", "nml");
        this.addMapping("application/vnd.micrografx.igx", "igx");
        this.addMapping("application/vnd.immervision-ivu", "ivu");
        this.addMapping("application/vnd.bluetooth.le.oob", "le");
        this.addMapping("application/vnd.chipnuts.karaoke-mmd", "mmd");
        this.addMapping("application/vnd.3gpp.pic-bw-small", "psb");
        this.addMapping("application/vnd.immervision-ivp", "ivp");
        this.addMapping("audio/basic", "au");
        this.addMapping("audio/basic", "snd");
        this.addMapping("application/pkix-pkipath", "pkipath");
        this.addMapping("application/vnd.zul", "zir");
        this.addMapping("application/vnd.zul", "zirz");
        this.addMapping("application/vnd.xmpie.cpkg", "cpkg");
        this.addMapping("application/LXF", "lxf");
        this.addMapping("application/mac-binhex40", "hqx");
        this.addMapping("image/jp2", "jp2");
        this.addMapping("image/jp2", "jpg2");
        this.addMapping("application/vnd.llamagraphics.life-balance.desktop", "lbd");
        this.addMapping("application/vnd.sealed.tiff", "stif");
        this.addMapping("application/vnd.sun.xml.draw", "sxd");
        this.addMapping("application/vnd.cendio.thinlinc.clientconf", "tlclient");
        this.addMapping("application/rpki-ghostbusters", "gbr");
        this.addMapping("application/vnd.wolfram.player", "nbp");
        this.addMapping("application/xcap-error+xml", "xer");
        this.addMapping("video/vnd.nokia.interleaved-multimedia", "nim");
        this.addMapping("application/tamp-community-update-confirm", "cuc");
        this.addMapping("application/vnd.fujixerox.ddd", "ddd");
        this.addMapping("application/simple-filter+xml", "cl");
        this.addMapping("application/vnd.oasis.opendocument.graphics", "odg");
        this.addMapping("application/pskc+xml", "pskcxml");
        this.addMapping("audio/x-ms-wax", "wax");
        this.addMapping("image/dicom-rle", "drle");
        this.addMapping("application/vnd.gmx", "gmx");
        this.addMapping("application/its+xml", "its");
        this.addMapping("application/vnd.trueapp", "tra");
        this.addMapping("application/vnd.dpgraph", "dpg");
        this.addMapping("application/vnd.dpgraph", "mwc");
        this.addMapping("application/vnd.dpgraph", "dpgraph");
        this.addMapping("application/bacnet-xdd+zip", "xdd");
        this.addMapping("application/vnd.sealed.doc", "sdoc");
        this.addMapping("application/vnd.sealed.doc", "sdo");
        this.addMapping("application/vnd.sealed.doc", "s1w");
        this.addMapping("video/x-ms-wmv", "wmv");
        this.addMapping("video/x-ms-wmx", "wmx");
        this.addMapping("application/rls-services+xml", "rs");
        this.addMapping("application/vnd.mynfc", "taglet");
        this.addMapping("text/vnd.wap.wml", "wml");
        this.addMapping("text/vnd.DMClientScript", "dms");
        this.addMapping("application/vnd.desmume.movie", "dsm");
        this.addMapping("model/mesh", "msh");
        this.addMapping("model/mesh", "mesh");
        this.addMapping("model/mesh", "silo");
        this.addMapping("application/vnd.oasis.opendocument.chart", "odc");
        this.addMapping("image/jpeg", "jpg");
        this.addMapping("image/jpeg", "jpeg");
        this.addMapping("image/jpeg", "jpe");
        this.addMapping("image/jpeg", "jfif");
        this.addMapping("application/mmt-usd+xml", "musd");
        this.addMapping("font/collection", "ttc");
        this.addMapping("application/vnd.coffeescript", "coffee");
        this.addMapping("image/tiff-fx", "tfx");
        this.addMapping("application/vnd.wv.csp+wbxml", "wv");
        this.addMapping("video/x-flv", "flv");
        this.addMapping("application/vnd.openofficeorg.extension", "oxt");
        this.addMapping("application/vnd.rar", "rar");
        this.addMapping("application/rfc+xml", "rfcxml");
        this.addMapping("message/global-headers", "u8hdr");
        this.addMapping("application/vnd.oasis.opendocument.spreadsheet", "ods");
        this.addMapping("application/x-java-archive", "jar");
        this.addMapping("application/vnd.adobe.xdp+xml", "xdp");
        this.addMapping("application/vnd.nitf", "nitf");
        this.addMapping("application/vnd.chemdraw+xml", "cdxml");
        this.addMapping("application/vnd.openeye.oeb", "oeb");
        this.addMapping("application/DCD", "dcd");
        this.addMapping("text/xml-external-parsed-entity", "ent");
        this.addMapping("application/vnd.crick.clicker.template", "clkt");
        this.addMapping("application/cdmi-domain", "cdmid");
        this.addMapping("application/vnd.wfa.wsc", "wsc");
        this.addMapping("application/marcxml+xml", "mrcx");
        this.addMapping("application/vnd.ms-powerpoint.template.macroEnabled.12", "potm");
        this.addMapping("application/emma+xml", "emma");
        this.addMapping("audio/vnd.nuera.ecelp9600", "ecelp9600");
        this.addMapping("application/dicom", "dcm");
        this.addMapping("application/vnd.zzazz.deck+xml", "zaz");
        this.addMapping("application/vnd.preminet", "preminet");
        this.addMapping("application/vnd.ms-fontobject", "eot");
        this.addMapping("application/hta", "hta");
        this.addMapping("application/vnd.visio", "vsd");
        this.addMapping("video/dv", "dif");
        this.addMapping("video/dv", "dv");
        this.addMapping("image/x-ms-bmp", "bmp");
        this.addMapping("audio/midi", "mid");
        this.addMapping("audio/midi", "midi");
        this.addMapping("audio/midi", "ota");
        this.addMapping("audio/midi", "kar");
        this.addMapping("audio/midi", "rtttl");
        this.addMapping("audio/midi", "xmf");
        this.addMapping("application/x-iso9660-image", "iso");
        this.addMapping("application/x-kpresenter", "kpr");
        this.addMapping("application/x-kpresenter", "kpt");
        this.addMapping("image/x-rgb", "rgb");
        this.addMapping("application/vnd.oasis.opendocument.spreadsheet-template", "ots");
        this.addMapping("audio/imelody", "imy");
        this.addMapping("application/x-futuresplash", "spl");
        this.addMapping("video/avi", "avi");
        this.addMapping("application/pdf", "pdf");
        this.addMapping("application/x-quicktimeplayer", "qtl");
        this.addMapping("audio/prs.sid", "sid");
        this.addMapping("application/x-bittorrent", "torrent");
        this.addMapping("video/vnd.mpegurl", "mxu");
        this.addMapping("text/xml", "xml");
        this.addMapping("application/rss+xml", "rss");
        this.addMapping("application/x-abiword", "abw");
        this.addMapping("text/iuls", "uls");
        this.addMapping("application/x-pkcs12", "p12");
        this.addMapping("application/x-pkcs12", "pfx");
        this.addMapping("application/vnd.stardivision.draw", "sda");
        this.addMapping("image/x-coreldrawpattern", "pat");
        this.addMapping("text/html", "htm");
        this.addMapping("text/html", "html");
        this.addMapping("image/x-xpixmap", "xpm");
        this.addMapping("video/dl", "dl");
        this.addMapping("text/css", "css");
        this.addMapping("text/x-dsrc", "d");
        this.addMapping("video/quicktime", "qt");
        this.addMapping("video/quicktime", "mov");
        this.addMapping("video/mp4", "mp4");
        this.addMapping("application/vnd.sun.xml.writer.template", "stw");
        this.addMapping("application/pgp-keys", "key");
        this.addMapping("text/x-c++hdr", "hpp");
        this.addMapping("text/x-c++hdr", "h++");
        this.addMapping("text/x-c++hdr", "hxx");
        this.addMapping("text/x-c++hdr", "hh");
        this.addMapping("video/webm", "webm");
        this.addMapping("audio/x-ms-wma", "wma");
        this.addMapping("image/vnd.djvu", "djvu");
        this.addMapping("image/vnd.djvu", "djv");
        this.addMapping("application/x-wais-source", "src");
        this.addMapping("image/x-photoshop", "psd");
        this.addMapping("video/x-ms-wm", "wm");
        this.addMapping("application/x-mif", "mif");
        this.addMapping("text/x-bibtex", "bib");
        this.addMapping("application/vnd.sun.xml.calc.template", "stc");
        this.addMapping("audio/x-scpls", "pls");
        this.addMapping("application/msaccess", "mdb");
        this.addMapping("application/x-dvi", "dvi");
        this.addMapping("application/x-latex", "latex");
        this.addMapping("video/3gpp", "3gpp");
        this.addMapping("video/3gpp", "3gp");
        this.addMapping("application/x-chess-pgn", "pgn");
        this.addMapping("x-epoc/x-sisx-app", "sisx");
        this.addMapping("application/vnd.openxmlformats-officedocument.spreadsheetml.template", "xltx");
        this.addMapping("application/vnd.sun.xml.writer.global", "sxg");
        this.addMapping("application/x-cdf", "cdf");
        this.addMapping("video/mpeg", "mpeg");
        this.addMapping("video/mpeg", "mpg");
        this.addMapping("video/mpeg", "mpe");
        this.addMapping("video/mpeg", "VOB");
        this.addMapping("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "xlsx");
        this.addMapping("image/ico", "cur");
        this.addMapping("image/ico", "ico");
        this.addMapping("image/x-panasonic-rw2", "rw2");
        this.addMapping("application/vnd.stardivision.impress", "sdd");
        this.addMapping("application/vnd.stardivision.impress", "sdp");
        this.addMapping("application/oda", "oda");
        this.addMapping("application/zip", "zip");
        this.addMapping("application/vnd.oasis.opendocument.text-master", "odm");
        this.addMapping("text/x-boo", "boo");
        this.addMapping("text/tab-separated-values", "tsv");
        this.addMapping("x-conference/x-cooltalk", "ice");
        this.addMapping("image/gif", "gif");
        this.addMapping("application/x-msi", "msi");
        this.addMapping("image/webp", "webp");
        this.addMapping("audio/x-realaudio", "ra");
        this.addMapping("text/h323", "323");
        this.addMapping("application/andrew-inset", "ez");
        this.addMapping("application/x-x509-server-cert", "crt");
        this.addMapping("application/vnd.stardivision.math", "smf");
        this.addMapping("application/x-killustrator", "kil");
        this.addMapping("application/vnd.google-earth.kmz", "kmz");
        this.addMapping("image/x-samsung-srw", "srw");
        this.addMapping("video/ogg", "ogv");
        this.addMapping("audio/x-aiff", "aif");
        this.addMapping("audio/x-aiff", "aiff");
        this.addMapping("audio/x-aiff", "aifc");
        this.addMapping("text/rtf", "rtf");
        this.addMapping("application/msword", "doc");
        this.addMapping("application/msword", "dot");
        this.addMapping("audio/mpegurl", "m3u");
        this.addMapping("application/vnd.stardivision.writer-global", "sgl");
        this.addMapping("application/pkix-cert", "cer");
        this.addMapping("application/x-apple-diskimage", "dmg");
        this.addMapping("video/x-ms-wvx", "wvx");
        this.addMapping("text/x-tcl", "tcl");
        this.addMapping("audio/amr-wb", "awb");
        this.addMapping("application/vnd.oasis.opendocument.text", "odt");
        this.addMapping("application/x-bcpio", "bcpio");
        this.addMapping("application/x-koan", "skp");
        this.addMapping("application/x-koan", "skd");
        this.addMapping("application/x-koan", "skt");
        this.addMapping("application/x-koan", "skm");
        this.addMapping("audio/x-sd2", "sd2");
        this.addMapping("image/x-portable-pixmap", "ppm");
        this.addMapping("text/x-pcs-gcd", "gcd");
        this.addMapping("application/x-xfig", "fig");
        this.addMapping("application/x-pkcs7-certreqresp", "p7r");
        this.addMapping("image/vnd.wap.wbmp", "wbmp");
        this.addMapping("application/x-nwc", "nwc");
        this.addMapping("application/x-pkcs7-crl", "crl");
        this.addMapping("text/x-csh", "csh");
        this.addMapping("application/x-director", "dcr");
        this.addMapping("application/x-director", "dir");
        this.addMapping("application/x-director", "dxr");
        this.addMapping("application/x-kspread", "ksp");
        this.addMapping("audio/x-pn-realaudio", "ra");
        this.addMapping("audio/x-pn-realaudio", "rm");
        this.addMapping("audio/x-pn-realaudio", "ram");
        this.addMapping("text/plain", "txt");
        this.addMapping("text/plain", "asc");
        this.addMapping("text/plain", "text");
        this.addMapping("text/plain", "diff");
        this.addMapping("text/plain", "po");
        this.addMapping("image/png", "png");
        this.addMapping("application/x-jmol", "jmz");
        this.addMapping("image/x-corelphotopaint", "cpt");
        this.addMapping("image/x-xwindowdump", "xwd");
        this.addMapping("application/x-cpio", "cpio");
        this.addMapping("video/x-sgi-movie", "movie");
        this.addMapping("application/x-font", "pfa");
        this.addMapping("application/x-font", "pfb");
        this.addMapping("application/x-font", "gsf");
        this.addMapping("application/x-font", "pcf");
        this.addMapping("application/x-font", "pcf.Z");
        this.addMapping("audio/aac-adts", "aac");
        this.addMapping("audio/ogg", "oga");
        this.addMapping("audio/ogg", "ogg");
        this.addMapping("audio/ogg", "spx");
        this.addMapping("application/vnd.oasis.opendocument.presentation-template", "otp");
        this.addMapping("application/x-tar", "tar");
        this.addMapping("application/vnd.sun.xml.impress.template", "sti");
        this.addMapping("text/x-tex", "tex");
        this.addMapping("text/x-tex", "ltx");
        this.addMapping("text/x-tex", "sty");
        this.addMapping("text/x-tex", "cls");
        this.addMapping("application/vnd.oasis.opendocument.formula", "odf");
        this.addMapping("application/pgp-signature", "pgp");
        this.addMapping("image/x-coreldraw", "cdr");
        this.addMapping("image/x-portable-graymap", "pgm");
        this.addMapping("application/vnd.openxmlformats-officedocument.wordprocessingml.template", "dotx");
        this.addMapping("image/x-coreldrawtemplate", "cdt");
        this.addMapping("application/vnd.youtube.yt", "yt");
        this.addMapping("application/x-troff", "t");
        this.addMapping("application/x-troff", "roff");
        this.addMapping("application/x-webarchive-xml", "webarchivexml");
        this.addMapping("application/vnd.sun.xml.draw.template", "std");
        this.addMapping("application/x-shockwave-flash", "swf");
        this.addMapping("image/x-portable-bitmap", "pbm");
        this.addMapping("text/x-java", "java");
        this.addMapping("application/x-dms", "dms");
        this.addMapping("application/x-ustar", "ustar");
        this.addMapping("application/vnd.stardivision.calc", "sdc");
        this.addMapping("application/vnd.ms-excel", "xls");
        this.addMapping("application/vnd.ms-excel", "xlt");
        this.addMapping("text/x-vcalendar", "vcs");
        this.addMapping("application/x-sv4cpio", "sv4cpio");
        this.addMapping("application/x-troff-man", "man");
        this.addMapping("application/x-xcf", "xcf");
        this.addMapping("application/epub+zip", "epub");
        this.addMapping("audio/amr", "amr");
        this.addMapping("application/vnd.oasis.opendocument.text-template", "ott");
        this.addMapping("application/vnd.openxmlformats-officedocument.presentationml.presentation", "pptx");
        this.addMapping("audio/x-matroska", "mka");
        this.addMapping("application/x-hdf", "hdf");
        this.addMapping("application/x-texinfo", "texinfo");
        this.addMapping("application/x-texinfo", "texi");
        this.addMapping("application/vnd.oasis.opendocument.database", "odb");
        this.addMapping("image/x-fuji-raf", "raf");
        this.addMapping("video/m4v", "m4v");
        this.addMapping("application/x-oz-application", "oza");
        this.addMapping("text/x-literate-haskell", "lhs");
        this.addMapping("text/calendar", "ics");
        this.addMapping("text/calendar", "icz");
        this.addMapping("text/mathml", "mml");
        this.addMapping("application/vnd.sun.xml.math", "sxm");
        this.addMapping("image/bmp", "bmp");
        this.addMapping("image/x-jng", "jng");
        this.addMapping("audio/mobile-xmf", "mxmf");
        this.addMapping("text/text", "phps");
        this.addMapping("application/vnd.cinderella", "cdy");
        this.addMapping("video/mp2ts", "ts");
        this.addMapping("application/x-hwp", "hwp");
        this.addMapping("application/xhtml+xml", "xhtml");
        this.addMapping("text/x-component", "htc");
        this.addMapping("application/vnd.smaf", "mmf");
        this.addMapping("image/x-cmu-raster", "ras");
        this.addMapping("application/vnd.rim.cod", "cod");
        this.addMapping("text/comma-separated-values", "csv");
        this.addMapping("application/x-iphone", "iii");
        this.addMapping("application/vnd.sun.xml.writer", "sxw");
        this.addMapping("audio/basic", "snd");
        this.addMapping("image/x-sony-arw", "arw");
        this.addMapping("image/x-adobe-dng", "dng");
        this.addMapping("text/x-chdr", "h");
        this.addMapping("application/x-internet-signup", "ins");
        this.addMapping("application/x-internet-signup", "isp");
        this.addMapping("image/x-canon-cr2", "cr2");
        this.addMapping("application/vnd.ms-powerpoint", "ppt");
        this.addMapping("application/vnd.ms-powerpoint", "pot");
        this.addMapping("application/vnd.ms-powerpoint", "pps");
        this.addMapping("image/x-olympus-orf", "orf");
        this.addMapping("application/mac-binhex40", "hqx");
        this.addMapping("text/x-c++src", "cpp");
        this.addMapping("text/x-c++src", "c++");
        this.addMapping("text/x-c++src", "cc");
        this.addMapping("text/x-c++src", "cxx");
        this.addMapping("application/vnd.openxmlformats-officedocument.presentationml.template", "potx");
        this.addMapping("application/rar", "rar");
        this.addMapping("image/tiff", "tiff");
        this.addMapping("image/tiff", "tif");
        this.addMapping("image/x-pentax-pef", "pef");
        this.addMapping("application/x-stuffit", "sit");
        this.addMapping("application/vnd.sun.xml.draw", "sxd");
        this.addMapping("application/x-gtar", "tgz");
        this.addMapping("application/x-gtar", "gtar");
        this.addMapping("application/x-gtar", "taz");
        this.addMapping("application/x-ms-wmd", "wmd");
        this.addMapping("image/ief", "ief");
        this.addMapping("application/vnd.stardivision.writer", "sdw");
        this.addMapping("application/vnd.stardivision.writer", "vor");
        this.addMapping("video/x-matroska", "mkv");
        this.addMapping("application/x-wingz", "wz");
        this.addMapping("application/x-object", "o");
        this.addMapping("application/vnd.sun.xml.calc", "sxc");
        this.addMapping("image/x-xbitmap", "xbm");
        this.addMapping("application/vnd.oasis.opendocument.graphics-template", "otg");
        this.addMapping("application/vnd.openxmlformats-officedocument.wordprocessingml.document", "docx");
        this.addMapping("application/x-ica", "ica");
        this.addMapping("application/x-cdlink", "vcd");
        this.addMapping("application/x-go-sgf", "sgf");
        this.addMapping("image/x-nikon-nrw", "nrw");
        this.addMapping("text/x-csrc", "c");
        this.addMapping("application/vnd.oasis.opendocument.text-web", "oth");
        this.addMapping("application/x-ms-wmz", "wmz");
        this.addMapping("video/x-la-asf", "lsf");
        this.addMapping("video/x-la-asf", "lsx");
        this.addMapping("audio/x-wav", "wav");
        this.addMapping("application/x-maker", "frm");
        this.addMapping("application/x-maker", "maker");
        this.addMapping("application/x-maker", "frame");
        this.addMapping("application/x-maker", "fb");
        this.addMapping("application/x-maker", "book");
        this.addMapping("application/x-maker", "fbdoc");
        this.addMapping("application/x-x509-user-cert", "crt");
        this.addMapping("text/x-setext", "etx");
        this.addMapping("application/vnd.oasis.opendocument.graphics", "odg");
        this.addMapping("application/x-webarchive", "webarchive");
        this.addMapping("audio/x-ms-wax", "wax");
        this.addMapping("image/pcx", "pcx");
        this.addMapping("video/x-ms-asf", "asf");
        this.addMapping("video/x-ms-asf", "asx");
        this.addMapping("application/rdf+xml", "rdf");
        this.addMapping("application/x-sv4crc", "sv4crc");
        this.addMapping("application/vnd.google-earth.kml+xml", "kml");
        this.addMapping("video/3gpp2", "3gpp2");
        this.addMapping("video/3gpp2", "3g2");
        this.addMapping("video/x-mng", "mng");
        this.addMapping("application/dsptype", "tsp");
        this.addMapping("audio/aac", "aac");
        this.addMapping("video/fli", "fli");
        this.addMapping("audio/flac", "flac");
        this.addMapping("audio/mpeg", "mp3");
        this.addMapping("audio/mpeg", "mpga");
        this.addMapping("audio/mpeg", "mpega");
        this.addMapping("audio/mpeg", "mp2");
        this.addMapping("audio/mpeg", "m4a");
        this.addMapping("application/x-lha", "lha");
        this.addMapping("text/x-pascal", "p");
        this.addMapping("text/x-pascal", "pas");
        this.addMapping("video/x-ms-wmv", "wmv");
        this.addMapping("application/x-doom", "wad");
        this.addMapping("audio/x-gsm", "gsm");
        this.addMapping("video/x-ms-wmx", "wmx");
        this.addMapping("application/vnd.oasis.opendocument.presentation", "odp");
        this.addMapping("application/x-x509-ca-cert", "crt");
        this.addMapping("audio/3gpp", "3gpp");
        this.addMapping("image/x-jg", "art");
        this.addMapping("model/iges", "igs");
        this.addMapping("model/iges", "iges");
        this.addMapping("text/richtext", "rtx");
        this.addMapping("text/x-moc", "moc");
        this.addMapping("audio/x-mpegurl", "m3u");
        this.addMapping("model/mesh", "msh");
        this.addMapping("model/mesh", "mesh");
        this.addMapping("model/mesh", "silo");
        this.addMapping("image/jpeg", "jpg");
        this.addMapping("image/jpeg", "jpeg");
        this.addMapping("image/jpeg", "jpe");
        this.addMapping("application/ogg", "ogx");
        this.addMapping("image/x-icon", "ico");
        this.addMapping("application/x-ns-proxy-autoconfig", "pac");
        this.addMapping("image/svg+xml", "svg");
        this.addMapping("image/svg+xml", "svgz");
        this.addMapping("application/x-shar", "shar");
        this.addMapping("application/x-debian-package", "deb");
        this.addMapping("application/x-debian-package", "udeb");
        this.addMapping("application/vnd.sun.xml.impress", "sxi");
        this.addMapping("video/x-webex", "wrf");
        this.addMapping("application/vnd.ms-pki.stl", "stl");
        this.addMapping("application/vnd.oasis.opendocument.spreadsheet", "ods");
        this.addMapping("application/pics-rules", "prf");
        this.addMapping("application/mathematica", "nb");
        this.addMapping("application/vnd.oasis.opendocument.image", "odi");
        this.addMapping("application/x-lzh", "lzh");
        this.addMapping("application/x-pem-file", "pem");
        this.addMapping("text/x-haskell", "hs");
        this.addMapping("text/x-vcard", "vcf");
        this.addMapping("application/vnd.android.package-archive", "apk");
        this.addMapping("application/x-kchart", "chrt");
        this.addMapping("application/x-flac", "flac");
        this.addMapping("application/futuresplash", "spl");
        this.addMapping("application/x-gnumeric", "gnumeric");
        this.addMapping("application/x-freemind", "mm");
        this.addMapping("application/x-lzx", "lzx");
        this.addMapping("application/vnd.openxmlformats-officedocument.presentationml.slideshow", "ppsx");
        this.addMapping("image/x-nikon-nef", "nef");
        this.addMapping("application/x-graphing-calculator", "gcf");
        this.addMapping("image/x-portable-anymap", "pnm");
        this.addMapping("application/x-kword", "kwd");
        this.addMapping("application/x-kword", "kwt");
        this.addMapping("application/powerpoint", "ppt");
        this.addMapping("application/freeloader", "frl");
        this.addMapping("audio/midi", "kar");
        this.addMapping("audio/midi", "mid");
        this.addMapping("audio/midi", "midi");
        this.addMapping("application/vnd.rn-realplayer", "rnx");
        this.addMapping("application/vnd.xara", "web");
        this.addMapping("application/x-ksh", "ksh");
        this.addMapping("image/x-pcx", "pcx");
        this.addMapping("image/x-rgb", "rgb");
        this.addMapping("video/x-mpeq2a", "mp2");
        this.addMapping("application/x-livescreen", "ivy");
        this.addMapping("video/x-ms-asf-plugin", "asx");
        this.addMapping("application/x-pagemaker", "pm4");
        this.addMapping("application/x-pagemaker", "pm5");
        this.addMapping("application/x-visio", "vsd");
        this.addMapping("application/x-visio", "vst");
        this.addMapping("application/x-visio", "vsw");
        this.addMapping("video/avi", "avi");
        this.addMapping("application/x-midi", "mid");
        this.addMapping("application/x-midi", "midi");
        this.addMapping("text/xml", "xml");
        this.addMapping("application/x-netcdf", "cdf");
        this.addMapping("application/x-netcdf", "nc");
        this.addMapping("application/x-tcl", "tcl");
        this.addMapping("audio/aiff", "aif");
        this.addMapping("audio/aiff", "aifc");
        this.addMapping("audio/aiff", "aiff");
        this.addMapping("audio/it", "it");
        this.addMapping("application/x-pkcs7-mime", "p7c");
        this.addMapping("application/x-pkcs7-mime", "p7m");
        this.addMapping("application/x-freelance", "pre");
        this.addMapping("text/html", "acgi");
        this.addMapping("text/html", "htm");
        this.addMapping("text/html", "html");
        this.addMapping("text/html", "htmls");
        this.addMapping("text/html", "htx");
        this.addMapping("text/html", "shtml");
        this.addMapping("application/x-ip2", "ip");
        this.addMapping("audio/voc", "voc");
        this.addMapping("image/x-xpixmap", "pm");
        this.addMapping("image/x-xpixmap", "xpm");
        this.addMapping("video/quicktime", "moov");
        this.addMapping("video/quicktime", "mov");
        this.addMapping("video/quicktime", "qt");
        this.addMapping("application/x-lotusscreencam", "scm");
        this.addMapping("application/x-navimap", "map");
        this.addMapping("application/x-sh", "sh");
        this.addMapping("application/x-sdp", "sdp");
        this.addMapping("application/x-wais-source", "src");
        this.addMapping("application/x-wais-source", "wsrc");
        this.addMapping("text/x-script.ksh", "ksh");
        this.addMapping("text/x-script.perl", "pl");
        this.addMapping("application/binhex4", "hqx");
        this.addMapping("application/x-sea", "sea");
        this.addMapping("audio/x-twinvq-plugin", "vqe");
        this.addMapping("audio/x-twinvq-plugin", "vql");
        this.addMapping("audio/x-midi", "mid");
        this.addMapping("audio/x-midi", "midi");
        this.addMapping("application/mac-compactpro", "cpt");
        this.addMapping("text/x-fortran", "f");
        this.addMapping("text/x-fortran", "f77");
        this.addMapping("text/x-fortran", "f90");
        this.addMapping("text/x-fortran", "for");
        this.addMapping("text/x-speech", "spc");
        this.addMapping("text/x-speech", "talk");
        this.addMapping("application/x-pointplus", "css");
        this.addMapping("music/x-karaoke", "kar");
        this.addMapping("text/x-m", "m");
        this.addMapping("text/x-h", "h");
        this.addMapping("text/x-h", "hh");
        this.addMapping("application/x-tex", "tex");
        this.addMapping("text/x-c", "c");
        this.addMapping("text/x-c", "cc");
        this.addMapping("text/x-c", "cpp");
        this.addMapping("application/x-cdf", "cdf");
        this.addMapping("application/vnd.ms-pki.pko", "pko");
        this.addMapping("video/x-mpeg", "mp2");
        this.addMapping("video/x-mpeg", "mp3");
        this.addMapping("text/x-script.tcl", "tcl");
        this.addMapping("application/acad", "dwg");
        this.addMapping("application/zip", "zip");
        this.addMapping("application/dxf", "dxf");
        this.addMapping("x-conference/x-cooltalk", "ice");
        this.addMapping("application/x-project", "mpc");
        this.addMapping("application/x-project", "mpt");
        this.addMapping("application/x-project", "mpv");
        this.addMapping("application/x-project", "mpx");
        this.addMapping("application/arj", "arj");
        this.addMapping("text/x-uuencode", "uu");
        this.addMapping("text/x-uuencode", "uue");
        this.addMapping("audio/x-realaudio", "ra");
        this.addMapping("video/vdo", "vdo");
        this.addMapping("application/vnd.fdf", "fdf");
        this.addMapping("application/x-vnd.audioexplosion.mzz", "mzz");
        this.addMapping("text/x-script.guile", "scm");
        this.addMapping("application/x-macbinary", "bin");
        this.addMapping("text/javascript", "js");
        this.addMapping("application/mac-binhex", "hqx");
        this.addMapping("audio/x-aiff", "aif");
        this.addMapping("audio/x-aiff", "aifc");
        this.addMapping("audio/x-aiff", "aiff");
        this.addMapping("video/x-amt-demorun", "xdr");
        this.addMapping("application/x-navidoc", "nvd");
        this.addMapping("image/vnd.fpx", "fpx");
        this.addMapping("video/x-isvideo", "isu");
        this.addMapping("application/x-javascript", "js");
        this.addMapping("application/pkix-cert", "cer");
        this.addMapping("application/pkix-cert", "crt");
        this.addMapping("application/vnd.ms-pki.certstore", "sst");
        this.addMapping("application/envoy", "evy");
        this.addMapping("application/x-sprite", "spr");
        this.addMapping("application/x-sprite", "sprite");
        this.addMapping("application/x-authorware-bin", "aab");
        this.addMapping("application/lha", "lha");
        this.addMapping("application/rtf", "rtf");
        this.addMapping("application/rtf", "rtx");
        this.addMapping("application/java-byte-code", "class");
        this.addMapping("image/x-portable-pixmap", "ppm");
        this.addMapping("application/x-msexcel", "xla");
        this.addMapping("application/x-msexcel", "xls");
        this.addMapping("application/x-msexcel", "xlw");
        this.addMapping("chemical/x-pdb", "pdb");
        this.addMapping("chemical/x-pdb", "xyz");
        this.addMapping("application/x-pixclscript", "plx");
        this.addMapping("multipart/x-zip", "zip");
        this.addMapping("application/x-pkcs7-certreqresp", "p7r");
        this.addMapping("application/binhex", "hqx");
        this.addMapping("application/x-troff-msvideo", "avi");
        this.addMapping("application/base64", "mm");
        this.addMapping("application/base64", "mme");
        this.addMapping("application/x-ima", "ima");
        this.addMapping("text/uri-list", "uni");
        this.addMapping("text/uri-list", "unis");
        this.addMapping("text/uri-list", "uri");
        this.addMapping("text/uri-list", "uris");
        this.addMapping("image/vnd.rn-realflash", "rf");
        this.addMapping("application/x-authorware-map", "aam");
        this.addMapping("text/vnd.abc", "abc");
        this.addMapping("application/x-director", "dcr");
        this.addMapping("application/x-director", "dir");
        this.addMapping("application/x-director", "dxr");
        this.addMapping("application/vocaltec-media-desc", "vmd");
        this.addMapping("image/pjpeg", "jfif");
        this.addMapping("image/pjpeg", "jpe");
        this.addMapping("image/pjpeg", "jpeg");
        this.addMapping("image/pjpeg", "jpg");
        this.addMapping("audio/nspaudio", "la");
        this.addMapping("audio/nspaudio", "lma");
        this.addMapping("application/x-inventor", "iv");
        this.addMapping("image/png", "png");
        this.addMapping("image/png", "x-png");
        this.addMapping("application/x-pkcs7-certificates", "spc");
        this.addMapping("audio/x-liveaudio", "lam");
        this.addMapping("text/x-script.zsh", "zsh");
        this.addMapping("application/x-omcdatamaker", "omcd");
        this.addMapping("application/pkix-crl", "crl");
        this.addMapping("image/x-xwd", "xwd");
        this.addMapping("image/x-xwindowdump", "xwd");
        this.addMapping("application/x-cpio", "cpio");
        this.addMapping("application/drafting", "drw");
        this.addMapping("video/x-sgi-movie", "movie");
        this.addMapping("video/x-sgi-movie", "mv");
        this.addMapping("application/x-tar", "tar");
        this.addMapping("application/mime", "aps");
        this.addMapping("application/streamingmedia", "ssm");
        this.addMapping("application/mcad", "mcd");
        this.addMapping("text/x-script.sh", "sh");
        this.addMapping("application/x-compactpro", "cpt");
        this.addMapping("audio/tsplayer", "tsp");
        this.addMapping("application/x-binary", "bin");
        this.addMapping("image/x-portable-graymap", "pgm");
        this.addMapping("application/x-mspowerpoint", "ppt");
        this.addMapping("image/x-niff", "nif");
        this.addMapping("image/x-niff", "niff");
        this.addMapping("application/x-shockwave-flash", "swf");
        this.addMapping("application/x-wpwin", "wpd");
        this.addMapping("x-world/x-svr", "svr");
        this.addMapping("text/sgml", "sgm");
        this.addMapping("text/sgml", "sgml");
        this.addMapping("application/x-ustar", "ustar");
        this.addMapping("application/book", "boo");
        this.addMapping("application/book", "book");
        this.addMapping("audio/x-psid", "sid");
        this.addMapping("application/vnd.ms-project", "mpp");
        this.addMapping("i-world/i-vrml", "ivr");
        this.addMapping("audio/x-vnd.audioexplosion.mjuicemediafile", "mjf");
        this.addMapping("video/vivo", "viv");
        this.addMapping("video/vivo", "vivo");
        this.addMapping("image/vasa", "mcf");
        this.addMapping("application/x-hdf", "hdf");
        this.addMapping("audio/make", "funk");
        this.addMapping("audio/make", "my");
        this.addMapping("audio/make", "pfunk");
        this.addMapping("application/x-texinfo", "texi");
        this.addMapping("application/x-texinfo", "texinfo");
        this.addMapping("application/marc", "mrc");
        this.addMapping("application/x-envoy", "env");
        this.addMapping("application/x-envoy", "evy");
        this.addMapping("application/netmc", "mcp");
        this.addMapping("image/bmp", "bm");
        this.addMapping("image/bmp", "bmp");
        this.addMapping("text/x-script.phyton", "py");
        this.addMapping("application/x-esrehber", "es");
        this.addMapping("application/step", "step");
        this.addMapping("application/step", "stp");
        this.addMapping("text/x-asm", "asm");
        this.addMapping("text/x-asm", "s");
        this.addMapping("image/x-cmu-raster", "ras");
        this.addMapping("application/x-deepv", "deepv");
        this.addMapping("text/vnd.rn-realtext", "rt");
        this.addMapping("application/vnd.ms-powerpoint", "pot");
        this.addMapping("application/vnd.ms-powerpoint", "ppa");
        this.addMapping("application/vnd.ms-powerpoint", "pps");
        this.addMapping("application/vnd.ms-powerpoint", "ppt");
        this.addMapping("application/vnd.ms-powerpoint", "pwz");
        this.addMapping("application/gnutar", "tgz");
        this.addMapping("image/tiff", "tif");
        this.addMapping("image/tiff", "tiff");
        this.addMapping("application/x-stuffit", "sit");
        this.addMapping("video/animaflex", "afl");
        this.addMapping("text/x-script.perl-module", "pm");
        this.addMapping("application/fractals", "fif");
        this.addMapping("audio/x-twinvq", "vqf");
        this.addMapping("image/x-xbitmap", "xbm");
        this.addMapping("application/x-java-class", "class");
        this.addMapping("application/vnd.rn-realmedia", "rm");
        this.addMapping("audio/x-wav", "wav");
        this.addMapping("application/toolbook", "tbk");
        this.addMapping("image/florian", "flo");
        this.addMapping("image/florian", "turbot");
        this.addMapping("application/x-bzip", "bz");
        this.addMapping("application/x-x509-user-cert", "crt");
        this.addMapping("text/x-setext", "etx");
        this.addMapping("application/octet-stream", "a");
        this.addMapping("application/octet-stream", "arc");
        this.addMapping("application/octet-stream", "arj");
        this.addMapping("application/octet-stream", "bin");
        this.addMapping("application/octet-stream", "com");
        this.addMapping("application/octet-stream", "dump");
        this.addMapping("application/octet-stream", "exe");
        this.addMapping("application/octet-stream", "lha");
        this.addMapping("application/octet-stream", "lhx");
        this.addMapping("application/octet-stream", "lzh");
        this.addMapping("application/octet-stream", "lzx");
        this.addMapping("application/octet-stream", "o");
        this.addMapping("application/octet-stream", "psd");
        this.addMapping("application/octet-stream", "saveme");
        this.addMapping("application/octet-stream", "uu");
        this.addMapping("application/octet-stream", "zoo");
        this.addMapping("video/x-ms-asf", "asf");
        this.addMapping("video/x-ms-asf", "asx");
        this.addMapping("application/x-sv4crc", "sv4crc");
        this.addMapping("application/dsptype", "tsp");
        this.addMapping("audio/mpeg", "m2a");
        this.addMapping("audio/mpeg", "mp2");
        this.addMapping("audio/mpeg", "mpa");
        this.addMapping("audio/mpeg", "mpg");
        this.addMapping("audio/mpeg", "mpga");
        this.addMapping("audio/make.my.funk", "pfunk");
        this.addMapping("application/x-lha", "lha");
        this.addMapping("text/mcf", "mcf");
        this.addMapping("text/x-pascal", "p");
        this.addMapping("audio/x-mod", "mod");
        this.addMapping("application/x-rtf", "rtf");
        this.addMapping("application/x-mathcad", "mcd");
        this.addMapping("image/x-pict", "pct");
        this.addMapping("image/x-jg", "art");
        this.addMapping("application/vnd.hp-hpgl", "hgl");
        this.addMapping("application/vnd.hp-hpgl", "hpg");
        this.addMapping("application/vnd.hp-hpgl", "hpgl");
        this.addMapping("application/x-world", "svr");
        this.addMapping("application/x-world", "wrl");
        this.addMapping("audio/x-nspaudio", "la");
        this.addMapping("audio/x-nspaudio", "lma");
        this.addMapping("image/x-icon", "ico");
        this.addMapping("model/vnd.dwf", "dwf");
        this.addMapping("application/x-compressed", "gz");
        this.addMapping("application/x-compressed", "tgz");
        this.addMapping("application/x-compressed", "z");
        this.addMapping("application/x-compressed", "zip");
        this.addMapping("audio/vnd.qcelp", "qcp");
        this.addMapping("application/mac-binary", "bin");
        this.addMapping("image/jutvision", "jut");
        this.addMapping("application/x-portable-anymap", "pnm");
        this.addMapping("application/x-authorware-seg", "aas");
        this.addMapping("application/x-omcregerator", "omcr");
        this.addMapping("video/vnd.vivo", "viv");
        this.addMapping("video/vnd.vivo", "vivo");
        this.addMapping("application/x-chat", "cha");
        this.addMapping("application/x-chat", "chat");
        this.addMapping("audio/x-mpeg", "mp2");
        this.addMapping("application/x-bzip2", "boz");
        this.addMapping("application/x-bzip2", "bz2");
        this.addMapping("video/x-qtc", "qtc");
        this.addMapping("audio/xm", "xm");
        this.addMapping("application/vocaltec-media-file", "vmf");
        this.addMapping("application/x-winhelp", "hlp");
        this.addMapping("audio/x-pn-realaudio-plugin", "ra");
        this.addMapping("audio/x-pn-realaudio-plugin", "rmp");
        this.addMapping("audio/x-pn-realaudio-plugin", "rpm");
        this.addMapping("audio/x-mpequrl", "m3u");
        this.addMapping("audio/x-au", "au");
        this.addMapping("image/x-dwg", "dwg");
        this.addMapping("image/x-dwg", "dxf");
        this.addMapping("image/x-dwg", "svf");
        this.addMapping("image/x-portable-anymap", "pnm");
        this.addMapping("application/wordperfect6.0", "w60");
        this.addMapping("application/wordperfect6.0", "wp5");
        this.addMapping("application/wordperfect6.1", "w61");
        this.addMapping("application/hta", "hta");
        this.addMapping("text/x-script.lisp", "lsp");
        this.addMapping("message/rfc822", "mht");
        this.addMapping("message/rfc822", "mhtml");
        this.addMapping("message/rfc822", "mime");
        this.addMapping("application/x-csh", "csh");
        this.addMapping("video/x-msvideo", "avi");
        this.addMapping("application/x-helpfile", "help");
        this.addMapping("application/x-helpfile", "hlp");
        this.addMapping("application/x-pkcs10", "p10");
        this.addMapping("audio/wav", "wav");
        this.addMapping("application/ecmascript", "js");
        this.addMapping("image/vnd.rn-realpix", "rp");
        this.addMapping("image/vnd.xiff", "xif");
        this.addMapping("audio/x-mpeg-3", "mp3");
        this.addMapping("application/pdf", "pdf");
        this.addMapping("text/webviewhtml", "htt");
        this.addMapping("application/x-internett-signup", "ins");
        this.addMapping("application/vnd.wap.wmlc", "wmlc");
        this.addMapping("application/x-pkcs12", "p12");
        this.addMapping("text/x-script.elisp", "el");
        this.addMapping("video/x-fli", "fli");
        this.addMapping("application/pkcs-crl", "crl");
        this.addMapping("application/pkcs10", "p10");
        this.addMapping("text/x-sgml", "sgm");
        this.addMapping("text/x-sgml", "sgml");
        this.addMapping("video/dl", "dl");
        this.addMapping("text/css", "css");
        this.addMapping("application/sounder", "sdr");
        this.addMapping("application/x-bsh", "bsh");
        this.addMapping("application/x-bsh", "sh");
        this.addMapping("application/x-bsh", "shar");
        this.addMapping("application/pkcs-12", "p12");
        this.addMapping("application/x-troff-ms", "ms");
        this.addMapping("text/x-script.csh", "csh");
        this.addMapping("application/x-omc", "omc");
        this.addMapping("model/vrml", "vrml");
        this.addMapping("model/vrml", "wrl");
        this.addMapping("model/vrml", "wrz");
        this.addMapping("application/x-mif", "mif");
        this.addMapping("image/xpm", "xpm");
        this.addMapping("application/javascript", "js");
        this.addMapping("windows/metafile", "wmf");
        this.addMapping("application/x-troff-me", "me");
        this.addMapping("image/x-quicktime", "qif");
        this.addMapping("image/x-quicktime", "qti");
        this.addMapping("image/x-quicktime", "qtif");
        this.addMapping("video/gl", "gl");
        this.addMapping("image/g3fax", "g3");
        this.addMapping("application/x-dvi", "dvi");
        this.addMapping("application/x-latex", "latex");
        this.addMapping("application/x-latex", "ltx");
        this.addMapping("video/x-scm", "scm");
        this.addMapping("text/scriplet", "wsc");
        this.addMapping("application/groupwise", "vew");
        this.addMapping("application/x-excel", "xla");
        this.addMapping("application/x-excel", "xlb");
        this.addMapping("application/x-excel", "xlc");
        this.addMapping("application/x-excel", "xld");
        this.addMapping("application/x-excel", "xlk");
        this.addMapping("application/x-excel", "xll");
        this.addMapping("application/x-excel", "xlm");
        this.addMapping("application/x-excel", "xls");
        this.addMapping("application/x-excel", "xlt");
        this.addMapping("application/x-excel", "xlv");
        this.addMapping("application/x-excel", "xlw");
        this.addMapping("application/x-compress", "z");
        this.addMapping("image/vnd.dwg", "dwg");
        this.addMapping("image/vnd.dwg", "dxf");
        this.addMapping("image/vnd.dwg", "svf");
        this.addMapping("application/x-seelogo", "sl");
        this.addMapping("image/x-xbm", "xbm");
        this.addMapping("audio/mod", "mod");
        this.addMapping("video/mpeg", "m1v");
        this.addMapping("video/mpeg", "m2v");
        this.addMapping("video/mpeg", "mp2");
        this.addMapping("video/mpeg", "mp3");
        this.addMapping("video/mpeg", "mpa");
        this.addMapping("video/mpeg", "mpe");
        this.addMapping("video/mpeg", "mpeg");
        this.addMapping("video/mpeg", "mpg");
        this.addMapping("application/x-navistyle", "stl");
        this.addMapping("application/oda", "oda");
        this.addMapping("application/x-123", "wk1");
        this.addMapping("application/sla", "stl");
        this.addMapping("text/asp", "asp");
        this.addMapping("text/tab-separated-values", "tsv");
        this.addMapping("video/x-amt-showrun", "xsr");
        this.addMapping("audio/x-adpcm", "snd");
        this.addMapping("image/gif", "gif");
        this.addMapping("application/sea", "sea");
        this.addMapping("video/msvideo", "avi");
        this.addMapping("text/x-la-asf", "lsx");
        this.addMapping("application/mspowerpoint", "pot");
        this.addMapping("application/mspowerpoint", "pps");
        this.addMapping("application/mspowerpoint", "ppt");
        this.addMapping("application/mspowerpoint", "ppz");
        this.addMapping("xgl/drawing", "xgz");
        this.addMapping("x-world/x-3dmf", "3dm");
        this.addMapping("x-world/x-3dmf", "3dmf");
        this.addMapping("x-world/x-3dmf", "qd3");
        this.addMapping("x-world/x-3dmf", "qd3d");
        this.addMapping("image/vnd.net-fpx", "fpx");
        this.addMapping("application/sdp", "sdp");
        this.addMapping("application/pro_eng", "part");
        this.addMapping("application/pro_eng", "prt");
        this.addMapping("video/avs-video", "avs");
        this.addMapping("application/x-qpro", "wb1");
        this.addMapping("text/x-audiosoft-intra", "aip");
        this.addMapping("application/msword", "doc");
        this.addMapping("application/msword", "dot");
        this.addMapping("application/msword", "w6w");
        this.addMapping("application/msword", "wiz");
        this.addMapping("application/msword", "word");
        this.addMapping("image/x-windows-bmp", "bmp");
        this.addMapping("video/vnd.rn-realvideo", "rv");
        this.addMapping("text/pascal", "pas");
        this.addMapping("application/commonground", "dp");
        this.addMapping("application/x-cmu-raster", "ras");
        this.addMapping("application/x-bcpio", "bcpio");
        this.addMapping("application/set", "set");
        this.addMapping("application/x-koan", "skd");
        this.addMapping("application/x-koan", "skm");
        this.addMapping("application/x-koan", "skp");
        this.addMapping("application/x-koan", "skt");
        this.addMapping("x-music/x-midi", "mid");
        this.addMapping("x-music/x-midi", "midi");
        this.addMapping("application/x-mplayer2", "asx");
        this.addMapping("application/x-lisp", "lsp");
        this.addMapping("image/vnd.wap.wbmp", "wbmp");
        this.addMapping("application/x-newton-compatible-pkg", "pkg");
        this.addMapping("application/x-navi-animation", "ani");
        this.addMapping("application/x-mac-binhex40", "hqx");
        this.addMapping("application/x-pkcs7-signature", "p7a");
        this.addMapping("application/pkcs7-mime", "p7c");
        this.addMapping("application/pkcs7-mime", "p7m");
        this.addMapping("xgl/movie", "xmz");
        this.addMapping("application/iges", "iges");
        this.addMapping("application/iges", "igs");
        this.addMapping("model/x-pov", "pov");
        this.addMapping("audio/x-jam", "jam");
        this.addMapping("application/x-cocoa", "cco");
        this.addMapping("application/vnd.hp-pcl", "pcl");
        this.addMapping("text/x-script.rexx", "rexx");
        this.addMapping("image/fif", "fif");
        this.addMapping("multipart/x-ustar", "ustar");
        this.addMapping("audio/x-pn-realaudio", "ra");
        this.addMapping("audio/x-pn-realaudio", "ram");
        this.addMapping("audio/x-pn-realaudio", "rm");
        this.addMapping("audio/x-pn-realaudio", "rmm");
        this.addMapping("audio/x-pn-realaudio", "rmp");
        this.addMapping("text/plain", "c");
        this.addMapping("text/plain", "c++");
        this.addMapping("text/plain", "cc");
        this.addMapping("text/plain", "com");
        this.addMapping("text/plain", "conf");
        this.addMapping("text/plain", "cxx");
        this.addMapping("text/plain", "def");
        this.addMapping("text/plain", "f");
        this.addMapping("text/plain", "f90");
        this.addMapping("text/plain", "for");
        this.addMapping("text/plain", "g");
        this.addMapping("text/plain", "h");
        this.addMapping("text/plain", "hh");
        this.addMapping("text/plain", "idc");
        this.addMapping("text/plain", "jav");
        this.addMapping("text/plain", "java");
        this.addMapping("text/plain", "list");
        this.addMapping("text/plain", "log");
        this.addMapping("text/plain", "lst");
        this.addMapping("text/plain", "m");
        this.addMapping("text/plain", "mar");
        this.addMapping("text/plain", "pl");
        this.addMapping("text/plain", "sdml");
        this.addMapping("text/plain", "text");
        this.addMapping("text/plain", "txt");
        this.addMapping("x-world/x-vrml", "vrml");
        this.addMapping("x-world/x-vrml", "wrl");
        this.addMapping("x-world/x-vrml", "wrz");
        this.addMapping("application/java", "class");
        this.addMapping("text/x-server-parsed-html", "shtml");
        this.addMapping("text/x-server-parsed-html", "ssi");
        this.addMapping("application/x-cpt", "cpt");
        this.addMapping("application/x-conference", "nsc");
        this.addMapping("application/vnd.nokia.configuration-message", "ncm");
        this.addMapping("text/vnd.wap.wmlscript", "wmls");
        this.addMapping("application/lzx", "lzx");
        this.addMapping("audio/x-mid", "mid");
        this.addMapping("audio/x-mid", "midi");
        this.addMapping("application/x-wintalk", "wtk");
        this.addMapping("image/pict", "pic");
        this.addMapping("image/pict", "pict");
        this.addMapping("application/plain", "text");
        this.addMapping("application/x-frame", "mif");
        this.addMapping("text/x-script", "hlb");
        this.addMapping("audio/voxware", "vox");
        this.addMapping("application/x-troff", "roff");
        this.addMapping("application/x-troff", "t");
        this.addMapping("application/x-troff", "tr");
        this.addMapping("application/clariscad", "ccad");
        this.addMapping("application/x-gss", "gss");
        this.addMapping("application/x-gsp", "gsp");
        this.addMapping("image/x-portable-bitmap", "pbm");
        this.addMapping("multipart/x-gzip", "gzip");
        this.addMapping("application/vnd.ms-excel", "xlb");
        this.addMapping("application/vnd.ms-excel", "xlc");
        this.addMapping("application/vnd.ms-excel", "xll");
        this.addMapping("application/vnd.ms-excel", "xlm");
        this.addMapping("application/vnd.ms-excel", "xls");
        this.addMapping("application/vnd.ms-excel", "xlw");
        this.addMapping("text/x-vcalendar", "vcs");
        this.addMapping("application/x-sv4cpio", "sv4cpio");
        this.addMapping("application/x-troff-man", "man");
        this.addMapping("video/x-motion-jpeg", "mjpg");
        this.addMapping("application/x-pcl", "pcl");
        this.addMapping("www/mime", "mime");
        this.addMapping("application/x-sit", "sit");
        this.addMapping("text/x-uil", "uil");
        this.addMapping("application/solids", "sol");
        this.addMapping("video/x-atomic3d-feature", "fmf");
        this.addMapping("application/inf", "inf");
        this.addMapping("image/x-jps", "jps");
        this.addMapping("paleovu/x-pv", "pvu");
        this.addMapping("application/x-wri", "wri");
        this.addMapping("application/hlp", "hlp");
        this.addMapping("application/ringing-tones", "rng");
        this.addMapping("application/smil", "smi");
        this.addMapping("application/smil", "smil");
        this.addMapping("application/x-lotus", "wq1");
        this.addMapping("application/x-magic-cap-package-1.0", "mc$");
        this.addMapping("application/xml", "xml");
        this.addMapping("application/x-java-commerce", "jcm");
        this.addMapping("application/postscript", "ai");
        this.addMapping("application/postscript", "eps");
        this.addMapping("application/postscript", "ps");
        this.addMapping("text/x-component", "htc");
        this.addMapping("application/x-binhex40", "hqx");
        this.addMapping("application/x-aim", "aim");
        this.addMapping("application/pkcs7-signature", "p7s");
        this.addMapping("text/ecmascript", "js");
        this.addMapping("image/x-portable-greymap", "pgm");
        this.addMapping("text/x-java-source", "jav");
        this.addMapping("text/x-java-source", "java");
        this.addMapping("application/x-mix-transfer", "nix");
        this.addMapping("audio/basic", "au");
        this.addMapping("audio/basic", "snd");
        this.addMapping("audio/mpeg3", "mp3");
        this.addMapping("application/mbedlet", "mbd");
        this.addMapping("image/cmu-raster", "ras");
        this.addMapping("image/cmu-raster", "rast");
        this.addMapping("application/mac-binhex40", "hqx");
        this.addMapping("application/cdf", "cdf");
        this.addMapping("image/x-tiff", "tif");
        this.addMapping("image/x-tiff", "tiff");
        this.addMapping("audio/x-voc", "voc");
        this.addMapping("application/x-gtar", "gtar");
        this.addMapping("video/x-gl", "gl");
        this.addMapping("image/ief", "ief");
        this.addMapping("image/ief", "iefs");
        this.addMapping("application/excel", "xl");
        this.addMapping("application/excel", "xla");
        this.addMapping("application/excel", "xlb");
        this.addMapping("application/excel", "xlc");
        this.addMapping("application/excel", "xld");
        this.addMapping("application/excel", "xlk");
        this.addMapping("application/excel", "xll");
        this.addMapping("application/excel", "xlm");
        this.addMapping("application/excel", "xls");
        this.addMapping("application/excel", "xlt");
        this.addMapping("application/excel", "xlv");
        this.addMapping("application/excel", "xlw");
        this.addMapping("audio/tsp-audio", "tsi");
        this.addMapping("application/x-cdlink", "vcd");
        this.addMapping("application/x-bytecode.elisp (compiled elisp)", "elc");
        this.addMapping("application/vnd.ms-pki.seccat", "cat");
        this.addMapping("image/naplps", "nap");
        this.addMapping("image/naplps", "naplps");
        this.addMapping("text/vnd.fmi.flexstor", "flx");
        this.addMapping("image/xbm", "xbm");
        this.addMapping("audio/mid", "rmi");
        this.addMapping("application/vda", "vda");
        this.addMapping("video/fli", "fli");
        this.addMapping("audio/s3m", "s3m");
        this.addMapping("audio/x-gsm", "gsd");
        this.addMapping("audio/x-gsm", "gsm");
        this.addMapping("application/mswrite", "wri");
        this.addMapping("text/vnd.wap.wml", "wml");
        this.addMapping("application/vnd.wap.wmlscriptc", "wmlsc");
        this.addMapping("application/x-x509-ca-cert", "cer");
        this.addMapping("application/x-x509-ca-cert", "crt");
        this.addMapping("application/x-x509-ca-cert", "der");
        this.addMapping("text/x-script.tcsh", "tcsh");
        this.addMapping("model/iges", "iges");
        this.addMapping("model/iges", "igs");
        this.addMapping("text/richtext", "rt");
        this.addMapping("text/richtext", "rtf");
        this.addMapping("text/richtext", "rtx");
        this.addMapping("video/vosaic", "vos");
        this.addMapping("application/i-deas", "unv");
        this.addMapping("image/jpeg", "jfif");
        this.addMapping("image/jpeg", "jfif-tbnl");
        this.addMapping("image/jpeg", "jpe");
        this.addMapping("image/jpeg", "jpeg");
        this.addMapping("image/jpeg", "jpg");
        this.addMapping("drawing/x-dwf (old)", "dwf");
        this.addMapping("application/x-tbook", "sbk");
        this.addMapping("application/x-tbook", "tbk");
        this.addMapping("x-world/x-vrt", "vrt");
        this.addMapping("application/x-shar", "sh");
        this.addMapping("application/x-shar", "shar");
        this.addMapping("music/crescendo", "mid");
        this.addMapping("music/crescendo", "midi");
        this.addMapping("application/vnd.nokia.ringing-tone", "rng");
        this.addMapping("application/x-zip-compressed", "zip");
        this.addMapping("application/x-meme", "mm");
        this.addMapping("application/macbinary", "bin");
        this.addMapping("application/vnd.ms-pki.stl", "stl");
        this.addMapping("application/x-gzip", "gz");
        this.addMapping("application/x-gzip", "gzip");
        this.addMapping("application/x-lzh", "lzh");
        this.addMapping("application/x-elc", "elc");
        this.addMapping("application/futuresplash", "spl");
        this.addMapping("application/x-httpd-imap", "imap");
        this.addMapping("video/x-dv", "dif");
        this.addMapping("video/x-dv", "dv");
        this.addMapping("application/x-lzx", "lzx");
        this.addMapping("text/x-script.scheme", "scm");
        this.addMapping("application/wordperfect", "wp");
        this.addMapping("application/wordperfect", "wp5");
        this.addMapping("application/wordperfect", "wp6");
        this.addMapping("application/wordperfect", "wpd");
        this.addMapping("application/x-vnd.ls-xpix", "xpix");
        this.addMapping("application/x-bytecode.python", "pyc");
        this.addMapping("application/x-vrml", "vrml");
        this.addMapping("application/x-nokia-9000-communicator-add-on-software", "aos");
        this.addMapping("video/x-dl", "dl");
        this.addMapping("", "mpeg");
        this.addMapping("", "parityfec");
        this.addMapping("", "raw");
        this.addMapping("", "alternative");
        this.addMapping("", "digest");
        this.addMapping("", "mixed");
        this.addMapping("", "parallel");
        this.addMapping("", "gif");
        this.addMapping("", "ief");
        this.addMapping("", "jpeg");
        this.addMapping("", "ktx");
        this.addMapping("", "svg+xml");
        this.addMapping("", "mesh");
        this.addMapping("", "vrml");
        this.addMapping("", "G7291");
        this.addMapping("", "QCELP");
        this.addMapping("", "enriched");
        this.addMapping("", "plain");
        this.addMapping("", "richtext");
        this.addMapping("", "external-body");
        this.addMapping("", "partial");
        this.addMapping("", "rfc822");
        this.addMapping("", "emma+xml");
        this.addMapping("", "exi");
        this.addMapping("", "mathml-content+xml");
        this.addMapping("", "mathml-presentation+xml");
        this.addMapping("", "mathml+xml");
        this.addMapping("", "pgp-keys");
        this.addMapping("", "sparql-query");
        this.addMapping("", "sparql-results+xml");
        this.addMapping("", "xslt+xml");
        this.addMapping("application/vnd.motorola.flexsuite.fis", "vnd.motorola.flexsuite.fis");
        this.addMapping("application/vnd.osgi.bundle", "vnd.osgi.bundle");
        this.addMapping("application/vnd.ms-htmlhelp", "vnd.ms-htmlhelp");
        this.addMapping("application/vnd.kidspiration", "vnd.kidspiration");
        this.addMapping("application/vnd.dvb_service", "vnd.dvb.service");
        this.addMapping("application/vnd.iptc.g2.knowledgeitem+xml", "vnd.iptc.g2.knowledgeitem+xml");
        this.addMapping("application/smpte336m", "smpte336m");
        this.addMapping("application/kpml-request+xml", "kpml-request+xml");
        this.addMapping("application/ibe-key-request+xml", "ibe-key-request+xml");
        this.addMapping("application/vnd.crick.clicker.wordbank", "vnd.crick.clicker.wordbank");
        this.addMapping("text/xml", "xml");
        this.addMapping("application/vnd.microsoft.portable-executable", "vnd.microsoft.portable-executable");
        this.addMapping("application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheRecords+xml", "vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheRecords+xml");
        this.addMapping("multipart/vnd.bint.med-plus", "vnd.bint.med-plus");
        this.addMapping("application/prs.rdf-xml-crypt", "prs.rdf-xml-crypt");
        this.addMapping("application/vnd.ms-windows.printerpairing", "vnd.ms-windows.printerpairing");
        this.addMapping("application/vnd.iptc.g2.packageitem+xml", "vnd.iptc.g2.packageitem+xml");
        this.addMapping("application/vnd.genomatix.tuxedo", "vnd.genomatix.tuxedo");
        this.addMapping("application/cose", "cose");
        this.addMapping("application/macwriteii", "macwriteii");
        this.addMapping("application/scvp-cv-request", "scvp-cv-request");
        this.addMapping("application/vnd.accpac.simply.imp", "vnd.accpac.simply.imp");
        this.addMapping("video/vnd.sealed-swf", "vnd.sealed.swf");
        this.addMapping("application/vnd.osgi.dp", "vnd.osgi.dp");
        this.addMapping("application/provenance+xml", "provenance+xml");
        this.addMapping("application/vnd.citationstyles.style+xml", "vnd.citationstyles.style+xml");
        this.addMapping("application/vnd.dvb.ipdcdftnotifaccess", "vnd.dvb.ipdcdftnotifaccess");
        this.addMapping("application/vnd.ms-wmdrm.lic-resp", "vnd.ms-wmdrm.lic-resp");
        this.addMapping("application/vnd.hbci", "vnd.hbci");
        this.addMapping("application/vnd.ims.lis.v2.result+json", "vnd.ims.lis.v2.result+json");
        this.addMapping("application/vnd.tcpdump.pcap", "vnd.tcpdump.pcap");
        this.addMapping("application/vnd.tableschema+json", "vnd.tableschema+json");
        this.addMapping("application/vnd.multiad.creator.cif", "vnd.multiad.creator.cif");
        this.addMapping("application/index.vnd", "index.vnd");
        this.addMapping("application/vnd.picsel", "vnd.picsel");
        this.addMapping("application/tamp-sequence-adjust-confirm", "tamp-sequence-adjust-confirm");
        this.addMapping("application/tamp-update-confirm", "tamp-update-confirm");
        this.addMapping("application/vnd.sealed-eml", "vnd.sealed.eml");
        this.addMapping("application/n-quads", "n-quads");
        this.addMapping("application/xcon-conference-info-diff+xml", "xcon-conference-info-diff+xml");
        this.addMapping("application/vcard+xml", "vcard+xml");
        this.addMapping("application/vnd.anki", "vnd.anki");
        this.addMapping("audio/rtploopback", "rtploopback");
        this.addMapping("application/vnd.ntt-local.ogw_remote-access", "vnd.ntt-local.ogw_remote-access");
        this.addMapping("application/vnd.3gpp.bsf+xml", "vnd.3gpp.bsf+xml");
        this.addMapping("font/sfnt", "sfnt");
        this.addMapping("application/A2L", "A2L");
        this.addMapping("application/fhir+xml", "fhir+xml");
        this.addMapping("application/vnd.ims.lti.v2.toolproxy.id+json", "vnd.ims.lti.v2.toolproxy.id+json");
        this.addMapping("application/vnd.marlin.drm.actiontoken+xml", "vnd.marlin.drm.actiontoken+xml");
        this.addMapping("application/index-obj", "index.obj");
        this.addMapping("application/vnd.ibm.afplinedata", "vnd.ibm.afplinedata");
        this.addMapping("application/vnd.syncml+xml", "vnd.syncml+xml");
        this.addMapping("video/vnd.iptvforum.1dparityfec-2005", "vnd.iptvforum.1dparityfec-2005");
        this.addMapping("image/vnd.fpx", "vnd.fpx");
        this.addMapping("application/rtx", "rtx");
        this.addMapping("application/yang-patch+json", "yang-patch+json");
        this.addMapping("application/mbms-msk+xml", "mbms-msk+xml");
        this.addMapping("image/t38", "t38");
        this.addMapping("application/rtf", "rtf");
        this.addMapping("application/vnd.imagemeter.folder+zip", "vnd.imagemeter.folder+zip");
        this.addMapping("application/EmergencyCallData.ServiceInfo+xml", "EmergencyCallData.ServiceInfo+xml");
        this.addMapping("application/vnd.ahead.space", "vnd.ahead.space");
        this.addMapping("application/vnd.oma-scws-http-request", "vnd.oma-scws-http-request");
        this.addMapping("application/vnd.unity", "vnd.unity");
        this.addMapping("application/vnd.globalplatform.card-content-mgt", "vnd.globalplatform.card-content-mgt");
        this.addMapping("application/vnd.panoply", "vnd.panoply");
        this.addMapping("audio/AMR", "AMR");
        this.addMapping("text/uri-list", "uri-list");
        this.addMapping("message/sipfrag", "sipfrag");
        this.addMapping("application/vnd.adobe.formscentral.fcdt", "vnd.adobe.formscentral.fcdt");
        this.addMapping("application/vnd.motorola.flexsuite.wem", "vnd.motorola.flexsuite.wem");
        this.addMapping("application/ccxml+xml", "ccxml+xml");
        this.addMapping("application/prs.alvestrand.titrax-sheet", "prs.alvestrand.titrax-sheet");
        this.addMapping("application/vnd.wolfram.mathematica.package", "vnd.wolfram.mathematica.package");
        this.addMapping("audio/vnd.nokia.mobile-xmf", "vnd.nokia.mobile-xmf");
        this.addMapping("application/vnd.openxmlformats-officedocument.spreadsheetml.chartsheet+xml", "vnd.openxmlformats-officedocument.spreadsheetml.chartsheet+xml");
        this.addMapping("application/vnd.openxmlformats-officedocument.wordprocessingml.footnotes+xml", "vnd.openxmlformats-officedocument.wordprocessingml.footnotes+xml");
        this.addMapping("video/vnd-mpegurl", "vnd.mpegurl");
        this.addMapping("application/ATFX", "ATFX");
        this.addMapping("application/lgr+xml", "lgr+xml");
        this.addMapping("application/vnd.yamaha.smaf-audio", "vnd.yamaha.smaf-audio");
        this.addMapping("audio/ogg", "ogg");
        this.addMapping("audio/32kadpcm", "32kadpcm");
        this.addMapping("application/vnd.smart.notebook", "vnd.smart.notebook");
        this.addMapping("application/vnd.medcalcdata", "vnd.medcalcdata");
        this.addMapping("application/xcap-el+xml", "xcap-el+xml");
        this.addMapping("application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml", "vnd.openxmlformats-officedocument.wordprocessingml.styles+xml");
        this.addMapping("application/vnd.infotech.project+xml", "vnd.infotech.project+xml");
        this.addMapping("application/SGML", "sgml");
        this.addMapping("application/vnd.pg.format", "vnd.pg.format");
        this.addMapping("application/vnd.wv.ssp+xml", "vnd.wv.ssp+xml");
        this.addMapping("audio/vnd.hns.audio", "vnd.hns.audio");
        this.addMapping("application/vnd.radisys.msml-dialog-speech+xml", "vnd.radisys.msml-dialog-speech+xml");
        this.addMapping("application/vnd.noblenet-sealer", "vnd.noblenet-sealer");
        this.addMapping("application/vnd.ms-wmdrm.meter-chlg-req", "vnd.ms-wmdrm.meter-chlg-req");
        this.addMapping("application/vnd.trid.tpt", "vnd.trid.tpt");
        this.addMapping("message/tracking-status", "tracking-status");
        this.addMapping("application/vnd.blueice.multipass", "vnd.blueice.multipass");
        this.addMapping("application/vnd.epson.quickanime", "vnd.epson.quickanime");
        this.addMapping("application/vnd.ms-excel.sheet.binary.macroEnabled.12", "vnd.ms-excel.sheet.binary.macroEnabled.12");
        this.addMapping("application/vnd.bbf.usp.msg", "vnd.bbf.usp.msg");
        this.addMapping("application/ocsp-request", "ocsp-request");
        this.addMapping("model/x3d+fastinfoset", "x3d+fastinfoset");
        this.addMapping("application/epub+zip", "epub+zip");
        this.addMapping("application/vnd.syncml.dmtnds+wbxml", "vnd.syncml.dmtnds+wbxml");
        this.addMapping("application/vnd.ocf+cbor", "vnd.ocf+cbor");
        this.addMapping("model/3mf", "3mf");
        this.addMapping("application/vnd.nokia.landmark+wbxml", "vnd.nokia.landmark+wbxml");
        this.addMapping("application/pkix-attr-cert", "pkix-attr-cert");
        this.addMapping("text/directory", "directory - DEPRECATED by RFC6350");
        this.addMapping("application/reginfo+xml", "reginfo+xml");
        this.addMapping("application/vnd.iptc.g2.newsitem+xml", "vnd.iptc.g2.newsitem+xml");
        this.addMapping("application/vnd.mediastation.cdkey", "vnd.mediastation.cdkey");
        this.addMapping("application/mosskey-request", "mosskey-request");
        this.addMapping("application/vnd.3gpp2.tcap", "vnd.3gpp2.tcap");
        this.addMapping("application/vnd.intertrust.nncp", "vnd.intertrust.nncp");
        this.addMapping("application/vnd.cluetrust.cartomobile-config", "vnd.cluetrust.cartomobile-config");
        this.addMapping("application/vnd.uplanet.cacheop", "vnd.uplanet.cacheop");
        this.addMapping("application/vnd.spotfire.dxp", "vnd.spotfire.dxp");
        this.addMapping("application/vnd.joost.joda-archive", "vnd.joost.joda-archive");
        this.addMapping("application/vnd.ecowin.fileupdate", "vnd.ecowin.fileupdate");
        this.addMapping("application/vnd.oma.lwm2m+tlv", "vnd.oma.lwm2m+tlv");
        this.addMapping("application/vnd.3gpp2.sms", "vnd.3gpp2.sms");
        this.addMapping("video/vnd.uvvu-mp4", "vnd.uvvu.mp4");
        this.addMapping("application/vnd.bekitzur-stech+json", "vnd.bekitzur-stech+json");
        this.addMapping("application/vnd.pvi.ptid1", "vnd.pvi.ptid1");
        this.addMapping("application/timestamped-data", "timestamped-data");
        this.addMapping("text/ulpfec", "ulpfec");
        this.addMapping("application/vnd.rs-274x", "vnd.rs-274x");
        this.addMapping("application/vnd.geonext", "vnd.geonext");
        this.addMapping("application/srgs", "srgs");
        this.addMapping("application/vnd.cups-raw", "vnd.cups-raw");
        this.addMapping("application/font-sfnt", "font-sfnt - DEPRECATED in favor of font/sfnt");
        this.addMapping("application/rlmi+xml", "rlmi+xml");
        this.addMapping("application/vnd.dvb.pfr", "vnd.dvb.pfr");
        this.addMapping("application/vnd.kahootz", "vnd.kahootz");
        this.addMapping("application/ccmp+xml", "ccmp+xml");
        this.addMapping("image/emf", "emf");
        this.addMapping("image/emf", "x-emf - DEPRECATED in favor of image/emf");
        this.addMapping("audio/RED", "RED");
        this.addMapping("application/vnd.oma.bcast.ltkm", "vnd.oma.bcast.ltkm");
        this.addMapping("application/vnd.ubisoft.webplayer", "vnd.ubisoft.webplayer");
        this.addMapping("application/vnd.google-earth.kml+xml", "vnd.google-earth.kml+xml");
        this.addMapping("audio/mpeg", "mpeg");
        this.addMapping("application/csvm+json", "csvm+json");
        this.addMapping("application/vnd.etsi.iptvueprofile+xml", "vnd.etsi.iptvueprofile+xml");
        this.addMapping("application/vnd.geoplan", "vnd.geoplan");
        this.addMapping("application/vnd.oma.bcast.associated-procedure-parameter+xml", "vnd.oma.bcast.associated-procedure-parameter+xml");
        this.addMapping("application/vnd.palm", "vnd.palm");
        this.addMapping("application/vnd.japannet-jpnstore-wakeup", "vnd.japannet-jpnstore-wakeup");
        this.addMapping("text/rtp-enc-aescm128", "rtp-enc-aescm128");
        this.addMapping("video/vnd.directv.mpeg-tts", "vnd.directv.mpeg-tts");
        this.addMapping("application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml", "vnd.openxmlformats-officedocument.spreadsheetml.styles+xml");
        this.addMapping("image/vnd.sealedmedia.softseal-gif", "vnd.sealedmedia.softseal.gif");
        this.addMapping("audio/vnd.qcelp", "vnd.qcelp - DEPRECATED in favor of audio/qcelp");
        this.addMapping("application/vnd.hp-jlyt", "vnd.hp-jlyt");
        this.addMapping("application/vnd.apple.installer+xml", "vnd.apple.installer+xml");
        this.addMapping("message/global-delivery-status", "global-delivery-status");
        this.addMapping("application/vnd.radisys.msml-dialog+xml", "vnd.radisys.msml-dialog+xml");
        this.addMapping("application/vnd.jam", "vnd.jam");
        this.addMapping("text/SGML", "sgml");
        this.addMapping("application/mathematica", "mathematica");
        this.addMapping("audio/vnd.dolby.pl2", "vnd.dolby.pl2");
        this.addMapping("image/vnd.airzip.accelerator.azv", "vnd.airzip.accelerator.azv");
        this.addMapping("application/eshop", "eshop");
        this.addMapping("application/MF4", "MF4");
        this.addMapping("model/x3d-vrml", "x3d-vrml");
        this.addMapping("application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml", "vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml");
        this.addMapping("application/CALS-1840", "CALS-1840");
        this.addMapping("application/yang-data+json", "yang-data+json");
        this.addMapping("application/yin+xml", "yin+xml");
        this.addMapping("application/vnd.balsamiq.bmml+xml", "vnd.balsamiq.bmml+xml");
        this.addMapping("application/cellml+xml", "cellml+xml");
        this.addMapping("video/vnd.iptvforum.ttsavc", "vnd.iptvforum.ttsavc");
        this.addMapping("application/alto-endpointcostparams+json", "alto-endpointcostparams+json");
        this.addMapping("application/vnd.iptc.g2.conceptitem+xml", "vnd.iptc.g2.conceptitem+xml");
        this.addMapping("audio/VMR-WB", "VMR-WB");
        this.addMapping("application/vnd.osgi.subsystem", "vnd.osgi.subsystem");
        this.addMapping("application/vnd.1000minds.decision-model+xml", "vnd.1000minds.decision-model+xml");
        this.addMapping("video/pointer", "pointer");
        this.addMapping("application/vnd.geospace", "vnd.geospace");
        this.addMapping("application/vnd.sealed-mht", "vnd.sealed.mht");
        this.addMapping("application/jwt", "jwt");
        this.addMapping("application/vnd.uiq.theme", "vnd.uiq.theme");
        this.addMapping("audio/prs.sid", "prs.sid");
        this.addMapping("application/oebps-package+xml", "oebps-package+xml");
        this.addMapping("application/vnd.datapackage+json", "vnd.datapackage+json");
        this.addMapping("application/mediaservercontrol+xml", "mediaservercontrol+xml");
        this.addMapping("text/prs.prop.logic", "prs.prop.logic");
        this.addMapping("application/vnd.omaloc-supl-init", "vnd.omaloc-supl-init");
        this.addMapping("text/csv", "csv");
        this.addMapping("application/vnd.lotus-notes", "vnd.lotus-notes");
        this.addMapping("text/css", "css");
        this.addMapping("application/vnd.is-xpr", "vnd.is-xpr");
        this.addMapping("application/vnd.ecdis-update", "vnd.ecdis-update");
        this.addMapping("audio/t140c", "t140c");
        this.addMapping("application/vnd.openxmlformats-officedocument.presentationml.tableStyles+xml", "vnd.openxmlformats-officedocument.presentationml.tableStyles+xml");
        this.addMapping("model/vnd.mts", "vnd.mts");
        this.addMapping("application/sru+xml", "sru+xml");
        this.addMapping("application/vnd.kde.kivio", "vnd.kde.kivio");
        this.addMapping("application/vnd.scribus", "vnd.scribus");
        this.addMapping("application/vnd.las.las+json", "vnd.las.las+json");
        this.addMapping("image/vnd-svf", "vnd.svf");
        this.addMapping("video/raptorfec", "raptorfec");
        this.addMapping("audio/EVRCWB", "EVRCWB");
        this.addMapping("audio/vnd.cmles.radio-events", "vnd.cmles.radio-events");
        this.addMapping("application/vnd.tmobile-livetv", "vnd.tmobile-livetv");
        this.addMapping("application/vnd.oma.bcast.simple-symbol-container", "vnd.oma.bcast.simple-symbol-container");
        this.addMapping("application/vnd.avistar+xml", "vnd.avistar+xml");
        this.addMapping("application/watcherinfo+xml", "watcherinfo+xml");
        this.addMapping("audio/MPA", "MPA");
        this.addMapping("application/yang-data+xml", "yang-data+xml");
        this.addMapping("application/vnd.dvb.iptv.alfec-enhancement", "vnd.dvb.iptv.alfec-enhancement");
        this.addMapping("application/vnd.frogans.ltf", "vnd.frogans.ltf");
        this.addMapping("application/vnd.ffsns", "vnd.ffsns");
        this.addMapping("model/x3d+xml", "x3d+xml");
        this.addMapping("application/vnd.hc+json", "vnd.hc+json");
        this.addMapping("application/ttml+xml", "ttml+xml");
        this.addMapping("text/vnd.motorola.reflex", "vnd.motorola.reflex");
        this.addMapping("text/tab-separated-values", "tab-separated-values");
        this.addMapping("audio/vnd.ms-playready.media.pya", "vnd.ms-playready.media.pya");
        this.addMapping("application/jwk+json", "jwk+json");
        this.addMapping("application/vnd.bmi", "vnd.bmi");
        this.addMapping("image/vnd.fastbidsheet", "vnd.fastbidsheet");
        this.addMapping("application/vnd.etsi.aoc+xml", "vnd.etsi.aoc+xml");
        this.addMapping("application/vnd.epson.salt", "vnd.epson.salt");
        this.addMapping("application/vnd.amundsen.maze+xml", "vnd.amundsen.maze+xml");
        this.addMapping("application/sdp", "sdp");
        this.addMapping("audio/encaprtp", "encaprtp");
        this.addMapping("application/vnd.triscape.mxs", "vnd.triscape.mxs");
        this.addMapping("application/vnd.gov.sk.e-form+xml", "vnd.gov.sk.e-form+xml");
        this.addMapping("message/global", "global");
        this.addMapping("application/link-format", "link-format");
        this.addMapping("application/vnd.kde.kformula", "vnd.kde.kformula");
        this.addMapping("audio/vnd.dolby.pulse.1", "vnd.dolby.pulse.1");
        this.addMapping("audio/vnd.4SB", "vnd.4SB");
        this.addMapping("audio/iLBC", "iLBC");
        this.addMapping("application/vnd.multiad.creator", "vnd.multiad.creator");
        this.addMapping("application/vnd.oasis.opendocument.text", "vnd.oasis.opendocument.text");
        this.addMapping("video/CelB", "CelB");
        this.addMapping("application/vnd.openxmlformats-officedocument.wordprocessingml.webSettings+xml", "vnd.openxmlformats-officedocument.wordprocessingml.webSettings+xml");
        this.addMapping("application/ocsp-response", "ocsp-response");
        this.addMapping("text/vnd-curl", "vnd.curl");
        this.addMapping("text/vnd.radisys.msml-basic-layout", "vnd.radisys.msml-basic-layout");
        this.addMapping("font/woff", "woff");
        this.addMapping("application/xacml+xml", "xacml+xml");
        this.addMapping("image/vnd.tencent.tap", "vnd.tencent.tap");
        this.addMapping("application/IOTP", "iotp");
        this.addMapping("application/vnd.sigrok.session", "vnd.sigrok.session");
        this.addMapping("application/vnd.radisys.msml-audit-dialog+xml", "vnd.radisys.msml-audit-dialog+xml");
        this.addMapping("message/vnd.si.simp", "vnd.si.simp - OBSOLETED by request");
        this.addMapping("application/im-iscomposing+xml", "im-iscomposing+xml");
        this.addMapping("application/vnd.syncml.ds.notification", "vnd.syncml.ds.notification");
        this.addMapping("application/vnd.nokia.pcd+xml", "vnd.nokia.pcd+xml");
        this.addMapping("application/vnd.openxmlformats-officedocument.presentationml.tags+xml", "vnd.openxmlformats-officedocument.presentationml.tags+xml");
        this.addMapping("video/H261", "H261");
        this.addMapping("video/H263", "H263");
        this.addMapping("video/H264", "H264");
        this.addMapping("video/H265", "H265");
        this.addMapping("application/ulpfec", "ulpfec");
        this.addMapping("application/sep-exi", "sep-exi");
        this.addMapping("application/vnd.openxmlformats-officedocument.presentationml.slide+xml", "vnd.openxmlformats-officedocument.presentationml.slide+xml");
        this.addMapping("application/passport", "passport");
        this.addMapping("application/vnd.fsc.weblaunch", "vnd.fsc.weblaunch");
        this.addMapping("audio/3gpp2", "3gpp2");
        this.addMapping("application/vnd.radisys.msml-conf+xml", "vnd.radisys.msml-conf+xml");
        this.addMapping("application/vnd.sealed.csf", "vnd.sealed.csf");
        this.addMapping("application/rpki-updown", "rpki-updown");
        this.addMapping("application/vnd.dece-zip", "vnd.dece.zip");
        this.addMapping("application/vnd.powerbuilder75-s", "vnd.powerbuilder75-s");
        this.addMapping("application/vnd.japannet-setstore-wakeup", "vnd.japannet-setstore-wakeup");
        this.addMapping("image/vnd.radiance", "vnd.radiance");
        this.addMapping("application/vnd.accpac.simply.aso", "vnd.accpac.simply.aso");
        this.addMapping("application/vnd.xmpie.xlim", "vnd.xmpie.xlim");
        this.addMapping("audio/t38", "t38");
        this.addMapping("application/urc-grpsheet+xml", "urc-grpsheet+xml");
        this.addMapping("application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml", "vnd.openxmlformats-officedocument.presentationml.presentation.main+xml");
        this.addMapping("application/alto-networkmapfilter+json", "alto-networkmapfilter+json");
        this.addMapping("application/vnd.cab-jscript", "vnd.cab-jscript");
        this.addMapping("application/jf2feed+json", "jf2feed+json");
        this.addMapping("application/vnd.ms-word.template.macroEnabled.12", "vnd.ms-word.template.macroEnabled.12");
        this.addMapping("application/vnd.obn", "vnd.obn");
        this.addMapping("application/EmergencyCallData.SubscriberInfo+xml", "EmergencyCallData.SubscriberInfo+xml");
        this.addMapping("application/vnd.openxmlformats-officedocument.presentationml.notesMaster+xml", "vnd.openxmlformats-officedocument.presentationml.notesMaster+xml");
        this.addMapping("application/vnd.nokia.n-gage.ac+xml", "vnd.nokia.n-gage.ac+xml");
        this.addMapping("application/vnd.ms-excel", "vnd.ms-excel");
        this.addMapping("application/vnd.noblenet-web", "vnd.noblenet-web");
        this.addMapping("application/vnd.sealed-doc", "vnd.sealed.doc");
        this.addMapping("application/index.response", "index.response");
        this.addMapping("application/tamp-error", "tamp-error");
        this.addMapping("application/pkcs8", "pkcs8");
        this.addMapping("application/vnd.eudora.data", "vnd.eudora.data");
        this.addMapping("model/vnd.opengex", "vnd.opengex");
        this.addMapping("application/vnd.ims.imsccv1p2", "vnd.ims.imsccv1p2");
        this.addMapping("application/vnd.orange.indata", "vnd.orange.indata");
        this.addMapping("application/vnd.ims.imsccv1p3", "vnd.ims.imsccv1p3");
        this.addMapping("application/vnd.quarantainenet", "vnd.quarantainenet");
        this.addMapping("application/vnd.document+json", "vnd.document+json");
        this.addMapping("application/vnd.ncd.reference", "vnd.ncd.reference");
        this.addMapping("application/route-apd+xml", "route-apd+xml");
        this.addMapping("application/vnd.ims.imsccv1p1", "vnd.ims.imsccv1p1");
        this.addMapping("application/vnd.ms-wmdrm.meter-resp", "vnd.ms-wmdrm.meter-resp");
        this.addMapping("application/vnd.oasis.opendocument.database", "vnd.oasis.opendocument.database");
        this.addMapping("application/vnd.wqd", "vnd.wqd");
        this.addMapping("model/gltf+json", "gltf+json");
        this.addMapping("application/EmergencyCallData.Control+xml", "EmergencyCallData.Control+xml");
        this.addMapping("application/vnd.cinderella", "vnd.cinderella");
        this.addMapping("application/vnd.kde.karbon", "vnd.kde.karbon");
        this.addMapping("application/timestamp-reply", "timestamp-reply");
        this.addMapping("application/vnd.microsoft.windows.thumbnail-cache", "vnd.microsoft.windows.thumbnail-cache");
        this.addMapping("application/vnd.iptc.g2.catalogitem+xml", "vnd.iptc.g2.catalogitem+xml");
        this.addMapping("application/vnd.openxmlformats-package.relationships+xml", "vnd.openxmlformats-package.relationships+xml");
        this.addMapping("audio/EVRCNW", "EVRCNW");
        this.addMapping("application/jrd+json", "jrd+json");
        this.addMapping("application/vnd.yamaha.openscoreformat", "vnd.yamaha.openscoreformat");
        this.addMapping("application/xml-external-parsed-entity", "xml-external-parsed-entity");
        this.addMapping("application/vnd.omads-email+xml", "vnd.omads-email+xml");
        this.addMapping("application/vnd.openxmlformats-officedocument.spreadsheetml.pivotTable+xml", "vnd.openxmlformats-officedocument.spreadsheetml.pivotTable+xml");
        this.addMapping("audio/AMR-WB", "AMR-WB");
        this.addMapping("application/vnd.openxmlformats-officedocument.spreadsheetml.connections+xml", "vnd.openxmlformats-officedocument.spreadsheetml.connections+xml");
        this.addMapping("application/vnd.enphase.envoy", "vnd.enphase.envoy");
        this.addMapping("video/vnd.iptvforum.2dparityfec-2005", "vnd.iptvforum.2dparityfec-2005");
        this.addMapping("application/wita", "wita");
        this.addMapping("application/tei+xml", "tei+xml");
        this.addMapping("application/pidf+xml", "pidf+xml");
        this.addMapping("video/vnd.dece.sd", "vnd.dece.sd");
        this.addMapping("application/vnd.httphone", "vnd.httphone");
        this.addMapping("application/vnd.nokia.n-gage.data", "vnd.nokia.n-gage.data");
        this.addMapping("application/relax-ng-compact-syntax", "relax-ng-compact-syntax");
        this.addMapping("model/gltf-binary", "gltf-binary");
        this.addMapping("application/vnd.ibm.modcap", "vnd.ibm.modcap");
        this.addMapping("application/conference-info+xml", "conference-info+xml");
        this.addMapping("application/vnd.kde.kchart", "vnd.kde.kchart");
        this.addMapping("application/vnd.openxmlformats-officedocument.wordprocessingml.document", "vnd.openxmlformats-officedocument.wordprocessingml.document");
        this.addMapping("video/vnd.dece.pd", "vnd.dece.pd");
        this.addMapping("image/naplps", "naplps");
        this.addMapping("application/vnd.crick.clicker.keyboard", "vnd.crick.clicker.keyboard");
        this.addMapping("text/vnd.fmi.flexstor", "vnd.fmi.flexstor");
        this.addMapping("audio/GSM-HR-08", "GSM-HR-08");
        this.addMapping("application/alto-endpointcost+json", "alto-endpointcost+json");
        this.addMapping("application/vnd.nokia.conml+xml", "vnd.nokia.conml+xml");
        this.addMapping("application/vnd.openxmlformats-officedocument.wordprocessingml.numbering+xml", "vnd.openxmlformats-officedocument.wordprocessingml.numbering+xml");
        this.addMapping("application/samlmetadata+xml", "samlmetadata+xml");
        this.addMapping("application/nss", "nss");
        this.addMapping("audio/rtx", "rtx");
        this.addMapping("audio/asc", "asc");
        this.addMapping("application/vnd.openxmlformats-officedocument.presentationml.handoutMaster+xml", "vnd.openxmlformats-officedocument.presentationml.handoutMaster+xml");
        this.addMapping("text/vnd.in3d.3dml", "vnd.in3d.3dml");
        this.addMapping("application/vnd.epson.ssf", "vnd.epson.ssf");
        this.addMapping("application/vnd.cosmocaller", "vnd.cosmocaller");
        this.addMapping("audio/PCMA-WB", "PCMA-WB");
        this.addMapping("application/vnd.pocketlearn", "vnd.pocketlearn");
        this.addMapping("application/vnd.uplanet.channel-wbxml", "vnd.uplanet.channel-wbxml");
        this.addMapping("application/cose-key-set", "cose-key-set");
        this.addMapping("application/mbms-schedule+xml", "mbms-schedule+xml");
        this.addMapping("application/media-policy-dataset+xml", "media-policy-dataset+xml");
        this.addMapping("application/vnd.wmc", "vnd.wmc");
        this.addMapping("audio/3gpp", "3gpp");
        this.addMapping("application/vnd.recordare.musicxml", "vnd.recordare.musicxml");
        this.addMapping("application/vnd.japannet-verification-wakeup", "vnd.japannet-verification-wakeup");
        this.addMapping("application/vnd.japannet-registration-wakeup", "vnd.japannet-registration-wakeup");
        this.addMapping("application/vnd.igloader", "vnd.igloader");
        this.addMapping("application/vnd.radisys.msml-dialog-group+xml", "vnd.radisys.msml-dialog-group+xml");
        this.addMapping("application/tamp-update", "tamp-update");
        this.addMapping("application/vnd.openxmlformats-officedocument.spreadsheetml.template.main+xml", "vnd.openxmlformats-officedocument.spreadsheetml.template.main+xml");
        this.addMapping("application/alto-endpointpropparams+json", "alto-endpointpropparams+json");
        this.addMapping("application/vnd.crick.clicker.palette", "vnd.crick.clicker.palette");
        this.addMapping("application/vnd.uplanet.bearer-choice-wbxml", "vnd.uplanet.bearer-choice-wbxml");
        this.addMapping("application/vnd.yamaha.hv-voice", "vnd.yamaha.hv-voice");
        this.addMapping("application/font-woff", "font-woff - DEPRECATED in favor of font/woff");
        this.addMapping("application/alto-costmapfilter+json", "alto-costmapfilter+json");
        this.addMapping("application/vnd.groove-tool-template", "vnd.groove-tool-template");
        this.addMapping("image/vnd-djvu", "vnd.djvu");
        this.addMapping("application/vnd.hcl-bireports", "vnd.hcl-bireports");
        this.addMapping("application/vnd.dvb.ipdcesgaccess2", "vnd.dvb.ipdcesgaccess2");
        this.addMapping("application/vnd.uri-map", "vnd.uri-map");
        this.addMapping("application/vnd.comicbook-rar", "vnd.comicbook-rar");
        this.addMapping("application/vnd.Quark.QuarkXPress", "vnd.Quark.QuarkXPress");
        this.addMapping("application/vnd.apache.thrift.json", "vnd.apache.thrift.json");
        this.addMapping("application/vnd.imagemeter.image+zip", "vnd.imagemeter.image+zip");
        this.addMapping("video/vnd.directv-mpeg", "vnd.directv.mpeg");
        this.addMapping("application/raptorfec", "raptorfec");
        this.addMapping("audio/vnd.audiokoz", "vnd.audiokoz");
        this.addMapping("text/provenance-notation", "provenance-notation");
        this.addMapping("application/sgml-open-catalog", "sgml-open-catalog");
        this.addMapping("application/vnd.openxmlformats-officedocument.presentationml.slideshow", "vnd.openxmlformats-officedocument.presentationml.slideshow");
        this.addMapping("application/ISUP", "isup");
        this.addMapping("application/vnd.fujixerox.ART4", "vnd.fujixerox.ART4");
        this.addMapping("video/vnd.CCTV", "vnd.CCTV");
        this.addMapping("application/vnd.3gpp-prose+xml", "vnd.3gpp-prose+xml");
        this.addMapping("application/vnd.geogebra.file", "vnd.geogebra.file");
        this.addMapping("application/vnd.oma.pal+xml", "vnd.oma.pal+xml");
        this.addMapping("application/msc-ivr+xml", "msc-ivr+xml");
        this.addMapping("application/example", "example");
        this.addMapping("application/voicexml+xml", "voicexml+xml");
        this.addMapping("application/vnd.restful+json", "vnd.restful+json");
        this.addMapping("application/vnd.ntt-local.file-transfer", "vnd.ntt-local.file-transfer");
        this.addMapping("application/set-registration", "set-registration");
        this.addMapping("application/vnd.tao.intent-module-archive", "vnd.tao.intent-module-archive");
        this.addMapping("application/vnd-curl", "vnd.curl");
        this.addMapping("application/spirits-event+xml", "spirits-event+xml");
        this.addMapping("text/jcr-cnd", "jcr-cnd");
        this.addMapping("application/mets+xml", "mets+xml");
        this.addMapping("application/mp4", "mp4");
        this.addMapping("application/vnd.powerbuilder7-s", "vnd.powerbuilder7-s");
        this.addMapping("video/ulpfec", "ulpfec");
        this.addMapping("text/vcard", "vcard");
        this.addMapping("application/vnd.kde.kspread", "vnd.kde.kspread");
        this.addMapping("application/prs.cww", "prs.cww");
        this.addMapping("application/vnd.balsamiq.bmpr", "vnd.balsamiq.bmpr");
        this.addMapping("application/vnd.ms-PrintSchemaTicket+xml", "vnd.ms-PrintSchemaTicket+xml");
        this.addMapping("application/geo+json", "geo+json");
        this.addMapping("audio/speex", "speex");
        this.addMapping("application/vnd.lotus-approach", "vnd.lotus-approach");
        this.addMapping("application/vnd.oma.poc.optimized-progress-report+xml", "vnd.oma.poc.optimized-progress-report+xml");
        this.addMapping("application/vnd.f-secure.mobile", "vnd.f-secure.mobile");
        this.addMapping("application/rtploopback", "rtploopback");
        this.addMapping("application/whoispp-response", "whoispp-response");
        this.addMapping("application/vnd.s3sms", "vnd.s3sms");
        this.addMapping("application/vnd.ncd.control", "vnd.ncd.control");
        this.addMapping("application/vnd.nokia.radio-presets", "vnd.nokia.radio-presets");
        this.addMapping("application/vnd.iptc.g2.planningitem+xml", "vnd.iptc.g2.planningitem+xml");
        this.addMapping("application/vnd.font-fontforge-sfd", "vnd.font-fontforge-sfd");
        this.addMapping("application/vnd.oma.bcast.sgdd+xml", "vnd.oma.bcast.sgdd+xml");
        this.addMapping("application/vnd.etsi.asic-s+zip", "vnd.etsi.asic-s+zip");
        this.addMapping("application/vnd.omads-folder+xml", "vnd.omads-folder+xml");
        this.addMapping("application/vnd.uplanet.list-wbxml", "vnd.uplanet.list-wbxml");
        this.addMapping("application/vnd.fujixerox.docuworks", "vnd.fujixerox.docuworks");
        this.addMapping("application/vnd.mophun.certificate", "vnd.mophun.certificate");
        this.addMapping("application/vnd.yamaha.hv-script", "vnd.yamaha.hv-script");
        this.addMapping("application/held+xml", "held+xml");
        this.addMapping("application/vnd.japannet-registration", "vnd.japannet-registration");
        this.addMapping("application/vnd-wap-wmlc", "vnd.wap.wmlc");
        this.addMapping("application/vnd.denovo.fcselayout-link", "vnd.denovo.fcselayout-link");
        this.addMapping("application/zip", "zip");
        this.addMapping("application/rpki-roa", "rpki-roa");
        this.addMapping("application/vnd.ims.lti.v2.toolsettings.simple+json", "vnd.ims.lti.v2.toolsettings.simple+json");
        this.addMapping("application/vnd.groove-vcard", "vnd.groove-vcard");
        this.addMapping("application/dvcs", "dvcs");
        this.addMapping("image/vnd.adobe.photoshop", "vnd.adobe.photoshop");
        this.addMapping("application/vnd.audiograph", "vnd.audiograph");
        this.addMapping("application/vnd.ms-PrintDeviceCapabilities+xml", "vnd.ms-PrintDeviceCapabilities+xml");
        this.addMapping("application/vnd.easykaraoke.cdgdownload", "vnd.easykaraoke.cdgdownload");
        this.addMapping("video/vnd.dece.hd", "vnd.dece.hd");
        this.addMapping("application/news-checkgroups", "news-checkgroups");
        this.addMapping("model/vnd.vtu", "vnd.vtu");
        this.addMapping("image/vnd.zbrush.pcx", "vnd.zbrush.pcx");
        this.addMapping("application/vnd.truedoc", "vnd.truedoc");
        this.addMapping("text/RED", "RED");
        this.addMapping("application/vnd.google-earth.kmz", "vnd.google-earth.kmz");
        this.addMapping("application/tamp-apex-update-confirm", "tamp-apex-update-confirm");
        this.addMapping("application/vnd.3gpp.mcptt-affiliation-command+xml", "vnd.3gpp.mcptt-affiliation-command+xml");
        this.addMapping("application/vnd.vividence.scriptfile", "vnd.vividence.scriptfile");
        this.addMapping("application/vnd.powerbuilder75", "vnd.powerbuilder75");
        this.addMapping("application/vnd.syncml.dm+xml", "vnd.syncml.dm+xml");
        this.addMapping("application/vnd.wv.csp+xml", "vnd.wv.csp+xml");
        this.addMapping("application/gml+xml", "gml+xml");
        this.addMapping("application/set-payment-initiation", "set-payment-initiation");
        this.addMapping("application/vnd.nokia.ncd", "vnd.nokia.ncd");
        this.addMapping("audio/SMV", "SMV");
        this.addMapping("application/vnd.ibm.MiniPay", "vnd.ibm.MiniPay");
        this.addMapping("application/xmpp+xml", "xmpp+xml");
        this.addMapping("application/vnd.3gpp.access-transfer-events+xml", "vnd.3gpp.access-transfer-events+xml");
        this.addMapping("application/vnd.etsi.iptvprofile+xml", "vnd.etsi.iptvprofile+xml");
        this.addMapping("application/vnd.openxmlformats-officedocument.spreadsheetml.calcChain+xml", "vnd.openxmlformats-officedocument.spreadsheetml.calcChain+xml");
        this.addMapping("application/vnd.proteus.magazine", "vnd.proteus.magazine");
        this.addMapping("application/vnd.ms-powerpoint.slide.macroEnabled.12", "vnd.ms-powerpoint.slide.macroEnabled.12");
        this.addMapping("audio/PCMA", "PCMA");
        this.addMapping("text/grammar-ref-list", "grammar-ref-list");
        this.addMapping("application/vnd.informedcontrol.rms+xml", "vnd.informedcontrol.rms+xml");
        this.addMapping("audio/PCMU", "PCMU");
        this.addMapping("video/vnd.iptvforum.1dparityfec-1010", "vnd.iptvforum.1dparityfec-1010");
        this.addMapping("application/vnd.groove-injector", "vnd.groove-injector");
        this.addMapping("application/vnd.ms-excel.addin.macroEnabled.12", "vnd.ms-excel.addin.macroEnabled.12");
        this.addMapping("text/vnd.trolltech.linguist", "vnd.trolltech.linguist");
        this.addMapping("video/vnd.radgamettools.smacker", "vnd.radgamettools.smacker");
        this.addMapping("application/dashdelta", "dashdelta");
        this.addMapping("audio/vnd.dolby.mlp", "vnd.dolby.mlp");
        this.addMapping("application/vnd.nintendo.nitro.rom", "vnd.nintendo.nitro.rom");
        this.addMapping("application/vnd.maxmind.maxmind-db", "vnd.maxmind.maxmind-db");
        this.addMapping("video/SMPTE292M", "SMPTE292M");
        this.addMapping("application/vnd.espass-espass+zip", "vnd.espass-espass+zip");
        this.addMapping("image/prs.pti", "prs.pti");
        this.addMapping("audio/vnd.octel.sbc", "vnd.octel.sbc");
        this.addMapping("application/mbms-envelope+xml", "mbms-envelope+xml");
        this.addMapping("application/vnd.sailingtracker.track", "vnd.sailingtracker.track");
        this.addMapping("application/mosskey-data", "mosskey-data");
        this.addMapping("application/vnd.criticaltools.wbs+xml", "vnd.criticaltools.wbs+xml");
        this.addMapping("application/vnd.evolv.ecig.theme", "vnd.evolv.ecig.theme");
        this.addMapping("application/vnd.uplanet.signal", "vnd.uplanet.signal");
        this.addMapping("application/vnd.oma.poc.detailed-progress-report+xml", "vnd.oma.poc.detailed-progress-report+xml");
        this.addMapping("application/vnd.nokia.conml+wbxml", "vnd.nokia.conml+wbxml");
        this.addMapping("application/vnd.dvb.notif-generic+xml", "vnd.dvb.notif-generic+xml");
        this.addMapping("application/vnd.ms-excel.sheet.macroEnabled.12", "vnd.ms-excel.sheet.macroEnabled.12");
        this.addMapping("audio/vnd.dlna.adts", "vnd.dlna.adts");
        this.addMapping("application/nlsml+xml", "nlsml+xml");
        this.addMapping("application/xv+xml", "xv+xml");
        this.addMapping("application/vnd.eprints.data+xml", "vnd.eprints.data+xml");
        this.addMapping("application/vnd.previewsystems.box", "vnd.previewsystems.box");
        this.addMapping("application/wspolicy+xml", "wspolicy+xml");
        this.addMapping("application/vnd.realvnc.bed", "vnd.realvnc.bed");
        this.addMapping("image/vnd.sealedmedia.softseal-jpg", "vnd.sealedmedia.softseal.jpg");
        this.addMapping("application/prs.nprend", "prs.nprend");
        this.addMapping("application/vq-rtcpxr", "vq-rtcpxr");
        this.addMapping("model/vnd.rosette.annotated-data-model", "vnd.rosette.annotated-data-model");
        this.addMapping("application/vnd.adobe.xfdf", "vnd.adobe.xfdf");
        this.addMapping("application/CDFX+XML", "CDFX+XML");
        this.addMapping("application/vnd.fujitsu.oasys2", "vnd.fujitsu.oasys2");
        this.addMapping("text/vnd.ms-mediapackage", "vnd.ms-mediapackage");
        this.addMapping("application/vnd.fujitsu.oasys3", "vnd.fujitsu.oasys3");
        this.addMapping("message/sip", "sip");
        this.addMapping("application/mbms-deregister+xml", "mbms-deregister+xml");
        this.addMapping("application/news-groupinfo", "news-groupinfo");
        this.addMapping("application/pls+xml", "pls+xml");
        this.addMapping("message/http", "http");
        this.addMapping("application/json-patch+json", "json-patch+json");
        this.addMapping("image/bmp", "bmp");
        this.addMapping("application/yang", "yang");
        this.addMapping("application/vnd.dvb.ipdcesgaccess", "vnd.dvb.ipdcesgaccess");
        this.addMapping("application/scvp-vp-request", "scvp-vp-request");
        this.addMapping("application/vnd.3M.Post-it-Notes", "vnd.3M.Post-it-Notes");
        this.addMapping("application/timestamp-query", "timestamp-query");
        this.addMapping("application/vnd.collection.doc+json", "vnd.collection.doc+json");
        this.addMapping("application/moss-keys", "moss-keys");
        this.addMapping("application/vnd.oipf.contentaccessstreaming+xml", "vnd.oipf.contentaccessstreaming+xml");
        this.addMapping("application/vnd.street-stream", "vnd.street-stream");
        this.addMapping("application/vnd.ms-word.document.macroEnabled.12", "vnd.ms-word.document.macroEnabled.12");
        this.addMapping("application/cdmi-queue", "cdmi-queue");
        this.addMapping("application/vnd.etsi.iptvsad-npvr+xml", "vnd.etsi.iptvsad-npvr+xml");
        this.addMapping("video/iso.segment", "iso.segment");
        this.addMapping("application/vnd.nokia.n-gage.symbian.install", "vnd.nokia.n-gage.symbian.install - OBSOLETE; no replacement given");
        this.addMapping("application/vnd.desmume-movie", "vnd.desmume.movie");
        this.addMapping("application/moss-signature", "moss-signature");
        this.addMapping("video/vnd.nokia.videovoip", "vnd.nokia.videovoip");
        this.addMapping("image/vnd.globalgraphics.pgb", "vnd.globalgraphics.pgb");
        this.addMapping("application/vnd.MFER", "vnd.MFER");
        this.addMapping("application/vnd.vectorworks", "vnd.vectorworks");
        this.addMapping("audio/vnd.dts.hd", "vnd.dts.hd");
        this.addMapping("application/dialog-info+xml", "dialog-info+xml");
        this.addMapping("application/vnd.openxmlformats-officedocument.presentationml.slideshow.main+xml", "vnd.openxmlformats-officedocument.presentationml.slideshow.main+xml");
        this.addMapping("application/vnd.ezpix-album", "vnd.ezpix-album");
        this.addMapping("application/vnd.oipf.dae.svg+xml", "vnd.oipf.dae.svg+xml");
        this.addMapping("application/vnd.micro+json", "vnd.micro+json");
        this.addMapping("text/raptorfec", "raptorfec");
        this.addMapping("application/vnd.ms-tnef", "vnd.ms-tnef");
        this.addMapping("application/vnd.astraea-software.iota", "vnd.astraea-software.iota");
        this.addMapping("application/vnd.oasis.opendocument.text-web", "vnd.oasis.opendocument.text-web");
        this.addMapping("application/vnd.svd", "vnd.svd");
        this.addMapping("video/vnd.motorola.video", "vnd.motorola.video");
        this.addMapping("application/fdt+xml", "fdt+xml");
        this.addMapping("video/JPEG", "JPEG");
        this.addMapping("application/alto-networkmap+json", "alto-networkmap+json");
        this.addMapping("application/vnd.airzip.filesecure.azs", "vnd.airzip.filesecure.azs");
        this.addMapping("application/metalink4+xml", "metalink4+xml");
        this.addMapping("video/vnd.hns.video", "vnd.hns.video");
        this.addMapping("application/x400-bp", "x400-bp");
        this.addMapping("audio/vnd.dece.audio", "vnd.dece.audio");
        this.addMapping("application/vnd.biopax.rdf+xml", "vnd.biopax.rdf+xml");
        this.addMapping("application/vnd.pwg-xhtml-print+xml", "vnd.pwg-xhtml-print+xml");
        this.addMapping("model/vnd.gs-gdl", "vnd.gs-gdl");
        this.addMapping("audio/EVRCB1", "EVRCB1");
        this.addMapping("text/vnd.sun.j2me.app-descriptor", "vnd.sun.j2me.app-descriptor");
        this.addMapping("audio/EVRCB0", "EVRCB0");
        this.addMapping("application/vnd.airzip.filesecure.azf", "vnd.airzip.filesecure.azf");
        this.addMapping("application/vnd.oasis.opendocument.presentation", "vnd.oasis.opendocument.presentation");
        this.addMapping("application/vnd.debian.binary-package", "vnd.debian.binary-package");
        this.addMapping("audio/vorbis", "vorbis");
        this.addMapping("application/vnd.openxmlformats-officedocument.wordprocessingml-template", "vnd.openxmlformats-officedocument.wordprocessingml.template");
        this.addMapping("text/turtle", "turtle");
        this.addMapping("audio/eac3", "eac3");
        this.addMapping("application/ATXML", "ATXML");
        this.addMapping("application/vnd.hp-HPGL", "vnd.hp-HPGL");
        this.addMapping("application/vnd.hzn-3d-crossword", "vnd.hzn-3d-crossword");
        this.addMapping("application/vnd.fujitsu.oasysgp", "vnd.fujitsu.oasysgp");
        this.addMapping("audio/mpa-robust", "mpa-robust");
        this.addMapping("audio/VDVI", "VDVI");
        this.addMapping("application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml", "vnd.openxmlformats-officedocument.spreadsheetml.comments+xml");
        this.addMapping("application/vnd.oasis.opendocument.image", "vnd.oasis.opendocument.image");
        this.addMapping("application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml", "vnd.openxmlformats-officedocument.presentationml.slideMaster+xml");
        this.addMapping("application/vnd.micrografx.flo", "vnd.micrografx.flo");
        this.addMapping("video/vnd.dece-mp4", "vnd.dece.mp4");
        this.addMapping("application/vnd.ms-playready.initiator+xml", "vnd.ms-playready.initiator+xml");
        this.addMapping("audio/G7221", "G7221");
        this.addMapping("application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml", "vnd.openxmlformats-officedocument.wordprocessingml.settings+xml");
        this.addMapping("application/vnd.oftn.l10n+json", "vnd.oftn.l10n+json");
        this.addMapping("application/vnd.grafeq", "vnd.grafeq");
        this.addMapping("application/vnd.openxmlformats-officedocument.spreadsheetml.revisionHeaders+xml", "vnd.openxmlformats-officedocument.spreadsheetml.revisionHeaders+xml");
        this.addMapping("application/vnd.semd", "vnd.semd");
        this.addMapping("application/vnd.semf", "vnd.semf");
        this.addMapping("application/vnd.shana.informed.interchange", "vnd.shana.informed.interchange");
        this.addMapping("application/prs.plucker", "prs.plucker");
        this.addMapping("application/vnd.apache.thrift.binary", "vnd.apache.thrift.binary");
        this.addMapping("audio/vnd.nuera.ecelp4800", "vnd.nuera.ecelp4800");
        this.addMapping("application/pkcs8-encrypted", "pkcs8-encrypted");
        this.addMapping("application/node", "node");
        this.addMapping("application/vnd.visio", "vnd.visio");
        this.addMapping("application/vnd.openxmlformats-officedocument.spreadsheetml.queryTable+xml", "vnd.openxmlformats-officedocument.spreadsheetml.queryTable+xml");
        this.addMapping("application/vnd-dxr", "vnd.dxr");
        this.addMapping("image/wmf", "wmf");
        this.addMapping("image/wmf", "x-wmf - DEPRECATED in favor of image/wmf");
        this.addMapping("application/vnd.jcp.javame.midlet-rms", "vnd.jcp.javame.midlet-rms");
        this.addMapping("application/cdmi-capability", "cdmi-capability");
        this.addMapping("application/vnd.etsi.timestamp-token", "vnd.etsi.timestamp-token");
        this.addMapping("application/vnd.ms-wmdrm.lic-chlg-req", "vnd.ms-wmdrm.lic-chlg-req");
        this.addMapping("application/3gpdash-qoe-report+xml", "3gpdash-qoe-report+xml");
        this.addMapping("application/vnd.fujixerox.HBPL", "vnd.fujixerox.HBPL");
        this.addMapping("application/vnd.iptc.g2.newsmessage+xml", "vnd.iptc.g2.newsmessage+xml");
        this.addMapping("application/vnd-mif", "vnd.mif");
        this.addMapping("application/pgp-encrypted", "pgp-encrypted");
        this.addMapping("application/vnd.wap-wbxml", "vnd.wap.wbxml");
        this.addMapping("audio/DVI4", "DVI4");
        this.addMapping("video/jpeg2000", "jpeg2000");
        this.addMapping("application/vnd.oma.drm.risd+xml", "vnd.oma.drm.risd+xml");
        this.addMapping("application/vnd.commerce-battelle", "vnd.commerce-battelle");
        this.addMapping("application/vnd.ruckus.download", "vnd.ruckus.download");
        this.addMapping("application/vnd.kde.kword", "vnd.kde.kword");
        this.addMapping("application/vnd.oma.poc.groups+xml", "vnd.oma.poc.groups+xml");
        this.addMapping("application/vnd.ms-wpl", "vnd.ms-wpl");
        this.addMapping("application/dssc+xml", "dssc+xml");
        this.addMapping("application/vnd.xmpie.ppkg", "vnd.xmpie.ppkg");
        this.addMapping("application/vnd.dece.data", "vnd.dece.data");
        this.addMapping("application/vnd.dolby.mobile.1", "vnd.dolby.mobile.1");
        this.addMapping("application/vnd.dolby.mobile.2", "vnd.dolby.mobile.2");
        this.addMapping("image/vnd.microsoft.icon", "vnd.microsoft.icon");
        this.addMapping("application/vnd.otps.ct-kip+xml", "vnd.otps.ct-kip+xml");
        this.addMapping("multipart/x-mixed-replace", "x-mixed-replace");
        this.addMapping("application/vnd.wordperfect", "vnd.wordperfect");
        this.addMapping("video/VP8", "VP8");
        this.addMapping("application/vnd.ms-powerpoint.presentation.macroEnabled.12", "vnd.ms-powerpoint.presentation.macroEnabled.12");
        this.addMapping("application/epp+xml", "epp+xml");
        this.addMapping("video/vnd-vivo", "vnd.vivo");
        this.addMapping("application/mbms-reception-report+xml", "mbms-reception-report+xml");
        this.addMapping("application/vnd.fujixerox.docuworks.container", "vnd.fujixerox.docuworks.container");
        this.addMapping("application/vnd.Mobius.TXF", "vnd.Mobius.TXF");
        this.addMapping("text/rtploopback", "rtploopback");
        this.addMapping("application/javascript", "javascript");
        this.addMapping("application/dskpp+xml", "dskpp+xml");
        this.addMapping("application/vnd.intu.qbo", "vnd.intu.qbo");
        this.addMapping("application/ssml+xml", "ssml+xml");
        this.addMapping("application/vnd.oipf.ueprofile+xml", "vnd.oipf.ueprofile+xml");
        this.addMapping("application/urc-ressheet+xml", "urc-ressheet+xml");
        this.addMapping("application/vnd.ms-powerpoint.addin.macroEnabled.12", "vnd.ms-powerpoint.addin.macroEnabled.12");
        this.addMapping("application/vnd.adobe.flash-movie", "vnd.adobe.flash.movie");
        this.addMapping("application/problem+xml", "problem+xml");
        this.addMapping("application/vnd.openxmlformats-officedocument.wordprocessingml.template.main+xml", "vnd.openxmlformats-officedocument.wordprocessingml.template.main+xml");
        this.addMapping("application/vnd.iccprofile", "vnd.iccprofile");
        this.addMapping("application/nasdata", "nasdata");
        this.addMapping("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        this.addMapping("text/csv-schema", "csv-schema");
        this.addMapping("application/cdmi-object", "cdmi-object");
        this.addMapping("application/vnd.oipf.contentaccessdownload+xml", "vnd.oipf.contentaccessdownload+xml");
        this.addMapping("application/vnd.valve.source.material", "vnd.valve.source.material");
        this.addMapping("application/vnd.cloanto.rp9", "vnd.cloanto.rp9");
        this.addMapping("application/vnd.tmd.mediaflex.api+xml", "vnd.tmd.mediaflex.api+xml");
        this.addMapping("application/vnd.nokia.catalogs", "vnd.nokia.catalogs");
        this.addMapping("application/EmergencyCallData.VEDS+xml", "EmergencyCallData.VEDS+xml");
        this.addMapping("application/andrew-inset", "andrew-inset");
        this.addMapping("application/vnd.autopackage", "vnd.autopackage");
        this.addMapping("video/ogg", "ogg");
        this.addMapping("text/t140", "t140");
        this.addMapping("application/vnd.dm.delegation+xml", "vnd.dm.delegation+xml");
        this.addMapping("application/vnd.oma.bcast.drm-trigger+xml", "vnd.oma.bcast.drm-trigger+xml");
        this.addMapping("application/atomsvc+xml", "atomsvc+xml");
        this.addMapping("image/jpm", "jpm");
        this.addMapping("application/msword", "msword");
        this.addMapping("application/vnd.etsi.mcid+xml", "vnd.etsi.mcid+xml");
        this.addMapping("application/DIT", "DIT");
        this.addMapping("application/emotionml+xml", "emotionml+xml");
        this.addMapping("image/jpx", "jpx");
        this.addMapping("application/vnd.openxmlformats-package.core-properties+xml", "vnd.openxmlformats-package.core-properties+xml");
        this.addMapping("application/vnd.dece.ttml+xml", "vnd.dece.ttml+xml");
        this.addMapping("application/vnd.openxmlformats-officedocument.spreadsheetml.tableSingleCells+xml", "vnd.openxmlformats-officedocument.spreadsheetml.tableSingleCells+xml");
        this.addMapping("application/vnd.informix-visionary", "vnd.informix-visionary - OBSOLETED in favor of application/vnd.visionary");
        this.addMapping("audio/GSM-EFR", "GSM-EFR");
        this.addMapping("application/vnd.ezpix-package", "vnd.ezpix-package");
        this.addMapping("application/DII", "DII");
        this.addMapping("application/vnd.radisys.msml-audit-stream+xml", "vnd.radisys.msml-audit-stream+xml");
        this.addMapping("application/vnd.route66.link66+xml", "vnd.route66.link66+xml");
        this.addMapping("application/load-control+xml", "load-control+xml");
        this.addMapping("application/cbor", "cbor");
        this.addMapping("text/vnd.IPTC.NewsML", "vnd.IPTC.NewsML");
        this.addMapping("application/vnd.openblox.game+xml", "vnd.openblox.game+xml");
        this.addMapping("application/vnd.ims.lti.v2.toolconsumerprofile+json", "vnd.ims.lti.v2.toolconsumerprofile+json");
        this.addMapping("multipart/multilingual", "multilingual");
        this.addMapping("application/pkcs7-mime", "pkcs7-mime");
        this.addMapping("application/vnd.oracle.resource+json", "vnd.oracle.resource+json");
        this.addMapping("application/vnd.drive+json", "vnd.drive+json");
        this.addMapping("application/vnd.openxmlformats-package.digital-signature-xmlsignature+xml", "vnd.openxmlformats-package.digital-signature-xmlsignature+xml");
        this.addMapping("application/vnd.xmpie.plan", "vnd.xmpie.plan");
        this.addMapping("application/ppsp-tracker+json", "ppsp-tracker+json");
        this.addMapping("application/vnd.ecowin.seriesupdate", "vnd.ecowin.seriesupdate");
        this.addMapping("application/vnd.intu.qfx", "vnd.intu.qfx");
        this.addMapping("application/jose", "jose");
        this.addMapping("application/rpki-manifest", "rpki-manifest");
        this.addMapping("application/alto-error+json", "alto-error+json");
        this.addMapping("text/n3", "n3");
        this.addMapping("application/vnd.koan", "vnd.koan");
        this.addMapping("application/ipfix", "ipfix");
        this.addMapping("application/vnd.renlearn.rlprint", "vnd.RenLearn.rlprint");
        this.addMapping("application/vnd.ecowin.chart", "vnd.ecowin.chart");
        this.addMapping("audio/vnd.cns.inf1", "vnd.cns.inf1");
        this.addMapping("application/mikey", "mikey");
        this.addMapping("application/vnd.groove-identity-message", "vnd.groove-identity-message");
        this.addMapping("application/vnd.tml", "vnd.tml");
        this.addMapping("application/vnd.Mobius.PLC", "vnd.Mobius.PLC");
        this.addMapping("application/vnd.etsi.sci+xml", "vnd.etsi.sci+xml");
        this.addMapping("application/vnd.openxmlformats-officedocument.spreadsheetml.volatileDependencies+xml", "vnd.openxmlformats-officedocument.spreadsheetml.volatileDependencies+xml");
        this.addMapping("message/imdn+xml", "imdn+xml");
        this.addMapping("application/vnd.hp-PCL", "vnd.hp-PCL");
        this.addMapping("application/vnd.oasis.opendocument.formula", "vnd.oasis.opendocument.formula");
        this.addMapping("video/rtploopback", "rtploopback");
        this.addMapping("application/pgp-signature", "pgp-signature");
        this.addMapping("application/vnd.dvb.notif-container+xml", "vnd.dvb.notif-container+xml");
        this.addMapping("message/vnd.wfa.wsc", "vnd.wfa.wsc");
        this.addMapping("image/vnd.fst", "vnd.fst");
        this.addMapping("application/vnd.mozilla.xul+xml", "vnd.mozilla.xul+xml");
        this.addMapping("application/vnd.filmit.zfc", "vnd.filmit.zfc");
        this.addMapping("application/vnd.3gpp-prose-pc3ch+xml", "vnd.3gpp-prose-pc3ch+xml");
        this.addMapping("application/vnd.vd-study", "vnd.vd-study");
        this.addMapping("application/vnd.shana.informed.formtemplate", "vnd.shana.informed.formtemplate");
        this.addMapping("application/xcap-ns+xml", "xcap-ns+xml");
        this.addMapping("application/vnd.lotus-organizer", "vnd.lotus-organizer");
        this.addMapping("audio/vnd.nuera.ecelp7470", "vnd.nuera.ecelp7470");
        this.addMapping("application/vnd.geogebra.tool", "vnd.geogebra.tool");
        this.addMapping("image/vnd.mozilla.apng", "vnd.mozilla.apng");
        this.addMapping("text/prs.lines.tag", "prs.lines.tag");
        this.addMapping("text/mizar", "mizar");
        this.addMapping("font/woff2", "woff2");
        this.addMapping("application/json", "json");
        this.addMapping("application/sep+xml", "sep+xml");
        this.addMapping("image/vnd.sealed-png", "vnd.sealed.png");
        this.addMapping("audio/vnd.dolby.pl2x", "vnd.dolby.pl2x");
        this.addMapping("application/vnd.syncml.dmtnds+xml", "vnd.syncml.dmtnds+xml");
        this.addMapping("image/jls", "jls");
        this.addMapping("application/vnd.arastra.swi", "vnd.arastra.swi - OBSOLETED in favor of application/vnd.aristanetworks.swi");
        this.addMapping("audio/EVS", "EVS");
        this.addMapping("audio/vnd.dolby.pl2z", "vnd.dolby.pl2z");
        this.addMapping("application/vnd.openxmlformats-officedocument.presentationml.presentation", "vnd.openxmlformats-officedocument.presentationml.presentation");
        this.addMapping("application/vnd.fdsn.seed", "vnd.fdsn.seed");
        this.addMapping("application/vnd.miele+json", "vnd.miele+json");
        this.addMapping("application/auth-policy+xml", "auth-policy+xml");
        this.addMapping("application/vnd.oma.cab-pcc+xml", "vnd.oma.cab-pcc+xml");
        this.addMapping("audio/vnd.presonus.multitrack", "vnd.presonus.multitrack");
        this.addMapping("application/smil", "smil - OBSOLETED in favor of application/smil+xml");
        this.addMapping("audio/vnd.cns.anp1", "vnd.cns.anp1");
        this.addMapping("application/efi", "efi");
        this.addMapping("audio/ATRAC-ADVANCED-LOSSLESS", "ATRAC-ADVANCED-LOSSLESS");
        this.addMapping("application/tamp-sequence-adjust", "tamp-sequence-adjust");
        this.addMapping("application/mxf", "mxf");
        this.addMapping("application/xhtml+xml", "xhtml+xml");
        this.addMapping("text/ecmascript", "ecmascript - OBSOLETED in favor of application/ecmascript");
        this.addMapping("application/H224", "H224");
        this.addMapping("application/vnd.chipnuts.karaoke-mmd", "vnd.chipnuts.karaoke-mmd");
        this.addMapping("audio/basic", "basic");
        this.addMapping("application/vnd.3gpp.pic-bw-small", "vnd.3gpp.pic-bw-small");
        this.addMapping("audio/dsr-es202050", "dsr-es202050");
        this.addMapping("message/news", "news - OBSOLETED by RFC5537");
        this.addMapping("application/LXF", "LXF");
        this.addMapping("image/jp2", "jp2");
        this.addMapping("application/mac-binhex40", "mac-binhex40");
        this.addMapping("video/nv", "nv");
        this.addMapping("application/ipp", "ipp");
        this.addMapping("application/vnd.oma.push", "vnd.oma.push");
        this.addMapping("application/dicom+json", "dicom+json");
        this.addMapping("application/vnd.openxmlformats-officedocument.wordprocessingml.comments+xml", "vnd.openxmlformats-officedocument.wordprocessingml.comments+xml");
        this.addMapping("application/tamp-community-update-confirm", "tamp-community-update-confirm");
        this.addMapping("application/3gpp-ims+xml", "3gpp-ims+xml");
        this.addMapping("application/vnd.etsi.iptvsad-cod+xml", "vnd.etsi.iptvsad-cod+xml");
        this.addMapping("application/vnd.fujixerox.ddd", "vnd.fujixerox.ddd");
        this.addMapping("application/fastsoap", "fastsoap");
        this.addMapping("application/vnd.ah-barcode", "vnd.ah-barcode");
        this.addMapping("application/vnd.nokia.landmark+xml", "vnd.nokia.landmark+xml");
        this.addMapping("application/vnd.oma.bcast.sprov+xml", "vnd.oma.bcast.sprov+xml");
        this.addMapping("application/soap+xml", "soap+xml");
        this.addMapping("image/dicom-rle", "dicom-rle");
        this.addMapping("video/vnd.iptvforum.2dparityfec-1010", "vnd.iptvforum.2dparityfec-1010");
        this.addMapping("application/vnd.gmx", "vnd.gmx - DEPRECATED");
        this.addMapping("application/its+xml", "its+xml");
        this.addMapping("application/vnd.dvb.notif-ia-registration-response+xml", "vnd.dvb.notif-ia-registration-response+xml");
        this.addMapping("application/vnd.oipf.mippvcontrolmessage+xml", "vnd.oipf.mippvcontrolmessage+xml");
        this.addMapping("application/x-www-form-urlencoded", "x-www-form-urlencoded");
        this.addMapping("application/vnd.3gpp.mcptt-location-info+xml", "vnd.3gpp.mcptt-location-info+xml");
        this.addMapping("application/vnd.dpgraph", "vnd.dpgraph");
        this.addMapping("application/vnd.oma.cab-subs-invite+xml", "vnd.oma.cab-subs-invite+xml");
        this.addMapping("application/bacnet-xdd+zip", "bacnet-xdd+zip");
        this.addMapping("application/rls-services+xml", "rls-services+xml");
        this.addMapping("application/vnd.mynfc", "vnd.mynfc");
        this.addMapping("application/vnd.sss-ntf", "vnd.sss-ntf");
        this.addMapping("text/vnd.DMClientScript", "vnd.DMClientScript");
        this.addMapping("application/vnd.uplanet.alert-wbxml", "vnd.uplanet.alert-wbxml");
        this.addMapping("application/vnd.oasis.opendocument.chart", "vnd.oasis.opendocument.chart");
        this.addMapping("message/CPIM", "CPIM");
        this.addMapping("application/mmt-usd+xml", "mmt-usd+xml");
        this.addMapping("message/disposition-notification", "disposition-notification");
        this.addMapping("application/vnd.nokia.iptv.config+xml", "vnd.nokia.iptv.config+xml");
        this.addMapping("application/vnd.radisys.msml-dialog-transform+xml", "vnd.radisys.msml-dialog-transform+xml");
        this.addMapping("application/vnd.wv.csp+wbxml", "vnd.wv.csp+wbxml");
        this.addMapping("image/aces", "aces");
        this.addMapping("application/vnd.nokia.iSDS-radio-presets", "vnd.nokia.iSDS-radio-presets");
        this.addMapping("application/vnd.openxmlformats-officedocument.drawing+xml", "vnd.openxmlformats-officedocument.drawing+xml");
        this.addMapping("application/coap-group+json", "coap-group+json");
        this.addMapping("message/global-headers", "global-headers");
        this.addMapping("application/vnd.oasis.opendocument.spreadsheet", "vnd.oasis.opendocument.spreadsheet");
        this.addMapping("application/vnd.openxmlformats-officedocument.vmlDrawing", "vnd.openxmlformats-officedocument.vmlDrawing");
        this.addMapping("application/set-payment", "set-payment");
        this.addMapping("application/poc-settings+xml", "poc-settings+xml");
        this.addMapping("application/EmergencyCallData.Comment+xml", "EmergencyCallData.Comment+xml");
        this.addMapping("application/vnd.chemdraw+xml", "vnd.chemdraw+xml");
        this.addMapping("application/vnd.sealed-tiff", "vnd.sealed.tiff");
        this.addMapping("application/DCD", "DCD");
        this.addMapping("application/EDIFACT", "EDIFACT");
        this.addMapping("application/vnd.crick.clicker.template", "vnd.crick.clicker.template");
        this.addMapping("application/cdmi-domain", "cdmi-domain");
        this.addMapping("application/vnd.geo+json", "vnd.geo+json (OBSOLETED by [RFC7946] in favor of application/geo+json)");
        this.addMapping("application/vnd.ms-powerpoint.template.macroEnabled.12", "vnd.ms-powerpoint.template.macroEnabled.12");
        this.addMapping("audio/vnd.nuera.ecelp9600", "vnd.nuera.ecelp9600");
        this.addMapping("application/vnd.3gpp.SRVCC-info+xml", "vnd.3gpp.SRVCC-info+xml");
        this.addMapping("application/dicom", "dicom");
        this.addMapping("application/vnd.zzazz.deck+xml", "vnd.zzazz.deck+xml");
        this.addMapping("application/index.cmd", "index.cmd");
        this.addMapping("application/vnd.radisys.msml-audit+xml", "vnd.radisys.msml-audit+xml");
        this.addMapping("application/vnd.preminet", "vnd.preminet");
        this.addMapping("application/vnd.xacml+json", "vnd.xacml+json");
        this.addMapping("application/atom+xml", "atom+xml");
        this.addMapping("application/vnd.3gpp.pic-bw-var", "vnd.3gpp.pic-bw-var");
        this.addMapping("application/clue_info+xml", "clue_info+xml");
        this.addMapping("audio/clearmode", "clearmode");
        this.addMapping("application/vnd.ufdl", "vnd.ufdl");
        this.addMapping("application/vnd.antix.game-component", "vnd.antix.game-component");
        this.addMapping("audio/GSM", "GSM");
        this.addMapping("audio/dls", "dls");
        this.addMapping("application/vnd.openxmlformats-officedocument.spreadsheetml.externalLink+xml", "vnd.openxmlformats-officedocument.spreadsheetml.externalLink+xml");
        this.addMapping("application/font-tdpfr", "font-tdpfr");
        this.addMapping("audio/EVRC1", "EVRC1");
        this.addMapping("video/MPV", "MPV");
        this.addMapping("audio/EVRC0", "EVRC0");
        this.addMapping("application/vnd.yamaha.through-ngn", "vnd.yamaha.through-ngn");
        this.addMapping("message/example", "example");
        this.addMapping("application/tamp-apex-update", "tamp-apex-update");
        this.addMapping("application/vnd.geocube+xml", "vnd.geocube+xml - OBSOLETED by request");
        this.addMapping("application/vnd.kenameaapp", "vnd.kenameaapp");
        this.addMapping("application/vnd.fujitsu.oasys", "vnd.fujitsu.oasys");
        this.addMapping("audio/EVRCB", "EVRCB");
        this.addMapping("application/vnd.visionary", "vnd.visionary");
        this.addMapping("application/vnd.d2l.coursepackage1p0+zip", "vnd.d2l.coursepackage1p0+zip");
        this.addMapping("application/xcap-diff+xml", "xcap-diff+xml");
        this.addMapping("text/html", "html");
        this.addMapping("application/vnd.lotus-freelance", "vnd.lotus-freelance");
        this.addMapping("application/vnd.ms-artgalry", "vnd.ms-artgalry");
        this.addMapping("application/vnd.ecip.rlp", "vnd.ecip.rlp");
        this.addMapping("application/vnd.geometry-explorer", "vnd.geometry-explorer");
        this.addMapping("application/vnd.motorola.flexsuite.adsi", "vnd.motorola.flexsuite.adsi");
        this.addMapping("audio/PCMU-WB", "PCMU-WB");
        this.addMapping("application/alto-endpointprop+json", "alto-endpointprop+json");
        this.addMapping("application/zlib", "zlib");
        this.addMapping("audio/example", "example");
        this.addMapping("application/vnd.commonspace", "vnd.commonspace");
        this.addMapping("audio/ip-mr_v2.5", "ip-mr_v2.5");
        this.addMapping("application/vnd.fujixerox.docuworks.binder", "vnd.fujixerox.docuworks.binder");
        this.addMapping("application/vnd.amazon.mobi8-ebook", "vnd.amazon.mobi8-ebook");
        this.addMapping("video/H264-SVC", "H264-SVC");
        this.addMapping("application/vnd.3gpp.mid-call+xml", "vnd.3gpp.mid-call+xml");
        this.addMapping("application/vnd.lotus-wordpro", "vnd.lotus-wordpro");
        this.addMapping("application/vnd.mophun.application", "vnd.mophun.application");
        this.addMapping("application/vnd.pcos", "vnd.pcos");
        this.addMapping("application/vnd.ecowin.seriesrequest", "vnd.ecowin.seriesrequest");
        this.addMapping("application/vnd.sealed-xls", "vnd.sealed.xls");
        this.addMapping("application/dicom+xml", "dicom+xml");
        this.addMapping("application/vnd.neurolanguage.nlu", "vnd.neurolanguage.nlu");
        this.addMapping("application/vnd.gridmp", "vnd.gridmp");
        this.addMapping("application/urc-uisocketdesc+xml", "urc-uisocketdesc+xml");
        this.addMapping("application/vnd.powerbuilder6-s", "vnd.powerbuilder6-s");
        this.addMapping("application/vnd.openxmlformats-officedocument.spreadsheetml.dialogsheet+xml", "vnd.openxmlformats-officedocument.spreadsheetml.dialogsheet+xml");
        this.addMapping("audio/MELP1200", "MELP1200");
        this.addMapping("application/vnd.sbm.mid2", "vnd.sbm.mid2");
        this.addMapping("video/example", "example");
        this.addMapping("application/vnd.ms-cab-compressed", "vnd.ms-cab-compressed");
        this.addMapping("application/vnd.etsi.iptvsync+xml", "vnd.etsi.iptvsync+xml");
        this.addMapping("application/vnd.oma.bcast.notification+xml", "vnd.oma.bcast.notification+xml");
        this.addMapping("video/MP2T", "MP2T");
        this.addMapping("application/vnd.software602.filler.form+xml", "vnd.software602.filler.form+xml");
        this.addMapping("application/vnd.rainstor.data", "vnd.rainstor.data");
        this.addMapping("application/http", "http");
        this.addMapping("application/vnd.uplanet.bearer-choice", "vnd.uplanet.bearer-choice");
        this.addMapping("audio/1d-interleaved-parityfec", "1d-interleaved-parityfec");
        this.addMapping("application/vnd.Mobius.DAF", "vnd.Mobius.DAF");
        this.addMapping("application/vnd.liberty-request+xml", "vnd.liberty-request+xml");
        this.addMapping("application/vnd.coreos.ignition+json", "vnd.coreos.ignition+json");
        this.addMapping("video/MP2P", "MP2P");
        this.addMapping("application/vnd.apple.mpegurl", "vnd.apple.mpegurl");
        this.addMapping("application/vnd.rig.cryptonote", "vnd.rig.cryptonote");
        this.addMapping("application/vnd.openxmlformats-officedocument.presentationml.template.main+xml", "vnd.openxmlformats-officedocument.presentationml.template.main+xml");
        this.addMapping("text/javascript", "javascript - OBSOLETED in favor of application/javascript");
        this.addMapping("application/vnd.nokia.radio-preset", "vnd.nokia.radio-preset");
        this.addMapping("application/vnd.hal+json", "vnd.hal+json");
        this.addMapping("audio/SMV0", "SMV0");
        this.addMapping("application/pkix-cert", "pkix-cert");
        this.addMapping("application/vnd.framemaker", "vnd.framemaker");
        this.addMapping("image/vnd.dece.graphic", "vnd.dece.graphic");
        this.addMapping("audio/EVRCNW0", "EVRCNW0");
        this.addMapping("audio/EVRCNW1", "EVRCNW1");
        this.addMapping("application/vnd.oasis.opendocument.image-template", "vnd.oasis.opendocument.image-template");
        this.addMapping("application/vnd.wmf.bootstrap", "vnd.wmf.bootstrap");
        this.addMapping("application/vnd.openxmlformats-officedocument.themeOverride+xml", "vnd.openxmlformats-officedocument.themeOverride+xml");
        this.addMapping("application/vnd.aristanetworks.swi", "vnd.aristanetworks.swi");
        this.addMapping("application/vnd.groove-help", "vnd.groove-help");
        this.addMapping("application/vnd.openxmlformats-officedocument.presentationml.commentAuthors+xml", "vnd.openxmlformats-officedocument.presentationml.commentAuthors+xml");
        this.addMapping("application/vnd.vidsoft.vidconference", "vnd.vidsoft.vidconference");
        this.addMapping("application/vnd.syncml.dm+wbxml", "vnd.syncml.dm+wbxml");
        this.addMapping("application/vnd.pg.osasli", "vnd.pg.osasli");
        this.addMapping("application/vnd.sqlite3", "vnd.sqlite3");
        this.addMapping("model/vnd.parasolid.transmit-text", "vnd.parasolid.transmit.text");
        this.addMapping("model/vnd.flatland.3dml", "vnd.flatland.3dml");
        this.addMapping("application/vnd.evolv.ecig.settings", "vnd.evolv.ecig.settings");
        this.addMapping("text/vnd.abc", "vnd.abc");
        this.addMapping("video/vnd.sealedmedia.softseal-mov", "vnd.sealedmedia.softseal.mov");
        this.addMapping("application/cpl+xml", "cpl+xml");
        this.addMapping("image/vnd.dvb.subtitle", "vnd.dvb.subtitle");
        this.addMapping("video/MP1S", "MP1S");
        this.addMapping("image/png", "png");
        this.addMapping("application/vnd.eszigno3+xml", "vnd.eszigno3+xml");
        this.addMapping("application/cccex", "cccex");
        this.addMapping("application/batch-SMTP", "batch-SMTP");
        this.addMapping("application/vnd.poc.group-advertisement+xml", "vnd.poc.group-advertisement+xml");
        this.addMapping("audio/vnd.sealedmedia.softseal-mpeg", "vnd.sealedmedia.softseal.mpeg");
        this.addMapping("application/vnd.onepagertamx", "vnd.onepagertamx");
        this.addMapping("application/vnd.musician", "vnd.musician");
        this.addMapping("application/vnd.msign", "vnd.msign");
        this.addMapping("application/vnd.ms-xpsdocument", "vnd.ms-xpsdocument");
        this.addMapping("application/vnd.anser-web-certificate-issue-initiation", "vnd.anser-web-certificate-issue-initiation");
        this.addMapping("application/vnd.onepagertamp", "vnd.onepagertamp");
        this.addMapping("application/vnd.sealed.3df", "vnd.sealed.3df");
        this.addMapping("video/vnd.nokia.mp4vr", "vnd.nokia.mp4vr");
        this.addMapping("application/vnd.ms-asf", "vnd.ms-asf");
        this.addMapping("application/vnd.stepmania.package", "vnd.stepmania.package");
        this.addMapping("video/H263-1998", "H263-1998");
        this.addMapping("text/vnd.wap.sl", "vnd.wap.sl");
        this.addMapping("application/vnd.hdt", "vnd.hdt");
        this.addMapping("text/vnd.wap.si", "vnd.wap.si");
        this.addMapping("application/vnd.3gpp.GMOP+xml", "vnd.3gpp.GMOP+xml");
        this.addMapping("application/vnd.radisys.msml-dialog-fax-detect+xml", "vnd.radisys.msml-dialog-fax-detect+xml");
        this.addMapping("application/vnd.wap-slc", "vnd.wap.slc");
        this.addMapping("application/vnd.sss-dtf", "vnd.sss-dtf");
        this.addMapping("application/vnd.youtube.yt", "vnd.youtube.yt");
        this.addMapping("text/vnd-a", "vnd.a");
        this.addMapping("application/vnd.oipf.cspg-hexbinary", "vnd.oipf.cspg-hexbinary");
        this.addMapping("application/vnd.pagerduty+json", "vnd.pagerduty+json");
        this.addMapping("application/vnd.shana.informed.formdata", "vnd.shana.informed.formdata");
        this.addMapping("application/vnd.contact.cmsg", "vnd.contact.cmsg");
        this.addMapping("audio/SMV-QCP", "SMV-QCP");
        this.addMapping("application/vnd.hp-hps", "vnd.hp-hps");
        this.addMapping("audio/vnd.rip", "vnd.rip");
        this.addMapping("application/vnd.dreamfactory", "vnd.dreamfactory");
        this.addMapping("application/vnd.ntt-local.sip-ta_tcp_stream", "vnd.ntt-local.sip-ta_tcp_stream");
        this.addMapping("application/vnd.ieee.1905", "vnd.ieee.1905");
        this.addMapping("text/example", "example");
        this.addMapping("application/vnd.etsi.iptvservice+xml", "vnd.etsi.iptvservice+xml");
        this.addMapping("application/whoispp-query", "whoispp-query");
        this.addMapping("text/vnd.si.uricatalogue", "vnd.si.uricatalogue - OBSOLETED by request");
        this.addMapping("application/vnd.patentdive", "vnd.patentdive");
        this.addMapping("application/wordperfect5.1", "wordperfect5.1");
        this.addMapping("application/vnd.crick.clicker", "vnd.crick.clicker");
        this.addMapping("video/MP4V-ES", "MP4V-ES");
        this.addMapping("application/simple-message-summary", "simple-message-summary");
        this.addMapping("application/marc", "marc");
        this.addMapping("application/vnd.fujixerox.ART-EX", "vnd.fujixerox.ART-EX");
        this.addMapping("audio/G726-40", "G726-40");
        this.addMapping("application/vnd.syncml.dmddf+wbxml", "vnd.syncml.dmddf+wbxml");
        this.addMapping("application/vnd.dvb.notif-init+xml", "vnd.dvb.notif-init+xml");
        this.addMapping("model/vnd.parasolid.transmit-binary", "vnd.parasolid.transmit.binary");
        this.addMapping("application/vnd.smaf", "vnd.smaf");
        this.addMapping("application/vnd.music-niff", "vnd.music-niff");
        this.addMapping("application/vnd.openxmlformats-officedocument.drawingml.diagramStyle+xml", "vnd.openxmlformats-officedocument.drawingml.diagramStyle+xml");
        this.addMapping("application/geoxacml+xml", "geoxacml+xml");
        this.addMapping("application/vnd.oma.dcdc", "vnd.oma.dcdc");
        this.addMapping("application/mbms-user-service-description+xml", "mbms-user-service-description+xml");
        this.addMapping("image/vnd.fujixerox.edmics-mmr", "vnd.fujixerox.edmics-mmr");
        this.addMapping("application/vnd.data-vision.rdz", "vnd.data-vision.rdz");
        this.addMapping("application/vnd.oma.bcast.provisioningtrigger", "vnd.oma.bcast.provisioningtrigger");
        this.addMapping("application/vnd.collection.next+json", "vnd.collection.next+json");
        this.addMapping("application/vnd.sus-calendar", "vnd.sus-calendar");
        this.addMapping("application/riscos", "riscos");
        this.addMapping("application/vnd.openxmlformats-officedocument.wordprocessingml.endnotes+xml", "vnd.openxmlformats-officedocument.wordprocessingml.endnotes+xml");
        this.addMapping("application/vnd.olpc-sugar", "vnd.olpc-sugar");
        this.addMapping("application/vnd.3gpp.state-and-event-info+xml", "vnd.3gpp.state-and-event-info+xml");
        this.addMapping("application/merge-patch+json", "merge-patch+json");
        this.addMapping("application/vnd.Mobius.MBK", "vnd.Mobius.MBK");
        this.addMapping("video/rtx", "rtx");
        this.addMapping("audio/vnd.3gpp.iufp", "vnd.3gpp.iufp");
        this.addMapping("application/vnd.Mobius.DIS", "vnd.Mobius.DIS");
        this.addMapping("application/vnd.lotus-1-2-3", "vnd.lotus-1-2-3");
        this.addMapping("multipart/form-data", "form-data");
        this.addMapping("application/vnd.gov.sk.e-form+zip", "vnd.gov.sk.e-form+zip");
        this.addMapping("application/vnd.dvb.esgcontainer", "vnd.dvb.esgcontainer");
        this.addMapping("application/vnd.novadigm.EXT", "vnd.novadigm.EXT");
        this.addMapping("application/vnd.clonk.c4group", "vnd.clonk.c4group");
        this.addMapping("application/vnd.oasis.opendocument.graphics-template", "vnd.oasis.opendocument.graphics-template");
        this.addMapping("application/vnd.oma.xcap-directory+xml", "vnd.oma.xcap-directory+xml");
        this.addMapping("application/vnd.onepagertatx", "vnd.onepagertatx");
        this.addMapping("application/vnd.nokia.pcd+wbxml", "vnd.nokia.pcd+wbxml");
        this.addMapping("audio/G726-16", "G726-16");
        this.addMapping("application/session-info", "session-info");
        this.addMapping("application/vnd.noblenet-directory", "vnd.noblenet-directory");
        this.addMapping("application/vnd.onepagertatp", "vnd.onepagertatp");
        this.addMapping("font/ttf", "ttf");
        this.addMapping("application/cms", "cms");
        this.addMapping("message/delivery-status", "delivery-status");
        this.addMapping("message/s-http", "s-http");
        this.addMapping("audio/G726-32", "G726-32");
        this.addMapping("application/octet-stream", "octet-stream");
        this.addMapping("application/activemessage", "activemessage");
        this.addMapping("application/vnd.3gpp.mcptt-mbms-usage-info+xml", "vnd.3gpp.mcptt-mbms-usage-info+xml");
        this.addMapping("application/rdf+xml", "rdf+xml");
        this.addMapping("video/3gpp2", "3gpp2");
        this.addMapping("application/vnd.dvb.ait", "vnd.dvb.ait");
        this.addMapping("application/davmount+xml", "davmount+xml");
        this.addMapping("application/patch-ops-error+xml", "patch-ops-error+xml");
        this.addMapping("application/vnd.windows.devicepairing", "vnd.windows.devicepairing");
        this.addMapping("application/index", "index");
        this.addMapping("audio/dsr-es201108", "dsr-es201108");
        this.addMapping("audio/G726-24", "G726-24");
        this.addMapping("application/coap-payload", "coap-payload");
        this.addMapping("application/vnd.openxmlformats-officedocument.spreadsheetml.revisionLog+xml", "vnd.openxmlformats-officedocument.spreadsheetml.revisionLog+xml");
        this.addMapping("application/tamp-community-update", "tamp-community-update");
        this.addMapping("application/xcap-caps+xml", "xcap-caps+xml");
        this.addMapping("application/vnd.siren+json", "vnd.siren+json");
        this.addMapping("application/cose-key", "cose-key");
        this.addMapping("application/vnd.llamagraphics.life-balance.exchange+xml", "vnd.llamagraphics.life-balance.exchange+xml");
        this.addMapping("application/tamp-status-response", "tamp-status-response");
        this.addMapping("application/vnd.osa.netdeploy", "vnd.osa.netdeploy");
        this.addMapping("image/fits", "fits");
        this.addMapping("application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml", "vnd.openxmlformats-officedocument.drawingml.diagramData+xml");
        this.addMapping("audio/ATRAC3", "ATRAC3");
        this.addMapping("application/set-registration-initiation", "set-registration-initiation");
        this.addMapping("application/mp21", "mp21");
        this.addMapping("multipart/related", "related");
        this.addMapping("application/vnd.software602.filler.form-xml-zip", "vnd.software602.filler.form-xml-zip");
        this.addMapping("text/strings", "strings");
        this.addMapping("application/vnd.heroku+json", "vnd.heroku+json");
        this.addMapping("application/vnd.etsi.tsl+xml", "vnd.etsi.tsl+xml");
        this.addMapping("application/vnd.motorola.iprm", "vnd.motorola.iprm");
        this.addMapping("video/DV", "DV");
        this.addMapping("application/vnd.openxmlformats-officedocument.drawingml.diagramLayout+xml", "vnd.openxmlformats-officedocument.drawingml.diagramLayout+xml");
        this.addMapping("application/ecmascript", "ecmascript");
        this.addMapping("application/vnd.swiftview-ics", "vnd.swiftview-ics");
        this.addMapping("application/vnd.kde.kpresenter", "vnd.kde.kpresenter");
        this.addMapping("application/vnd.kde.kontour", "vnd.kde.kontour");
        this.addMapping("application/vnd.uplanet.alert", "vnd.uplanet.alert");
        this.addMapping("image/vnd.xiff", "vnd.xiff");
        this.addMapping("application/vnd.collabio.xodocuments.document", "vnd.collabio.xodocuments.document");
        this.addMapping("application/vnd.oxli.countgraph", "vnd.oxli.countgraph");
        this.addMapping("application/vnd.syncml.dmddf+xml", "vnd.syncml.dmddf+xml");
        this.addMapping("application/PDX", "PDX");
        this.addMapping("text/vnd.IPTC.NITF", "vnd.IPTC.NITF");
        this.addMapping("application/vnd.comicbook+zip", "vnd.comicbook+zip");
        this.addMapping("application/dssc+der", "dssc+der");
        this.addMapping("application/pkcs10", "pkcs10");
        this.addMapping("application/pkcs12", "pkcs12");
        this.addMapping("text/troff", "troff");
        this.addMapping("image/cgm", "cgm");
        this.addMapping("application/vnd.radisys.msml-dialog-fax-sendrecv+xml", "vnd.radisys.msml-dialog-fax-sendrecv+xml");
        this.addMapping("application/vnd.cups-pdf", "vnd.cups-pdf");
        this.addMapping("application/vnd.sealed.net", "vnd.sealed.net");
        this.addMapping("application/resource-lists+xml", "resource-lists+xml");
        this.addMapping("application/vnd.cups-raster", "vnd.cups-raster");
        this.addMapping("application/vnd.etsi.pstn+xml", "vnd.etsi.pstn+xml");
        this.addMapping("application/atomicmail", "atomicmail");
        this.addMapping("application/vnd.oipf.pae.gem", "vnd.oipf.pae.gem");
        this.addMapping("application/vnd.mason+json", "vnd.mason+json");
        this.addMapping("application/vnd.sbm.cid", "vnd.sbm.cid");
        this.addMapping("application/EmergencyCallData.ProviderInfo+xml", "EmergencyCallData.ProviderInfo+xml");
        this.addMapping("application/vnd.mcd", "vnd.mcd");
        this.addMapping("application/xenc+xml", "xenc+xml");
        this.addMapping("audio/vnd.everad.plj", "vnd.everad.plj");
        this.addMapping("application/dns", "dns");
        this.addMapping("application/vnd.oasis.opendocument.text-master", "vnd.oasis.opendocument.text-master");
        this.addMapping("application/vnd.bluetooth.ep.oob", "vnd.bluetooth.ep.oob");
        this.addMapping("application/vnd.rapid", "vnd.rapid");
        this.addMapping("audio/MP4A-LATM", "MP4A-LATM");
        this.addMapping("application/vnd.xmpie.dpkg", "vnd.xmpie.dpkg");
        this.addMapping("text/rtx", "rtx");
        this.addMapping("application/vnd.dtg.local.flash", "vnd.dtg.local.flash");
        this.addMapping("text/vnd.esmertec.theme-descriptor", "vnd.esmertec.theme-descriptor");
        this.addMapping("audio/ATRAC-X", "ATRAC-X");
        this.addMapping("audio/UEMCLIP", "UEMCLIP");
        this.addMapping("application/vnd.wrq-hp3000-labelled", "vnd.wrq-hp3000-labelled");
        this.addMapping("image/vnd.net-fpx", "vnd.net-fpx");
        this.addMapping("application/vnd.yamaha.openscoreformat.osfpvg+xml", "vnd.yamaha.openscoreformat.osfpvg+xml");
        this.addMapping("application/srgs+xml", "srgs+xml");
        this.addMapping("application/vnd.mitsubishi.misty-guard.trustweb", "vnd.mitsubishi.misty-guard.trustweb");
        this.addMapping("application/applefile", "applefile");
        this.addMapping("audio/L16", "L16");
        this.addMapping("text/rtf", "rtf");
        this.addMapping("application/vnd.pmi.widget", "vnd.pmi.widget");
        this.addMapping("application/vnd.sun.wadl+xml", "vnd.sun.wadl+xml");
        this.addMapping("audio/mpeg4-generic", "mpeg4-generic");
        this.addMapping("audio/vnd.dra", "vnd.dra");
        this.addMapping("application/news-transmission", "news-transmission");
        this.addMapping("application/vnd.quobject-quoxdocument", "vnd.quobject-quoxdocument");
        this.addMapping("application/EmergencyCallData.DeviceInfo+xml", "EmergencyCallData.DeviceInfo+xml");
        this.addMapping("application/vnd.capasystems-pg+json", "vnd.capasystems-pg+json");
        this.addMapping("text/cache-manifest", "cache-manifest");
        this.addMapping("application/vnd.ms-windows.wsd.oob", "vnd.ms-windows.wsd.oob");
        this.addMapping("application/vnd.nokia.landmarkcollection+xml", "vnd.nokia.landmarkcollection+xml");
        this.addMapping("application/vnd.ms-windows.nwprinting.oob", "vnd.ms-windows.nwprinting.oob");
        this.addMapping("application/rpki-publication", "rpki-publication");
        this.addMapping("application/atomdeleted+xml", "atomdeleted+xml");
        this.addMapping("application/vnd.adobe.fxp", "vnd.adobe.fxp");
        this.addMapping("application/vnd.japannet-payment-wakeup", "vnd.japannet-payment-wakeup");
        this.addMapping("model/vnd.gdl", "vnd.gdl");
        this.addMapping("application/scvp-cv-response", "scvp-cv-response");
        this.addMapping("application/iges", "iges");
        this.addMapping("audio/G729D", "G729D");
        this.addMapping("audio/G729E", "G729E");
        this.addMapping("model/vnd.collada+xml", "vnd.collada+xml");
        this.addMapping("video/1d-interleaved-parityfec", "1d-interleaved-parityfec");
        this.addMapping("model/vnd.valve.source.compiled-map", "vnd.valve.source.compiled-map");
        this.addMapping("audio/raptorfec", "raptorfec");
        this.addMapping("audio/ulpfec", "ulpfec");
        this.addMapping("application/lostsync+xml", "lostsync+xml");
        this.addMapping("audio/vnd.dts", "vnd.dts");
        this.addMapping("video/vnd.objectvideo", "vnd.objectvideo");
        this.addMapping("application/vnd.3gpp.srvcc-ext+xml", "vnd.3gpp.srvcc-ext+xml");
        this.addMapping("application/vnd.businessobjects", "vnd.businessobjects");
        this.addMapping("application/vnd.ms-works", "vnd.ms-works");
        this.addMapping("application/vnd.xmi+xml", "vnd.xmi+xml");
        this.addMapping("image/vnd.fujixerox.edmics-rlc", "vnd.fujixerox.edmics-rlc");
        this.addMapping("application/vnd.dna", "vnd.dna");
        this.addMapping("application/vnd.lotus-screencam", "vnd.lotus-screencam");
        this.addMapping("application/vnd.aether.imp", "vnd.aether.imp");
        this.addMapping("application/vnd.dynageo", "vnd.dynageo");
        this.addMapping("application/vnd.fluxtime.clip", "vnd.fluxtime.clip");
        this.addMapping("audio/L24", "L24");
        this.addMapping("application/vnd.ms-windows.devicepairing", "vnd.ms-windows.devicepairing");
        this.addMapping("application/vnd.etsi.iptvsad-bc+xml", "vnd.etsi.iptvsad-bc+xml");
        this.addMapping("application/1d-interleaved-parityfec", "1d-interleaved-parityfec");
        this.addMapping("audio/L20", "L20");
        this.addMapping("application/vnd.collabio.xodocuments.spreadsheet-template", "vnd.collabio.xodocuments.spreadsheet-template");
        this.addMapping("application/mbox", "mbox");
        this.addMapping("application/prs.xsf+xml", "prs.xsf+xml");
        this.addMapping("application/reputon+json", "reputon+json");
        this.addMapping("application/vnd.dvb.iptv.alfec-base", "vnd.dvb.iptv.alfec-base");
        this.addMapping("application/mbms-register-response+xml", "mbms-register-response+xml");
        this.addMapping("audio/vnd.CELP", "vnd.CELP");
        this.addMapping("application/cnrp+xml", "cnrp+xml");
        this.addMapping("application/vnd.3gpp.mcptt-info+xml", "vnd.3gpp.mcptt-info+xml");
        this.addMapping("application/vnd.fastcopy-disk-image", "vnd.fastcopy-disk-image");
        this.addMapping("application/vnd.seemail", "vnd.seemail");
        this.addMapping("application/scvp-vp-response", "scvp-vp-response");
        this.addMapping("application/vnd.century-systems.tcp_stream", "vnd.century-systems.tcp_stream");
        this.addMapping("application/json-seq", "json-seq");
        this.addMapping("application/kpml-response+xml", "kpml-response+xml");
        this.addMapping("application/vnd.hp-PCLXL", "vnd.hp-PCLXL");
        this.addMapping("application/vnd.novadigm.EDM", "vnd.novadigm.EDM");
        this.addMapping("audio/fwdred", "fwdred");
        this.addMapping("application/vnd.etsi.iptvcommand+xml", "vnd.etsi.iptvcommand+xml");
        this.addMapping("application/vnd.novadigm.EDX", "vnd.novadigm.EDX");
        this.addMapping("application/vnd.muvee.style", "vnd.muvee.style");
        this.addMapping("application/xml-dtd", "xml-dtd");
        this.addMapping("application/vnd.collection+json", "vnd.collection+json");
        this.addMapping("audio/vnd.dolby.heaac.1", "vnd.dolby.heaac.1");
        this.addMapping("audio/vnd.dolby.heaac.2", "vnd.dolby.heaac.2");
        this.addMapping("application/tamp-status-query", "tamp-status-query");
        this.addMapping("application/rdap+json", "rdap+json");
        this.addMapping("application/vnd.etsi.tsl.der", "vnd.etsi.tsl.der");
        this.addMapping("application/vnd.infotech.project", "vnd.infotech.project");
        this.addMapping("application/vnd.radisys.msml-dialog-base+xml", "vnd.radisys.msml-dialog-base+xml");
        this.addMapping("audio/vnd.vmx.cvsd", "vnd.vmx.cvsd");
        this.addMapping("application/cea-2018+xml", "cea-2018+xml");
        this.addMapping("application/vnd.mapbox-vector-tile", "vnd.mapbox-vector-tile");
        this.addMapping("application/scim+json", "scim+json");
        this.addMapping("application/vnd.Mobius.MQY", "vnd.Mobius.MQY");
        this.addMapping("application/vnd.cyan.dean.root+xml", "vnd.cyan.dean.root+xml");
        this.addMapping("text/prs.fallenstein.rst", "prs.fallenstein.rst");
        this.addMapping("application/postscript", "postscript");
        this.addMapping("application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheDefinition+xml", "vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheDefinition+xml");
        this.addMapping("application/vnd.ms-ims", "vnd.ms-ims");
        this.addMapping("application/vnd.ipunplugged.rcprofile", "vnd.ipunplugged.rcprofile");
        this.addMapping("video/3gpp-tt", "3gpp-tt");
        this.addMapping("application/shf+xml", "shf+xml");
        this.addMapping("application/vnd.3gpp-v2x-local-service-information", "vnd.3gpp-v2x-local-service-information");
        this.addMapping("application/vnd.smart.teacher", "vnd.smart.teacher");
        this.addMapping("audio/vnd.dolby.mps", "vnd.dolby.mps");
        this.addMapping("application/vnd.fujitsu.oasysprs", "vnd.fujitsu.oasysprs");
        this.addMapping("application/vnd.spotfire.sfs", "vnd.spotfire.sfs");
        this.addMapping("application/vnd.marlin.drm.conftoken+xml", "vnd.marlin.drm.conftoken+xml");
        this.addMapping("video/encaprtp", "encaprtp");
        this.addMapping("video/vnd.dvb.file", "vnd.dvb.file");
        this.addMapping("audio/opus", "opus");
        this.addMapping("application/vnd.canon-cpdl", "vnd.canon-cpdl");
        this.addMapping("application/vnd.nintendo.snes.rom", "vnd.nintendo.snes.rom");
        this.addMapping("video/vnd.sealed.mpeg4", "vnd.sealed.mpeg4");
        this.addMapping("video/vnd.sealed.mpeg1", "vnd.sealed.mpeg1");
        this.addMapping("application/CEA", "CEA");
        this.addMapping("application/vnd.openxmlformats-officedocument.presentationml.presProps+xml", "vnd.openxmlformats-officedocument.presentationml.presProps+xml");
        this.addMapping("application/vnd.firemonkeys.cloudcell", "vnd.firemonkeys.cloudcell");
        this.addMapping("application/prs.hpub+zip", "prs.hpub+zip");
        this.addMapping("application/ld+json", "ld+json");
        this.addMapping("application/vnd.radisys.msml-audit-conf+xml", "vnd.radisys.msml-audit-conf+xml");
        this.addMapping("application/vnd.yellowriver-custom-menu", "vnd.yellowriver-custom-menu");
        this.addMapping("application/vnd.dvb.dvbj", "vnd.dvb.dvbj");
        this.addMapping("application/vnd.uplanet.listcmd", "vnd.uplanet.listcmd");
        this.addMapping("application/vnd.ecowin.filerequest", "vnd.ecowin.filerequest");
        this.addMapping("application/csrattrs", "csrattrs");
        this.addMapping("audio/telephone-event", "telephone-event");
        this.addMapping("application/vemmi", "vemmi");
        this.addMapping("application/n-triples", "n-triples");
        this.addMapping("application/smil+xml", "smil+xml");
        this.addMapping("application/vnd.cybank", "vnd.cybank");
        this.addMapping("text/markdown", "markdown");
        this.addMapping("application/dash+xml", "dash+xml");
        this.addMapping("application/vnd.micrografx-igx", "vnd.micrografx.igx");
        this.addMapping("application/vnd.recordare.musicxml+xml", "vnd.recordare.musicxml+xml");
        this.addMapping("image/vnd-wap-wbmp", "vnd.wap.wbmp");
        this.addMapping("model/vnd.moml+xml", "vnd.moml+xml");
        this.addMapping("application/calendar+xml", "calendar+xml");
        this.addMapping("application/vnd.frogans.fnc", "vnd.frogans.fnc");
        this.addMapping("application/vnd.globalplatform.card-content-mgt-response", "vnd.globalplatform.card-content-mgt-response");
        this.addMapping("application/vnd.wap.wmlscriptc", "vnd.wap.wmlscriptc");
        this.addMapping("model/iges", "iges");
        this.addMapping("application/mpeg4-iod", "mpeg4-iod");
        this.addMapping("application/vnd.ntt-local.sip-ta_remote", "vnd.ntt-local.sip-ta_remote");
        this.addMapping("application/xcap-att+xml", "xcap-att+xml");
        this.addMapping("application/vnd.cups-ppd", "vnd.cups-ppd");
        this.addMapping("application/vnd.publishare-delta-tree", "vnd.publishare-delta-tree");
        this.addMapping("multipart/report", "report");
        this.addMapping("application/vnd.qualcomm.brew-app-res", "vnd.qualcomm.brew-app-res");
        this.addMapping("application/vnd.tri.onesource", "vnd.tri.onesource");
        this.addMapping("application/gzip", "gzip");
        this.addMapping("video/BMPEG", "BMPEG");
        this.addMapping("audio/sp-midi", "sp-midi");
        this.addMapping("text/vnd.net2phone.commcenter.command", "vnd.net2phone.commcenter.command");
        this.addMapping("application/vnd.motorola.flexsuite.gotap", "vnd.motorola.flexsuite.gotap");
        this.addMapping("application/cybercash", "cybercash");
        this.addMapping("video/smpte291", "smpte291");
        this.addMapping("application/vnd.openxmlformats-officedocument.theme+xml", "vnd.openxmlformats-officedocument.theme+xml");
        this.addMapping("application/vnd.ms-excel.template.macroEnabled.12", "vnd.ms-excel.template.macroEnabled.12");
        this.addMapping("application/vnd.openxmlformats-officedocument.presentationml.notesSlide+xml", "vnd.openxmlformats-officedocument.presentationml.notesSlide+xml");
        this.addMapping("image/pwg-raster", "pwg-raster");
        this.addMapping("application/vnd.onepager", "vnd.onepager");
        this.addMapping("application/sbml+xml", "sbml+xml");
        this.addMapping("application/vnd.3gpp.ussd+xml", "vnd.3gpp.ussd+xml");
        this.addMapping("application/vnd.innopath.wamp.notification", "vnd.innopath.wamp.notification");
        this.addMapping("application/call-completion", "call-completion");
        this.addMapping("application/vnd.xara", "vnd.xara");
        this.addMapping("application/vnd.3gpp.mcptt-signed+xml", "vnd.3gpp.mcptt-signed+xml");
        this.addMapping("application/vnd.hal+xml", "vnd.hal+xml");
        this.addMapping("audio/G719", "G719");
        this.addMapping("application/simpleSymbolContainer", "simpleSymbolContainer");
        this.addMapping("application/vnd.wfa.p2p", "vnd.wfa.p2p");
        this.addMapping("application/mbms-associated-procedure-description+xml", "mbms-associated-procedure-description+xml");
        this.addMapping("application/vnd.ibm.electronic-media", "vnd.ibm.electronic-media");
        this.addMapping("application/vnd.pawaafile", "vnd.pawaafile");
        this.addMapping("application/wsdl+xml", "wsdl+xml");
        this.addMapping("application/vnd.epson.msf", "vnd.epson.msf");
        this.addMapping("application/vnd.oasis.opendocument.spreadsheet-template", "vnd.oasis.opendocument.spreadsheet-template");
        this.addMapping("application/trig", "trig");
        this.addMapping("application/vnd.3lightssoftware.imagescal", "vnd.3lightssoftware.imagescal");
        this.addMapping("application/vnd.xfdl.webform", "vnd.xfdl.webform");
        this.addMapping("audio/aptx", "aptx");
        this.addMapping("application/vnd.ms-office.activeX+xml", "vnd.ms-office.activeX+xml");
        this.addMapping("audio/G711-0", "G711-0");
        this.addMapping("application/vnd.FloGraphIt", "vnd.FloGraphIt");
        this.addMapping("application/vnd.collabio.xodocuments.document-template", "vnd.collabio.xodocuments.document-template");
        this.addMapping("application/vnd.HandHeld-Entertainment+xml", "vnd.HandHeld-Entertainment+xml");
        this.addMapping("application/vnd.intercon.formnet", "vnd.intercon.formnet");
        this.addMapping("multipart/encrypted", "encrypted");
        this.addMapping("audio/G729", "G729");
        this.addMapping("audio/G728", "G728");
        this.addMapping("application/vnd-acucobol", "vnd.acucobol");
        this.addMapping("multipart/appledouble", "appledouble");
        this.addMapping("audio/G723", "G723");
        this.addMapping("audio/G722", "G722");
        this.addMapping("application/xop+xml", "xop+xml");
        this.addMapping("application/vnd.openxmlformats-officedocument.drawingml.diagramColors+xml", "vnd.openxmlformats-officedocument.drawingml.diagramColors+xml");
        this.addMapping("video/quicktime", "quicktime");
        this.addMapping("video/mp4", "mp4");
        this.addMapping("application/vnd.collabio.xodocuments.presentation", "vnd.collabio.xodocuments.presentation");
        this.addMapping("application/vnd.openxmlformats-officedocument.wordprocessingml.fontTable+xml", "vnd.openxmlformats-officedocument.wordprocessingml.fontTable+xml");
        this.addMapping("application/vnd.3gpp.sms", "vnd.3gpp.sms");
        this.addMapping("audio/vnd.nortel.vbk", "vnd.nortel.vbk");
        this.addMapping("image/vnd.valve.source.texture", "vnd.valve.source.texture");
        this.addMapping("application/mads+xml", "mads+xml");
        this.addMapping("application/vnd.japannet-directory-service", "vnd.japannet-directory-service");
        this.addMapping("application/vnd.oma.scidm.messages+xml", "vnd.oma.scidm.messages+xml");
        this.addMapping("application/vnd.intertrust.digibox", "vnd.intertrust.digibox");
        this.addMapping("text/vnd.wap-wml", "vnd.wap.wml");
        this.addMapping("application/p2p-overlay+xml", "p2p-overlay+xml");
        this.addMapping("application/vnd.paos+xml", "vnd.paos.xml");
        this.addMapping("application/vnd.hhe.lesson-player", "vnd.hhe.lesson-player");
        this.addMapping("video/3gpp", "3gpp");
        this.addMapping("application/media_control+xml", "media_control+xml");
        this.addMapping("model/vnd-dwf", "vnd.dwf");
        this.addMapping("audio/L8", "L8");
        this.addMapping("application/soap+fastinfoset", "soap+fastinfoset");
        this.addMapping("application/vnd.claymore", "vnd.claymore");
        this.addMapping("text/1d-interleaved-parityfec", "1d-interleaved-parityfec");
        this.addMapping("application/vnd.acucorp", "vnd.acucorp");
        this.addMapping("application/vnd.chess-pgn", "vnd.chess-pgn");
        this.addMapping("application/vnd.nervana", "vnd.nervana");
        this.addMapping("application/vnd.Mobius.MSL", "vnd.Mobius.MSL");
        this.addMapping("application/vnd.artsquare", "vnd.artsquare");
        this.addMapping("application/vnd.openxmlformats-officedocument.drawingml.chart+xml", "vnd.openxmlformats-officedocument.drawingml.chart+xml");
        this.addMapping("application/vnd.hydrostatix.sof-data", "vnd.hydrostatix.sof-data");
        this.addMapping("application/pidf-diff+xml", "pidf-diff+xml");
        this.addMapping("application/scaip+xml", "scaip+xml");
        this.addMapping("application/vnd.ms-officetheme", "vnd.ms-officetheme");
        this.addMapping("application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml", "vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml");
        this.addMapping("application/vnd.ericsson.quickcall", "vnd.ericsson.quickcall");
        this.addMapping("application/vnd.marlin.drm.mdcf", "vnd.marlin.drm.mdcf");
        this.addMapping("application/problem+json", "problem+json");
        this.addMapping("application/vnd.vcx", "vnd.vcx");
        this.addMapping("application/dca-rft", "dca-rft");
        this.addMapping("application/ibe-pkg-reply+xml", "ibe-pkg-reply+xml");
        this.addMapping("application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml", "vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml");
        this.addMapping("text/vnd.fly", "vnd.fly");
        this.addMapping("application/ATF", "ATF");
        this.addMapping("audio/EVRC", "EVRC");
        this.addMapping("application/vnd.dvb.notif-aggregate-root+xml", "vnd.dvb.notif-aggregate-root+xml");
        this.addMapping("application/vnd.uplanet.listcmd-wbxml", "vnd.uplanet.listcmd-wbxml");
        this.addMapping("application/vnd.3gpp2.bcmcsinfo+xml", "vnd.3gpp2.bcmcsinfo+xml");
        this.addMapping("application/inkml+xml", "inkml+xml");
        this.addMapping("model/vnd.gtw", "vnd.gtw");
        this.addMapping("application/vnd.etsi.iptvdiscovery+xml", "vnd.etsi.iptvdiscovery+xml");
        this.addMapping("application/vnd.motorola.flexsuite.kmr", "vnd.motorola.flexsuite.kmr");
        this.addMapping("application/vnd.etsi.mheg5", "vnd.etsi.mheg5");
        this.addMapping("application/vnd.cluetrust.cartomobile-config-pkg", "vnd.cluetrust.cartomobile-config-pkg");
        this.addMapping("application/vnd.oipf.spdlist+xml", "vnd.oipf.spdlist+xml");
        this.addMapping("video/vnd.radgamettools.bink", "vnd.radgamettools.bink");
        this.addMapping("application/vnd.emclient.accessrequest+xml", "vnd.emclient.accessrequest+xml");
        this.addMapping("application/vnd.3gpp.pic-bw-large", "vnd.3gpp.pic-bw-large");
        this.addMapping("application/vnd.openxmlformats-officedocument.spreadsheetml.userNames+xml", "vnd.openxmlformats-officedocument.spreadsheetml.userNames+xml");
        this.addMapping("application/msc-mixer+xml", "msc-mixer+xml");
        this.addMapping("application/vnd.oma.poc.invocation-descriptor+xml", "vnd.oma.poc.invocation-descriptor+xml");
        this.addMapping("video/mpeg4-generic", "mpeg4-generic");
        this.addMapping("text/vnd.latex-z", "vnd.latex-z");
        this.addMapping("font/otf", "otf");
        this.addMapping("video/BT656", "BT656");
        this.addMapping("application/vnd.oma.cab-address-book+xml", "vnd.oma.cab-address-book+xml");
        this.addMapping("application/vnd.dvb.notif-ia-registration-request+xml", "vnd.dvb.notif-ia-registration-request+xml");
        this.addMapping("application/ibe-pp-data", "ibe-pp-data");
        this.addMapping("application/vnd.dvb.ipdcesgpdd", "vnd.dvb.ipdcesgpdd");
        this.addMapping("application/vnd.oma.poc.final-report+xml", "vnd.oma.poc.final-report+xml");
        this.addMapping("application/vnd.hyper-item+json", "vnd.hyper-item+json");
        this.addMapping("text/fwdred", "fwdred");
        this.addMapping("application/pkix-crl", "pkix-crl");
        this.addMapping("image/vnd.ms-modi", "vnd.ms-modi");
        this.addMapping("application/vnd.oma.bcast.imd+xml", "vnd.oma.bcast.imd+xml");
        this.addMapping("video/vc1", "vc1");
        this.addMapping("application/vnd.oasis.opendocument.presentation-template", "vnd.oasis.opendocument.presentation-template");
        this.addMapping("application/thraud+xml", "thraud+xml");
        this.addMapping("application/vnd.gov.sk.xmldatacontainer+xml", "vnd.gov.sk.xmldatacontainer+xml");
        this.addMapping("application/vnd-fdf", "vnd.fdf");
        this.addMapping("application/jose+json", "jose+json");
        this.addMapping("application/pkixcmp", "pkixcmp");
        this.addMapping("application/vnd.ibm.secure-container", "vnd.ibm.secure-container");
        this.addMapping("text/vnd.debian.copyright", "vnd.debian.copyright");
        this.addMapping("application/samlassertion+xml", "samlassertion+xml");
        this.addMapping("application/xcon-conference-info+xml", "xcon-conference-info+xml");
        this.addMapping("application/vnd.wap.sic", "vnd.wap.sic");
        this.addMapping("application/mbms-protection-description+xml", "mbms-protection-description+xml");
        this.addMapping("application/vnd.oma.cab-feature-handler+xml", "vnd.oma.cab-feature-handler+xml");
        this.addMapping("application/vnd.jisp", "vnd.jisp");
        this.addMapping("application/vnd.collabio.xodocuments.spreadsheet", "vnd.collabio.xodocuments.spreadsheet");
        this.addMapping("video/vnd.dlna.mpeg-tts", "vnd.dlna.mpeg-tts");
        this.addMapping("application/sql", "sql");
        this.addMapping("application/vnd.motorola.flexsuite", "vnd.motorola.flexsuite");
        this.addMapping("application/vnd.intergeo", "vnd.intergeo");
        this.addMapping("application/vnd.avalon+json", "vnd.avalon+json");
        this.addMapping("application/vnd.dtg.local", "vnd.dtg.local");
        this.addMapping("application/vnd.msa-disk-image", "vnd.msa-disk-image");
        this.addMapping("application/vnd.sealedmedia.softseal-html", "vnd.sealedmedia.softseal.html");
        this.addMapping("application/CSTAdata+xml", "CSTAdata+xml");
        this.addMapping("application/vnd.ms-project", "vnd.ms-project");
        this.addMapping("application/vnd.blink-idb-value-wrapper", "vnd.blink-idb-value-wrapper");
        this.addMapping("application/vnd.oasis.opendocument.text-template", "vnd.oasis.opendocument.text-template");
        this.addMapping("application/mbms-register+xml", "mbms-register+xml");
        this.addMapping("application/webpush-options+json", "webpush-options+json");
        this.addMapping("application/vnd.amadeus+json", "vnd.amadeus+json");
        this.addMapping("application/vnd.uplanet.cacheop-wbxml", "vnd.uplanet.cacheop-wbxml");
        this.addMapping("application/route-usd+xml", "route-usd+xml");
        this.addMapping("application/vnd-dart", "vnd.dart");
        this.addMapping("application/sieve", "sieve");
        this.addMapping("application/QSIG", "qsig");
        this.addMapping("audio/mobile-xmf", "mobile-xmf");
        this.addMapping("application/mods+xml", "mods+xml");
        this.addMapping("application/EDI-X12", "EDI-X12");
        this.addMapping("application/vnd.fut-misnet", "vnd.fut-misnet");
        this.addMapping("text/dns", "dns");
        this.addMapping("application/vnd.ms-powerpoint.slideshow.macroEnabled.12", "vnd.ms-powerpoint.slideshow.macroEnabled.12");
        this.addMapping("application/vnd.3gpp.mcptt-floor-request+xml", "vnd.3gpp.mcptt-floor-request+xml");
        this.addMapping("application/vnd.oasis.opendocument.formula-template", "vnd.oasis.opendocument.formula-template");
        this.addMapping("application/vnd-sema", "vnd.sema");
        this.addMapping("application/vnd.xfdl", "vnd.xfdl");
        this.addMapping("application/vnd.yaoweme", "vnd.yaoweme");
        this.addMapping("application/vnd.groove-account", "vnd.groove-account");
        this.addMapping("application/vnd.ms-powerpoint", "vnd.ms-powerpoint");
        this.addMapping("application/vnd.dzr", "vnd.dzr");
        this.addMapping("image/tiff", "tiff");
        this.addMapping("application/vnd.dece.unspecified", "vnd.dece.unspecified");
        this.addMapping("application/vnd.uplanet.channel", "vnd.uplanet.channel");
        this.addMapping("application/vnd.wt.stf", "vnd.wt.stf");
        this.addMapping("application/vnd.etsi.asic-e+zip", "vnd.etsi.asic-e+zip");
        this.addMapping("application/vnd.SimTech-MindMapper", "vnd.SimTech-MindMapper");
        this.addMapping("application/vnd.oipf.dae.xhtml+xml", "vnd.oipf.dae.xhtml+xml");
        this.addMapping("application/widget", "widget");
        this.addMapping("audio/MELP2400", "MELP2400");
        this.addMapping("application/vnd.dataresource+json", "vnd.dataresource+json");
        this.addMapping("audio/BV16", "BV16");
        this.addMapping("application/vnd.oma.dd2+xml", "vnd.oma.dd2+xml");
        this.addMapping("application/vnd.hp-hpid", "vnd.hp-hpid");
        this.addMapping("application/vnd.openxmlformats-officedocument.presentationml.viewProps+xml", "vnd.openxmlformats-officedocument.presentationml.viewProps+xml");
        this.addMapping("application/vnd.oma.dcd", "vnd.oma.dcd");
        this.addMapping("image/example", "example");
        this.addMapping("application/vnd.uplanet.list", "vnd.uplanet.list");
        this.addMapping("application/vnd.las.las+xml", "vnd.las.las+xml");
        this.addMapping("application/vnd.sss-cod", "vnd.sss-cod");
        this.addMapping("text/vnd.dvb.subtitle", "vnd.dvb.subtitle");
        this.addMapping("application/vnd.cups-postscript", "vnd.cups-postscript");
        this.addMapping("application/vnd.isac.fcs", "vnd.isac.fcs");
        this.addMapping("application/calendar+json", "calendar+json");
        this.addMapping("application/vnd.hyperdrive+json", "vnd.hyperdrive+json");
        this.addMapping("application/vnd.stepmania.stepchart", "vnd.stepmania.stepchart");
        this.addMapping("application/vnd.uoml+xml", "vnd.uoml+xml");
        this.addMapping("application/vnd.irepository.package+xml", "vnd.irepository.package+xml");
        this.addMapping("application/vnd.oma.lwm2m+json", "vnd.oma.lwm2m+json");
        this.addMapping("audio/ac3", "ac3");
        this.addMapping("audio/tone", "tone");
        this.addMapping("application/vnd.ctct.ws+xml", "vnd.ctct.ws+xml");
        this.addMapping("video/mj2", "mj2");
        this.addMapping("application/vnd.doremir.scorecloud-binary-document", "vnd.doremir.scorecloud-binary-document");
        this.addMapping("application/ogg", "ogg");
        this.addMapping("application/vnd.amiga.ami", "vnd.amiga.ami");
        this.addMapping("video/vnd.fvt", "vnd.fvt");
        this.addMapping("text/vnd.ascii-art", "vnd.ascii-art");
        this.addMapping("application/vnd.openxmlformats-officedocument.presentationml.slideUpdateInfo+xml", "vnd.openxmlformats-officedocument.presentationml.slideUpdateInfo+xml");
        this.addMapping("audio/BV32", "BV32");
        this.addMapping("audio/vnd.digital-winds", "vnd.digital-winds");
        this.addMapping("application/vnd.ibm.rights-management", "vnd.ibm.rights-management");
        this.addMapping("audio/vorbis-config", "vorbis-config");
        this.addMapping("video/vnd.dece.video", "vnd.dece.video");
        this.addMapping("video/vnd.motorola.videop", "vnd.motorola.videop");
        this.addMapping("image/prs.btif", "prs.btif");
        this.addMapping("application/vnd.solent.sdkm+xml", "vnd.solent.sdkm+xml");
        this.addMapping("application/vnd.canon-lips", "vnd.canon-lips");
        this.addMapping("application/atomcat+xml", "atomcat+xml");
        this.addMapping("application/alto-directory+json", "alto-directory+json");
        this.addMapping("application/vnd.dtg.local-html", "vnd.dtg.local.html");
        this.addMapping("application/vnd.dvb.ipdcroaming", "vnd.dvb.ipdcroaming");
        this.addMapping("application/vnd.oma.group-usage-list+xml", "vnd.oma.group-usage-list+xml");
        this.addMapping("application/AML", "AML");
        this.addMapping("application/vnd.oma.cab-user-prefs+xml", "vnd.oma.cab-user-prefs+xml");
        this.addMapping("application/tve-trigger", "tve-trigger");
        this.addMapping("application/yang-patch+xml", "yang-patch+xml");
        this.addMapping("application/vnd.Kinar", "vnd.Kinar");
        this.addMapping("application/vnd.openblox.game-binary", "vnd.openblox.game-binary");
        this.addMapping("image/vnd.dxf", "vnd.dxf");
        this.addMapping("application/vnd.oma-scws-config", "vnd.oma-scws-config");
        this.addMapping("application/vnd.etsi.simservs+xml", "vnd.etsi.simservs+xml");
        this.addMapping("application/vnd.insors.igm", "vnd.insors.igm");
        this.addMapping("application/vnd.epson.esf", "vnd.epson.esf");
        this.addMapping("application/vnd.fuzzysheet", "vnd.fuzzysheet");
        this.addMapping("application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml", "vnd.openxmlformats-officedocument.spreadsheetml.table+xml");
        this.addMapping("application/hyperstudio", "hyperstudio");
        this.addMapping("application/vnd.americandynamics.acc", "vnd.americandynamics.acc");
        this.addMapping("application/vnd.openxmlformats-officedocument.presentationml.slide", "vnd.openxmlformats-officedocument.presentationml.slide");
        this.addMapping("audio/MELP", "MELP");
        this.addMapping("application/vcard+json", "vcard+json");
        this.addMapping("audio/mp4", "mp4");
        this.addMapping("application/dec-dx", "dec-dx");
        this.addMapping("application/vnd.mseq", "vnd.mseq");
        this.addMapping("application/framework-attributes+xml", "framework-attributes+xml");
        this.addMapping("application/pdf", "pdf");
        this.addMapping("multipart/voice-message", "voice-message");
        this.addMapping("application/vnd.oma.bcast.sgboot", "vnd.oma.bcast.sgboot");
        this.addMapping("application/vnd.cirpack.isdn-ext", "vnd.cirpack.isdn-ext");
        this.addMapping("video/vnd.iptvforum.ttsmpeg2", "vnd.iptvforum.ttsmpeg2");
        this.addMapping("application/EmergencyCallData.eCall.MSD", "EmergencyCallData.eCall.MSD");
        this.addMapping("audio/vnd.rhetorex.32kadpcm", "vnd.rhetorex.32kadpcm");
        this.addMapping("application/vnd.openxmlformats-officedocument.wordprocessingml.footer+xml", "vnd.openxmlformats-officedocument.wordprocessingml.footer+xml");
        this.addMapping("application/vnd.openxmlformats-officedocument.presentationml-template", "vnd.openxmlformats-officedocument.presentationml.template");
        this.addMapping("application/vnd.openstreetmap.data+xml", "vnd.openstreetmap.data+xml");
        this.addMapping("image/vnd.mix", "vnd.mix");
        this.addMapping("application/vnd.sealedmedia.softseal-pdf", "vnd.sealedmedia.softseal.pdf");
        this.addMapping("multipart/byteranges", "byteranges");
        this.addMapping("audio/MELP600", "MELP600");
        this.addMapping("application/vnd.verimatrix.vcas", "vnd.verimatrix.vcas");
        this.addMapping("video/rtp-enc-aescm128", "rtp-enc-aescm128");
        this.addMapping("application/vnd.umajin", "vnd.umajin");
        this.addMapping("video/H264-RCDO", "H264-RCDO");
        this.addMapping("application/vnd.dir-bi.plate-dl-nosuffix", "vnd.dir-bi.plate-dl-nosuffix");
        this.addMapping("application/vnd.minisoft-hp3000-save", "vnd.minisoft-hp3000-save");
        this.addMapping("application/vnd.nearst.inv+json", "vnd.nearst.inv+json");
        this.addMapping("application/vnd.jsk.isdn-ngn", "vnd.jsk.isdn-ngn");
        this.addMapping("application/vnd.yamaha.smaf-phrase", "vnd.yamaha.smaf-phrase");
        this.addMapping("application/vnd.motorola.flexsuite.ttc", "vnd.motorola.flexsuite.ttc");
        this.addMapping("application/xml-patch+xml", "xml-patch+xml");
        this.addMapping("application/ODA", "oda");
        this.addMapping("image/g3fax", "g3fax");
        this.addMapping("application/vnd.meridian-slingshot", "vnd.meridian-slingshot");
        this.addMapping("message/feedback-report", "feedback-report");
        this.addMapping("application/cdni", "cdni");
        this.addMapping("application/resource-lists-diff+xml", "resource-lists-diff+xml");
        this.addMapping("application/vnd.collabio.xodocuments.presentation-template", "vnd.collabio.xodocuments.presentation-template");
        this.addMapping("image/vnd.dwg", "vnd.dwg");
        this.addMapping("audio/dsr-es202211", "dsr-es202211");
        this.addMapping("application/vnd.groove-tool-message", "vnd.groove-tool-message");
        this.addMapping("audio/DAT12", "DAT12");
        this.addMapping("text/rfc822-headers", "rfc822-headers");
        this.addMapping("application/oxps", "oxps");
        this.addMapping("application/tnauthlist", "tnauthlist");
        this.addMapping("application/vnd.mfmp", "vnd.mfmp");
        this.addMapping("audio/vnd.dvb.file", "vnd.dvb.file");
        this.addMapping("application/ODX", "ODX");
        this.addMapping("application/vnd.oasis.opendocument.chart-template", "vnd.oasis.opendocument.chart-template");
        this.addMapping("video/H263-2000", "H263-2000");
        this.addMapping("audio/vnd.cisco.nse", "vnd.cisco.nse");
        this.addMapping("audio/dsr-es202212", "dsr-es202212");
        this.addMapping("application/vnd.shana.informed.package", "vnd.shana.informed.package");
        this.addMapping("application/fits", "fits");
        this.addMapping("application/vnd.osgeo.mapguide.package", "vnd.osgeo.mapguide.package");
        this.addMapping("application/route-s-tsid+xml", "route-s-tsid+xml");
        this.addMapping("application/vnd.openxmlformats-officedocument.customXmlProperties+xml", "vnd.openxmlformats-officedocument.customXmlProperties+xml");
        this.addMapping("application/vnd.adobe.partial-upload", "vnd.adobe.partial-upload");
        this.addMapping("application/vnd.etsi.cug+xml", "vnd.etsi.cug+xml");
        this.addMapping("application/vnd.fints", "vnd.fints");
        this.addMapping("audio/LPC", "LPC");
        this.addMapping("application/vnd.efi-iso", "vnd.efi.iso");
        this.addMapping("application/vnd.openxmlformats-officedocument.spreadsheetml-template", "vnd.openxmlformats-officedocument.spreadsheetml.template");
        this.addMapping("application/cfw", "cfw");
        this.addMapping("application/vnd.ms-3mfdocument", "vnd.ms-3mfdocument");
        this.addMapping("application/vnd.oma-scws-http-response", "vnd.oma-scws-http-response");
        this.addMapping("application/commonground", "commonground");
        this.addMapping("text/vnd.graphviz", "vnd.graphviz");
        this.addMapping("text/vnd.in3d.spot", "vnd.in3d.spot");
        this.addMapping("application/vnd.yamaha.remote-setup", "vnd.yamaha.remote-setup");
        this.addMapping("application/vnd.openxmlformats-officedocument.custom-properties+xml", "vnd.openxmlformats-officedocument.custom-properties+xml");
        this.addMapping("application/vnd.powerbuilder7", "vnd.powerbuilder7");
        this.addMapping("application/vnd.omads-file+xml", "vnd.omads-file+xml");
        this.addMapping("application/vnd.ims.lti.v2.toolsettings+json", "vnd.ims.lti.v2.toolsettings+json");
        this.addMapping("application/vnd.openxmlformats-officedocument.spreadsheetml.sheetMetadata+xml", "vnd.openxmlformats-officedocument.spreadsheetml.sheetMetadata+xml");
        this.addMapping("application/vnd.vsf", "vnd.vsf");
        this.addMapping("application/jwk-set+json", "jwk-set+json");
        this.addMapping("application/vnd.openxmlformats-officedocument.presentationml.comments+xml", "vnd.openxmlformats-officedocument.presentationml.comments+xml");
        this.addMapping("application/vnd.ctc-posml", "vnd.ctc-posml");
        this.addMapping("application/vnd.bint.med-content", "vnd.bint.med-content");
        this.addMapping("application/cdmi-container", "cdmi-container");
        this.addMapping("application/mrb-consumer+xml", "mrb-consumer+xml");
        this.addMapping("application/vnd.dvb.notif-ia-msglist+xml", "vnd.dvb.notif-ia-msglist+xml");
        this.addMapping("application/vnd.powerbuilder6", "vnd.powerbuilder6");
        this.addMapping("application/vnd.ntt-local.content-share", "vnd.ntt-local.content-share");
        this.addMapping("application/EDI-consent", "EDI-consent");
        this.addMapping("application/vnd.sealed-ppt", "vnd.sealed.ppt");
        this.addMapping("message/global-disposition-notification", "global-disposition-notification");
        this.addMapping("application/vnd.oma.bcast.sgdu", "vnd.oma.bcast.sgdu");
        this.addMapping("application/fastinfoset", "fastinfoset");
        this.addMapping("application/vnd.oipf.spdiscovery+xml", "vnd.oipf.spdiscovery+xml");
        this.addMapping("application/mpeg4-iod-xmt", "mpeg4-iod-xmt");
        this.addMapping("application/vnd.gerber", "vnd.gerber");
        this.addMapping("application/vnd.yamaha.hv-dic", "vnd.yamaha.hv-dic");
        this.addMapping("application/encaprtp", "encaprtp");
        this.addMapping("text/vnd.wap.wmlscript", "vnd.wap.wmlscript");
        this.addMapping("model/example", "example");
        this.addMapping("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml", "vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml");
        this.addMapping("video/vnd.ms-playready.media.pyv", "vnd.ms-playready.media.pyv");
        this.addMapping("application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml", "vnd.openxmlformats-officedocument.presentationml.slideLayout+xml");
        this.addMapping("application/remote-printing", "remote-printing");
        this.addMapping("application/vnd.onepagertat", "vnd.onepagertat");
        this.addMapping("application/vnd.webturbo", "vnd.webturbo");
        this.addMapping("application/vnd.radisys.msml+xml", "vnd.radisys.msml+xml");
        this.addMapping("image/vnd.cns.inf2", "vnd.cns.inf2");
        this.addMapping("application/vnd.api+json", "vnd.api+json");
        this.addMapping("application/vnd.wolfram.mathematica", "vnd.wolfram.mathematica");
        this.addMapping("application/lost+xml", "lost+xml");
        this.addMapping("application/urc-targetdesc+xml", "urc-targetdesc+xml");
        this.addMapping("application/vnd.ims.lti.v2.toolproxy+json", "vnd.ims.lti.v2.toolproxy+json");
        this.addMapping("application/vnd.radisys.msml-audit-conn+xml", "vnd.radisys.msml-audit-conn+xml");
        this.addMapping("application/vnd.piaccess.application-licence", "vnd.piaccess.application-licence");
        this.addMapping("audio/vnd.lucent.voice", "vnd.lucent.voice");
        this.addMapping("application/mpeg4-generic", "mpeg4-generic");
        this.addMapping("text/encaprtp", "encaprtp");
        this.addMapping("text/parameters", "parameters");
        this.addMapping("application/vnd.openxmlformats-officedocument.wordprocessingml.document.glossary+xml", "vnd.openxmlformats-officedocument.wordprocessingml.document.glossary+xml");
        this.addMapping("application/beep+xml", "beep+xml");
        this.addMapping("application/vnd.fdsn.mseed", "vnd.fdsn.mseed");
        this.addMapping("application/vnd.pwg-multiplexed", "vnd.pwg-multiplexed");
        this.addMapping("application/vnd.oma.bcast.stkm", "vnd.oma.bcast.stkm");
        this.addMapping("application/geo+json-seq", "geo+json-seq");
        this.addMapping("application/vnd.ms-lrm", "vnd.ms-lrm");
        this.addMapping("application/csta+xml", "csta+xml");
        this.addMapping("text/calendar", "calendar");
        this.addMapping("application/vnd.kodak-descriptor", "vnd.kodak-descriptor");
        this.addMapping("application/xml", "xml");
        this.addMapping("audio/DV", "DV");
        this.addMapping("application/vnd.macports.portpkg", "vnd.macports.portpkg");
        this.addMapping("video/vnd.dece.mobile", "vnd.dece.mobile");
        this.addMapping("application/vnd.evolv.ecig.profile", "vnd.evolv.ecig.profile");
        this.addMapping("application/vnd.marlin.drm.license+xml", "vnd.marlin.drm.license+xml");
        this.addMapping("application/vnd.oma.bcast.smartcard-trigger+xml", "vnd.oma.bcast.smartcard-trigger+xml");
        this.addMapping("application/pkcs7-signature", "pkcs7-signature");
        this.addMapping("application/vnd.enliven", "vnd.enliven");
        this.addMapping("application/vnd.immervision-ivu", "vnd.immervision-ivu");
        this.addMapping("multipart/example", "example");
        this.addMapping("application/vnd.bluetooth.le.oob", "vnd.bluetooth.le.oob");
        this.addMapping("application/vnd.ecowin.series", "vnd.ecowin.series");
        this.addMapping("application/vnd.immervision-ivp", "vnd.immervision-ivp");
        this.addMapping("application/pkix-pkipath", "pkix-pkipath");
        this.addMapping("application/slate", "slate");
        this.addMapping("application/vnd.zul", "vnd.zul");
        this.addMapping("application/vnd.xmpie.cpkg", "vnd.xmpie.cpkg");
        this.addMapping("audio/EVRCWB0", "EVRCWB0");
        this.addMapping("audio/EVRCWB1", "EVRCWB1");
        this.addMapping("audio/CN", "CN");
        this.addMapping("application/vnd.netfpx", "vnd.netfpx");
        this.addMapping("application/voucher-cms+json", "voucher-cms+json");
        this.addMapping("application/vnd.llamagraphics.life-balance.desktop", "vnd.llamagraphics.life-balance.desktop");
        this.addMapping("application/vnd.cendio.thinlinc.clientconf", "vnd.cendio.thinlinc.clientconf");
        this.addMapping("application/vnd.openxmlformats-officedocument.extended-properties+xml", "vnd.openxmlformats-officedocument.extended-properties+xml");
        this.addMapping("application/rpki-ghostbusters", "rpki-ghostbusters");
        this.addMapping("application/vnd.wolfram.player", "vnd.wolfram.player");
        this.addMapping("application/xcap-error+xml", "xcap-error+xml");
        this.addMapping("application/vnd.apache.thrift.compact", "vnd.apache.thrift.compact");
        this.addMapping("video/vnd.nokia.interleaved-multimedia", "vnd.nokia.interleaved-multimedia");
        this.addMapping("application/simple-filter+xml", "simple-filter+xml");
        this.addMapping("application/vnd.oasis.opendocument.graphics", "vnd.oasis.opendocument.graphics");
        this.addMapping("application/pskc+xml", "pskc+xml");
        this.addMapping("audio/rtp-enc-aescm128", "rtp-enc-aescm128");
        this.addMapping("application/vnd.trueapp", "vnd.trueapp");
        this.addMapping("multipart/header-set", "header-set");
        this.addMapping("audio/EVRC-QCP", "EVRC-QCP");
        this.addMapping("application/vnd.vel+json", "vnd.vel+json");
        this.addMapping("application/vnd.radisys.moml+xml", "vnd.radisys.moml+xml");
        this.addMapping("application/vnd.openxmlformats-officedocument.drawingml.chartshapes+xml", "vnd.openxmlformats-officedocument.drawingml.chartshapes+xml");
        this.addMapping("application/vnd.syncml.dm.notification", "vnd.syncml.dm.notification");
        this.addMapping("application/vnd.oipf.userprofile+xml", "vnd.oipf.userprofile+xml");
        this.addMapping("font/collection", "collection");
        this.addMapping("application/vnd.coffeescript", "vnd.coffeescript");
        this.addMapping("application/alto-costmap+json", "alto-costmap+json");
        this.addMapping("image/tiff-fx", "tiff-fx");
        this.addMapping("multipart/signed", "signed");
        this.addMapping("audio/rtp-midi", "rtp-midi");
        this.addMapping("application/vnd.etsi.overload-control-policy-dataset+xml", "vnd.etsi.overload-control-policy-dataset+xml");
        this.addMapping("application/vnd.rar", "vnd.rar");
        this.addMapping("application/mrb-publish+xml", "mrb-publish+xml");
        this.addMapping("application/rfc+xml", "rfc+xml");
        this.addMapping("application/vnd.japannet-verification", "vnd.japannet-verification");
        this.addMapping("application/vnd.bbf.usp.msg+json", "vnd.bbf.usp.msg+json");
        this.addMapping("application/vnd.efi-img", "vnd.efi.img");
        this.addMapping("application/vnd.adobe.xdp+xml", "vnd.adobe.xdp+xml");
        this.addMapping("application/vnd.nitf", "vnd.nitf");
        this.addMapping("application/vnd.openeye.oeb", "vnd.openeye.oeb");
        this.addMapping("audio/amr-wb+", "amr-wb+");
        this.addMapping("application/vnd.apothekende.reservation+json", "vnd.apothekende.reservation+json");
        this.addMapping("application/vnd.3gpp.sms+xml", "vnd.3gpp.sms+xml");
        this.addMapping("text/xml-external-parsed-entity", "xml-external-parsed-entity");
        this.addMapping("application/vnd.wfa.wsc", "vnd.wfa.wsc");
        this.addMapping("application/vnd.yamaha.tunnel-udpencap", "vnd.yamaha.tunnel-udpencap");
        this.addMapping("application/marcxml+xml", "marcxml+xml");
        this.addMapping("application/mbms-msk-response+xml", "mbms-msk-response+xml");
        this.addMapping("application/vnd.ms-fontobject", "vnd.ms-fontobject");
    }

    protected void addMapping(@NotNull String mimeType, @NotNull String fileExtension) {
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
            Intrinsics.checkParameterIsNotNull((Object)fileExtension, (String)"fileExtension");
            String string = fileExtension;
            String string2 = string.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
            String fileExtensionLowerCased = string2;
            if (!this.fileExtensionsToMimeTypeMap.containsKey(fileExtensionLowerCased)) {
                this.fileExtensionsToMimeTypeMap.put(fileExtensionLowerCased, new LinkedHashSet());
            }
            Set<String> set = this.fileExtensionsToMimeTypeMap.get(fileExtensionLowerCased);
            if (set != null) {
                set.add(mimeType);
            }
            String string3 = mimeType;
            String string4 = string3.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
            String mimeTypeLowerCased = string4;
            if (!this.mimeTypesMap.containsKey(mimeTypeLowerCased)) {
                this.mimeTypesMap.put(mimeTypeLowerCased, new LinkedHashSet());
            }
            Set<String> set2 = this.mimeTypesMap.get(mimeTypeLowerCased);
            if (set2 == null) break block3;
            set2.add(fileExtension);
        }
    }

    @NotNull
    protected final MimeTypePicker getPicker() {
        return this.picker;
    }

    @JvmOverloads
    public MimeTypeDetector(@NotNull MimeTypePicker picker) {
        Intrinsics.checkParameterIsNotNull((Object)picker, (String)"picker");
        this.picker = picker;
        this.mimeTypesMap = new HashMap();
        this.fileExtensionsToMimeTypeMap = new HashMap();
        this.generateMimeTypeToFileExtensionMapping();
    }

    @JvmOverloads
    public /* synthetic */ MimeTypeDetector(MimeTypePicker mimeTypePicker, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            mimeTypePicker = new MimeTypePicker();
        }
        this(mimeTypePicker);
    }

    @JvmOverloads
    public MimeTypeDetector() {
        this(null, 1, null);
    }
}

