/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.mime.service.creator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.dankito.mime.service.FileDownloader;
import net.dankito.mime.service.creator.MimeTypeFileParserBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\n0\b2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u001c\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\n\u0018\u00010\bH\u0016J$\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\n\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\tH\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lnet/dankito/mime/service/creator/SitePointMimeTypeWebsiteParser;", "Lnet/dankito/mime/service/creator/MimeTypeFileParserBase;", "downloader", "Lnet/dankito/mime/service/FileDownloader;", "(Lnet/dankito/mime/service/FileDownloader;)V", "getDownloader", "()Lnet/dankito/mime/service/FileDownloader;", "parseMediaTypesTable", "", "", "", "tableElement", "Lorg/jsoup/nodes/Element;", "parseSitePointWebsite", "html", "Companion", "mime-utils"})
public class SitePointMimeTypeWebsiteParser
extends MimeTypeFileParserBase {
    @NotNull
    private final FileDownloader downloader;
    @NotNull
    public static final String SitePointMimeTypesWebsiteUrl = "https://www.sitepoint.com/mime-types-complete-list/";
    private static final Logger log;
    public static final Companion Companion;

    @Nullable
    public Map<String, Set<String>> parseSitePointWebsite() {
        String string = this.downloader.get(SitePointMimeTypesWebsiteUrl).getDownloadedContent();
        if (string != null) {
            String string2;
            String html = string2 = string;
            return this.parseSitePointWebsite(html);
        }
        return null;
    }

    @Nullable
    protected Map<String, Set<String>> parseSitePointWebsite(@NotNull String html) {
        Intrinsics.checkParameterIsNotNull((Object)html, (String)"html");
        Document document = Jsoup.parse((String)html);
        Elements elements = document.body().select("table");
        Intrinsics.checkExpressionValueIsNotNull((Object)elements, (String)"document.body().select(\"table\")");
        Iterable $receiver$iv = (Iterable)elements;
        for (Object element$iv : $receiver$iv) {
            Element tableElement = (Element)element$iv;
            String string = tableElement.select("thead").html();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"tableElement.select(\"thead\").html()");
            if (!StringsKt.contains((CharSequence)string, (CharSequence)"Media type", (boolean)true)) continue;
            Element element = tableElement;
            Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"tableElement");
            return this.parseMediaTypesTable(element);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Map<String, Set<String>> parseMediaTypesTable(@NotNull Element tableElement) {
        Intrinsics.checkParameterIsNotNull((Object)tableElement, (String)"tableElement");
        HashMap<String, Set<String>> mimeTypesToExtensionsMap = new HashMap<String, Set<String>>();
        Elements elements = tableElement.select("tbody tr");
        Intrinsics.checkExpressionValueIsNotNull((Object)elements, (String)"tableElement.select(\"tbody tr\")");
        Iterable $receiver$iv = (Iterable)elements;
        for (Object element$iv : $receiver$iv) {
            Collection<String> collection;
            void $receiver$iv$iv;
            void $receiver$iv2;
            String fileExtension;
            Object mimeType;
            Element tableRow = (Element)element$iv;
            Elements tableData = tableRow.select("td");
            if (tableData.size() == 2) {
                String string;
                String string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)((Element)tableData.get(1)).text(), (String)"tableData[1].text()");
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                mimeType = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)((Element)tableData.get(0)).text(), (String)"tableData[0].text()");
                String string4 = string;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                fileExtension = StringsKt.substringAfter$default((String)((Object)StringsKt.trim((CharSequence)string4)).toString(), (char)'.', null, (int)2, null);
                this.addFileExtensionForMimeType(mimeTypesToExtensionsMap, (String)mimeType, fileExtension);
                continue;
            }
            Logger logger = SitePointMimeTypeWebsiteParser.Companion.getLog();
            StringBuilder stringBuilder = new StringBuilder().append("Table row's column size is ").append(tableData.size()).append(" and not 2:");
            Elements elements2 = tableData;
            Intrinsics.checkExpressionValueIsNotNull((Object)elements2, (String)"tableData");
            mimeType = (Iterable)elements2;
            StringBuilder stringBuilder2 = stringBuilder;
            Logger logger2 = logger;
            fileExtension = $receiver$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            int index$iv$iv = 0;
            for (Object item$iv$iv : $receiver$iv$iv) {
                void element;
                void index;
                int n = index$iv$iv++;
                Element element2 = (Element)item$iv$iv;
                int n2 = n;
                collection = destination$iv$iv;
                String string = "\n[" + (int)index + "] " + element.html();
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            logger2.warn(stringBuilder2.append(collection).toString());
        }
        return mimeTypesToExtensionsMap;
    }

    @NotNull
    protected final FileDownloader getDownloader() {
        return this.downloader;
    }

    public SitePointMimeTypeWebsiteParser(@NotNull FileDownloader downloader) {
        Intrinsics.checkParameterIsNotNull((Object)downloader, (String)"downloader");
        this.downloader = downloader;
    }

    static {
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(SitePointMimeTypeWebsiteParser.class);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lnet/dankito/mime/service/creator/SitePointMimeTypeWebsiteParser$Companion;", "", "()V", "SitePointMimeTypesWebsiteUrl", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "mime-utils"})
    public static final class Companion {
        private final Logger getLog() {
            return log;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

