/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.mime.service.creator;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.dankito.mime.model.CreateMimeTypeDetectorConfig;
import net.dankito.mime.service.creator.EtcMimeTypesFileParser;
import net.dankito.mime.service.creator.IanaMimeTypeRetriever;
import net.dankito.mime.service.creator.JavaMimeUtilsParser;
import net.dankito.mime.service.creator.SitePointMimeTypeWebsiteParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\"\n\u0000\n\u0002\u0010#\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0018H\u0017J\u0010\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001aH\u0014J(\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u001aH\u0014J \u0010#\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0010\u0010$\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020%H\u0014J(\u0010&\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u001aH\u0014J\u0084\u0001\u0010'\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001d2\u0018\u0010(\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0*0)2\u001a\u0010+\u001a\u0016\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0,\u0018\u00010)2\u0018\u0010-\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0*0)2\u001a\u0010.\u001a\u0016\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0,\u0018\u00010)H\u0014J \u0010/\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J \u00100\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u001aH\u0014J \u00101\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u001aH\u0014J\u0018\u00102\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001dH\u0014J\u0018\u00103\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001dH\u0014J\u0018\u00104\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001dH\u0014J\u0018\u00105\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001dH\u0014J\u0018\u00106\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001dH\u0014J\"\u00107\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020%2\u0006\u00108\u001a\u00020\u001a2\b\b\u0002\u0010 \u001a\u00020\u001dH\u0014J\"\u00109\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020%2\u0006\u00108\u001a\u00020\u001a2\b\b\u0002\u0010 \u001a\u00020\u001dH\u0014J\u0018\u0010:\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001dH\u0014J \u0010;\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\"\u0010<\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020%2\u0006\u0010 \u001a\u00020\u001d2\b\b\u0002\u0010=\u001a\u00020>H\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006?"}, d2={"Lnet/dankito/mime/service/creator/MimeTypeDetectorCreator;", "", "etcMimeTypesFileParser", "Lnet/dankito/mime/service/creator/EtcMimeTypesFileParser;", "javaMimeUtilsParser", "Lnet/dankito/mime/service/creator/JavaMimeUtilsParser;", "ianaMimeTypeRetriever", "Lnet/dankito/mime/service/creator/IanaMimeTypeRetriever;", "sitePointParser", "Lnet/dankito/mime/service/creator/SitePointMimeTypeWebsiteParser;", "(Lnet/dankito/mime/service/creator/EtcMimeTypesFileParser;Lnet/dankito/mime/service/creator/JavaMimeUtilsParser;Lnet/dankito/mime/service/creator/IanaMimeTypeRetriever;Lnet/dankito/mime/service/creator/SitePointMimeTypeWebsiteParser;)V", "getEtcMimeTypesFileParser", "()Lnet/dankito/mime/service/creator/EtcMimeTypesFileParser;", "getIanaMimeTypeRetriever", "()Lnet/dankito/mime/service/creator/IanaMimeTypeRetriever;", "getJavaMimeUtilsParser", "()Lnet/dankito/mime/service/creator/JavaMimeUtilsParser;", "getSitePointParser", "()Lnet/dankito/mime/service/creator/SitePointMimeTypeWebsiteParser;", "createMimeTypeDetectorClass", "", "outputFile", "Ljava/io/File;", "config", "Lnet/dankito/mime/model/CreateMimeTypeDetectorConfig;", "getLineSeparator", "", "kotlin.jvm.PlatformType", "writeAddMimeTypeToFileExtensionMappingMethod", "", "writer", "Ljava/io/FileWriter;", "indent", "mimeTypesMap", "fileExtensionsMap", "writeClassStatementAndComment", "writeEmptyLine", "Ljava/io/Writer;", "writeFields", "writeGenerateMimeTypeToFileExtensionMappingMethod", "etcMimeTypesToExtensionsMap", "", "", "javaMimeUtilsMimeTypesToExtensionsMap", "", "ianaMimeTypesToExtensionsMap", "sitePointMimeTypesToExtensionsMap", "writeGetBestPickConvenienceMethods", "writeGetExtensionsForMimeTypeMethod", "writeGetMimeTypesForExtensionMethod", "writeGetMimeTypesForFileMethod", "writeGetMimeTypesForFilenameMethod", "writeGetMimeTypesForUriMethod", "writeImports", "writeInitializerMethod", "writeLine", "line", "writeLineAndAnEmptyLine", "writeNormalizeFileExtensionMethod", "writePackageDeclaration", "writeStatementEnd", "addEnEmptyLine", "", "mime-utils"})
public class MimeTypeDetectorCreator {
    @NotNull
    private final EtcMimeTypesFileParser etcMimeTypesFileParser;
    @NotNull
    private final JavaMimeUtilsParser javaMimeUtilsParser;
    @NotNull
    private final IanaMimeTypeRetriever ianaMimeTypeRetriever;
    @NotNull
    private final SitePointMimeTypeWebsiteParser sitePointParser;

    @JvmOverloads
    public void createMimeTypeDetectorClass(@NotNull File outputFile, @NotNull CreateMimeTypeDetectorConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        outputFile.getParentFile().mkdirs();
        Map<String, Set<String>> etcMimeTypesToExtensionsMap = this.etcMimeTypesFileParser.parseEtcMimeTypesFile();
        Map<String, Set<String>> javaMimeUtilsMimeTypesToExtensionsMap = this.javaMimeUtilsParser.parseJavaMimeUtilsSource();
        Map<String, Set<String>> ianaMimeTypesToExtensionsMap = this.ianaMimeTypeRetriever.retrieveAndParseAllFiles();
        Map<String, Set<String>> sitePointMimeTypesToExtensionsMap = this.sitePointParser.parseSitePointWebsite();
        String mimeTypesMap = config.getMimeTypesMapVariableName();
        String fileExtensionsMap = config.getFileExtensionsMapVariableName();
        int indent = 0;
        FileWriter writer = new FileWriter(outputFile);
        this.writePackageDeclaration(writer, indent, config);
        this.writeImports(writer, indent);
        indent = this.writeClassStatementAndComment(writer, indent, config);
        this.writeFields(writer, indent, mimeTypesMap, fileExtensionsMap);
        this.writeEmptyLine(writer);
        indent = this.writeInitializerMethod(writer, indent);
        this.writeEmptyLine(writer);
        indent = this.writeGetMimeTypesForUriMethod(writer, indent);
        indent = this.writeGetMimeTypesForFileMethod(writer, indent);
        indent = this.writeGetMimeTypesForFilenameMethod(writer, indent);
        indent = this.writeGetMimeTypesForExtensionMethod(writer, indent, fileExtensionsMap);
        indent = this.writeNormalizeFileExtensionMethod(writer, indent);
        this.writeEmptyLine(writer);
        indent = this.writeGetBestPickConvenienceMethods(writer, indent, config);
        this.writeEmptyLine(writer);
        indent = this.writeGetExtensionsForMimeTypeMethod(writer, indent, mimeTypesMap);
        this.writeEmptyLine(writer);
        this.writeGenerateMimeTypeToFileExtensionMappingMethod(writer, indent, etcMimeTypesToExtensionsMap, javaMimeUtilsMimeTypesToExtensionsMap, ianaMimeTypesToExtensionsMap, sitePointMimeTypesToExtensionsMap);
        this.writeAddMimeTypeToFileExtensionMappingMethod(writer, indent, mimeTypesMap, fileExtensionsMap);
        MimeTypeDetectorCreator.writeLine$default(this, writer, "}", 0, 4, null);
        writer.close();
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ void createMimeTypeDetectorClass$default(MimeTypeDetectorCreator mimeTypeDetectorCreator, File file, CreateMimeTypeDetectorConfig createMimeTypeDetectorConfig, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createMimeTypeDetectorClass");
        }
        if ((n & 2) != 0) {
            createMimeTypeDetectorConfig = new CreateMimeTypeDetectorConfig(null, null, null, null, null, 31, null);
        }
        mimeTypeDetectorCreator.createMimeTypeDetectorClass(file, createMimeTypeDetectorConfig);
    }

    @JvmOverloads
    public void createMimeTypeDetectorClass(@NotNull File outputFile) {
        MimeTypeDetectorCreator.createMimeTypeDetectorClass$default(this, outputFile, null, 2, null);
    }

    protected void writePackageDeclaration(@NotNull FileWriter writer, int indent, @NotNull CreateMimeTypeDetectorConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.writeLineAndAnEmptyLine(writer, "package " + config.getPackageName(), indent);
    }

    protected void writeImports(@NotNull FileWriter writer, int indent) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        this.writeLine(writer, "import java.io.File", indent);
        this.writeLine(writer, "import java.net.URI", indent);
        this.writeLineAndAnEmptyLine(writer, "import java.net.URLConnection", indent);
    }

    protected int writeClassStatementAndComment(@NotNull FileWriter writer, int indent, @NotNull CreateMimeTypeDetectorConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        int newIndent = indent;
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss zZ");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.writeLine(writer, "/**", indent);
        this.writeLine(writer, " * MimeTypeDetector contains Mime type mappings for the most commonly known file types.", indent);
        this.writeLine(writer, " * ", indent);
        this.writeLine(writer, " * You can get a Mime type from a file, URI, file name or file extension, or", indent);
        this.writeLine(writer, " * retrieve the corresponding file extension(s) for a Mime type.", indent);
        this.writeLine(writer, " * ", indent);
        this.writeLine(writer, " * Automatically generated by MimeTypeDetectorCreator on " + dateFormat.format(new Date()) + " from", indent);
        this.writeLine(writer, " * - an Unix /etc/mime.types file", indent);
        this.writeLine(writer, " * - Java MimeUtils class with source from https://android.googlesource.com/platform/libcore/+/master/luni/src/main/java/libcore/net/MimeUtils.java", indent);
        this.writeLine(writer, " * - the .csv files from http://www.iana.org/assignments/media-types/media-types.xhtml", indent);
        this.writeLine(writer, " * - the mime types listed on https://www.sitepoint.com/mime-types-complete-list/", indent);
        this.writeLine(writer, " */", indent);
        this.writeLineAndAnEmptyLine(writer, "open class " + config.getClassName() + "  " + "@JvmOverloads constructor(protected val " + config.getMimeTypePickerVariableName() + ": MimeTypePicker = MimeTypePicker()) {", newIndent);
        return ++newIndent;
    }

    protected void writeFields(@NotNull FileWriter writer, int indent, @NotNull String mimeTypesMap, @NotNull String fileExtensionsMap) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        Intrinsics.checkParameterIsNotNull((Object)mimeTypesMap, (String)"mimeTypesMap");
        Intrinsics.checkParameterIsNotNull((Object)fileExtensionsMap, (String)"fileExtensionsMap");
        this.writeLineAndAnEmptyLine(writer, "protected val " + mimeTypesMap + " = HashMap<String, MutableSet<String>>()", indent);
        this.writeLineAndAnEmptyLine(writer, "protected val " + fileExtensionsMap + " = HashMap<String, MutableSet<String>>()", indent);
    }

    protected int writeInitializerMethod(@NotNull FileWriter writer, int indent) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        int newIndent = indent;
        this.writeLine(writer, "init {", newIndent);
        this.writeLine(writer, "generateMimeTypeToFileExtensionMapping() // ignore Calling non-final function in constructor warning, i want to make it overwritable", ++newIndent);
        newIndent = MimeTypeDetectorCreator.writeStatementEnd$default(this, writer, newIndent, false, 4, null);
        return newIndent;
    }

    protected int writeGetMimeTypesForUriMethod(@NotNull FileWriter writer, int indent) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        int newIndent = indent;
        this.writeLine(writer, "open fun getMimeTypesForUri(uri: URI): List<String>? {", newIndent);
        this.writeLine(writer, "return getMimeTypesForFilename(uri.toASCIIString())", ++newIndent);
        newIndent = MimeTypeDetectorCreator.writeStatementEnd$default(this, writer, newIndent, false, 4, null);
        return newIndent;
    }

    protected int writeGetMimeTypesForFileMethod(@NotNull FileWriter writer, int indent) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        int newIndent = indent;
        this.writeLine(writer, "open fun getMimeTypesForFile(file: File): List<String>? {", newIndent);
        this.writeLine(writer, "return getMimeTypesForExtension(file.extension)", ++newIndent);
        newIndent = MimeTypeDetectorCreator.writeStatementEnd$default(this, writer, newIndent, false, 4, null);
        return newIndent;
    }

    protected int writeGetMimeTypesForFilenameMethod(@NotNull FileWriter writer, int indent) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        int newIndent = indent;
        this.writeLine(writer, "open fun getMimeTypesForFilename(filename: String): List<String>? {", newIndent);
        this.writeLine(writer, "return getMimeTypesForExtension(filename.substringAfterLast('.', \"\"))", ++newIndent);
        newIndent = MimeTypeDetectorCreator.writeStatementEnd$default(this, writer, newIndent, false, 4, null);
        return newIndent;
    }

    protected int writeGetMimeTypesForExtensionMethod(@NotNull FileWriter writer, int indent, @NotNull String fileExtensionsMap) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        Intrinsics.checkParameterIsNotNull((Object)fileExtensionsMap, (String)"fileExtensionsMap");
        int newIndent = indent;
        this.writeLine(writer, "open fun getMimeTypesForExtension(fileExtension: String): List<String>? {", newIndent);
        this.writeLine(writer, "try {", ++newIndent);
        this.writeLine(writer, "var result = fileExtensionsToMimeTypeMap[normalizeFileExtension(fileExtension)]?.toList()", ++newIndent);
        this.writeEmptyLine(writer);
        this.writeLine(writer, "if(result == null) { // as a fallback, but actually we should already know all URLConnection Mime types due to parsing Java's MimeUtils class", newIndent);
        this.writeLine(writer, "URLConnection.guessContentTypeFromName(fileExtension)?.let { mimeType ->", ++newIndent);
        this.writeLine(writer, "result = listOf(mimeType)", ++newIndent);
        newIndent = this.writeStatementEnd(writer, newIndent, false);
        newIndent = MimeTypeDetectorCreator.writeStatementEnd$default(this, writer, newIndent, false, 4, null);
        this.writeLine(writer, "return result", newIndent);
        this.writeLine(writer, "} catch(e: Exception) { }", --newIndent);
        this.writeEmptyLine(writer);
        this.writeLine(writer, "return null", newIndent);
        newIndent = MimeTypeDetectorCreator.writeStatementEnd$default(this, writer, newIndent, false, 4, null);
        return newIndent;
    }

    protected int writeNormalizeFileExtensionMethod(@NotNull FileWriter writer, int indent) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        int newIndent = indent;
        this.writeLine(writer, "/**", newIndent);
        this.writeLine(writer, " * Removes '*.' at start of extension filter and lower cases extension", newIndent);
        this.writeLine(writer, " */", newIndent);
        this.writeLine(writer, "protected open fun normalizeFileExtension(extension: String?): String? {", newIndent);
        this.writeLine(writer, "if(extension == null) {", ++newIndent);
        this.writeLine(writer, "return extension", ++newIndent);
        newIndent = MimeTypeDetectorCreator.writeStatementEnd$default(this, writer, newIndent, false, 4, null);
        this.writeLine(writer, "var normalizedExtension = extension", newIndent);
        this.writeLine(writer, "if(normalizedExtension.startsWith('*')) {", newIndent);
        this.writeLine(writer, "normalizedExtension = normalizedExtension.substring(1)", ++newIndent);
        newIndent = MimeTypeDetectorCreator.writeStatementEnd$default(this, writer, newIndent, false, 4, null);
        this.writeLine(writer, "if(normalizedExtension.startsWith('.')) {", newIndent);
        this.writeLine(writer, "normalizedExtension = normalizedExtension.substring(1)", ++newIndent);
        newIndent = MimeTypeDetectorCreator.writeStatementEnd$default(this, writer, newIndent, false, 4, null);
        this.writeLine(writer, "return normalizedExtension.toLowerCase()", newIndent);
        newIndent = MimeTypeDetectorCreator.writeStatementEnd$default(this, writer, newIndent, false, 4, null);
        return newIndent;
    }

    protected int writeGetBestPickConvenienceMethods(@NotNull FileWriter writer, int indent, @NotNull CreateMimeTypeDetectorConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        int newIndent = indent;
        this.writeLine(writer, "open fun getBestPickForUri(uri: URI): String? {", newIndent);
        this.writeLine(writer, "return " + config.getMimeTypePickerVariableName() + ".getBestPick(getMimeTypesForUri(uri))", ++newIndent);
        newIndent = MimeTypeDetectorCreator.writeStatementEnd$default(this, writer, newIndent, false, 4, null);
        this.writeLine(writer, "open fun getBestPickForFile(file: File): String? {", newIndent);
        this.writeLine(writer, "return " + config.getMimeTypePickerVariableName() + ".getBestPick(getMimeTypesForFile(file))", ++newIndent);
        newIndent = MimeTypeDetectorCreator.writeStatementEnd$default(this, writer, newIndent, false, 4, null);
        this.writeLine(writer, "open fun getBestPickForFilename(filename: String): String? {", newIndent);
        this.writeLine(writer, "return " + config.getMimeTypePickerVariableName() + ".getBestPick(getMimeTypesForFilename(filename))", ++newIndent);
        newIndent = MimeTypeDetectorCreator.writeStatementEnd$default(this, writer, newIndent, false, 4, null);
        this.writeLine(writer, "open fun getBestPickForExtension(fileExtension: String): String? {", newIndent);
        this.writeLine(writer, "return " + config.getMimeTypePickerVariableName() + ".getBestPick(getMimeTypesForExtension(fileExtension))", ++newIndent);
        newIndent = MimeTypeDetectorCreator.writeStatementEnd$default(this, writer, newIndent, false, 4, null);
        return newIndent;
    }

    protected int writeGetExtensionsForMimeTypeMethod(@NotNull FileWriter writer, int indent, @NotNull String mimeTypesMap) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        Intrinsics.checkParameterIsNotNull((Object)mimeTypesMap, (String)"mimeTypesMap");
        int newIndent = indent;
        this.writeLine(writer, "open fun getExtensionsForMimeType(mimeType: String): List<String>? {", newIndent);
        this.writeLine(writer, "return " + mimeTypesMap + "[mimeType.toLowerCase()]?.toList()", ++newIndent);
        newIndent = MimeTypeDetectorCreator.writeStatementEnd$default(this, writer, newIndent, false, 4, null);
        return newIndent;
    }

    protected int writeGenerateMimeTypeToFileExtensionMappingMethod(@NotNull FileWriter writer, int indent, @NotNull Map<String, ? extends Set<String>> etcMimeTypesToExtensionsMap, @Nullable Map<String, ? extends Set<String>> javaMimeUtilsMimeTypesToExtensionsMap, @NotNull Map<String, ? extends Set<String>> ianaMimeTypesToExtensionsMap, @Nullable Map<String, ? extends Set<String>> sitePointMimeTypesToExtensionsMap) {
        String fileExtension;
        Iterable $receiver$iv;
        String mimeType;
        Iterable $receiver$iv2;
        Map<String, ? extends Set<String>> it;
        Object fileExtension2;
        Iterable $receiver$iv3;
        Object mimeType2;
        Object element$iv;
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        Intrinsics.checkParameterIsNotNull(etcMimeTypesToExtensionsMap, (String)"etcMimeTypesToExtensionsMap");
        Intrinsics.checkParameterIsNotNull(ianaMimeTypesToExtensionsMap, (String)"ianaMimeTypesToExtensionsMap");
        int newIndent = indent;
        this.writeLine(writer, "protected open fun generateMimeTypeToFileExtensionMapping() {", newIndent);
        int n = newIndent;
        newIndent = n + 1;
        Object $receiver$iv4 = etcMimeTypesToExtensionsMap.keySet();
        Iterator iterator = $receiver$iv4.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            mimeType2 = (String)element$iv;
            Set<String> set = etcMimeTypesToExtensionsMap.get(mimeType2);
            if (set == null) continue;
            $receiver$iv3 = set;
            for (Object element$iv2 : $receiver$iv3) {
                fileExtension2 = (String)element$iv2;
                this.writeLine(writer, "addMapping(\"" + (String)mimeType2 + "\", \"" + fileExtension2 + "\")", newIndent);
            }
        }
        Map<String, ? extends Set<String>> map = javaMimeUtilsMimeTypesToExtensionsMap;
        if (map != null) {
            $receiver$iv4 = map;
            it = $receiver$iv4;
            $receiver$iv2 = javaMimeUtilsMimeTypesToExtensionsMap.keySet();
            for (Object element$iv3 : $receiver$iv2) {
                mimeType = (String)element$iv3;
                Set<String> set = javaMimeUtilsMimeTypesToExtensionsMap.get(mimeType);
                if (set != null) {
                    $receiver$iv = set;
                    for (Object element$iv4 : $receiver$iv) {
                        fileExtension = (String)element$iv4;
                        this.writeLine(writer, "addMapping(\"" + mimeType + "\", \"" + fileExtension + "\")", newIndent);
                    }
                }
            }
        }
        Map<String, ? extends Set<String>> map2 = sitePointMimeTypesToExtensionsMap;
        if (map2 != null) {
            $receiver$iv4 = map2;
            it = $receiver$iv4;
            $receiver$iv2 = sitePointMimeTypesToExtensionsMap.keySet();
            for (Object element$iv3 : $receiver$iv2) {
                mimeType = (String)element$iv3;
                Set<String> set = sitePointMimeTypesToExtensionsMap.get(mimeType);
                if (set != null) {
                    $receiver$iv = set;
                    for (Object element$iv4 : $receiver$iv) {
                        fileExtension = (String)element$iv4;
                        this.writeLine(writer, "addMapping(\"" + mimeType + "\", \"" + fileExtension + "\")", newIndent);
                    }
                }
            }
        }
        $receiver$iv4 = ianaMimeTypesToExtensionsMap.keySet();
        iterator = $receiver$iv4.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            mimeType2 = (String)element$iv;
            Set<String> set = ianaMimeTypesToExtensionsMap.get(mimeType2);
            if (set == null) continue;
            $receiver$iv3 = set;
            for (Object element$iv2 : $receiver$iv3) {
                fileExtension2 = (String)element$iv2;
                this.writeLine(writer, "addMapping(\"" + (String)mimeType2 + "\", \"" + (String)fileExtension2 + "\")", newIndent);
            }
        }
        newIndent = MimeTypeDetectorCreator.writeStatementEnd$default(this, writer, newIndent, false, 4, null);
        return newIndent;
    }

    protected int writeAddMimeTypeToFileExtensionMappingMethod(@NotNull FileWriter writer, int indent, @NotNull String mimeTypesMap, @NotNull String fileExtensionsMap) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        Intrinsics.checkParameterIsNotNull((Object)mimeTypesMap, (String)"mimeTypesMap");
        Intrinsics.checkParameterIsNotNull((Object)fileExtensionsMap, (String)"fileExtensionsMap");
        int newIndent = indent;
        this.writeLine(writer, "open protected fun addMapping(mimeType: String, fileExtension: String) {", newIndent);
        this.writeLineAndAnEmptyLine(writer, "val fileExtensionLowerCased = fileExtension.toLowerCase()", ++newIndent);
        this.writeLine(writer, "if(" + fileExtensionsMap + ".containsKey(fileExtensionLowerCased) == false) {", newIndent);
        this.writeLine(writer, "" + fileExtensionsMap + ".put(fileExtensionLowerCased, LinkedHashSet())", ++newIndent);
        newIndent = MimeTypeDetectorCreator.writeStatementEnd$default(this, writer, newIndent, false, 4, null);
        this.writeLineAndAnEmptyLine(writer, "" + fileExtensionsMap + "[fileExtensionLowerCased]?.add(mimeType)", newIndent);
        this.writeEmptyLine(writer);
        this.writeLineAndAnEmptyLine(writer, "val mimeTypeLowerCased = mimeType.toLowerCase()", newIndent);
        this.writeLine(writer, "if(" + mimeTypesMap + ".containsKey(mimeTypeLowerCased) == false) {", newIndent);
        this.writeLine(writer, "" + mimeTypesMap + ".put(mimeTypeLowerCased, LinkedHashSet())", ++newIndent);
        newIndent = MimeTypeDetectorCreator.writeStatementEnd$default(this, writer, newIndent, false, 4, null);
        this.writeLine(writer, "" + mimeTypesMap + "[mimeTypeLowerCased]?.add(fileExtension)", newIndent);
        newIndent = MimeTypeDetectorCreator.writeStatementEnd$default(this, writer, newIndent, false, 4, null);
        return newIndent;
    }

    protected void writeLine(@NotNull Writer writer, @NotNull String line, int indent) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        String indentString = StringsKt.repeat((CharSequence)"\t", (int)indent);
        writer.write(indentString + line + this.getLineSeparator());
    }

    public static /* bridge */ /* synthetic */ void writeLine$default(MimeTypeDetectorCreator mimeTypeDetectorCreator, Writer writer, String string, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: writeLine");
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        mimeTypeDetectorCreator.writeLine(writer, string, n);
    }

    protected void writeLineAndAnEmptyLine(@NotNull Writer writer, @NotNull String line, int indent) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        this.writeLine(writer, line, indent);
        this.writeEmptyLine(writer);
    }

    public static /* bridge */ /* synthetic */ void writeLineAndAnEmptyLine$default(MimeTypeDetectorCreator mimeTypeDetectorCreator, Writer writer, String string, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: writeLineAndAnEmptyLine");
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        mimeTypeDetectorCreator.writeLineAndAnEmptyLine(writer, string, n);
    }

    protected void writeEmptyLine(@NotNull Writer writer) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        MimeTypeDetectorCreator.writeLine$default(this, writer, "", 0, 4, null);
    }

    protected int writeStatementEnd(@NotNull Writer writer, int indent, boolean addEnEmptyLine) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        int newIndent = indent - 1;
        this.writeLine(writer, "}", newIndent);
        if (addEnEmptyLine) {
            this.writeEmptyLine(writer);
        }
        return newIndent;
    }

    public static /* bridge */ /* synthetic */ int writeStatementEnd$default(MimeTypeDetectorCreator mimeTypeDetectorCreator, Writer writer, int n, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: writeStatementEnd");
        }
        if ((n2 & 4) != 0) {
            bl = true;
        }
        return mimeTypeDetectorCreator.writeStatementEnd(writer, n, bl);
    }

    protected String getLineSeparator() {
        return System.lineSeparator();
    }

    @NotNull
    protected final EtcMimeTypesFileParser getEtcMimeTypesFileParser() {
        return this.etcMimeTypesFileParser;
    }

    @NotNull
    protected final JavaMimeUtilsParser getJavaMimeUtilsParser() {
        return this.javaMimeUtilsParser;
    }

    @NotNull
    protected final IanaMimeTypeRetriever getIanaMimeTypeRetriever() {
        return this.ianaMimeTypeRetriever;
    }

    @NotNull
    protected final SitePointMimeTypeWebsiteParser getSitePointParser() {
        return this.sitePointParser;
    }

    public MimeTypeDetectorCreator(@NotNull EtcMimeTypesFileParser etcMimeTypesFileParser, @NotNull JavaMimeUtilsParser javaMimeUtilsParser, @NotNull IanaMimeTypeRetriever ianaMimeTypeRetriever, @NotNull SitePointMimeTypeWebsiteParser sitePointParser) {
        Intrinsics.checkParameterIsNotNull((Object)etcMimeTypesFileParser, (String)"etcMimeTypesFileParser");
        Intrinsics.checkParameterIsNotNull((Object)javaMimeUtilsParser, (String)"javaMimeUtilsParser");
        Intrinsics.checkParameterIsNotNull((Object)ianaMimeTypeRetriever, (String)"ianaMimeTypeRetriever");
        Intrinsics.checkParameterIsNotNull((Object)sitePointParser, (String)"sitePointParser");
        this.etcMimeTypesFileParser = etcMimeTypesFileParser;
        this.javaMimeUtilsParser = javaMimeUtilsParser;
        this.ianaMimeTypeRetriever = ianaMimeTypeRetriever;
        this.sitePointParser = sitePointParser;
    }
}

