/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.mime.service.creator;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.dankito.mime.service.creator.MimeTypeFileParserBase;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u001a\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\t0\bH\u0016J\"\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J@\u0010\f\u001a\u00020\r2.\u0010\u000e\u001a*\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\t0\u000fj\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\t`\u00102\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0012"}, d2={"Lnet/dankito/mime/service/creator/EtcMimeTypesFileParser;", "Lnet/dankito/mime/service/creator/MimeTypeFileParserBase;", "()V", "isCommentOrBlank", "", "line", "", "parseEtcMimeTypesFile", "", "", "etcMimeTypesFile", "Ljava/io/File;", "parseEtcMimeTypesLines", "", "mimeTypesToExtensionsMap", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "Companion", "mime-utils"})
public class EtcMimeTypesFileParser
extends MimeTypeFileParserBase {
    private static final Logger log;
    public static final Companion Companion;

    @NotNull
    public Map<String, Set<String>> parseEtcMimeTypesFile() {
        URL resourceUrl = EtcMimeTypesFileParser.class.getClassLoader().getResource(new File("ect-mime.types").getPath());
        return this.parseEtcMimeTypesFile(new File(resourceUrl.toURI()));
    }

    @NotNull
    public Map<String, Set<String>> parseEtcMimeTypesFile(@NotNull File etcMimeTypesFile) {
        Intrinsics.checkParameterIsNotNull((Object)etcMimeTypesFile, (String)"etcMimeTypesFile");
        HashMap mimeTypesToExtensionsMap = new HashMap();
        FileReader reader = new FileReader(etcMimeTypesFile);
        TextStreamsKt.forEachLine((Reader)reader, (Function1)((Function1)new Function1<String, Unit>(this, mimeTypesToExtensionsMap){
            final /* synthetic */ EtcMimeTypesFileParser this$0;
            final /* synthetic */ HashMap $mimeTypesToExtensionsMap;

            public final void invoke(@NotNull String line) {
                Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
                if (!this.this$0.isCommentOrBlank(line)) {
                    this.this$0.parseEtcMimeTypesLines(this.$mimeTypesToExtensionsMap, line);
                }
            }
            {
                this.this$0 = etcMimeTypesFileParser;
                this.$mimeTypesToExtensionsMap = hashMap;
                super(1);
            }
        }));
        reader.close();
        return mimeTypesToExtensionsMap;
    }

    protected boolean isCommentOrBlank(@NotNull String line) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        return StringsKt.isBlank((CharSequence)line) || StringsKt.startsWith$default((CharSequence)((Object)StringsKt.trim((CharSequence)(string = line))).toString(), (char)'#', (boolean)false, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    protected void parseEtcMimeTypesLines(@NotNull HashMap<String, Set<String>> mimeTypesToExtensionsMap, @NotNull String line) {
        CharSequence charSequence;
        String $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(mimeTypesToExtensionsMap, (String)"mimeTypesToExtensionsMap");
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        Iterable iterable = $receiver$iv = (Iterable)StringsKt.split$default((CharSequence)line, (char[])new char[]{'\t'}, (boolean)false, (int)0, (int)6, null);
        Iterable destination$iv$iv = new ArrayList();
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            String it = (String)element$iv$iv;
            charSequence = it;
            if (!(!StringsKt.isBlank((CharSequence)charSequence))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List columns = (List)destination$iv$iv;
        if (columns.size() > 1) {
            Object object;
            void $receiver$iv$iv2;
            void $receiver$iv22;
            ArrayList arrayList;
            String string = $receiver$iv$iv = (String)columns.get(0);
            if (string == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String mimeType = ((Object)StringsKt.trim((CharSequence)string)).toString();
            destination$iv$iv = StringsKt.split$default((CharSequence)((CharSequence)columns.get(1)), (char[])new char[]{' '}, (boolean)false, (int)0, (int)6, null);
            ArrayList arrayList2 = arrayList;
            ArrayList arrayList3 = arrayList;
            iterator = $receiver$iv22;
            Collection destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv2) {
                String it = (String)element$iv$iv;
                object = it;
                if (!(!StringsKt.isBlank((CharSequence)object))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv2;
            arrayList2(list);
            ArrayList extensions = arrayList3;
            int $receiver$iv22 = 2;
            int n = columns.size() - 1;
            if ($receiver$iv22 <= n) {
                while (true) {
                    void i;
                    extensions.add(columns.get((int)i));
                    if (i == n) break;
                    ++i;
                }
            }
            Iterable $receiver$iv3 = extensions;
            for (Object element$iv : $receiver$iv3) {
                String fileExtension = (String)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)fileExtension, (String)"fileExtension");
                String string2 = mimeType;
                object = mimeTypesToExtensionsMap;
                EtcMimeTypesFileParser etcMimeTypesFileParser = this;
                CharSequence charSequence2 = charSequence;
                if (charSequence2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String string3 = ((Object)StringsKt.trim((CharSequence)charSequence2)).toString();
                etcMimeTypesFileParser.addFileExtensionForMimeType((HashMap<String, Set<String>>)object, string2, string3);
            }
        } else {
            EtcMimeTypesFileParser.Companion.getLog().info("Line contains only one column: " + line);
        }
    }

    static {
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(EtcMimeTypesFileParser.class);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lnet/dankito/mime/service/creator/EtcMimeTypesFileParser$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "mime-utils"})
    public static final class Companion {
        private final Logger getLog() {
            return log;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

