/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.mime;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.dankito.mime.MimeTypeDetector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0002J\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0006J\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0004J\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0002J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0002J$\u0010\u0012\u001a\u00020\u00042\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0002\u00a8\u0006\u0014"}, d2={"Lnet/dankito/mime/MimeTypePicker;", "", "()V", "containsSingleVndType", "", "mimeTypesWithoutEmptyEntries", "", "getBestPick", "mimeTypes", "detector", "Lnet/dankito/mime/MimeTypeDetector;", "file", "Ljava/io/File;", "uri", "Ljava/net/URI;", "fileExtension", "getKnownBestPick", "getMostUsedCategory", "tryToGuessBestMimeType", "withoutApplicationAndExtensionsMimeTypes", "mime-utils"})
public final class MimeTypePicker {
    @Nullable
    public final String getBestPick(@NotNull MimeTypeDetector detector, @NotNull URI uri) {
        Intrinsics.checkParameterIsNotNull((Object)detector, (String)"detector");
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        return this.getBestPick(detector.getMimeTypesForUri(uri));
    }

    @Nullable
    public final String getBestPick(@NotNull MimeTypeDetector detector, @NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)detector, (String)"detector");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return this.getBestPick(detector.getMimeTypesForFile(file));
    }

    @Nullable
    public final String getBestPick(@NotNull MimeTypeDetector detector, @NotNull String fileExtension) {
        Intrinsics.checkParameterIsNotNull((Object)detector, (String)"detector");
        Intrinsics.checkParameterIsNotNull((Object)fileExtension, (String)"fileExtension");
        return this.getBestPick(detector.getMimeTypesForExtension(fileExtension));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String getBestPick(@Nullable List<String> mimeTypes) {
        List<String> list = mimeTypes;
        if (list != null) {
            void $receiver$iv$iv;
            void $receiver$iv$iv2;
            void $receiver$iv$iv3;
            void $receiver$iv$iv4;
            Iterable $receiver$iv;
            List<String> list2;
            List<String> it = list2 = list;
            if (mimeTypes.isEmpty()) {
                return null;
            }
            Iterable iterable = $receiver$iv = (Iterable)mimeTypes;
            Iterable destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv4) {
                String it2 = (String)element$iv$iv;
                CharSequence charSequence = it2;
                if (!(!StringsKt.isBlank((CharSequence)charSequence))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List mimeTypesWithoutEmptyEntries = (List)destination$iv$iv;
            if (mimeTypesWithoutEmptyEntries.size() == 1) {
                return (String)mimeTypesWithoutEmptyEntries.get(0);
            }
            Iterable $receiver$iv2 = mimeTypesWithoutEmptyEntries;
            destination$iv$iv = $receiver$iv2;
            Iterable destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv3) {
                String it3 = (String)element$iv$iv;
                if (!(!StringsKt.contains$default((CharSequence)it3, (CharSequence)"x-", (boolean)false, (int)2, null))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List withoutExtensionsMimeTypes = (List)destination$iv$iv2;
            if (withoutExtensionsMimeTypes.size() == 1) {
                return (String)withoutExtensionsMimeTypes.get(0);
            }
            Iterable $receiver$iv3 = mimeTypesWithoutEmptyEntries;
            destination$iv$iv2 = $receiver$iv3;
            Iterable destination$iv$iv3 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv2) {
                String it4 = (String)element$iv$iv;
                if (!(!StringsKt.startsWith$default((String)it4, (String)"application/", (boolean)false, (int)2, null))) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            List withoutApplicationMimeTypes = (List)destination$iv$iv3;
            if (withoutApplicationMimeTypes.size() == 1) {
                return (String)withoutApplicationMimeTypes.get(0);
            }
            Iterable $receiver$iv4 = withoutApplicationMimeTypes;
            destination$iv$iv3 = $receiver$iv4;
            Collection destination$iv$iv4 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                String it5 = (String)element$iv$iv;
                if (!(!StringsKt.contains$default((CharSequence)it5, (CharSequence)"x-", (boolean)false, (int)2, null))) continue;
                destination$iv$iv4.add(element$iv$iv);
            }
            List withoutApplicationAndExtensionsMimeTypes = (List)destination$iv$iv4;
            if (withoutApplicationAndExtensionsMimeTypes.size() == 1) {
                return (String)withoutApplicationAndExtensionsMimeTypes.get(0);
            }
            Object object = withoutApplicationAndExtensionsMimeTypes;
            if (!object.isEmpty()) {
                return this.tryToGuessBestMimeType(withoutApplicationAndExtensionsMimeTypes, mimeTypesWithoutEmptyEntries);
            }
            String string = this.containsSingleVndType(mimeTypesWithoutEmptyEntries);
            if (string != null) {
                Object it6 = object = string;
                return it6;
            }
            return (String)CollectionsKt.last(mimeTypes);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final String tryToGuessBestMimeType(List<String> withoutApplicationAndExtensionsMimeTypes, List<String> mimeTypesWithoutEmptyEntries) {
        String string = this.getMostUsedCategory(mimeTypesWithoutEmptyEntries);
        if (string != null) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            String string2;
            String category = string2 = string;
            Iterable iterable = $receiver$iv = (Iterable)mimeTypesWithoutEmptyEntries;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                String it = (String)element$iv$iv;
                if (!StringsKt.startsWith$default((String)it, (String)category, (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List mimeTypesOfCategory = (List)destination$iv$iv;
            $receiver$iv = mimeTypesOfCategory;
            return (String)CollectionsKt.first((List)CollectionsKt.sortedWith((Iterable)$receiver$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    String it = (String)a;
                    Comparable comparable = Integer.valueOf(it.length());
                    it = (String)b;
                    Comparable comparable2 = comparable;
                    Integer n = it.length();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            }));
        }
        String string3 = this.getKnownBestPick(withoutApplicationAndExtensionsMimeTypes);
        if (string3 != null) {
            String string4;
            String it = string4 = string3;
            return it;
        }
        Iterable $receiver$iv = withoutApplicationAndExtensionsMimeTypes;
        return (String)CollectionsKt.first((List)CollectionsKt.sortedWith((Iterable)$receiver$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                String it = (String)a;
                Comparable comparable = Integer.valueOf(it.length());
                it = (String)b;
                Comparable comparable2 = comparable;
                Integer n = it.length();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        }));
    }

    private final String getKnownBestPick(List<String> mimeTypes) {
        return mimeTypes.contains("audio/mpeg3") ? "audio/mpeg3" : (mimeTypes.contains("video/mpeg") ? "video/mpeg" : (mimeTypes.contains("video/3gpp") ? "video/3gpp" : null));
    }

    /*
     * WARNING - void declaration
     */
    private final String getMostUsedCategory(List<String> mimeTypesWithoutEmptyEntries) {
        Object object;
        Iterator $receiver$iv$iv;
        Iterable $receiver$iv;
        LinkedHashMap categories = new LinkedHashMap();
        Iterable iterable = $receiver$iv = (Iterable)mimeTypesWithoutEmptyEntries;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv = iterator.next();
            object = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string = StringsKt.substringBefore$default((String)it, (char)'/', null, (int)2, null);
            collection.add(string);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            String category = (String)element$iv;
            Integer currentCount = (Integer)categories.get(category);
            object = categories;
            Integer n = currentCount != null ? currentCount + 1 : 1;
            object.put(category, n);
        }
        if (categories.size() == 1) {
            Set set = categories.keySet();
            Intrinsics.checkExpressionValueIsNotNull(set, (String)"categories.keys");
            return (String)CollectionsKt.first((Iterable)set);
        }
        Iterable $receiver$iv2 = MapsKt.toList((Map)categories);
        LinkedHashMap sortedCategories = (LinkedHashMap)MapsKt.toMap((Iterable)CollectionsKt.sortedWith((Iterable)$receiver$iv2, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                Pair $$_$_count = (Pair)b;
                int count = ((Number)$$_$_count.component2()).intValue();
                $$_$_count = (Pair)a;
                Comparable comparable = Integer.valueOf(count);
                count = ((Number)$$_$_count.component2()).intValue();
                Integer n = count;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n);
            }
        }), (Map)new LinkedHashMap());
        Set set = sortedCategories.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"sortedCategories.keys");
        Integer n = (Integer)sortedCategories.get(CollectionsKt.first((Iterable)set));
        if (n == null) {
            n = 0;
        }
        int n2 = n;
        Set set2 = sortedCategories.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set2, (String)"sortedCategories.keys");
        Integer n3 = (Integer)sortedCategories.get(CollectionsKt.toList((Iterable)set2).get(1));
        if (n3 == null) {
            n3 = 0;
        }
        if (Intrinsics.compare((int)n2, (int)n3) > 0) {
            Set set3 = sortedCategories.keySet();
            Intrinsics.checkExpressionValueIsNotNull(set3, (String)"sortedCategories.keys");
            return (String)CollectionsKt.first((Iterable)set3);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final String containsSingleVndType(List<String> mimeTypesWithoutEmptyEntries) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)mimeTypesWithoutEmptyEntries;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            String it = (String)element$iv$iv;
            if (!StringsKt.contains((CharSequence)it, (CharSequence)"vnd.", (boolean)true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List vnds = (List)destination$iv$iv;
        if (vnds.size() == 1) {
            return (String)vnds.get(0);
        }
        return null;
    }
}

