/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.mime;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u001f\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010 \u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010!\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\"\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010#\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010$\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006%"}, d2={"Lnet/dankito/mime/MimeTypeCategorizer;", "", "()V", "isAudioFile", "", "mimeType", "", "isDocument", "isHtmlFile", "isImageFile", "isMarkUpFile", "isMicrosoftExcelFile", "isMicrosoftExcelSheet", "isMicrosoftExcelTemplate", "isMicrosoftOfficeFile", "isMicrosoftPowerPointFile", "isMicrosoftPowerPointPresentation", "isMicrosoftPowerPointSlideshow", "isMicrosoftPowerPointTemplate", "isMicrosoftWordDocument", "isMicrosoftWordFile", "isMicrosoftWordTemplate", "isOpenOfficeCalcFile", "isOpenOfficeCalcSheet", "isOpenOfficeCalcTemplate", "isOpenOfficeFile", "isOpenOfficeImpressFile", "isOpenOfficeImpressPresentation", "isOpenOfficeImpressTemplate", "isOpenOfficeWriterDocument", "isOpenOfficeWriterFile", "isOpenOfficeWriterTemplate", "isOtherOpenOfficeFile", "isPdfFile", "isTextFile", "isVideoFile", "isXmlFile", "mime-utils"})
public final class MimeTypeCategorizer {
    public final boolean isImageFile(@NotNull String mimeType) {
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        return StringsKt.startsWith((String)mimeType, (String)"image/", (boolean)true);
    }

    public final boolean isAudioFile(@NotNull String mimeType) {
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        return StringsKt.startsWith((String)mimeType, (String)"audio/", (boolean)true);
    }

    public final boolean isVideoFile(@NotNull String mimeType) {
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        return StringsKt.startsWith((String)mimeType, (String)"video/", (boolean)true);
    }

    public final boolean isTextFile(@NotNull String mimeType) {
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        return StringsKt.startsWith((String)mimeType, (String)"text/", (boolean)true);
    }

    public final boolean isDocument(@NotNull String mimeType) {
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        return this.isTextFile(mimeType) || this.isPdfFile(mimeType) || this.isMicrosoftOfficeFile(mimeType) || this.isOpenOfficeFile(mimeType);
    }

    public final boolean isPdfFile(@NotNull String mimeType) {
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        return StringsKt.equals((String)"application/pdf", (String)mimeType, (boolean)true);
    }

    public final boolean isMarkUpFile(@NotNull String mimeType) {
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        return this.isHtmlFile(mimeType) || this.isXmlFile(mimeType);
    }

    public final boolean isHtmlFile(@NotNull String mimeType) {
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        return StringsKt.equals((String)"text/html", (String)mimeType, (boolean)true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isXmlFile(@NotNull String mimeType) {
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        String string = mimeType;
        String string2 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        String string3 = string2;
        switch (string3.hashCode()) {
            case -1248326952: {
                if (!string3.equals("application/xml")) return false;
                return true;
            }
            case -1004727243: {
                if (!string3.equals("text/xml")) return false;
                return true;
            }
        }
        return false;
    }

    public final boolean isMicrosoftOfficeFile(@NotNull String mimeType) {
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        return this.isMicrosoftWordFile(mimeType) || this.isMicrosoftExcelFile(mimeType) || this.isMicrosoftPowerPointFile(mimeType);
    }

    public final boolean isMicrosoftWordFile(@NotNull String mimeType) {
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        return this.isMicrosoftWordDocument(mimeType) || this.isMicrosoftWordTemplate(mimeType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isMicrosoftWordDocument(@NotNull String mimeType) {
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        String string = mimeType;
        String string2 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        String string3 = string2;
        switch (string3.hashCode()) {
            case -1293459259: {
                if (!string3.equals("application/vnd.ms-word.document.macroenabled.12")) return false;
                return true;
            }
            case 904647503: {
                if (!string3.equals("application/msword")) return false;
                return true;
            }
            case -1050893613: {
                if (!string3.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.document")) return false;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isMicrosoftWordTemplate(@NotNull String mimeType) {
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        String string = mimeType;
        String string2 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        String string3 = string2;
        switch (string3.hashCode()) {
            case 1060806194: {
                if (!string3.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.template")) return false;
                return true;
            }
            case 1383644708: {
                if (!string3.equals("application/vnd.ms-word.template.macroenabled.12")) return false;
                return true;
            }
        }
        return false;
    }

    public final boolean isMicrosoftExcelFile(@NotNull String mimeType) {
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        return this.isMicrosoftExcelSheet(mimeType) || this.isMicrosoftExcelTemplate(mimeType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isMicrosoftExcelSheet(@NotNull String mimeType) {
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        String string = mimeType;
        String string2 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        String string3 = string2;
        switch (string3.hashCode()) {
            case 1993842850: {
                if (!string3.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet")) return false;
                return true;
            }
            case -1653115602: {
                if (!string3.equals("application/vnd.ms-excel.sheet.macroenabled.12")) return false;
                return true;
            }
            case -366307023: {
                if (!string3.equals("application/vnd.ms-excel")) return false;
                return true;
            }
            case -300783143: {
                if (!string3.equals("application/vnd.ms-excel.sheet.binary.macroenabled.12")) return false;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isMicrosoftExcelTemplate(@NotNull String mimeType) {
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        String string = mimeType;
        String string2 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        String string3 = string2;
        switch (string3.hashCode()) {
            case -878977693: {
                if (!string3.equals("application/vnd.ms-excel.template.macroenabled.12")) return false;
                return true;
            }
            case -1506009513: {
                if (!string3.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.template")) return false;
                return true;
            }
        }
        return false;
    }

    public final boolean isMicrosoftPowerPointFile(@NotNull String mimeType) {
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        return this.isMicrosoftPowerPointPresentation(mimeType) || this.isMicrosoftPowerPointTemplate(mimeType) || this.isMicrosoftPowerPointSlideshow(mimeType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isMicrosoftPowerPointPresentation(@NotNull String mimeType) {
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        String string = mimeType;
        String string2 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        String string3 = string2;
        switch (string3.hashCode()) {
            case -1073633483: {
                if (!string3.equals("application/vnd.openxmlformats-officedocument.presentationml.presentation")) return false;
                return true;
            }
            case 1750539587: {
                if (!string3.equals("application/vnd.ms-powerpoint.presentation.macroenabled.12")) return false;
                return true;
            }
            case -1071817359: {
                if (!string3.equals("application/vnd.ms-powerpoint")) return false;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isMicrosoftPowerPointTemplate(@NotNull String mimeType) {
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        String string = mimeType;
        String string2 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        String string3 = string2;
        switch (string3.hashCode()) {
            case 65167651: {
                if (!string3.equals("application/vnd.ms-powerpoint.template.macroenabled.12")) return false;
                return true;
            }
            case 694663701: {
                if (!string3.equals("application/vnd.openxmlformats-officedocument.presentationml.template")) return false;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isMicrosoftPowerPointSlideshow(@NotNull String mimeType) {
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        String string = mimeType;
        String string2 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        String string3 = string2;
        switch (string3.hashCode()) {
            case -1095881539: {
                if (!string3.equals("application/vnd.ms-powerpoint.slideshow.macroenabled.12")) return false;
                return true;
            }
            case 1944301046: {
                if (!string3.equals("application/vnd.openxmlformats-officedocument.presentationml.slide")) return false;
                return true;
            }
            case 1577426419: {
                if (!string3.equals("application/vnd.openxmlformats-officedocument.presentationml.slideshow")) return false;
                return true;
            }
        }
        return false;
    }

    public final boolean isOpenOfficeFile(@NotNull String mimeType) {
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        return this.isOpenOfficeWriterFile(mimeType) || this.isOpenOfficeCalcFile(mimeType) || this.isOpenOfficeImpressFile(mimeType) || this.isOtherOpenOfficeFile(mimeType);
    }

    public final boolean isOpenOfficeWriterFile(@NotNull String mimeType) {
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        return this.isOpenOfficeWriterDocument(mimeType) || this.isOpenOfficeWriterTemplate(mimeType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isOpenOfficeWriterDocument(@NotNull String mimeType) {
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        String string = mimeType;
        String string2 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        String string3 = string2;
        switch (string3.hashCode()) {
            case 1673742401: {
                if (!string3.equals("application/vnd.stardivision.writer")) return false;
                return true;
            }
            case -1719571662: {
                if (!string3.equals("application/vnd.oasis.opendocument.text")) return false;
                return true;
            }
            case 1912824857: {
                if (!string3.equals("application/x-starwriter")) return false;
                return true;
            }
            case -1628346451: {
                if (!string3.equals("application/vnd.sun.xml.writer")) return false;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isOpenOfficeWriterTemplate(@NotNull String mimeType) {
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        String string = mimeType;
        String string2 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        String string3 = string2;
        switch (string3.hashCode()) {
            case -1747277413: {
                if (!string3.equals("application/vnd.sun.xml.writer.template")) return false;
                return true;
            }
            case -1316922187: {
                if (!string3.equals("application/vnd.oasis.opendocument.text-template")) return false;
                return true;
            }
        }
        return false;
    }

    public final boolean isOpenOfficeCalcFile(@NotNull String mimeType) {
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        return this.isOpenOfficeCalcSheet(mimeType) || this.isOpenOfficeCalcTemplate(mimeType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isOpenOfficeCalcSheet(@NotNull String mimeType) {
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        String string = mimeType;
        String string2 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        String string3 = string2;
        switch (string3.hashCode()) {
            case -2135180893: {
                if (!string3.equals("application/vnd.stardivision.calc")) return false;
                return true;
            }
            case 729869179: {
                if (!string3.equals("application/x-starcalc")) return false;
                return true;
            }
            case -779959281: {
                if (!string3.equals("application/vnd.sun.xml.calc")) return false;
                return true;
            }
            case 1643664935: {
                if (!string3.equals("application/vnd.oasis.opendocument.spreadsheet")) return false;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isOpenOfficeCalcTemplate(@NotNull String mimeType) {
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        String string = mimeType;
        String string2 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        String string3 = string2;
        switch (string3.hashCode()) {
            case -1590813831: {
                if (!string3.equals("application/vnd.sun.xml.calc.template")) return false;
                return true;
            }
            case -109382304: {
                if (!string3.equals("application/vnd.oasis.opendocument.spreadsheet-template")) return false;
                return true;
            }
        }
        return false;
    }

    public final boolean isOpenOfficeImpressFile(@NotNull String mimeType) {
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        return this.isOpenOfficeImpressPresentation(mimeType) || this.isOpenOfficeImpressTemplate(mimeType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isOpenOfficeImpressPresentation(@NotNull String mimeType) {
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        String string = mimeType;
        String string2 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        String string3 = string2;
        switch (string3.hashCode()) {
            case 776322612: {
                if (!string3.equals("application/vnd.stardivision.impress-packed")) return false;
                return true;
            }
            case -508861767: {
                if (!string3.equals("application/x-starimpress")) return false;
                return true;
            }
            case 1383977381: {
                if (!string3.equals("application/vnd.sun.xml.impress")) return false;
                return true;
            }
            case 1436962847: {
                if (!string3.equals("application/vnd.oasis.opendocument.presentation")) return false;
                return true;
            }
            case 669516689: {
                if (!string3.equals("application/vnd.stardivision.impress")) return false;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isOpenOfficeImpressTemplate(@NotNull String mimeType) {
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        String string = mimeType;
        String string2 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        String string3 = string2;
        switch (string3.hashCode()) {
            case -291851672: {
                if (!string3.equals("application/vnd.oasis.opendocument.presentation-template")) return false;
                return true;
            }
            case -396757341: {
                if (!string3.equals("application/vnd.sun.xml.impress.template")) return false;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isOtherOpenOfficeFile(@NotNull String mimeType) {
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        String string = mimeType;
        String string2 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        String string3 = string2;
        switch (string3.hashCode()) {
            case -1777056778: {
                if (!string3.equals("application/vnd.oasis.opendocument.image")) return false;
                return true;
            }
            case -1782746503: {
                if (!string3.equals("application/vnd.oasis.opendocument.chart")) return false;
                return true;
            }
            case -779661118: {
                if (!string3.equals("application/vnd.sun.xml.math")) return false;
                return true;
            }
            case -2134883067: {
                if (!string3.equals("application/vnd.stardivision.mail")) return false;
                return true;
            }
            case 571050671: {
                if (!string3.equals("application/vnd.stardivision.writer-global")) return false;
                return true;
            }
            case 1151306616: {
                if (!string3.equals("application/x-starchart")) return false;
                return true;
            }
            case -479218428: {
                if (!string3.equals("application/vnd.sun.xml.writer.global")) return false;
                return true;
            }
            case 729914986: {
                if (!string3.equals("application/x-stardraw")) return false;
                return true;
            }
            case 730167342: {
                if (!string3.equals("application/x-starmath")) return false;
                return true;
            }
            case -1033484950: {
                if (!string3.equals("application/vnd.sun.xml.draw.template")) return false;
                return true;
            }
            case -2135135086: {
                if (!string3.equals("application/vnd.stardivision.draw")) return false;
                return true;
            }
            case -1765899696: {
                if (!string3.equals("application/vnd.stardivision.chart")) return false;
                return true;
            }
            case 1377360791: {
                if (!string3.equals("application/vnd.oasis.opendocument.graphics-template")) return false;
                return true;
            }
            case -676675015: {
                if (!string3.equals("application/vnd.oasis.opendocument.text-web")) return false;
                return true;
            }
            case -2134882730: {
                if (!string3.equals("application/vnd.stardivision.math")) return false;
                return true;
            }
            case 2117577984: {
                if (!string3.equals("application/vnd.oasis.opendocument.database")) return false;
                return true;
            }
            case -1715868050: {
                if (!string3.equals("application/vnd.openofficeorg.extension")) return false;
                return true;
            }
            case -943935167: {
                if (!string3.equals("application/vnd.oasis.opendocument.formula")) return false;
                return true;
            }
            case 1461751133: {
                if (!string3.equals("application/vnd.oasis.opendocument.text-master")) return false;
                return true;
            }
            case -779913474: {
                if (!string3.equals("application/vnd.sun.xml.draw")) return false;
                return true;
            }
            case 428819984: {
                if (!string3.equals("application/vnd.oasis.opendocument.graphics")) return false;
                return true;
            }
        }
        return false;
    }
}

