/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.lucene.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import net.dankito.utils.lucene.search.SearchResult;
import net.dankito.utils.lucene.search.SearchResults;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0017\u00a8\u0006\u000e"}, d2={"Lnet/dankito/utils/lucene/search/Searcher;", "", "()V", "search", "Lnet/dankito/utils/lucene/search/SearchResults;", "directory", "Lorg/apache/lucene/store/Directory;", "query", "Lorg/apache/lucene/search/Query;", "countMaxResults", "", "sortFields", "", "Lorg/apache/lucene/search/SortField;", "LuceneUtilsLib"})
public class Searcher {
    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public SearchResults search(@NotNull Directory directory, @NotNull Query query, int countMaxResults, @NotNull List<? extends SortField> sortFields) {
        void $this$mapTo$iv$iv;
        Object object;
        Object object2;
        TopDocs topDocs;
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        Intrinsics.checkParameterIsNotNull(sortFields, (String)"sortFields");
        DirectoryReader reader = DirectoryReader.open((Directory)directory);
        IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
        if (sortFields.isEmpty()) {
            topDocs = searcher.search(query, countMaxResults);
        } else {
            void $this$toTypedArray$iv;
            Collection collection = sortFields;
            int n = countMaxResults;
            object2 = query;
            object = searcher;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            SortField[] sortFieldArray = thisCollection$iv.toArray(new SortField[0]);
            if (sortFieldArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            SortField[] sortFieldArray2 = sortFieldArray;
            SortField[] sortFieldArray3 = Arrays.copyOf(sortFieldArray2, sortFieldArray2.length);
            topDocs = (TopDocs)object.search(object2, n, new Sort(sortFieldArray3));
        }
        TopDocs topDocs2 = topDocs;
        Intrinsics.checkExpressionValueIsNotNull((Object)topDocs2.scoreDocs, (String)"topDocs.scoreDocs");
        ScoreDoc[] $this$map$iv = topDocs2.scoreDocs;
        boolean $i$f$map = false;
        ScoreDoc[] scoreDocArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var14_21 = $this$mapTo$iv$iv;
        int n = ((void)var14_21).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var18_25 = item$iv$iv = var14_21[i];
            object = destination$iv$iv;
            boolean bl = false;
            float f = it.score;
            Document document = searcher.doc(it.doc);
            Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"searcher.doc(it.doc)");
            object2 = new SearchResult(f, document);
            object.add(object2);
        }
        List hits = (List)destination$iv$iv;
        reader.close();
        return new SearchResults(topDocs2.totalHits.value, hits);
    }

    public static /* synthetic */ SearchResults search$default(Searcher searcher, Directory directory, Query query, int n, List list, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: search");
        }
        if ((n2 & 4) != 0) {
            n = 10000;
        }
        if ((n2 & 8) != 0) {
            boolean bl = false;
            list = CollectionsKt.emptyList();
        }
        return searcher.search(directory, query, n, list);
    }

    @JvmOverloads
    @NotNull
    public SearchResults search(@NotNull Directory directory, @NotNull Query query, int countMaxResults) {
        return Searcher.search$default(this, directory, query, countMaxResults, null, 8, null);
    }

    @JvmOverloads
    @NotNull
    public SearchResults search(@NotNull Directory directory, @NotNull Query query) {
        return Searcher.search$default(this, directory, query, 0, null, 12, null);
    }
}

