/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.lucene.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.WildcardQuery;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J(\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0014J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\fH\u0016J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\"\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0017J9\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042'\u0010\u0015\u001a#\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u001a0\u0016H\u0016J9\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u00042'\u0010\u0015\u001a#\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u001a0\u0016H\u0014J\"\u0010\u001c\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0017J\u0018\u0010\u001d\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u000fH\u0016J\u0018\u0010\u001f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\"\u0010 \u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0017J\"\u0010!\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0017J0\u0010!\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0016\u00a8\u0006\""}, d2={"Lnet/dankito/utils/lucene/search/QueryBuilder;", "", "()V", "adjustSearchTerm", "", "searchTerm", "caseInsensitive", "", "adjustSearchTermForWildcardQuery", "prefixWildcard", "suffixWildcard", "afterDateQuery", "Lorg/apache/lucene/search/Query;", "fieldName", "dateAfterThisInclusive", "Ljava/util/Date;", "allDocuments", "beforeDateQuery", "dateBeforeThisInclusive", "contains", "createQueriesForSingleTerms", "singleTermQueryBuilder", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "singleTerm", "", "createQueryForSingleTerm", "endsWith", "exactDateQuery", "date", "fulltextQuery", "startsWith", "wildcardQuery", "LuceneUtilsLib"})
public class QueryBuilder {
    @NotNull
    public Query allDocuments() {
        return (Query)new MatchAllDocsQuery();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Query createQueriesForSingleTerms(@NotNull String searchTerm, @NotNull Function1<? super String, ? extends List<? extends Query>> singleTermQueryBuilder) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)searchTerm, (String)"searchTerm");
        Intrinsics.checkParameterIsNotNull(singleTermQueryBuilder, (String)"singleTermQueryBuilder");
        if (StringsKt.isBlank((CharSequence)searchTerm)) {
            return this.allDocuments();
        }
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)searchTerm, (String[])new String[]{" "}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            CharSequence charSequence = it;
            boolean bl2 = false;
            if (!(!StringsKt.isBlank((CharSequence)charSequence))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List singleTerms = (List)destination$iv$iv;
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        Iterable $this$forEach$iv = singleTerms;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String singleTerm = (String)element$iv;
            boolean bl = false;
            queryBuilder.add(this.createQueryForSingleTerm(singleTerm, singleTermQueryBuilder), BooleanClause.Occur.MUST);
        }
        BooleanQuery booleanQuery = queryBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)booleanQuery, (String)"queryBuilder.build()");
        return (Query)booleanQuery;
    }

    @NotNull
    protected Query createQueryForSingleTerm(@NotNull String singleTerm, @NotNull Function1<? super String, ? extends List<? extends Query>> singleTermQueryBuilder) {
        Intrinsics.checkParameterIsNotNull((Object)singleTerm, (String)"singleTerm");
        Intrinsics.checkParameterIsNotNull(singleTermQueryBuilder, (String)"singleTermQueryBuilder");
        List singleTermQueries = (List)singleTermQueryBuilder.invoke((Object)singleTerm);
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        Iterable $this$forEach$iv = singleTermQueries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Query it = (Query)element$iv;
            boolean bl = false;
            queryBuilder.add(it, BooleanClause.Occur.SHOULD);
        }
        BooleanQuery booleanQuery = queryBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)booleanQuery, (String)"queryBuilder.build()");
        return (Query)booleanQuery;
    }

    @NotNull
    public Query fulltextQuery(@NotNull String fieldName, @NotNull String searchTerm) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Intrinsics.checkParameterIsNotNull((Object)searchTerm, (String)"searchTerm");
        return (Query)new PrefixQuery(new Term(fieldName, this.adjustSearchTerm(searchTerm, false)));
    }

    @JvmOverloads
    @NotNull
    public Query startsWith(@NotNull String fieldName, @NotNull String searchTerm, boolean caseInsensitive) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Intrinsics.checkParameterIsNotNull((Object)searchTerm, (String)"searchTerm");
        return this.wildcardQuery(fieldName, searchTerm, caseInsensitive, true, false);
    }

    public static /* synthetic */ Query startsWith$default(QueryBuilder queryBuilder, String string, String string2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: startsWith");
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return queryBuilder.startsWith(string, string2, bl);
    }

    @JvmOverloads
    @NotNull
    public Query startsWith(@NotNull String fieldName, @NotNull String searchTerm) {
        return QueryBuilder.startsWith$default(this, fieldName, searchTerm, false, 4, null);
    }

    @JvmOverloads
    @NotNull
    public Query contains(@NotNull String fieldName, @NotNull String searchTerm, boolean caseInsensitive) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Intrinsics.checkParameterIsNotNull((Object)searchTerm, (String)"searchTerm");
        return this.wildcardQuery(fieldName, searchTerm, caseInsensitive);
    }

    public static /* synthetic */ Query contains$default(QueryBuilder queryBuilder, String string, String string2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: contains");
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return queryBuilder.contains(string, string2, bl);
    }

    @JvmOverloads
    @NotNull
    public Query contains(@NotNull String fieldName, @NotNull String searchTerm) {
        return QueryBuilder.contains$default(this, fieldName, searchTerm, false, 4, null);
    }

    @JvmOverloads
    @NotNull
    public Query endsWith(@NotNull String fieldName, @NotNull String searchTerm, boolean caseInsensitive) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Intrinsics.checkParameterIsNotNull((Object)searchTerm, (String)"searchTerm");
        return this.wildcardQuery(fieldName, searchTerm, caseInsensitive, false, true);
    }

    public static /* synthetic */ Query endsWith$default(QueryBuilder queryBuilder, String string, String string2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: endsWith");
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return queryBuilder.endsWith(string, string2, bl);
    }

    @JvmOverloads
    @NotNull
    public Query endsWith(@NotNull String fieldName, @NotNull String searchTerm) {
        return QueryBuilder.endsWith$default(this, fieldName, searchTerm, false, 4, null);
    }

    @JvmOverloads
    @NotNull
    public Query wildcardQuery(@NotNull String fieldName, @NotNull String searchTerm, boolean caseInsensitive) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Intrinsics.checkParameterIsNotNull((Object)searchTerm, (String)"searchTerm");
        return this.wildcardQuery(fieldName, searchTerm, caseInsensitive, true, true);
    }

    public static /* synthetic */ Query wildcardQuery$default(QueryBuilder queryBuilder, String string, String string2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: wildcardQuery");
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return queryBuilder.wildcardQuery(string, string2, bl);
    }

    @JvmOverloads
    @NotNull
    public Query wildcardQuery(@NotNull String fieldName, @NotNull String searchTerm) {
        return QueryBuilder.wildcardQuery$default(this, fieldName, searchTerm, false, 4, null);
    }

    @NotNull
    public Query wildcardQuery(@NotNull String fieldName, @NotNull String searchTerm, boolean caseInsensitive, boolean prefixWildcard, boolean suffixWildcard) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Intrinsics.checkParameterIsNotNull((Object)searchTerm, (String)"searchTerm");
        String adjustedSearchTerm = this.adjustSearchTermForWildcardQuery(searchTerm, caseInsensitive, prefixWildcard, suffixWildcard);
        return (Query)new WildcardQuery(new Term(fieldName, adjustedSearchTerm));
    }

    @NotNull
    protected String adjustSearchTermForWildcardQuery(@NotNull String searchTerm, boolean caseInsensitive, boolean prefixWildcard, boolean suffixWildcard) {
        Intrinsics.checkParameterIsNotNull((Object)searchTerm, (String)"searchTerm");
        String adjustedSearchTerm = this.adjustSearchTerm(searchTerm, caseInsensitive);
        if (prefixWildcard && suffixWildcard) {
            return '*' + adjustedSearchTerm + '*';
        }
        if (prefixWildcard) {
            return adjustedSearchTerm + '*';
        }
        return '*' + adjustedSearchTerm;
    }

    @NotNull
    protected String adjustSearchTerm(@NotNull String searchTerm, boolean caseInsensitive) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)searchTerm, (String)"searchTerm");
        String adjustedSearchTerm = QueryParser.escape((String)searchTerm);
        if (caseInsensitive) {
            String string2 = adjustedSearchTerm;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"adjustedSearchTerm");
            String string3 = string2;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase();
            string = string5;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
        } else {
            String string6 = adjustedSearchTerm;
            string = string6;
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"adjustedSearchTerm");
        }
        return string;
    }

    @NotNull
    public Query exactDateQuery(@NotNull String fieldName, @NotNull Date date) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        Query query = LongPoint.newExactQuery((String)fieldName, (long)date.getTime());
        Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"LongPoint.newExactQuery(fieldName, date.time)");
        return query;
    }

    @NotNull
    public Query afterDateQuery(@NotNull String fieldName, @NotNull Date dateAfterThisInclusive) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Intrinsics.checkParameterIsNotNull((Object)dateAfterThisInclusive, (String)"dateAfterThisInclusive");
        Query query = LongPoint.newRangeQuery((String)fieldName, (long)dateAfterThisInclusive.getTime(), (long)Long.MAX_VALUE);
        Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"LongPoint.newRangeQuery(\u2026ive.time, Long.MAX_VALUE)");
        return query;
    }

    @NotNull
    public Query beforeDateQuery(@NotNull String fieldName, @NotNull Date dateBeforeThisInclusive) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Intrinsics.checkParameterIsNotNull((Object)dateBeforeThisInclusive, (String)"dateBeforeThisInclusive");
        Query query = LongPoint.newRangeQuery((String)fieldName, (long)Long.MIN_VALUE, (long)dateBeforeThisInclusive.getTime());
        Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"LongPoint.newRangeQuery(\u2026BeforeThisInclusive.time)");
        return query;
    }
}

