/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.lucene.index;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0018\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0014J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\nH\u0016J)\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0013\"\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\u0014J9\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0013\"\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\u0016J=\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0016\u0010\u0005\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00070\u0013\"\u0004\u0018\u00010\u0007H\u0016\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lnet/dankito/utils/lucene/index/DocumentsWriter;", "", "()V", "createDocument", "Lorg/apache/lucene/document/Document;", "fields", "", "Lorg/apache/lucene/index/IndexableField;", "createIdField", "fieldName", "", "value", "deleteDocument", "", "writer", "Lorg/apache/lucene/index/IndexWriter;", "idFieldName", "idFieldValue", "saveDocument", "", "(Lorg/apache/lucene/index/IndexWriter;[Lorg/apache/lucene/index/IndexableField;)Lorg/apache/lucene/document/Document;", "updateDocument", "(Lorg/apache/lucene/index/IndexWriter;Ljava/lang/String;Ljava/lang/String;[Lorg/apache/lucene/index/IndexableField;)Lorg/apache/lucene/document/Document;", "updateDocumentForNonNullFields", "LuceneUtilsLib"})
public class DocumentsWriter {
    @NotNull
    public Document createDocument(@NotNull List<? extends IndexableField> fields) {
        Intrinsics.checkParameterIsNotNull(fields, (String)"fields");
        Document document = new Document();
        Iterable $this$forEach$iv = fields;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IndexableField field = (IndexableField)element$iv;
            boolean bl = false;
            document.add(field);
        }
        return document;
    }

    @NotNull
    public Document saveDocument(@NotNull IndexWriter writer, IndexableField ... fields) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        Intrinsics.checkParameterIsNotNull((Object)fields, (String)"fields");
        Document document = this.createDocument(ArraysKt.toList((Object[])fields));
        writer.addDocument((Iterable)document);
        writer.commit();
        return document;
    }

    @NotNull
    public Document updateDocument(@NotNull IndexWriter writer, @NotNull String idFieldName, @NotNull String idFieldValue, IndexableField ... fields) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        Intrinsics.checkParameterIsNotNull((Object)idFieldName, (String)"idFieldName");
        Intrinsics.checkParameterIsNotNull((Object)idFieldValue, (String)"idFieldValue");
        Intrinsics.checkParameterIsNotNull((Object)fields, (String)"fields");
        List fieldsIncludingIdField = CollectionsKt.mutableListOf((Object[])new IndexableField[]{this.createIdField(idFieldName, idFieldValue)});
        fieldsIncludingIdField.addAll(ArraysKt.toList((Object[])fields));
        Document document = this.createDocument(fieldsIncludingIdField);
        Term findExistingDocumentTerm = new Term(idFieldName, idFieldValue);
        writer.updateDocument(findExistingDocumentTerm, (Iterable)document);
        writer.commit();
        return document;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Document updateDocumentForNonNullFields(@NotNull IndexWriter writer, @NotNull String idFieldName, @NotNull String idFieldValue, IndexableField ... fields) {
        IndexableField[] indexableFieldArray;
        void $this$toTypedArray$iv;
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        Intrinsics.checkParameterIsNotNull((Object)idFieldName, (String)"idFieldName");
        Intrinsics.checkParameterIsNotNull((Object)idFieldValue, (String)"idFieldValue");
        Intrinsics.checkParameterIsNotNull((Object)fields, (String)"fields");
        Collection collection = ArraysKt.filterNotNull((Object[])fields);
        String string = idFieldValue;
        String string2 = idFieldName;
        IndexWriter indexWriter = writer;
        DocumentsWriter documentsWriter = this;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        IndexableField[] indexableFieldArray2 = thisCollection$iv.toArray(new IndexableField[0]);
        if (indexableFieldArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        IndexableField[] indexableFieldArray3 = indexableFieldArray = indexableFieldArray2;
        return documentsWriter.updateDocument(indexWriter, string2, string, Arrays.copyOf(indexableFieldArray3, indexableFieldArray3.length));
    }

    public void deleteDocument(@NotNull IndexWriter writer, @NotNull String idFieldName, @NotNull String idFieldValue) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        Intrinsics.checkParameterIsNotNull((Object)idFieldName, (String)"idFieldName");
        Intrinsics.checkParameterIsNotNull((Object)idFieldValue, (String)"idFieldValue");
        writer.deleteDocuments(new Term[]{new Term(idFieldName, idFieldValue)});
    }

    @NotNull
    protected IndexableField createIdField(@NotNull String fieldName, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return (IndexableField)new StringField(fieldName, value, Field.Store.YES);
    }
}

