/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.web.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.dankito.utils.web.client.Cookie;
import net.dankito.utils.web.client.IWebClient;
import net.dankito.utils.web.client.RequestParameters;
import net.dankito.utils.web.client.ResponseType;
import net.dankito.utils.web.client.WebClientResponse;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\b\u0016\u0018\u0000 \\2\u00020\u0001:\u0001\\B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J?\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001d2!\u0010\u001e\u001a\u001d\u0012\u0013\u0012\u00110 \u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020\u00150\u001fH\u0014J?\u0010$\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001d2!\u0010\u001e\u001a\u001d\u0012\u0013\u0012\u00110 \u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020\u00150\u001fH\u0014J?\u0010%\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001d2!\u0010\u001e\u001a\u001d\u0012\u0013\u0012\u00110 \u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020\u00150\u001fH\u0014JG\u0010&\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(2\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001d2!\u0010\u001e\u001a\u001d\u0012\u0013\u0012\u00110 \u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020\u00150\u001fH\u0014J\u0010\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\rH\u0002J\u001e\u0010+\u001a\u0010\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020-\u0018\u00010,2\u0006\u0010#\u001a\u00020.H\u0014J\u0010\u0010/\u001a\u00020(2\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0010\u00100\u001a\u00020(2\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u00101\u001a\u00020\u0004H\u0004J\u0010\u00102\u001a\u00020(2\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0018\u00103\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(H\u0014J\u0018\u00104\u001a\u00020.2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(H\u0014J;\u00105\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(2!\u0010\u001e\u001a\u001d\u0012\u0013\u0012\u00110 \u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020\u00150\u001fH\u0014J\u0010\u00106\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J3\u00107\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192!\u0010\u001e\u001a\u001d\u0012\u0013\u0012\u00110 \u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020\u00150\u001fH\u0016J\u0014\u00108\u001a\u0004\u0018\u0001092\b\u0010:\u001a\u0004\u0018\u00010-H\u0014J\u001c\u0010;\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u00192\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001dH\u0014J\u0018\u0010<\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010#\u001a\u00020.H\u0014J\u0010\u0010=\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J3\u0010>\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192!\u0010\u001e\u001a\u001d\u0012\u0013\u0012\u00110 \u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020\u00150\u001fH\u0016J\u001c\u0010?\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u00192\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001dH\u0014J\u0010\u0010@\u001a\u00020A2\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0014\u0010B\u001a\u00020A2\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001dH\u0014J\u0010\u0010C\u001a\u00020\u000f2\u0006\u0010D\u001a\u00020EH\u0014J\u0010\u0010C\u001a\u00020E2\u0006\u0010D\u001a\u00020\u000fH\u0014J\u0016\u0010F\u001a\b\u0012\u0004\u0012\u00020E0\u000e2\u0006\u0010#\u001a\u00020.H\u0014J\u0010\u0010G\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J3\u0010H\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192!\u0010\u001e\u001a\u001d\u0012\u0013\u0012\u00110 \u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020\u00150\u001fH\u0016J\u001c\u0010I\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u00192\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001dH\u0014J\u0010\u0010J\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J(\u0010K\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020OH\u0014J0\u0010K\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010Q\u001a\u00020M2\u0006\u0010R\u001a\u00020O2\u0006\u0010S\u001a\u00020O2\u0006\u0010T\u001a\u00020UH\u0014J\u001c\u0010V\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u00192\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001dH\u0002J\u0018\u0010W\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u001c\u0010X\u001a\u00020A2\u0006\u0010\u0018\u001a\u00020\u00192\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001dH\u0014J<\u0010Y\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010#\u001a\u00020.2\u0014\u0010Z\u001a\u0010\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020-\u0018\u00010,2\f\u0010[\u001a\b\u0012\u0004\u0012\u00020E0\u000eH\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR&\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R&\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006]"}, d2={"Lnet/dankito/utils/web/client/OkHttpWebClient;", "Lnet/dankito/utils/web/client/IWebClient;", "()V", "client", "Lokhttp3/OkHttpClient;", "getClient", "()Lokhttp3/OkHttpClient;", "cookieJar", "Lokhttp3/CookieJar;", "getCookieJar", "()Lokhttp3/CookieJar;", "cookiesToSetInNextCall", "Ljava/util/concurrent/ConcurrentHashMap;", "Lokhttp3/HttpUrl;", "", "Lokhttp3/Cookie;", "getCookiesToSetInNextCall", "()Ljava/util/concurrent/ConcurrentHashMap;", "receivedCookies", "getReceivedCookies", "applyParameters", "", "requestBuilder", "Lokhttp3/Request$Builder;", "parameters", "Lnet/dankito/utils/web/client/RequestParameters;", "asyncGetRequestFailed", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "callback", "Lkotlin/Function1;", "Lnet/dankito/utils/web/client/WebClientResponse;", "Lkotlin/ParameterName;", "name", "response", "asyncHeadRequestFailed", "asyncPostRequestFailed", "asyncRequestFailed", "request", "Lokhttp3/Request;", "clearCookiesForUrl", "url", "copyHeaders", "", "", "Lokhttp3/Response;", "createGetRequest", "createHeadRequest", "createOkHttpClient", "createPostRequest", "executeAndGetResponse", "executeRequest", "executeRequestAsync", "get", "getAsync", "getMediaType", "Lokhttp3/MediaType;", "contentType", "getRequestFailed", "getResponse", "head", "headAsync", "headRequestFailed", "isCancelled", "", "isConnectionException", "mapCookie", "cookie", "Lnet/dankito/utils/web/client/Cookie;", "mapCookies", "post", "postAsync", "postRequestFailed", "prepareConnectionRetry", "publishProgress", "downloadedChunk", "", "currentlyDownloaded", "", "total", "buffer", "downloaded", "contentLength", "read", "", "requestFailedFinally", "setPostBody", "shouldRetryConnection", "streamBinaryResponse", "headers", "cookies", "Companion", "JavaUtils"})
public class OkHttpWebClient
implements IWebClient {
    @NotNull
    private final ConcurrentHashMap<HttpUrl, List<okhttp3.Cookie>> receivedCookies = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentHashMap<HttpUrl, List<okhttp3.Cookie>> cookiesToSetInNextCall = new ConcurrentHashMap();
    @NotNull
    private final CookieJar cookieJar = new CookieJar(this){
        final /* synthetic */ OkHttpWebClient this$0;

        public void saveFromResponse(@Nullable HttpUrl url, @Nullable List<okhttp3.Cookie> cookies) {
            block1: {
                HttpUrl httpUrl = url;
                if (httpUrl == null) break block1;
                HttpUrl httpUrl2 = httpUrl;
                boolean bl = false;
                boolean bl2 = false;
                HttpUrl it = httpUrl2;
                boolean bl3 = false;
                List<okhttp3.Cookie> list = cookies;
                if (list != null) {
                    List<okhttp3.Cookie> list2 = list;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    List<okhttp3.Cookie> it2 = list2;
                    boolean bl6 = false;
                    this.this$0.getReceivedCookies().put(url, cookies);
                }
            }
        }

        @NotNull
        public List<okhttp3.Cookie> loadForRequest(@Nullable HttpUrl url) {
            Map map = this.this$0.getCookiesToSetInNextCall();
            boolean bl = false;
            List list = (List)map.get(url);
            if (list == null || (list = CollectionsKt.toMutableList((Collection)list)) == null) {
                boolean bl2 = false;
                list = new ArrayList<E>();
            }
            return list;
        }
        {
            this.this$0 = $outer;
        }
    };
    @NotNull
    private final OkHttpClient client = this.createOkHttpClient();
    private static final Logger log;
    public static final Companion Companion;

    @NotNull
    protected final ConcurrentHashMap<HttpUrl, List<okhttp3.Cookie>> getReceivedCookies() {
        return this.receivedCookies;
    }

    @NotNull
    protected final ConcurrentHashMap<HttpUrl, List<okhttp3.Cookie>> getCookiesToSetInNextCall() {
        return this.cookiesToSetInNextCall;
    }

    @NotNull
    protected final CookieJar getCookieJar() {
        return this.cookieJar;
    }

    @NotNull
    protected final OkHttpClient getClient() {
        return this.client;
    }

    @NotNull
    protected final OkHttpClient createOkHttpClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.followRedirects(true);
        builder.retryOnConnectionFailure(true);
        builder.connectTimeout((long)2000, TimeUnit.MILLISECONDS);
        builder.readTimeout((long)2000, TimeUnit.MILLISECONDS);
        builder.writeTimeout((long)2000, TimeUnit.MILLISECONDS);
        builder.cookieJar(this.cookieJar);
        OkHttpClient okHttpClient = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)okHttpClient, (String)"builder.build()");
        return okHttpClient;
    }

    @Override
    @NotNull
    public WebClientResponse get(@NotNull RequestParameters parameters) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        try {
            Request request = this.createGetRequest(parameters);
            return this.executeAndGetResponse(parameters, request);
        }
        catch (Exception e) {
            return this.getRequestFailed(parameters, e);
        }
    }

    @Override
    public void getAsync(@NotNull RequestParameters parameters, @NotNull Function1<? super WebClientResponse, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        try {
            Request request = this.createGetRequest(parameters);
            this.executeRequestAsync(parameters, request, callback);
        }
        catch (Exception e) {
            this.asyncGetRequestFailed(parameters, e, callback);
        }
    }

    @NotNull
    protected Request createGetRequest(@NotNull RequestParameters parameters) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Request.Builder requestBuilder = new Request.Builder();
        this.applyParameters(requestBuilder, parameters);
        Request request = requestBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)request, (String)"requestBuilder.build()");
        return request;
    }

    @Override
    @NotNull
    public WebClientResponse post(@NotNull RequestParameters parameters) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        try {
            Request request = this.createPostRequest(parameters);
            return this.executeAndGetResponse(parameters, request);
        }
        catch (Exception e) {
            return this.postRequestFailed(parameters, e);
        }
    }

    @Override
    public void postAsync(@NotNull RequestParameters parameters, @NotNull Function1<? super WebClientResponse, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        try {
            Request request = this.createPostRequest(parameters);
            this.executeRequestAsync(parameters, request, callback);
        }
        catch (Exception e) {
            this.asyncPostRequestFailed(parameters, e, callback);
        }
    }

    @NotNull
    protected Request createPostRequest(@NotNull RequestParameters parameters) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Request.Builder requestBuilder = new Request.Builder();
        this.setPostBody(requestBuilder, parameters);
        this.applyParameters(requestBuilder, parameters);
        Request request = requestBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)request, (String)"requestBuilder.build()");
        return request;
    }

    protected void setPostBody(@NotNull Request.Builder requestBuilder, @NotNull RequestParameters parameters) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)requestBuilder, (String)"requestBuilder");
            Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
            String string = parameters.getBody();
            if (string == null) break block1;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String body = string2;
            boolean bl3 = false;
            if (parameters.isBodySet()) {
                MediaType mediaType = this.getMediaType(parameters.getContentType());
                RequestBody postBody = RequestBody.create((MediaType)mediaType, (String)body);
                requestBuilder.post(postBody);
            }
        }
    }

    @Nullable
    protected MediaType getMediaType(@Nullable String contentType) {
        try {
            String string = contentType;
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                return MediaType.parse((String)contentType);
            }
        }
        catch (Exception e) {
            log.error("Could not parse '" + contentType + "' to a MediaType");
        }
        return null;
    }

    @Override
    @NotNull
    public WebClientResponse head(@NotNull RequestParameters parameters) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        try {
            Request request = this.createHeadRequest(parameters);
            return this.executeAndGetResponse(parameters, request);
        }
        catch (Exception e) {
            return this.headRequestFailed(parameters, e);
        }
    }

    @Override
    public void headAsync(@NotNull RequestParameters parameters, @NotNull Function1<? super WebClientResponse, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        try {
            Request request = this.createHeadRequest(parameters);
            this.executeRequestAsync(parameters, request, callback);
        }
        catch (Exception e) {
            this.asyncHeadRequestFailed(parameters, e, callback);
        }
    }

    @NotNull
    protected Request createHeadRequest(@NotNull RequestParameters parameters) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Request.Builder requestBuilder = new Request.Builder();
        this.applyParameters(requestBuilder, parameters);
        requestBuilder.head();
        Request request = requestBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)request, (String)"requestBuilder.build()");
        return request;
    }

    /*
     * WARNING - void declaration
     */
    protected void applyParameters(@NotNull Request.Builder requestBuilder, @NotNull RequestParameters parameters) {
        Collection<okhttp3.Cookie> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)requestBuilder, (String)"requestBuilder");
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        requestBuilder.url(parameters.getUrl());
        if (parameters.isUserAgentSet()) {
            requestBuilder.header("User-Agent", parameters.getUserAgent());
        }
        Object $this$forEach$iv = parameters.getHeaders();
        boolean $i$f$forEach = false;
        Map<String, String> map = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> $dstr$name$value = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry<String, String> entry = $dstr$name$value;
            boolean bl3 = false;
            String name = entry.getKey();
            entry = $dstr$name$value;
            bl3 = false;
            String value = entry.getValue();
            requestBuilder.header(name, value);
        }
        $this$forEach$iv = parameters.getCookies();
        HttpUrl httpUrl = HttpUrl.get((String)parameters.getUrl());
        ConcurrentHashMap<HttpUrl, List<okhttp3.Cookie>> concurrentHashMap = this.cookiesToSetInNextCall;
        boolean $i$f$map = false;
        map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Cookie bl2 = (Cookie)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl4 = false;
            okhttp3.Cookie cookie = this.mapCookie((Cookie)it);
            collection.add(cookie);
        }
        collection = (List)destination$iv$iv;
        concurrentHashMap.put(httpUrl, (List<okhttp3.Cookie>)collection);
    }

    @NotNull
    protected Response executeRequest(@NotNull RequestParameters parameters, @NotNull Request request) throws Exception {
        Response response;
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Response response2 = response = this.client.newCall(request).execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
        if (!response2.isSuccessful() && parameters.isCountConnectionRetriesSet()) {
            this.prepareConnectionRetry(parameters);
            return this.executeRequest(parameters, request);
        }
        return response;
    }

    protected void executeRequestAsync(@NotNull RequestParameters parameters, @NotNull Request request, @NotNull Function1<? super WebClientResponse, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.client.newCall(request).enqueue(new Callback(this, parameters, request, callback){
            final /* synthetic */ OkHttpWebClient this$0;
            final /* synthetic */ RequestParameters $parameters;
            final /* synthetic */ Request $request;
            final /* synthetic */ Function1 $callback;

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.this$0.asyncRequestFailed(this.$parameters, this.$request, e, (Function1<? super WebClientResponse, Unit>)this.$callback);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                this.$callback.invoke((Object)this.this$0.getResponse(this.$parameters, response));
            }
            {
                this.this$0 = $outer;
                this.$parameters = $captured_local_variable$1;
                this.$request = $captured_local_variable$2;
                this.$callback = $captured_local_variable$3;
            }
        });
    }

    @NotNull
    protected WebClientResponse getRequestFailed(@NotNull RequestParameters parameters, @NotNull Exception e) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        if (this.shouldRetryConnection(parameters, e)) {
            this.prepareConnectionRetry(parameters);
            return this.get(parameters);
        }
        return this.requestFailedFinally(parameters, e);
    }

    protected void asyncGetRequestFailed(@NotNull RequestParameters parameters, @NotNull Exception e, @NotNull Function1<? super WebClientResponse, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        if (this.shouldRetryConnection(parameters, e)) {
            this.prepareConnectionRetry(parameters);
            this.getAsync(parameters, callback);
        } else {
            callback.invoke((Object)this.requestFailedFinally(parameters, e));
        }
    }

    @NotNull
    protected WebClientResponse postRequestFailed(@NotNull RequestParameters parameters, @NotNull Exception e) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        if (this.shouldRetryConnection(parameters, e)) {
            this.prepareConnectionRetry(parameters);
            return this.post(parameters);
        }
        return this.requestFailedFinally(parameters, e);
    }

    protected void asyncPostRequestFailed(@NotNull RequestParameters parameters, @NotNull Exception e, @NotNull Function1<? super WebClientResponse, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        if (this.shouldRetryConnection(parameters, e)) {
            this.prepareConnectionRetry(parameters);
            this.postAsync(parameters, callback);
        } else {
            callback.invoke((Object)this.requestFailedFinally(parameters, e));
        }
    }

    @NotNull
    protected WebClientResponse headRequestFailed(@NotNull RequestParameters parameters, @NotNull Exception e) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        if (this.shouldRetryConnection(parameters, e)) {
            this.prepareConnectionRetry(parameters);
            return this.head(parameters);
        }
        return this.requestFailedFinally(parameters, e);
    }

    protected void asyncHeadRequestFailed(@NotNull RequestParameters parameters, @NotNull Exception e, @NotNull Function1<? super WebClientResponse, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        if (this.shouldRetryConnection(parameters, e)) {
            this.prepareConnectionRetry(parameters);
            this.headAsync(parameters, callback);
        } else {
            callback.invoke((Object)this.requestFailedFinally(parameters, e));
        }
    }

    protected void asyncRequestFailed(@NotNull RequestParameters parameters, @NotNull Request request, @NotNull Exception e, @NotNull Function1<? super WebClientResponse, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        if (this.shouldRetryConnection(parameters, e)) {
            this.prepareConnectionRetry(parameters);
            this.executeRequestAsync(parameters, request, callback);
        } else {
            log.error("Failure on Request to " + request.url(), (Throwable)e);
            callback.invoke((Object)this.requestFailedFinally(parameters, e));
        }
    }

    private final WebClientResponse requestFailedFinally(RequestParameters parameters, Exception e) {
        log.error("Could not request url " + parameters.getUrl(), (Throwable)e);
        HttpUrl httpUrl = HttpUrl.get((String)parameters.getUrl());
        Intrinsics.checkExpressionValueIsNotNull((Object)httpUrl, (String)"HttpUrl.get(parameters.url)");
        this.clearCookiesForUrl(httpUrl);
        return new WebClientResponse(false, 0, null, null, e, null, null, 110, null);
    }

    private final void clearCookiesForUrl(HttpUrl url) {
        this.cookiesToSetInNextCall.remove(url);
    }

    protected void prepareConnectionRetry(@NotNull RequestParameters parameters) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        parameters.decrementCountConnectionRetries();
        log.info("Going to retry to connect to " + parameters.getUrl() + " (count tries left: " + parameters.getCountConnectionRetries() + ")");
    }

    protected boolean shouldRetryConnection(@NotNull RequestParameters parameters, @NotNull Exception e) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        return parameters.isCountConnectionRetriesSet() && this.isConnectionException(e);
    }

    protected boolean isConnectionException(@NotNull Exception e) {
        String string;
        block5: {
            block4: {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                string = e.getMessage();
                if (string == null) break block4;
                String string2 = string;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                string = string4;
                if (string4 != null) break block5;
            }
            string = "";
        }
        String errorMessage = string;
        return StringsKt.contains$default((CharSequence)errorMessage, (CharSequence)"timeout", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)errorMessage, (CharSequence)"failed to connect", (boolean)false, (int)2, null);
    }

    @NotNull
    protected WebClientResponse executeAndGetResponse(@NotNull RequestParameters parameters, @NotNull Request request) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Response response = this.executeRequest(parameters, request);
        return this.getResponse(parameters, response);
    }

    @NotNull
    protected WebClientResponse getResponse(@NotNull RequestParameters parameters, @NotNull Response response) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        Map<String, String> headers = this.copyHeaders(response);
        List<Cookie> cookies = this.mapCookies(response);
        HttpUrl httpUrl = response.request().url();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpUrl, (String)"response.request().url()");
        this.clearCookiesForUrl(httpUrl);
        if (parameters.getResponseType() == ResponseType.String) {
            ResponseBody responseBody = response.body();
            String body = responseBody != null ? responseBody.string() : null;
            response.close();
            return new WebClientResponse(true, response.code(), headers, cookies, null, body, null, 80, null);
        }
        if (parameters.getResponseType() == ResponseType.Stream) {
            ResponseBody responseBody = response.body();
            return new WebClientResponse(true, response.code(), headers, cookies, null, null, responseBody != null ? responseBody.byteStream() : null, 48, null);
        }
        return this.streamBinaryResponse(parameters, response, headers, cookies);
    }

    @Nullable
    protected Map<String, String> copyHeaders(@NotNull Response response) {
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        HashMap<String, String> headers = new HashMap<String, String>();
        Set set = response.headers().names();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"response.headers().names()");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String name = (String)element$iv;
            boolean bl = false;
            String string = response.header(name);
            if (string == null) {
                string = "";
            }
            headers.put(name, string);
        }
        return headers;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<Cookie> mapCookies(@NotNull Response response) {
        List list;
        List<okhttp3.Cookie> cookies;
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        List<okhttp3.Cookie> list2 = cookies = this.receivedCookies.remove(response.request().url());
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                okhttp3.Cookie cookie = (okhttp3.Cookie)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Cookie cookie2 = this.mapCookie((okhttp3.Cookie)it);
                collection.add(cookie2);
            }
            list = (List)destination$iv$iv;
        } else {
            boolean bl = false;
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    protected Cookie mapCookie(@NotNull okhttp3.Cookie cookie) {
        Intrinsics.checkParameterIsNotNull((Object)cookie, (String)"cookie");
        String string = cookie.name();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"cookie.name()");
        String string2 = cookie.value();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"cookie.value()");
        String string3 = cookie.domain();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"cookie.domain()");
        String string4 = cookie.path();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"cookie.path()");
        return new Cookie(string, string2, string3, string4, cookie.expiresAt(), cookie.secure(), cookie.httpOnly(), cookie.persistent(), cookie.hostOnly());
    }

    @NotNull
    protected okhttp3.Cookie mapCookie(@NotNull Cookie cookie) {
        Intrinsics.checkParameterIsNotNull((Object)cookie, (String)"cookie");
        Cookie.Builder builder = new Cookie.Builder().name(cookie.getName()).value(cookie.getValue()).domain(cookie.getDomain()).path(cookie.getPath()).expiresAt(cookie.getExpiresAt());
        if (cookie.getSecure()) {
            builder.secure();
        }
        if (cookie.getHttpOnly()) {
            builder.httpOnly();
        }
        if (cookie.getHostOnly()) {
            builder.hostOnlyDomain(cookie.getDomain());
        }
        okhttp3.Cookie cookie2 = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)cookie2, (String)"builder.build()");
        return cookie2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    protected WebClientResponse streamBinaryResponse(@NotNull RequestParameters parameters, @NotNull Response response, @Nullable Map<String, String> headers, @NotNull List<Cookie> cookies) {
        InputStream inputStream;
        WebClientResponse read2;
        InputStream inputStream2;
        block26: {
            InputStream it;
            WebClientResponse webClientResponse;
            Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
            Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
            Intrinsics.checkParameterIsNotNull(cookies, (String)"cookies");
            inputStream2 = null;
            try {
                ResponseBody responseBody = response.body();
                inputStream2 = responseBody != null ? responseBody.byteStream() : null;
                byte[] buffer = new byte[parameters.getDownloadBufferSize()];
                long downloaded = 0L;
                ResponseBody responseBody2 = response.body();
                long contentLength = responseBody2 != null ? responseBody2.contentLength() : 0L;
                this.publishProgress(parameters, new byte[0], 0L, contentLength);
                do {
                    int read2;
                    InputStream inputStream3 = inputStream2;
                    if (inputStream3 == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((read2 = inputStream3.read(buffer)) == -1) {
                        read2 = new WebClientResponse(true, response.code(), headers, cookies, null, null, null, 112, null);
                        inputStream = inputStream2;
                        break block26;
                    }
                    this.publishProgress(parameters, buffer, downloaded += (long)read2, contentLength, read2);
                } while (!this.isCancelled(parameters));
                webClientResponse = new WebClientResponse(false, response.code(), headers, cookies, null, null, null, 112, null);
                InputStream inputStream4 = inputStream2;
                boolean bl = false;
                boolean bl2 = false;
                it = inputStream4;
                boolean bl3 = false;
            }
            catch (IOException e) {
                log.error("Could not download binary Response for Url " + parameters.getUrl(), (Throwable)e);
                WebClientResponse webClientResponse2 = new WebClientResponse(false, response.code(), headers, cookies, e, null, null, 96, null);
                return webClientResponse2;
            }
            try {
                it.close();
            }
            catch (Exception exception) {
            }
            try {
                response.close();
                return webClientResponse;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return webClientResponse;
        }
        boolean bl = false;
        boolean bl4 = false;
        InputStream it = inputStream;
        boolean bl5 = false;
        try {
            it.close();
        }
        catch (Exception exception) {
        }
        try {
            response.close();
            return read2;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return read2;
        finally {
            InputStream inputStream5 = inputStream2;
            if (inputStream5 != null) {
                InputStream inputStream6 = inputStream5;
                boolean bl6 = false;
                boolean bl7 = false;
                InputStream it2 = inputStream6;
                $i$a$-let-OkHttpWebClient$streamBinaryResponse$1 = false;
                try {
                    it2.close();
                }
                catch (Exception exception) {
                }
            }
            try {
                response.close();
            }
            catch (Exception exception) {}
        }
    }

    protected boolean isCancelled(@NotNull RequestParameters parameters) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        return false;
    }

    protected void publishProgress(@NotNull RequestParameters parameters, @NotNull byte[] buffer, long downloaded, long contentLength, int read) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        byte[] downloadedData = buffer;
        if (read < parameters.getDownloadBufferSize()) {
            byte[] byArray = Arrays.copyOfRange(buffer, 0, read);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Arrays.copyOfRange(buffer, 0, read)");
            downloadedData = byArray;
        }
        this.publishProgress(parameters, downloadedData, downloaded, contentLength);
    }

    protected void publishProgress(@NotNull RequestParameters parameters, @NotNull byte[] downloadedChunk, long currentlyDownloaded, long total) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)downloadedChunk, (String)"downloadedChunk");
        Function2<Float, byte[], Unit> progressListener = parameters.getDownloadProgressListener();
        if (progressListener != null) {
            float progress = total <= 0L ? Float.NaN : (float)currentlyDownloaded / (float)total;
            progressListener.invoke((Object)Float.valueOf(progress), (Object)downloadedChunk);
        }
    }

    static {
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(OkHttpWebClient.class);
    }

    @Override
    @NotNull
    public WebClientResponse get(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        return IWebClient.DefaultImpls.get(this, url);
    }

    @Override
    public void getAsync(@NotNull String url, @NotNull Function1<? super WebClientResponse, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        IWebClient.DefaultImpls.getAsync(this, url, callback);
    }

    @Override
    @NotNull
    public WebClientResponse head(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        return IWebClient.DefaultImpls.head(this, url);
    }

    @Override
    public void headAsync(@NotNull String url, @NotNull Function1<? super WebClientResponse, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        IWebClient.DefaultImpls.headAsync(this, url, callback);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/dankito/utils/web/client/OkHttpWebClient$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "JavaUtils"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

