/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.resources;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.dankito.utils.PackageInfo;
import net.dankito.utils.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u001e\u0010\u000b\u001a\u00020\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u001e\u0010\u000e\u001a\u00020\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J$\u0010\u000f\u001a\u00020\u00042\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J6\u0010\u0014\u001a\u00020\u00042\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0010\b\u0002\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0016H\u0016J \u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J0\u0010\u0018\u001a\u00020\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0010\b\u0002\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0016H\u0016J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0006H\u0002\u00a8\u0006\u001e"}, d2={"Lnet/dankito/utils/resources/ResourceFilesExtractor;", "", "()V", "copyResourceFileToDestination", "", "destinationDirectory", "Ljava/io/File;", "filename", "", "classLoader", "Ljava/lang/ClassLoader;", "copyResourceFilesToDestination", "resourceFilesToExtract", "", "extract", "extractAllFilesFromFolder", "jarPath", "folder", "aClassFromJarFile", "Ljava/lang/Class;", "extractAllFilesFromFolderAsync", "extractionDone", "Lkotlin/Function0;", "extractAllFilesFromJarFolder", "extractAsync", "writeToFile", "inputStream", "Ljava/io/InputStream;", "destinationFile", "Companion", "JavaUtils"})
public class ResourceFilesExtractor {
    private static final Logger log;
    public static final Companion Companion;

    public void extractAsync(@NotNull List<String> resourceFilesToExtract, @NotNull File destinationDirectory, @Nullable Function0<Unit> extractionDone) {
        Intrinsics.checkParameterIsNotNull(resourceFilesToExtract, (String)"resourceFilesToExtract");
        Intrinsics.checkParameterIsNotNull((Object)destinationDirectory, (String)"destinationDirectory");
        ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(this, resourceFilesToExtract, destinationDirectory, extractionDone){
            final /* synthetic */ ResourceFilesExtractor this$0;
            final /* synthetic */ List $resourceFilesToExtract;
            final /* synthetic */ File $destinationDirectory;
            final /* synthetic */ Function0 $extractionDone;

            public final void invoke() {
                block0: {
                    this.this$0.extract(this.$resourceFilesToExtract, this.$destinationDirectory);
                    Function0 function0 = this.$extractionDone;
                    if (function0 == null) break block0;
                    Unit cfr_ignored_0 = (Unit)function0.invoke();
                }
            }
            {
                this.this$0 = resourceFilesExtractor;
                this.$resourceFilesToExtract = list;
                this.$destinationDirectory = file;
                this.$extractionDone = function0;
                super(0);
            }
        }), (int)31, null);
    }

    public static /* synthetic */ void extractAsync$default(ResourceFilesExtractor resourceFilesExtractor, List list, File file, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: extractAsync");
        }
        if ((n & 4) != 0) {
            function0 = null;
        }
        resourceFilesExtractor.extractAsync(list, file, (Function0<Unit>)function0);
    }

    public void extract(@NotNull List<String> resourceFilesToExtract, @NotNull File destinationDirectory) {
        Intrinsics.checkParameterIsNotNull(resourceFilesToExtract, (String)"resourceFilesToExtract");
        Intrinsics.checkParameterIsNotNull((Object)destinationDirectory, (String)"destinationDirectory");
        File absoluteDestinationDirectory = destinationDirectory.getAbsoluteFile();
        if (!absoluteDestinationDirectory.exists()) {
            absoluteDestinationDirectory.mkdirs();
        }
        File file = absoluteDestinationDirectory;
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"absoluteDestinationDirectory");
        this.copyResourceFilesToDestination(resourceFilesToExtract, file);
    }

    public void extractAllFilesFromFolderAsync(@NotNull Class<?> aClassFromJarFile, @NotNull File folder, @NotNull File destinationDirectory, @Nullable Function0<Unit> extractionDone) {
        Intrinsics.checkParameterIsNotNull(aClassFromJarFile, (String)"aClassFromJarFile");
        Intrinsics.checkParameterIsNotNull((Object)folder, (String)"folder");
        Intrinsics.checkParameterIsNotNull((Object)destinationDirectory, (String)"destinationDirectory");
        ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(this, aClassFromJarFile, folder, destinationDirectory, extractionDone){
            final /* synthetic */ ResourceFilesExtractor this$0;
            final /* synthetic */ Class $aClassFromJarFile;
            final /* synthetic */ File $folder;
            final /* synthetic */ File $destinationDirectory;
            final /* synthetic */ Function0 $extractionDone;

            public final void invoke() {
                block0: {
                    this.this$0.extractAllFilesFromFolder(this.$aClassFromJarFile, this.$folder, this.$destinationDirectory);
                    Function0 function0 = this.$extractionDone;
                    if (function0 == null) break block0;
                    Unit cfr_ignored_0 = (Unit)function0.invoke();
                }
            }
            {
                this.this$0 = resourceFilesExtractor;
                this.$aClassFromJarFile = clazz;
                this.$folder = file;
                this.$destinationDirectory = file2;
                this.$extractionDone = function0;
                super(0);
            }
        }), (int)31, null);
    }

    public static /* synthetic */ void extractAllFilesFromFolderAsync$default(ResourceFilesExtractor resourceFilesExtractor, Class clazz, File file, File file2, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: extractAllFilesFromFolderAsync");
        }
        if ((n & 8) != 0) {
            function0 = null;
        }
        resourceFilesExtractor.extractAllFilesFromFolderAsync(clazz, file, file2, (Function0<Unit>)function0);
    }

    public void extractAllFilesFromFolder(@NotNull Class<?> aClassFromJarFile, @NotNull File folder, @NotNull File destinationDirectory) {
        block2: {
            Intrinsics.checkParameterIsNotNull(aClassFromJarFile, (String)"aClassFromJarFile");
            Intrinsics.checkParameterIsNotNull((Object)folder, (String)"folder");
            Intrinsics.checkParameterIsNotNull((Object)destinationDirectory, (String)"destinationDirectory");
            File file = new PackageInfo().getClassJarPath(aClassFromJarFile);
            if (file == null) break block2;
            File file2 = file;
            boolean bl = false;
            boolean bl2 = false;
            File jarPath = file2;
            boolean bl3 = false;
            log.info("Jar file: " + jarPath.getAbsolutePath());
            if (jarPath.isFile()) {
                this.extractAllFilesFromJarFolder(jarPath, folder, destinationDirectory);
            } else {
                this.extractAllFilesFromFolder(jarPath, folder, destinationDirectory);
            }
        }
    }

    protected void extractAllFilesFromJarFolder(@NotNull File jarPath, @NotNull File folder, @NotNull File destinationDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)jarPath, (String)"jarPath");
        Intrinsics.checkParameterIsNotNull((Object)folder, (String)"folder");
        Intrinsics.checkParameterIsNotNull((Object)destinationDirectory, (String)"destinationDirectory");
        JarFile jar = new JarFile(jarPath);
        String string = folder.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"folder.path");
        String subDirectory = StringsKt.replace$default((String)string, (String)"\\", (String)"/", (boolean)false, (int)4, null);
        Enumeration<JarEntry> enumeration = jar.entries();
        Intrinsics.checkExpressionValueIsNotNull(enumeration, (String)"jar.entries()");
        Enumeration<JarEntry> enumeration2 = enumeration;
        boolean bl = false;
        ArrayList<JarEntry> arrayList = Collections.list(enumeration2);
        Intrinsics.checkExpressionValueIsNotNull(arrayList, (String)"java.util.Collections.list(this)");
        Iterable $this$forEach$iv = arrayList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String relativePath;
            String string2;
            JarEntry entry = (JarEntry)element$iv;
            boolean bl2 = false;
            JarEntry jarEntry = entry;
            Intrinsics.checkExpressionValueIsNotNull((Object)jarEntry, (String)"entry");
            String string3 = jarEntry.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"entry.name");
            if (!StringsKt.startsWith$default((String)string3, (String)subDirectory, (boolean)false, (int)2, null) || entry.isDirectory()) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)entry.getName(), (String)"entry.name");
            int n = subDirectory.length();
            boolean bl3 = false;
            String string4 = string2;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string4.substring(n), (String)"(this as java.lang.String).substring(startIndex)");
            File destinationFile = new File(destinationDirectory, relativePath);
            log.info("Going to copy Jar entry " + entry.getName() + " with relative path " + relativePath + " to " + destinationFile);
            InputStream inputStream = jar.getInputStream(entry);
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"jar.getInputStream(entry)");
            this.writeToFile(inputStream, destinationFile);
        }
    }

    protected void extractAllFilesFromFolder(@NotNull File jarPath, @NotNull File folder, @NotNull File destinationDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)jarPath, (String)"jarPath");
        Intrinsics.checkParameterIsNotNull((Object)folder, (String)"folder");
        Intrinsics.checkParameterIsNotNull((Object)destinationDirectory, (String)"destinationDirectory");
        File sourceFolder = new File(jarPath, folder.getPath());
        FileUtils fileUtils = new FileUtils(null, 1, null);
        List filesInSourceFolder = FileUtils.getFilesOfDirectory$default(fileUtils, sourceFolder, null, Integer.MAX_VALUE, null, 10, null);
        if (filesInSourceFolder == null) {
            if (Intrinsics.areEqual((Object)jarPath.getName(), (Object)"classes")) {
                sourceFolder = new File(new File(jarPath.getParent(), "resources"), folder.getPath());
            } else {
                String string = jarPath.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jarPath.path");
                if (StringsKt.endsWith$default((String)string, (String)"classes/kotlin/test", (boolean)false, (int)2, null)) {
                    File file = jarPath.getParentFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"jarPath.parentFile");
                    File file2 = file.getParentFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"jarPath.parentFile.parentFile");
                    sourceFolder = new File(new File(new File(file2.getParent(), "resources"), "test"), folder.getPath());
                }
            }
            filesInSourceFolder = FileUtils.getFilesOfDirectory$default(fileUtils, sourceFolder, null, Integer.MAX_VALUE, null, 10, null);
        }
        List list = filesInSourceFolder;
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File file = (File)element$iv;
                boolean bl = false;
                String relativeFilePath = FilesKt.relativeTo((File)file, (File)sourceFolder).getPath();
                this.writeToFile(new FileInputStream(file), new File(new File(destinationDirectory, folder.getPath()), relativeFilePath));
            }
        }
    }

    protected void copyResourceFilesToDestination(@NotNull List<String> resourceFilesToExtract, @NotNull File destinationDirectory) {
        Intrinsics.checkParameterIsNotNull(resourceFilesToExtract, (String)"resourceFilesToExtract");
        Intrinsics.checkParameterIsNotNull((Object)destinationDirectory, (String)"destinationDirectory");
        ClassLoader classLoader = ResourceFilesExtractor.class.getClassLoader();
        Iterable $this$forEach$iv = resourceFilesToExtract;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String filename = (String)element$iv;
            boolean bl = false;
            try {
                ClassLoader classLoader2 = classLoader;
                Intrinsics.checkExpressionValueIsNotNull((Object)classLoader2, (String)"classLoader");
                this.copyResourceFileToDestination(destinationDirectory, filename, classLoader2);
            }
            catch (Exception e) {
                log.error("Could not copy resource file " + filename + " to destination directory " + destinationDirectory, (Throwable)e);
            }
        }
    }

    protected void copyResourceFileToDestination(@NotNull File destinationDirectory, @NotNull String filename, @NotNull ClassLoader classLoader) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)destinationDirectory, (String)"destinationDirectory");
            Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
            Intrinsics.checkParameterIsNotNull((Object)classLoader, (String)"classLoader");
            InputStream inputStream = classLoader.getResourceAsStream(filename);
            if (inputStream == null) break block0;
            InputStream inputStream2 = inputStream;
            boolean bl = false;
            boolean bl2 = false;
            InputStream inputStream3 = inputStream2;
            boolean bl3 = false;
            File destination = new File(destinationDirectory, filename);
            this.writeToFile(inputStream3, destination);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void writeToFile(InputStream inputStream, File destinationFile) throws Exception {
        try {
            destinationFile.getParentFile().mkdirs();
        }
        catch (Exception e) {
            log.error("Could not create parent directory for " + destinationFile);
        }
        OutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(destinationFile));
            InputStream inputStream2 = inputStream;
            int n = 8192;
            boolean bl = false;
            ByteStreamsKt.copyTo((InputStream)(inputStream2 instanceof BufferedInputStream ? (BufferedInputStream)inputStream2 : new BufferedInputStream(inputStream2, n)), (OutputStream)outputStream, (int)16384);
        }
        catch (IOException e) {
            try {
                log.error("Could not write InputStream to file " + destinationFile.getAbsolutePath(), (Throwable)e);
                throw (Throwable)e;
            }
            catch (Throwable throwable) {
                try {
                    OutputStream outputStream2 = outputStream;
                    if (outputStream2 != null) {
                        outputStream2.flush();
                    }
                    OutputStream outputStream3 = outputStream;
                    if (outputStream3 != null) {
                        outputStream3.close();
                    }
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            outputStream.flush();
            outputStream.close();
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    static {
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(ResourceFilesExtractor.class);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/dankito/utils/resources/ResourceFilesExtractor$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "JavaUtils"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

