/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.network;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import net.dankito.utils.network.INetworkHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0016\u0018\u0000 !2\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0016J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0014\u0010\u0018\u001a\u00020\r2\n\u0010\u0019\u001a\u00060\u001aj\u0002`\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010 \u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\""}, d2={"Lnet/dankito/utils/network/NetworkHelper;", "Lnet/dankito/utils/network/INetworkHelper;", "()V", "getBroadcastAddress", "Ljava/net/Inet4Address;", "address", "networkInterface", "Ljava/net/NetworkInterface;", "getConnectedRealNetworkInterfaces", "", "getIPAddress", "Ljava/net/InetAddress;", "useIPv4", "", "getIPAddresses", "", "onlyIPv4", "getMACAddress", "", "interfaceName", "getRealNetworkInterfaces", "isCellularOrUsbInterface", "isDockerInterface", "isDummyInterface", "isSocketCloseException", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "isTcpPortAvailable", "port", "", "isUdpPortAvailable", "shouldInterfaceBeIgnored", "Companion", "JavaUtils"})
public class NetworkHelper
implements INetworkHelper {
    public static final int MaxPortNumber = 65535;
    public static final int MinTcpPortNumber = 1;
    public static final int MinUdpPortNumber = 0;
    private static final Logger log;
    public static final Companion Companion;

    @Override
    @Nullable
    public Inet4Address getBroadcastAddress(@NotNull NetworkInterface networkInterface) {
        Intrinsics.checkParameterIsNotNull((Object)networkInterface, (String)"networkInterface");
        Enumeration<InetAddress> enumeration = networkInterface.getInetAddresses();
        Intrinsics.checkExpressionValueIsNotNull(enumeration, (String)"networkInterface.inetAddresses");
        Iterator iterator = CollectionsKt.iterator(enumeration);
        while (iterator.hasNext()) {
            InetAddress address = (InetAddress)iterator.next();
            if (!(address instanceof Inet4Address)) continue;
            try {
                return this.getBroadcastAddress((Inet4Address)address);
            }
            catch (Exception e) {
                log.error("Could not determine Broadcast Address of " + ((Inet4Address)address).getHostAddress(), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Inet4Address getBroadcastAddress(@NotNull Inet4Address address) {
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        byte[] broadcastAddress = address.getAddress();
        broadcastAddress[broadcastAddress.length - 1] = (byte)255;
        InetAddress inetAddress = Inet4Address.getByAddress(broadcastAddress);
        if (!(inetAddress instanceof Inet4Address)) {
            inetAddress = null;
        }
        return (Inet4Address)inetAddress;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String getMACAddress(@Nullable String interfaceName) {
        try {
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface intf : interfaces) {
                if (interfaceName != null) {
                    NetworkInterface networkInterface = intf;
                    Intrinsics.checkExpressionValueIsNotNull((Object)networkInterface, (String)"intf");
                    if (!StringsKt.equals((String)networkInterface.getName(), (String)interfaceName, (boolean)true)) continue;
                }
                NetworkInterface networkInterface = intf;
                Intrinsics.checkExpressionValueIsNotNull((Object)networkInterface, (String)"intf");
                byte[] byArray = networkInterface.getHardwareAddress();
                if (byArray == null) {
                    return "";
                }
                byte[] mac = byArray;
                StringBuilder buf = new StringBuilder();
                int n = 0;
                int n2 = mac.length;
                while (n < n2) {
                    String string;
                    void idx;
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string2 = "%02X:";
                    Object[] objectArray = new Object[]{mac[idx]};
                    StringBuilder stringBuilder = buf;
                    boolean bl = false;
                    Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
                    stringBuilder.append(string);
                    ++idx;
                }
                if (buf.length() > 0) {
                    buf.deleteCharAt(buf.length() - 1);
                }
                String string = buf.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"buf.toString()");
                return string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    @Override
    @Nullable
    public InetAddress getIPAddress(boolean useIPv4) {
        List<InetAddress> addresses = this.getIPAddresses(useIPv4);
        if (addresses.size() > 0) {
            return addresses.get(0);
        }
        return null;
    }

    @Override
    @NotNull
    public List<InetAddress> getIPAddresses(boolean onlyIPv4) {
        ArrayList addresses = new ArrayList();
        try {
            for (NetworkInterface networkInterface : this.getConnectedRealNetworkInterfaces()) {
                addresses.addAll(this.getIPAddresses(networkInterface, onlyIPv4));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return addresses;
    }

    @Override
    @NotNull
    public List<InetAddress> getIPAddresses(@NotNull NetworkInterface networkInterface, boolean onlyIPv4) {
        Intrinsics.checkParameterIsNotNull((Object)networkInterface, (String)"networkInterface");
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        ArrayList<InetAddress> interfaceAddresses = Collections.list(networkInterface.getInetAddresses());
        Iterator<InetAddress> iterator = interfaceAddresses.iterator();
        while (iterator.hasNext()) {
            InetAddress address;
            InetAddress inetAddress = address = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)inetAddress, (String)"address");
            if (inetAddress.isLoopbackAddress() || onlyIPv4 && !(address instanceof Inet4Address)) continue;
            addresses.add(address);
        }
        return addresses;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<NetworkInterface> getRealNetworkInterfaces() {
        void $this$filterTo$iv$iv;
        ArrayList<NetworkInterface> allInterfaces;
        ArrayList<NetworkInterface> arrayList = allInterfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
        Intrinsics.checkExpressionValueIsNotNull(arrayList, (String)"allInterfaces");
        Iterable $this$filter$iv = arrayList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            NetworkInterface it = (NetworkInterface)element$iv$iv;
            boolean bl = false;
            NetworkInterface networkInterface = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)networkInterface, (String)"it");
            if (!(!this.shouldInterfaceBeIgnored(networkInterface))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<NetworkInterface> getConnectedRealNetworkInterfaces() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getRealNetworkInterfaces();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            NetworkInterface it = (NetworkInterface)element$iv$iv;
            boolean bl = false;
            if (!it.isUp()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    protected boolean shouldInterfaceBeIgnored(@NotNull NetworkInterface networkInterface) throws SocketException {
        Intrinsics.checkParameterIsNotNull((Object)networkInterface, (String)"networkInterface");
        return networkInterface.isLoopback() || this.isCellularOrUsbInterface(networkInterface) || this.isDockerInterface(networkInterface) || this.isDummyInterface(networkInterface);
    }

    protected boolean isCellularOrUsbInterface(@NotNull NetworkInterface networkInterface) {
        Intrinsics.checkParameterIsNotNull((Object)networkInterface, (String)"networkInterface");
        String string = networkInterface.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"networkInterface.name");
        return StringsKt.startsWith$default((String)string, (String)"rmnet", (boolean)false, (int)2, null);
    }

    protected boolean isDockerInterface(@NotNull NetworkInterface networkInterface) {
        Intrinsics.checkParameterIsNotNull((Object)networkInterface, (String)"networkInterface");
        String string = networkInterface.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"networkInterface.name");
        return StringsKt.startsWith$default((String)string, (String)"docker", (boolean)false, (int)2, null);
    }

    protected boolean isDummyInterface(@NotNull NetworkInterface networkInterface) {
        Intrinsics.checkParameterIsNotNull((Object)networkInterface, (String)"networkInterface");
        String string = networkInterface.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"networkInterface.name");
        return StringsKt.startsWith$default((String)string, (String)"dummy", (boolean)false, (int)2, null);
    }

    @Override
    public boolean isSocketCloseException(@NotNull Exception exception) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        return exception instanceof SocketException && Intrinsics.areEqual((Object)"Socket closed", (Object)exception.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean isTcpPortAvailable(int port) {
        if (port < 1 || port > 65535) {
            throw (Throwable)new IllegalArgumentException("Port has to be in range [1, 65535]");
        }
        ServerSocket serverSocket = null;
        serverSocket = new ServerSocket(port);
        serverSocket.setReuseAddress(true);
        boolean bl = true;
        try {
            serverSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
        catch (IOException iOException) {
            try {
                ServerSocket serverSocket2 = serverSocket;
                if (serverSocket2 != null) {
                    serverSocket2.close();
                }
            }
            catch (Exception exception) {}
            catch (Throwable throwable) {
                try {
                    ServerSocket serverSocket3 = serverSocket;
                    if (serverSocket3 != null) {
                        serverSocket3.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean isUdpPortAvailable(int port) {
        if (port < 0 || port > 65535) {
            throw (Throwable)new IllegalArgumentException("Port has to be in range [0, 65535]");
        }
        DatagramSocket datagramSocket = null;
        datagramSocket = new DatagramSocket(port);
        datagramSocket.setReuseAddress(true);
        boolean bl = true;
        try {
            datagramSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
        catch (IOException iOException) {
            try {
                DatagramSocket datagramSocket2 = datagramSocket;
                if (datagramSocket2 != null) {
                    datagramSocket2.close();
                }
            }
            catch (Exception exception) {}
            catch (Throwable throwable) {
                try {
                    DatagramSocket datagramSocket3 = datagramSocket;
                    if (datagramSocket3 != null) {
                        datagramSocket3.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return false;
    }

    static {
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(NetworkHelper.class);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lnet/dankito/utils/network/NetworkHelper$Companion;", "", "()V", "MaxPortNumber", "", "MinTcpPortNumber", "MinUdpPortNumber", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "JavaUtils"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

